/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  I2S2 control
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_i2s.c
 *   Version: \main\50
 *   Date: 2007-10-05 12:58:58
 *   Responsible: soerenek
 *   Comment:
 *     corrected a bug in disable clock
 */
//??pow.h?1?o??
/*
#===============================================
# y?L1G?pow.h?Da???2?̨3??
# 騰a?L1G???3????
#===============================================*/
#if defined(_OS_TOS)
#define _OS_ECOS _OS_TOS
#elif defined(_OS_LINUX)
#define _OS_LINUX _OS_LINUX
#endif

/*---------------------------------------------*/
/* Include files.                              */
/*---------------------------------------------*/

#include "drvs_general.h"

//#include "icu_funct.h"
//#include "scttypes.h"
//#include "ms.h"
#include "bastypes.h"
//#include "psv.h"
//#include "platform_cnf.h"       /* for PCL_pad and related enums */
//#include "hw_reg.h"
//#include "dsp.h"                /* for DSP command types */
#include "aud_drv.h"            /* audio types and functions */
#include "aud_data.h"           /* data describing the paths */
#include "aud_com.h"
#include "aud_ext_def.h"
//#include "pow.h" // Required for POW_SetPowerDemands
//#include "ilevels.h" // required for capture compare definitions (CCx_CCINTx)
#include "aud_path_control.h"
#include "aud_i2s.h"

/*changed by wangjun for NV change.[20090214]*/
#include "aud_nv.h"  //#include "eep.h"      //used for loading super visory tones  (Most be included before aud_tone.h is included)

#include "aud_tone.h"
#include "aud_ear.h"
//#include "aud_hal_ext_amp.h"
#include "drvs_rtt.h"
//#include "trap.h"
//#include "math.h"
#include "aud_ratesw.h"
#include "aud_volume.h"
#include "drv_stub.h"

//#include "cc.h"
/*---------------------------------------------*/
/* Local defines.                              */
/*---------------------------------------------*/


#define AUD_DAIRESET_INTR         CC0_CCINT3
#define AUD_DAIRESET_CCM          *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf4000014)))
#define PCL_31          *((volatile uint *) (GSML1_ZX29_GSM_VA(0xf430009C)))  //PCL_31 in REG_SGOLD_Regs.h
#define AUD_DAIRESET_CCM_DISABLE  0x0FFF
#define AUD_DISABLE_DAIRESET_INTR sCC0_CCSRC3.SRE = 0
#define AUD_ENABLE_DAIRESET_INTR  sCC0_CCSRC3.SRE = 1
#define AUD_CLEAR_DAIRESET_INTR   sCC0_CCSRC3.CLRR = 1

//DAI reset concept
extern T_DSP_CMD_VB_HW_PAR                  aud_dsp_vb_hw_parms_global;         //actually belongs to base group and might be made static - new access needed then
extern T_DSP_CMD_VB_SET_GAIN_PAR       aud_dsp_gain_parms;                         //actually belongs to base group and might be made static - new access needed then
extern T_DSP_CMD_VB_SET_BIQUAD_PAR          aud_dsp_uplink_filter_parms;     //actually belongs to base group and might be made static - new access needed then
#ifdef _USE_CUT_TEAKLIT_CODE
NU_HISR AUD_I2S2DAI_HISR_control;
char I2S2DAIResetInt_hisr_stack[600];
#endif
#define BITMASK_CLK0SEL 0xC
#define BITMASK_CLK1SEL 0xC0
#define CLK0_IN_SLAVE_MODE 0x8
#define CLK1_IN_SLAVE_MODE 0x08

/*---------------------------------------------*/
/* Internal functions.                         */
/*---------------------------------------------*/
static void Turn_off_I2S1_TxRx(void);
static void aud_drv_setup_I2S1(UINT16 mode_pointer);
static void InitDAI(void);
static void SetDAI(UINT16 mode);
static void AUD_DAIReset_lowisr(void);
static UINT32 I2S_SetClock(void);
static BOOL I2S_ResetClock(UINT32 handle);
//static BOOL AudI2S2RxSM(aud_event_enum event, void* pData);
//static BOOL AudI2S2TxSM(aud_event_enum event, void* pData);//xiu
/*[Begin] [lvwenhua-2010/11/9]*/
static void aud_drv_setup_AFEI2S(UINT16 mode_pointer);
void aud_setup_afei2s_vb_on_parameters(
    U16 csel,   /* csel parameter */
    U16 den0,   /* den0 parameter */
    U16 den1,   /* den1 parameter */
    U16 num0,   /* num0 parameter */
    U16 num1,   /* num1 parameter */
    U16 rxconf, /* rxconf parameter */
    U16 txconf,
    U16 hwmode,
    aud_I2S_samplerate_enum sample
    );//xiu
/*[End] [lvwenhua-2010/11/9]*/
/*---------------------------------------------*/
/* Internal data.                              */
/*---------------------------------------------*/

static T_DSP_CMD_VB_I2S2_PAR   aud_dsp_vb_i2s2_parms;
static UINT16 dai_mode; //Can be accesed from aud_i2s_tst.c
static aud_glob_I2S1_type  I2S1_settings;
/*[Begin] [lvwenhua-2010/11/5]*/
static aud_glob_I2S1_type  AFEI2S_settings;
/*[End] [lvwenhua-2010/11/5]*/
static aud_I2S_clk_handle_type clk_handle = 0; /* counter of clock users*/

/*---------------------------------------------*/
/* External data.                              */
/*---------------------------------------------*/
extern BOOL aud_i2s_validation_matrix[aud_I2S_entry_point_end][aud_I2S_Master_Slave_end][aud_I2S_mode_end][aud_I2S_transmission_mode_end][aud_I2S_samplerate_end];
extern aud_I2S_status_type aud_I2S_status;

// added PCL_pad after delete #include "platform_cnf.h"
extern volatile unsigned int *PCL_pad(int function);

#if 0//xiu
/*****************************************************************************************
* Function:..: aud_I2S_calculate_num_and_den
* Description: Calculates the DEN and Num used for I2S configuration.
*            : The function will alway use the 104MHz clk as the referance clk
******************************************************************************************/
static aud_i2s_num_den_type aud_I2S_calculate_num_and_den(aud_I2S_samplerate_enum samplerate_enum, aud_I2S_mode_enum i2s_mode_enum, aud_I2S_periode_enum periode_enum)
{
    const UINT32 Fref=104000000; //104MHz
    UINT32 Fclk;
    UINT32 samplerate=0;
    UINT32 periode =0;
    UINT32 num=0;
    UINT32 den=0;
    UINT32 utemp_den=0;
    double temp_den=0;
    double factor=0;
    aud_i2s_num_den_type ret = {0,0};


//Calculating Fclk which are the Nominal Bit clock
    switch(samplerate_enum)
    {
    case aud_I2S_samplerate_08000:
    {
        samplerate=8000;
        break;
    }
    case aud_I2S_samplerate_11025:
    {
        samplerate=11025;
        break;
    }
    case aud_I2S_samplerate_12000:
    {
        samplerate=12000;
        break;
    }
    case aud_I2S_samplerate_16000:
    {
        samplerate=16000;
        break;
    }
    case aud_I2S_samplerate_22050:
    {
        samplerate=22050;
        break;
    }
    case aud_I2S_samplerate_24000:
    {
        samplerate=24000;
        break;
    }
    case aud_I2S_samplerate_32000:
    {
        samplerate=32000;
        break;
    }
    case aud_I2S_samplerate_44100:
    {
        samplerate=44100;
        break;
    }
    case aud_I2S_samplerate_48000:
    {
        samplerate=48000;
        break;
    }
	default:
		break;//xiu
    }

    switch(periode_enum)
    {
    case aud_I2S_periode_64:
    {
        periode=64;
        break;
    }
    case aud_I2S_periode_48:
    {
        periode=48;
        break;
    }
    case aud_I2S_periode_32:
    {
        periode=32;
        break;
    }
    case aud_I2S_periode_18:
    {
        periode=18;
        break;
    }
    case aud_I2S_periode_17:
    {
        periode=17;
        break;
    }
    default:
	  break;//xiu
    }

    if (i2s_mode_enum!=aud_I2S_mode_mono)
    {
        Fclk=samplerate*periode;
    }
    else
    {
        Fclk=samplerate*periode/2;
    }

    if(Fclk !=0) /* removing lint "Possible division by 0 : w414"*/
    {
//Calculating the factor = den/num
        factor=(double)Fref/((double)Fclk*4);

        if (factor<0.5)
        {
            AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Nominal Bit Clock to high for the 104MhZ: clk > 1/8 of 104 MHz  !!",factor)
            return ret;
        }

    } else
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Calculation of factor failed in I2S2 !!",factor)
        return ret;
    }
//Finding the num and den
    for(num=1; num<2048; num++)
    {
        temp_den = num*factor;
        utemp_den = (UINT32) temp_den;
        if(temp_den==utemp_den)
        {
            den=utemp_den;
            break;
        }
    }
    /*lint -save -e734 (Loss of precision) */
    /*lint -save -e524 (Loss of precision) */
//If the above loop runs out then find the best fit
    if(num==2048)
    {
        double temp_num;
        double error_org=1000, error_new;
        den=0;
        num=0xffffffff;

        for(temp_num=1; temp_num<2048; temp_num++)
        {

            utemp_den=(UINT32) (double)temp_num*factor;

            if(utemp_den>=65532)
            {
                break;
            }

            error_new=fabs((double)Fref*temp_num/4/utemp_den-Fclk);
            if (error_new<error_org)
            {
                num=temp_num;
                den=utemp_den;
                error_org=fabs((double)Fref*num/4/den-Fclk);
            }

            utemp_den+=1;
            error_new=fabs((double)Fref*temp_num/4/utemp_den-Fclk);

            if (error_new<error_org)
            {
                num=temp_num;
                den=utemp_den;
                error_org=fabs((double)Fref*num/4/den-Fclk);
            }

        }
    }
    /*lint -restore */
    /*lint -restore */
    ret.num=num;
    ret.den=den;
    return ret;
}
#endif
/*****************************************************************************************
* Function:... aud_I2S_setup_pin
* Description: Keeps the control over the I2S PIN, to have only one place for PIN config
******************************************************************************************/
static void aud_I2S_setup_pin(aud_I2S_PIN_enum pin, aud_I2S_PIN_config_enum config)
{
#if 0
    UINT16 time_start = 0;

#ifdef LLT
    time_start = RTT_stm_get_time_10us_resolution(); //Get start time
#endif


//tracing
    /* Send string : at+xl1set="l22 14l" To enable this LLT trace */
    aud_common_trace( llt_group_audio2, llt_type_audio_I2S_PIN_config, 4, 0,               // LLT params
                      'P', 0x08,                                               // LIS params
                      aud_log_lis_display, aud_log_lis_display_nodata, aud_log_llt_trace, // LIS params
                      (UINT32) time_start,
                      (UINT32) pin,
                      (UINT32) config,
                      (UINT32) E_audio_llt_type_id_0  );
    switch(pin)
    {
    case aud_I2S1_Rx_pin:
    {
        if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S1_RX = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S1_RX   */
        }
        else
        {   //off
            AUD_PAD_I2S1_RX =  AUD_PAD_I2S1_RX_OFF;
        }
    }
    break;

    case aud_I2S1_Tx_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S1_TX = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S1_TX   */
        }
        else
        {   //off
            AUD_PAD_I2S1_TX = AUD_PAD_I2S1_TX_OFF;
        }
    }
    break;

    case aud_I2S1_Clk0_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S1_CLK0 = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S1_CLK0 */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S1_CLK0 = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S1_CLK0 */
        }
        else
        {   //off
            AUD_PAD_I2S1_CLK0 = AUD_PAD_I2S1_CLK0_OFF;
        }
    }
    break;

    case aud_I2S1_Clk1_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S1_CLK1 = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S1_CLK1 */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S1_CLK1 = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S1_CLK1 */
        }
        else
        {   //off
            AUD_PAD_I2S1_CLK1 = AUD_PAD_I2S1_CLK1_OFF;
        }
    }
    break;

    case aud_I2S1_Wa0_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S1_WA0  = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S1_WA0  */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S1_WA0  = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S1_WA0  */
        }
        else
        {   //off
            AUD_PAD_I2S1_WA0 = AUD_PAD_I2S1_WA0_OFF;
        }
    }
    break;

    case aud_I2S1_Wa1_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S1_WA1  = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S1_WA1  */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S1_WA1  = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S1_WA1  */
        }
        else
        {   //off
            AUD_PAD_I2S1_WA1 = AUD_PAD_I2S1_WA1_OFF;
        }
    }
    break;

    case aud_I2S2_Rx_pin:
    {
        if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S2_RX = PCL_ENABLE | PCL_PD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1)    | PCL_OS(0);         /* I2S2_Rx */
        }
        else
        {   //off
            AUD_PAD_I2S2_RX =  AUD_PAD_I2S2_RX_OFF;
        }
        break;
    }

    case aud_I2S2_Tx_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S2_TX = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0)    | PCL_OS(1);    /* I2S2_Tx  */
        }
        else
        {   //off
            AUD_PAD_I2S2_TX = AUD_PAD_I2S2_TX_OFF;
        }
        break;
    }

    case aud_I2S2_Clk0_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S2_CLK0 = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S2_CLK0 */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S2_CLK0 = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S2_CLK0 */
        }
        else
        {   //off
            AUD_PAD_I2S2_CLK0 = AUD_PAD_I2S2_CLK0_OFF;
        }
        break;
    }

    case aud_I2S2_Clk1_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S2_CLK1 = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S2_CLK1 */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S2_CLK1 = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S2_CLK1 */
        }
        else
        {   //off
            AUD_PAD_I2S2_CLK1 = AUD_PAD_I2S2_CLK1_OFF;
        }
        break;
    }
    case aud_I2S2_Wa0_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S2_WA0  = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S2_WA0  */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S2_WA0  = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S2_WA0  */
        }
        else
        {   //off
            AUD_PAD_I2S2_WA0 = AUD_PAD_I2S2_WA0_OFF;
        }
        break;
    }

    case aud_I2S2_Wa1_pin:
    {
        if(config==aud_I2S_PIN_output)
        {
            AUD_PAD_I2S2_WA1 = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);    /* I2S2_WA0  */
        }
        else if(config==aud_I2S_PIN_input)
        {
            AUD_PAD_I2S2_WA1 = PCL_ENABLE | PCL_NO_PUPD | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);    /* I2S2_WA0  */
        }
        else
        {   //off
            AUD_PAD_I2S2_WA1 = AUD_PAD_I2S2_WA1_OFF;
        }
        break;
    }
    }
#endif
}
#if 0//xiu
/****************************************************************************************
* Function:... aud_I2S_update_VB_I2S2
* Description: Makes it possible for the two I2S2 SM to control the same registers
****************************************************************************************/
static BOOL aud_I2S_update_VB_I2S2(aud_resource_enum resource, aud_event_enum event, UINT16 entry_point, UINT16 rate, UINT16 mode)
{
    static BOOL aud_I2S2_Rx_on=FALSE;
    static BOOL aud_I2S2_Tx_on=FALSE;

    //UINT16 temp_Switch_rx = 0;
    //UINT16 temp_Switch_tx = 0;//xiu
    UINT16 temp_Switch = 0;
    UINT16 temp_mode=0;
    UINT16 temp_rate=0;

    if (event == E_I2S_enable)
    {
        temp_rate=rate;
        temp_mode=mode;

        switch(entry_point)
        {
        case aud_I2S_entry_point_MMS:
        {
            temp_Switch=AUD_I2S_Switch_MMS_mode;
            break;
        }

        case aud_I2S_entry_point_External:
        {
            temp_Switch=AUD_I2S_Switch_external_mode;
            break;
        }

        case aud_I2S_entry_point_DAI:
        {
            temp_Switch=AUD_I2S_Switch_DAI_mode;
            break;
        }

        case aud_I2S_entry_point_MMS_FB:
        {
            temp_Switch=AUD_I2S_Switch_MMS_FB_mode;
            break;
        }
        }

#ifndef STEON2_PROJECT
        if ((aud_I2S2_Tx_on == TRUE && resource == aud_resource_I2S2_Rx)||(aud_I2S2_Rx_on == TRUE && resource == aud_resource_I2S2_Tx))
        {
            if(aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode!=temp_mode)
            {
                return FALSE;
            }

            if (aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate!=temp_rate)
            {
                return FALSE;
            }
        }
#endif

        if (resource == aud_resource_I2S2_Rx)
        {
            aud_I2S2_Rx_on = TRUE;
        }

        if (resource == aud_resource_I2S2_Tx)
        {
            aud_I2S2_Tx_on = TRUE;
        }


        /* set all switches according to request both ways rx and tx on at the same time. */
#ifdef STEON2_PROJECT
        if(resource == aud_resource_I2S2_Rx)
        {
            aud_dsp_vb_i2s2_parms.Rx_Switch=temp_Switch;
        }
        if(resource == aud_resource_I2S2_Tx)
        {
            aud_dsp_vb_i2s2_parms.Tx_Switch=temp_Switch;
        }
        aud_dsp_vb_i2s2_parms.I2S2_TX_PPM= 0x05;
        /* must be found by test for optimum value for the system*/
        aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode=temp_mode;
        aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate=temp_rate;
        aud_dsp_vb_i2s2_parms.HW_SOURCE_ALLOC =aud_get_hw_src_allocation();
        if(aud_dsp_vb_i2s2_parms.HW_SOURCE_ALLOC== aud_hw_src_no_usage)
        {
            /* for can temporary allocate HW resources to MIDI permanent in case we run I2S2.
            In this case no interrupt will come to i2s2. If the HW source is allocated to I2S2,the interrupt DSP_7 should be generated when pll locks*/
            //aud_set_hw_src_acllocation(aud_hw_src_I2S2_rx3);
            aud_set_hw_src_allocation(aud_hw_src_MIDI);
            // aud_dsp_vb_i2s2_parms.HW_SOURCE_ALLOC =aud_hw_src_I2S2_rx3;
            aud_dsp_vb_i2s2_parms.HW_SOURCE_ALLOC =aud_hw_src_MIDI;

        }
        if (resource == aud_resource_I2S2_Rx && aud_I2S2_Tx_on == FALSE)
        {
            aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF=aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF ^ AUD_I2S_CONF_EDGE_Bitmask;

        }
        if (resource == aud_resource_I2S2_Tx && aud_I2S2_Rx_on == FALSE)
        {
            aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF=aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF ^ AUD_I2S_CONF_EDGE_Bitmask;
        }

#else
        aud_dsp_vb_i2s2_parms.Switch=temp_Switch;
        aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode=temp_mode;
        aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate=temp_rate;
        if (resource == aud_resource_I2S2_Rx && aud_I2S2_Tx_on == FALSE)
        {
            aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF=aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF ^ AUD_I2S_CONF_EDGE_Bitmask;
        }
#endif

    }
    else if ((event == E_I2S_disable) || (event == E_I2S_release_disable))
    {
        if (resource == aud_resource_I2S2_Rx)
            aud_I2S2_Rx_on=FALSE;
        else if(resource == aud_resource_I2S2_Tx)
            aud_I2S2_Tx_on=FALSE;
        else
        {
            return FALSE;
        }

        if(aud_I2S2_Rx_on==FALSE && aud_I2S2_Tx_on==FALSE )
        {
            aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate=rate;
            aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode=mode;
#ifdef STEON2_PROJECT
            aud_dsp_vb_i2s2_parms.Tx_Switch=AUD_I2S_Switch_Interface_off;
            aud_dsp_vb_i2s2_parms.Rx_Switch=AUD_I2S_Switch_Interface_off;
            if(aud_get_hw_src_allocation()== aud_hw_src_I2S2_rx3)
            {
                aud_set_hw_src_allocation(aud_hw_src_no_usage);
                aud_dsp_vb_i2s2_parms.HW_SOURCE_ALLOC =aud_hw_src_no_usage;
            }
#else
            aud_dsp_vb_i2s2_parms.Switch=AUD_I2S_Switch_Interface_off;
#endif
            aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF=0;
            aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF=0;

        }
    }
    else
    {
        return FALSE;
    }

    return TRUE;
}
#endif
/****************************************************************************************
* Function:... aud_I2S_clk_generate_handle
* Description: Return a new handle, and adding the handle to clk_handle
****************************************************************************************/
static aud_I2S_clk_handle_type aud_I2S_clk_generate_handle(aud_I2S_clk_handle_type* clk_handle)
{
    aud_I2S_clk_handle_type handle=0;

    //Finds the first bit which are non zero
    for(handle=1; handle<0xffffffff; handle = handle<<1)
    {
        if ((handle & *clk_handle )== 0)
            break;
    }

    *clk_handle = *clk_handle | handle;

    return handle;
}

/****************************************************************************************
* Function:... aud_I2S_clk_remove_handle
* Description: Removes the handle from clk_handle
****************************************************************************************/
static void aud_I2S_clk_remove_handle(aud_I2S_clk_handle_type* clk_handle, aud_I2S_clk_handle_type handle)
{
    if((handle & *clk_handle) != 0)
    {
        *clk_handle = *clk_handle & (~handle);
    }
}



/****************************************************************************************
* Function:... Aud_I2S_dispatcher
* Description: Dispatching all I2S events to the different SM
****************************************************************************************/
BOOL Aud_I2S_dispatcher (aud_event_enum event, void* pData)
{
    disp_to_SM_data_type *SM_data = (disp_to_SM_data_type*)pData; //contains the structure passed from the dispatcher
    BOOL ret = TRUE;

    switch (event)
    {
        /*************************
        *     I2S1 events       *
        *************************/
    case E_I2S1_configure:
    case E_I2S1_enable:
    case E_I2S1_disable:
        AudI2S1SM(event, pData);
        break;

        /*[Begin] [lvwenhua-2010/11/5]*/
        /*************************
        *     AFEI2S events       *
        *************************/
    case E_AFEI2S_configure:
    case E_AFEI2S_enable:
    case E_AFEI2S_disable:
        AudAFEI2SSM(event, pData);
        break;
        /*[End] [lvwenhua-2010/11/5]*/
        /*************************
        *     I2S2 events       *
        *************************/
    case E_I2S_enable:
    case E_I2S_disable:
    case E_I2S_release_disable:
    case E_I2S_setup_resource:
    case E_I2S_handle_slave_interrupt:
    {
        switch (SM_data->parm1)
        {
        case aud_resource_I2S2_Rx:
//          AudI2S2RxSM(event, pData);
            break;

        case aud_resource_I2S2_Tx:
//          AudI2S2TxSM(event, pData);
            break;

        default:
            ret = FALSE;
            break;
        }
    }
    break;

    /*************************
    *       clk events       *
    *************************/
    case E_I2S_setup_clk:
    {
        switch (SM_data->parm1)
        {
        case aud_I2S2_clk0:
//          AudI2SClk0SM(aud_I2S_E_setup_clk,pData);
            break;

        case aud_I2S2_clk1:
//          AudI2SClk1SM(aud_I2S_E_setup_clk,pData);
            break;

        default:
            ret = FALSE;
            break;

        }
    }
    break;

    case E_idle_command:
    {
        if(aud_get_SM_state(aud_resource_I2S2_Rx)==S_active||aud_get_SM_state(aud_resource_I2S2_Tx)==S_active)
        {
            DSP_ASYNC_VB_I2S2(&aud_dsp_vb_i2s2_parms);
        }
    }
    break;

    /*************************
    *     default events     *
    *************************/
    default:
        ret = FALSE;
        break;
    }
    return ret;
}


void Aud_I2S_init(void)
{
    POW_RETURN_RESULT_T pow_clock = POW_OK;

    I2S1_settings.mode_pointer = 0; //First valid mode
#ifdef STEON2_PROJECT
    aud_dsp_vb_i2s2_parms.Rx_Switch =0;
    aud_dsp_vb_i2s2_parms.Tx_Switch = 0;
    aud_dsp_vb_i2s2_parms.I2S2_TX_PPM = 0;
#else
    aud_dsp_vb_i2s2_parms.Switch =0;
#endif

    aud_dsp_vb_i2s2_parms.SI2Sx_SCEL= 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_NUM0 = 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_DEN0= 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_NUM1= 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_DEN1= 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF= 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF = 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate= 0;
    aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode= 0;

//Resetting the aud_I2S interface status variables
    aud_I2S_status.clk0_enabled=FALSE;
    aud_I2S_status.clk1_enabled=FALSE;
    aud_I2S_status.I2S2_Rx_enabled=FALSE;
    aud_I2S_status.I2S2_Tx_enabled=FALSE;
    aud_I2S_status.I2S2_Rx_clk=aud_I2S_clk_end;
    aud_I2S_status.I2S2_Tx_clk=aud_I2S_clk_end;

    clk_handle = 0;

//pow_clock =POW_SetClockRange(POW_CLK_I2S, POW_FREQ_104M, POW_FREQ_104M);  huojishan 2008.04.01
	/*klocwork 3  INVARIANT_CONDITION.UNREACH delete if*/
	/*
    if(pow_clock != POW_OK)
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "I2S clock is not available",pow_clock)
        return;
    }*/
    /*huojishan 2008.04.04*/
//pow_clock =POW_SetClockDemands(POW_CLK_I2S, FALSE);
	/*klocwork 3  INVARIANT_CONDITION.UNREACH delete if*/
	/*
    if(pow_clock != POW_OK)
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "I2S clock is not set up",pow_clock)
        return;
    }*/

    /* register functions that receive notifications when ratesw has changed */
//aud_register_ratesw_observer(aud_resource_I2S2_Rx, AUD_I2S2Rx_ratesw_callback);
//aud_register_ratesw_observer(aud_resource_I2S2_Tx, AUD_I2S2Tx_ratesw_callback);

#if 0 //Used to validating the calculation of NUM and DEN, the code are storred because a new implemantation will be made not using doubles
    {

Move me so i become a global variable :
        -) static aud_i2s_num_den_type temp_cal[aud_I2S_samplerate_end][aud_I2S_mode_end][aud_I2S_periode_end]; //help delete me


        aud_I2S_samplerate_enum samplerate_enum = aud_I2S_samplerate_08000;
        aud_I2S_mode_enum i2s_mode_enum = aud_I2S_mode_stereo;
        aud_I2S_periode_enum periode_enum = aud_I2S_periode_17;

        for (samplerate_enum=aud_I2S_samplerate_08000; samplerate_enum< aud_I2S_samplerate_end; samplerate_enum++)
    {
        for(periode_enum = aud_I2S_periode_64; periode_enum < aud_I2S_periode_end; periode_enum++)
            {
                temp_cal[samplerate_enum][i2s_mode_enum][periode_enum]=aud_I2S_calculate_num_and_den(samplerate_enum, i2s_mode_enum, periode_enum);
            }
        }

        i2s_mode_enum = aud_I2S_mode_dual_mono;
        for (samplerate_enum=aud_I2S_samplerate_08000; samplerate_enum< aud_I2S_samplerate_end; samplerate_enum++)
    {
        for(periode_enum = aud_I2S_periode_64; periode_enum < aud_I2S_periode_end; periode_enum++)
            {
                temp_cal[samplerate_enum][i2s_mode_enum][periode_enum]=aud_I2S_calculate_num_and_den(samplerate_enum, i2s_mode_enum, periode_enum);
            }
        }


        i2s_mode_enum = aud_I2S_mode_mono;
        for (samplerate_enum=aud_I2S_samplerate_08000; samplerate_enum< aud_I2S_samplerate_end; samplerate_enum++)
    {
        for(periode_enum = aud_I2S_periode_64; periode_enum < aud_I2S_periode_18; periode_enum++)
            {
                temp_cal[samplerate_enum][i2s_mode_enum][periode_enum]=aud_I2S_calculate_num_and_den(samplerate_enum, i2s_mode_enum, periode_enum);
            }
        }
    }
#endif
}


/****************************************************************************************
* Function:... void Turn_off_I2S1_TxRx
* Description: Turns sets the I/O ports into neutra posiotion to save power
****************************************************************************************/
static void Turn_off_I2S1_TxRx(void)
{

    aud_I2S_setup_pin(aud_I2S1_Rx_pin, aud_I2S_PIN_off);
    aud_I2S_setup_pin(aud_I2S1_Tx_pin, aud_I2S_PIN_off);
    aud_I2S_setup_pin(aud_I2S1_Clk0_pin, aud_I2S_PIN_off);
    aud_I2S_setup_pin(aud_I2S1_Clk1_pin, aud_I2S_PIN_off);

#ifdef AUD_I2S_4PIN_CONFIG
    aud_I2S_setup_pin(aud_I2S1_Wa0_pin, aud_I2S_PIN_off);
    aud_I2S_setup_pin(aud_I2S1_Wa1_pin, aud_I2S_PIN_off);
#endif //AUD_I2S_4PIN_CONFIG
}

#ifdef _USE_CUT_TEAKLIT_CODE
/****************************************************************************************
* Function:...  Aud_I2S_get_info
* Returns:....  Returns the value of to variable pointet to by the input enum
****************************************************************************************/
UINT32 Aud_I2S_get_info(aud_I2S_get_info_enum variable)
{
    UINT32 ret=0;
    switch(variable)
    {
    case aud_I2S_get_info_I2S1_mode_pointer:
    {
        ret = (UINT32) I2S1_settings.mode_pointer;
    }
    break;

    case aud_I2S_get_info_dai_mode:
    {
        ret = (UINT32) dai_mode;
    }
    break;
    }
    return ret;
}
#endif
/****************************************************************************************
* Function:... AudI2S1SM
* Description: The I2S1 state machine - I2S1
****************************************************************************************/
BOOL AudI2S1SM(aud_event_enum event, void* pData)
{
    disp_to_SM_data_type *SM_data = (disp_to_SM_data_type*)pData; //contains the structure passed from the dispatcher
    BOOL ret = TRUE;
    static aud_SM_state_enum my_state = S_idle;
    //UINT16 time_start = 0;
    static aud_I2S_clk_handle_type clk_handleI2S1;
    static UINT8 AUD_i2s1_sm_execution_complete = TRUE;

#ifdef LLT
    //time_start = RTT_stm_get_time_10us_resolution(); //Get start time
#endif
#if 0
    //tracing
    /* Send string : at+xl1set="l22 14l" To enable this LLT trace */
    aud_common_trace( llt_group_audio2, llt_type_audio_sm_i2s1, 11, 0,               // LLT params
                      'P', 0x08,                                               // LIS params
                      aud_log_lis_display, aud_log_lis_display_nodata, aud_log_llt_trace, // LIS params
                      (UINT32) time_start,
                      (UINT32) event,
                      (UINT32) SM_data->parm1,
                      (UINT32) SM_data->parm2,
                      (UINT32) SM_data->parm3,
                      (UINT32) SM_data->parm4,
                      (UINT32) SM_data->parm5,
                      (UINT32) SM_data->parm6,
                      (UINT32) SM_data->parm7,
                      (UINT32) SM_data->parm8,
                      (UINT32) E_audio_llt_type_id_0  );
#endif


    /* Prevent simultaneous access of state machine */
    if(FALSE == AUD_i2s1_sm_execution_complete)
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Simultaneous access of I2S1 state machine !!",FALSE)
        return FALSE;
    }

    AUD_i2s1_sm_execution_complete = FALSE;

    switch (my_state)
    {
        /*-------------------------------------------------------------------*/
        /*                           Idle state                              */
        /*-------------------------------------------------------------------*/
    case S_idle:
        switch (event)
        {
        case E_I2S1_configure:
        {
            aud_I2Sx_mode_enum mode_pointer = aud_I2Sx_mode1;
            //Finding the the place in the array where the mode are defined
            for (mode_pointer=aud_I2Sx_mode1; mode_pointer<=aud_number_of_i2s1_modes; mode_pointer++)
            {
                if (mode_pointer==aud_number_of_i2s1_modes)
                {
                    /* AUD_LOCAL_ERROR(TRAP_AUD_ERROR) */
                    AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Wrong I2S1 Mode",mode_pointer)
                    return ret;
                }
                if (aud_i2s1_configuration[mode_pointer].I2S_mode_enum==((disp_to_SM_data_type*) SM_data)->parm1)
                    break;
            }
            I2S1_settings.mode_pointer = mode_pointer;
            break;
        }

        case E_I2S1_enable:
            clk_handleI2S1 = I2S_SetClock();
            aud_drv_setup_I2S1(I2S1_settings.mode_pointer);
            my_state=S_active;
            break;

        case E_I2S1_disable:
            break;

        default:
            ret = FALSE;
            break;
        }
        break;
        /*-------------------------------------------------------------------*/
        /*                          Active state                             */
        /*-------------------------------------------------------------------*/
    case S_active:
        switch (event)
        {
        case E_I2S1_configure:
        {
            aud_I2Sx_mode_enum mode_pointer=aud_I2Sx_mode1;
            //Finding the the place in the array where the mode are defined
            for (mode_pointer=aud_I2Sx_mode1; mode_pointer<=aud_number_of_i2s1_modes; mode_pointer++)
            {
                if (mode_pointer==aud_number_of_i2s1_modes)
                {
                    /* AUD_LOCAL_ERROR(TRAP_AUD_ERROR) */
                    AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Wrong I2S1 Mode",mode_pointer)
                    return ret;
                }

                if (aud_i2s1_configuration[mode_pointer].I2S_mode_enum==((disp_to_SM_data_type*) SM_data)->parm1)
                    break;
            }
            I2S1_settings.mode_pointer = mode_pointer;
            aud_drv_setup_I2S1(I2S1_settings.mode_pointer);
            aud_enable_path_and_resource(aud_resource_end, S_active, FALSE);/* To update I2S1 */
            break;
        }

        case E_I2S1_enable:
            break;

        case E_I2S1_disable:
            if(!I2S_ResetClock(clk_handleI2S1))
            {
                AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "I2S clock handle is wrong",event)
            }
            clk_handleI2S1 = 0;
            Turn_off_I2S1_TxRx();
            my_state=S_idle;
            break;

        default:
            ret = FALSE;
            break;
        }
        break;
    }

    AUD_i2s1_sm_execution_complete = TRUE;
    return ret;
}


/****************************************************************************************
* Function:... void aud_drv_setup_I2S1( )
* Parameters:. Mode : decides mode and is used to index into correct parameter set.
* Description: configure I2S1 pins.
****************************************************************************************/
static void aud_drv_setup_I2S1( UINT16 mode_pointer)
{
    if (mode_pointer != aud_I2Sx_mode_end)
    {
        //Testing to see if the SGOLD is in master or Slave mode for I2S1 CLK0 and WA0
        if ((aud_i2s1_configuration [mode_pointer].csel & BITMASK_CLK0SEL )!=CLK0_IN_SLAVE_MODE)
        {   /* I2S Master mode */
            aud_I2S_setup_pin(aud_I2S1_Clk0_pin, aud_I2S_PIN_output);
            aud_I2S_setup_pin(aud_I2S1_Wa0_pin, aud_I2S_PIN_output);
        }
        else
        {
            /* I2S Slave mode */
            aud_I2S_setup_pin(aud_I2S1_Clk0_pin, aud_I2S_PIN_input);
            aud_I2S_setup_pin(aud_I2S1_Wa0_pin, aud_I2S_PIN_input);
        }


        aud_I2S_setup_pin(aud_I2S1_Rx_pin, aud_I2S_PIN_input);
        aud_I2S_setup_pin(aud_I2S1_Tx_pin, aud_I2S_PIN_output);

        aud_setup_i2s1_vb_on_parameters(aud_i2s1_configuration [mode_pointer].csel,
                                        aud_i2s1_configuration [mode_pointer].den0,
                                        aud_i2s1_configuration [mode_pointer].den1,
                                        aud_i2s1_configuration [mode_pointer].num0,
                                        aud_i2s1_configuration [mode_pointer].num1,
                                        aud_i2s1_configuration [mode_pointer].rxconf,
                                        aud_i2s1_configuration [mode_pointer].txconf
#ifndef STEON2_PROJECT
                                        ,
                                        aud_i2s1_configuration [mode_pointer].hwmode,
                                        aud_i2s1_configuration [mode_pointer].channel_mode
#endif
                                       );

    }
    else
    {
        /* AUD_LOCAL_ERROR(TRAP_AUD_ERROR); // OCCURS if I2S1 path is set and activated before AUD_configure_bluetooth() is called!! */
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Wrong I2S1 Mode",mode_pointer)
    }
#if 0
    aud_common_trace( llt_group_audio2, llt_type_audio_sm_i2s1, 2, 0,               // LLT params
                      'G', 0x34,                                               // LIS params
                      aud_log_lis_display, aud_log_lis_display_data, aud_log_lis_llt_trace, // LIS params
                      (UINT32) mode_pointer,
                      (UINT32) E_audio_llt_type_id_1 );
#endif


}
#ifdef _USE_CUT_TEAKLIT_CODE
/*****************************************************************************
* Function:... InitDAI
* Description: Prepare PCL / interrupt for using DAI
******************************************************************************/
static void InitDAI(void)
{
    AUD_DAIRESET_CCM = (AUD_DAIRESET_CCM_DISABLE & AUD_DAIRESET_CCM) & ~(0x7000);
    NU_Create_HISR(&AUD_I2S2DAI_HISR_control, "DAI Reset Interrupt", AUD_DAIReset_lowisr, 2, &I2S2DAIResetInt_hisr_stack, 600);
}

/****************************************************************************************
* Function:... aud_dai_mode
* Description: Enters the specified DAI mode
****************************************************************************************/
void aud_dai_mode(aud_dai_mode_enum dai_mode)
{
    SetDAI(dai_mode);
} /* End of function aud_dai_mode */
#endif
/****************************************************************************************
* Function:... SetDAI
* Parameters:. dai_mode: Specifies the DAI mode which the phone should enter.
* Description: Put the phone in the specified DAI mode.
****************************************************************************************/
static void SetDAI(UINT16 mode)
{
    POW_RETURN_RESULT_T pow_clock = POW_OK;
#if 0
    aud_common_trace( llt_group_audio, llt_type_audio_function_interface, 1, 0,               // LLT params
                      'G', 0x24,                                               // LIS params
                      aud_log_lis_display, aud_log_lis_display_data, aud_log_lis_trace, // LIS params
                      (UINT32) mode );
#endif

    /*Set-up I2S2 to dai mode*/
    /*dai mode IS NOT SUPPORTED*/
#ifdef STEON2_PROJECT
    aud_dsp_vb_i2s2_parms.Rx_Switch =4;
    aud_dsp_vb_i2s2_parms.Tx_Switch = 4;
    aud_dsp_vb_i2s2_parms.I2S2_TX_PPM = 0x05;
#else
    aud_dsp_vb_i2s2_parms.Switch          = aud_enable_pcm_channel_and_Dai; //switch
#endif
    aud_dsp_vb_i2s2_parms.SI2Sx_SCEL      = 0x00B0; //csel
    aud_dsp_vb_i2s2_parms.SI2Sx_DEN0      = 0x00FA; //den0
    aud_dsp_vb_i2s2_parms.SI2Sx_DEN1      = 0x00FA; //den1
    aud_dsp_vb_i2s2_parms.SI2Sx_NUM0      = 0x1001; //num0
    aud_dsp_vb_i2s2_parms.SI2Sx_NUM1      = 0x1001; //num1
    aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF    = 0x0000; //rxconf
    aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF    = 0x0000; //txconf
    aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate = 0x0000; //rate
    aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode = 0x0000; //mode

    //special stuff for DAI mode
    /*huojishan 2008.04.04*/
    //pow_clock =POW_SetClockDemands(POW_CLK_I2S, TRUE);
    /*klocwork 3  INVARIANT_CONDITION.UNREACH delete if*/
	/*
    if(pow_clock != POW_OK)
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "I2S1 clock is not set up");
    }*/

    InitDAI();
    #if 0
    *PCL_pad(PAD_I2S2_CLK0) = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);
    *PCL_pad(PAD_I2S2_RX)   = PCL_ENABLE | PCL_PD      | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(1) | PCL_OS(0);
    *PCL_pad(PAD_I2S2_TX)   = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);
    *PCL_pad(PAD_I2S2_WA0)   = PCL_ENABLE | PCL_PU      | PCL_OPEN_DRAIN | PCL_INTERNAL_SIG | PCL_IS(2) | PCL_OS(0);// made as input
    #endif
#ifndef STEON2_PROJECT	/* add this after the mepeh merge to the general code*/
//	CC_ActivateExtInt( CC_I2S2DAIResetInt, CC_FallingEdge_v, &AUD_I2S2DAI_HISR_control);
#endif
    DspStopToneGenerator();
    aud_speech_SM(E_speech_enable, NULL);

    DSP_ASYNC_VB_I2S2(&aud_dsp_vb_i2s2_parms);

    DspSetVoiceBandPath(mode);
}
#ifdef _USE_CUT_TEAKLIT_CODE

/****************************************************************************************
* Function:... DspSetVoiceBandPath
* Parameters:.
* Description:
****************************************************************************************/
void DspSetVoiceBandPath(UINT16 mode)
{
    DISABLE_CLOCK;
    dai_mode = mode;

    DSP_ASYNC_VB_DAI(&dai_mode);
#if 0
    aud_common_trace( llt_group_audio, llt_type_audio_dsp_VB_gain, 1, 0,               // LLT params
                      'G', 0x22,                                               // LIS params
                      aud_log_lis_display, aud_log_lis_display_data, aud_log_lis_trace, // LIS params
                      (UINT32) mode );
#endif


    ENABLE_CLOCK;
} /* End of function DspSetVoiceBandPath */
/****************************************************************************************
 * Function:... AUD_DAIReset_lowisr
 * Description: Called from interrupt entry when DAI reset occurs
 ****************************************************************************************/
static void AUD_DAIReset_lowisr(void)
{
#ifndef STEON2_PROJECT	/* add this after the mepeh merge to the general code*/

//    CC_DeactivateExtInt( CC_I2S2DAIResetInt);
#endif
    if (AUD_DAIRESET_CCM & 0x2000) //check for falling edge
    {
        // Configure Pin from I2S2_CLK0 to GPIO output high
        PCL_31 = 0x00000700;
#ifdef STEON2_PROJECT
        aud_dsp_vb_i2s2_parms.Rx_Switch = aud_disable_pcm_channel;
        aud_dsp_vb_i2s2_parms.Tx_Switch = aud_disable_pcm_channel;
#else
        aud_dsp_vb_i2s2_parms.Switch = aud_disable_pcm_channel;
#endif
        DSP_ASYNC_VB_I2S2(&aud_dsp_vb_i2s2_parms);
#ifndef STEON2_PROJECT
        //CC_ActivateExtInt( CC_I2S2DAIResetInt, CC_RaisingEdge_v, &AUD_I2S2DAI_HISR_control);
#endif
        return;
    }

    if (AUD_DAIRESET_CCM & 0x1000) //check for rising edge
    {
        *PCL_pad(PAD_I2S2_CLK0) = PCL_ENABLE | PCL_NO_PUPD | PCL_PUSH_PULL  | PCL_INTERNAL_SIG | PCL_IS(0) | PCL_OS(1);
        DSP_ASYNC_VB_SET_GAIN(&aud_dsp_gain_parms);
        DSP_ASYNC_VB_SET_BIQUAD(&aud_dsp_uplink_filter_parms);
        DSP_ASYNC_VB_HW(&aud_dsp_vb_hw_parms_global);
#ifdef STEON2_PROJECT
        aud_dsp_vb_i2s2_parms.Rx_Switch = aud_enable_pcm_channel_and_Dai;
        aud_dsp_vb_i2s2_parms.Tx_Switch = aud_enable_pcm_channel_and_Dai;
        aud_dsp_vb_i2s2_parms.I2S2_TX_PPM = 0x05;
#else
        aud_dsp_vb_i2s2_parms.Switch = aud_enable_pcm_channel_and_Dai;
#endif
        aud_dsp_vb_i2s2_parms.SI2Sx_SCEL      = 0x0000;
        aud_dsp_vb_i2s2_parms.SI2Sx_NUM0      = 0x1004;
        aud_dsp_vb_i2s2_parms.SI2Sx_DEN0      = 0x03e8;
        aud_dsp_vb_i2s2_parms.SI2Sx_NUM1      = 0x1004;
        aud_dsp_vb_i2s2_parms.SI2Sx_DEN1      = 0x03e8;
        aud_dsp_vb_i2s2_parms.SI2Sx_RXCONF    = 0x0000;
        aud_dsp_vb_i2s2_parms.SI2Sx_TXCONF    = 0x0000;
        aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Rate = 0x0;
        aud_dsp_vb_i2s2_parms.SI2Sx_I2s2_Mode = 0x0;

        DSP_ASYNC_VB_I2S2(&aud_dsp_vb_i2s2_parms);
        DSP_ASYNC_VB_DAI(&dai_mode);
#ifndef STEON2_PROJECT
        //CC_ActivateExtInt( CC_I2S2DAIResetInt, CC_FallingEdge_v, &AUD_I2S2DAI_HISR_control);
#endif
        return;
    }
}
#endif
/* Function set the I2S clock range and clock demands, also disables power saving,
returnes a handle to a clock which has to be used by a specific I2Sx modul*/
static aud_I2S_clk_handle_type I2S_SetClock(void)
{
    aud_I2S_clk_handle_type new_handle;
    POW_RETURN_RESULT_T pow_clock = POW_OK;
    if ( clk_handle != 0)/* if clock already running, do not do anyhting*/
    {
        new_handle=aud_I2S_clk_generate_handle(&clk_handle); /* clock is enabled*/
        return new_handle;
    }
    else
    {
        /*huojishan 2008.04.04*/
        //pow_clock =POW_SetClockDemands(POW_CLK_I2S, TRUE);
        /*klocwork 3  INVARIANT_CONDITION.UNREACH delete if*/
	    /*
        if(pow_clock != POW_OK)
        {
            AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "I2S1 clock is not set up",pow_clock)
            return FALSE;
        }*/
        new_handle=aud_I2S_clk_generate_handle(&clk_handle); /* clock is enabled*/
        return new_handle;
    }
}

/* Function switch off the clock and enable power saving*/
static BOOL I2S_ResetClock(UINT32 handle)
{
    POW_RETURN_RESULT_T pow_clock = POW_OK;
    BOOL ret = TRUE;

    if((handle & clk_handle) == 0)/* if for some reason wrong handle is used*/
    {
        return FALSE;
    }
    aud_I2S_clk_remove_handle(&clk_handle, handle);
    if( clk_handle > 0)/* if clock is needed still, do nothing*/
    {
        ret = TRUE;
    }
    else
    {
        /*huojishan 2008.04.04*/
        //pow_clock = POW_SetClockDemands(POW_CLK_I2S, FALSE);
        /*klocwork 3  INVARIANT_CONDITION.UNREACH delete if*/
		/*
        if(pow_clock != POW_OK)
        {
            AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "I2S clock is not set up",pow_clock)
            return FALSE;
        }*/
        ret = TRUE;
    }

    return ret;
}



/*[Begin] [lvwenhua-2010/11/5]*/
/****************************************************************************************
* Function:... AudAFEI2SSM
* Description: The AFEI2S state machine - AFEI2S
****************************************************************************************/
BOOL AudAFEI2SSM(aud_event_enum event, void* pData)
{
    disp_to_SM_data_type *SM_data = (disp_to_SM_data_type*)pData; //contains the structure passed from the dispatcher
    BOOL ret = TRUE;
    static aud_SM_state_enum my_state = S_idle;
    static UINT8 AUD_afei2s_sm_execution_complete = TRUE;

    /* Prevent simultaneous access of state machine */
    if(FALSE == AUD_afei2s_sm_execution_complete)
    {
        return FALSE;
    }

    AUD_afei2s_sm_execution_complete = FALSE;

    switch (my_state)
    {
        /*-------------------------------------------------------------------*/
        /*                           Idle state                              */
        /*-------------------------------------------------------------------*/
    case S_idle:
        switch (event)
        {
        case E_AFEI2S_configure:
        {
            aud_I2Sx_mode_enum mode_pointer = aud_I2Sx_mode1;
            //Finding the the place in the array where the mode are defined
            for (mode_pointer=aud_I2Sx_mode1; mode_pointer<=aud_number_of_afei2s_modes; mode_pointer++)
            {
                if (mode_pointer==aud_number_of_afei2s_modes)
                {
                    return ret;
                }
                if (aud_afei2s_configuration[mode_pointer].I2S_mode_enum==((disp_to_SM_data_type*) SM_data)->parm1)
                    break;
            }
            AFEI2S_settings.mode_pointer = mode_pointer;
            break;
        }

        case E_AFEI2S_enable:
            aud_drv_setup_AFEI2S(AFEI2S_settings.mode_pointer);
            my_state=S_active;
            break;

        case E_AFEI2S_disable:
            break;

        default:
            ret = FALSE;
            break;
        }
        break;
        /*-------------------------------------------------------------------*/
        /*                          Active state                             */
        /*-------------------------------------------------------------------*/
    case S_active:
        switch (event)
        {
        case E_AFEI2S_configure:
        {
            aud_I2Sx_mode_enum mode_pointer=aud_I2Sx_mode1;
            //Finding the the place in the array where the mode are defined
            for (mode_pointer=aud_I2Sx_mode1; mode_pointer<=aud_number_of_afei2s_modes; mode_pointer++)
            {
                if (mode_pointer==aud_number_of_afei2s_modes)
                {
                    return ret;
                }

                if (aud_afei2s_configuration[mode_pointer].I2S_mode_enum==((disp_to_SM_data_type*) SM_data)->parm1)
                    break;
            }
            AFEI2S_settings.mode_pointer = mode_pointer;
            aud_drv_setup_AFEI2S(AFEI2S_settings.mode_pointer);
            aud_enable_path_and_resource(aud_resource_end, S_active, FALSE);/* To update AFEI2S */
            break;
        }

        case E_AFEI2S_enable:
            break;

        case E_AFEI2S_disable:
            my_state=S_idle;
            break;

        default:
            ret = FALSE;
            break;
        }
        break;
    }

    AUD_afei2s_sm_execution_complete = TRUE;
    return ret;
}


SINT32 zDrvAud_DspCfgI2sMode( VOID *pI2sCfg)
{

    SINT32  ret = DRV_SUCCESS;
    aud_I2Sx_mode_enum mode_pointer = aud_I2Sx_mode1;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgI2sMode start!\n");


    for (mode_pointer=aud_I2Sx_mode1; mode_pointer <= aud_number_of_afei2s_modes; mode_pointer++)
    {
        if (mode_pointer == aud_number_of_afei2s_modes)
        {
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgI2sMode mode_pointer not support =%d!\n",mode_pointer);
            return DRV_ERR_INVALID_PARAM;
        }
        if (aud_afei2s_configuration[mode_pointer].I2S_mode_enum==((aud_afei2s_configuration_type*) pI2sCfg)->I2S_mode_enum)
        {
            aud_afei2s_configuration[mode_pointer]=*((aud_afei2s_configuration_type*) pI2sCfg);
            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgI2sMode edit AfeI2sCfg ok,mode_pointer=%d!\n",mode_pointer);
            break;
        }
    }



    return ret;
}


SINT32 zDrvAud_DspCfgPcmMode( VOID *pPcmCfg)
{

    SINT32  ret = DRV_SUCCESS;
    U16 mode_pointer = 0;
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgPcmMode start!\n");

    for(mode_pointer=0; mode_pointer <= aud_number_of_i2s1_modes; mode_pointer++)
    {
        if( mode_pointer >= aud_number_of_i2s1_modes)
        {

            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgPcmMode mode_pointer not support =%d!\n",mode_pointer);
            return DRV_ERR_INVALID_PARAM;
        }


        if (aud_i2s1_configuration[mode_pointer].I2S_mode_enum==((aud_i2s1_configuration_type*) pPcmCfg)->I2S_mode_enum)
        {
            aud_i2s1_configuration[mode_pointer].csel=((aud_i2s1_configuration_type*) pPcmCfg)->csel;
            aud_i2s1_configuration[mode_pointer].den0=((aud_i2s1_configuration_type*) pPcmCfg)->den0;
            aud_i2s1_configuration[mode_pointer].den1=((aud_i2s1_configuration_type*) pPcmCfg)->den1;
            aud_i2s1_configuration[mode_pointer].num0=((aud_i2s1_configuration_type*) pPcmCfg)->num0;
            aud_i2s1_configuration[mode_pointer].num1=((aud_i2s1_configuration_type*) pPcmCfg)->num1;
            aud_i2s1_configuration[mode_pointer].rxconf=((aud_i2s1_configuration_type*) pPcmCfg)->rxconf;
            aud_i2s1_configuration[mode_pointer].txconf=((aud_i2s1_configuration_type*) pPcmCfg)->txconf;
            aud_i2s1_configuration[mode_pointer].hwmode=((aud_i2s1_configuration_type*) pPcmCfg)->hwmode;
            aud_i2s1_configuration[mode_pointer].channel_mode=((aud_i2s1_configuration_type*) pPcmCfg)->channel_mode;

            zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "zDrvAud_DspCfgPcmMode edit pPcmCfg ok,mode_pointer=%d!\n",mode_pointer);
            break;
        }


    }

    return ret;
}



/****************************************************************************************
* Function:... void aud_drv_setup_AFEI2S( )
* Parameters:. Mode : decides mode and is used to index into correct parameter set.
* Description: configure AFEI2S pins.
****************************************************************************************/
static void aud_drv_setup_AFEI2S( UINT16 mode_pointer)
{
    zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "aud_drv_setup_AFEI2S start!\n");

    if (mode_pointer != aud_I2Sx_mode_end)
    {
        aud_setup_afei2s_vb_on_parameters(aud_afei2s_configuration [mode_pointer].csel,
                                          aud_afei2s_configuration [mode_pointer].den0,
                                          aud_afei2s_configuration [mode_pointer].den1,
                                          aud_afei2s_configuration [mode_pointer].num0,
                                          aud_afei2s_configuration [mode_pointer].num1,
                                          aud_afei2s_configuration [mode_pointer].rxconf,
                                          aud_afei2s_configuration [mode_pointer].txconf,
                                          aud_afei2s_configuration [mode_pointer].hwmode,
                                          aud_afei2s_configuration [mode_pointer].sample
                                         );

    }
}

/*[End] [lvwenhua-2010/11/5]*/
/* End of file. */
