/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  Library for function related to internal polyphonic ringer for the audio driver.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_intern_midilib.h
 *   Version: \main\25
 *   Date: 2007-03-13 12:11:32
 *   Responsible: wip_spr
 *   Comment:
 *     Adding extern variable...
 */
#ifndef _AUD_MIDILIB
#define _AUD_MIDILIB

#ifdef INTERNAL_POLYRINGER
//#include "scttypes.h"
//#include "ms.h"
#include "bastypes.h"
#include "drvs_teak.h"
//#include "dsp_sgold3_aud_ext.h"

/*---------------------------------------------*/
/* Defines                                                                   */
/*---------------------------------------------*/
#define MIDI_MAX_NUM_OF_TRACKS   32

/* Size of converter event buffer (required for converter generated events
   such as Timing Clock). Currently the biggest message is Time Signature
   (11 data bytes + length -> 12 bytes required).*/
#define CONV_EVENT_BUFFER_SIZE    12

#define AUD_NOF_SUSPENDNEST 5

#define MIDI_USE_16kHz_INSTRUMENTS   1
#define MIDI_USE_32kHz_INSTRUMENTS   6
#define MIDI_USE_48kHz_INSTRUMENTS   8

/*---------------------------------------------*/
/* Structure Define                                                      */
/*---------------------------------------------*/
typedef struct {
    UINT32 write_flag;
    UINT8   value[16];
}midi_internal_status_type;

typedef struct {
    UINT32 write_flag;
    UINT8   value1[16];
    UINT8   value2[16];
}midi_internal_status2_type;

enum midi_player_states_enum {
    S_midi_idle,
    S_midi_waiting_to_start,
    S_midi_playing,
    S_midi_waiting_to_close
};

enum midi_data_buff_status_enum {
    data_buff_status_idle,
    data_buff_status_fill,
    data_buff_status_busy,
    data_buff_status_ready,
    data_buff_status_eof
};
typedef UINT8 midi_data_buff_status_enum;

enum melody_conv_errors_enum {
    melody_error_none=0,
    midi_error_file_end,
    midi_error_invalid_header,
    midi_error_invalid_format,
    midi_error_invalid_tracks_number,
    midi_error_invalid_smpte,
    midi_error_file_empty,
    midi_error_file_truncated,
    midi_error_invalid_division,
    imelody_error_invalid_header,
    imelody_error_file_empty,
    imelody_error_file_truncated,
    imelody_error_parsing,

    melody_error_last
};
typedef UINT8 melody_conv_errors_enum;

typedef struct {
    huge UINT8  *p_track_start;
    huge UINT8  *p_track_end;
    huge UINT8  *p_track_data;
    UINT8  track_ended;
    UINT8  last_status;           /* for supporting running status */
    SINT32 delta_time;
}midi_track_info_type;

typedef struct {
    /* calculated start time of current event in extended precision frame indices
       relative to current frame start  */
    SINT32        calc_index;
    /* next available (free) write position in frame indices relative to current
       frame start */
    SINT32        write_index;
    /* number of bytes of the current event which still have to be written */
    SINT32        n_bytes2write;
    /* conversion factor needed for transformation of delta time in ticks to
       delta time in indices. Depends on tempo and division value in MIDI file */
    UINT32    ticks2index;
    UINT16    division; /* <division> parameter from MIDI File header */
    UINT8    format;
    UINT8 norm_flag;    /* For Volume normalization */
    UINT8 delta_velocity;
    UINT8 delta_volume;
    UINT8 delta_expression;
    UINT16 vol_corr_flags;

    /* Number of tracks in MIDI file (format 0: 1+1, format 1: [1, ..., MIDI_MAX_NUM_OF_TRACKS]) + 1 
      (converter event track) */
    UINT8    number_of_tracks;

    /* track number from which currently processed event originates from */
    UINT8    active_track;

    /* Parameters for converter generated events (MIDI Clock, Barmarker):
    Distance between two MIDI clocks in ticks */
    SINT32    midi_clock_delta_time_max;

    /* Distance between two bar-marker events in ticks */
    SINT32 bar_marker_delta_time_max;

    /* Distance from current position to next MIDI clock in ticks */
    SINT32    midi_clock_delta_time;

    /* Distance from current position to next bar-marker event in ticks */
    SINT32 bar_marker_delta_time;

    UINT8 conv_event_buffer[CONV_EVENT_BUFFER_SIZE]; /* Buffer for converter generated events */
    UINT8   resume;
    UINT32  delta_time;
    UINT32  n_event_processed;
    UINT32  n_noteonoff_processed;
    UINT32  n_event_resume;
    UINT8 reset; /* for Restarting: reset flag */
    /* Track info for each track, one additional track for converter
      generated events (track 0). */
    midi_track_info_type track_info[MIDI_MAX_NUM_OF_TRACKS + 1];
    /* only for a fast chasing: */
    midi_internal_status_type BankSelectMSB;
    midi_internal_status_type BankSelectLSB;
    midi_internal_status_type ModulationDepthMSB;
    midi_internal_status_type ModulationDepthLSB;
    midi_internal_status_type ChannelVolumeMSB;
    midi_internal_status_type ChannelVolumeLSB;
    midi_internal_status_type PanMSB;
    midi_internal_status_type PanLSB;
    midi_internal_status_type ExpressionMSB;
    midi_internal_status_type ExpressionLSB;
    midi_internal_status_type ProgramChange;
    midi_internal_status2_type PitchBendChange;
    UINT16 resume_status_index;
    UINT16 active_channels;
    UINT16 set_volume_channels;
    UINT8 skip_status;
    UINT32 frames_passed; //nof 20ms frames parsed and stored into the buffer - not the frames send to FW synth
    UINT32 set_pos; //used to store the position wanted when using set position functionality - as number of 20ms frames
} midi_conv_statics_t;

typedef struct {
    SINT32 write_index;
    UINT8 cmd[3];
} midi_cmd_item_type;

typedef struct {
    SINT32        calc_index;       /* calculated start time of current event in extended 
                                       precision frame indices relative to current frame start  */
    huge UINT8 * p_imelody_start;   /* pointer to start of melody */
    huge UINT8 *p_imelody_end;      /* pointer to end of melody */
    huge UINT8 *p_imelody_data;     /* pointer to imelody data to be parsed */
    UINT32   midi_indeces_per_full_note; /* conversion factor needed to transformation of notes
                                            to delta time in indices depends on beat */
    UINT8 compute_volume;           /* for volume normalization */
    UINT8 delta_volume;
    UINT8 reset;                    /* for Restarting: reset flag */
    UINT8 style;                    /* style of imelody : 0,1,2 */
    UINT8 volume                    /* volume from 0 to 15 */;                    
    UINT8 start_volume;
    UINT8 octave;                   /* octave from 0 to 8 */
    UINT8 led_status;               /* led vibro and backlight indicators */
    UINT8 vibe_status;
    UINT8 backlight_status;
    UINT8 repeat_flag;              /* in repeat loop flag */
    UINT16 repeat_count;
    huge UINT8 *p_repeat_start;
    midi_cmd_item_type cmd_queue[6];/* commands queue */ 
    UINT8 cmd_queue_len;
    UINT32 n_event_processed;       /* number of notes processed for resuming */   
    UINT32 n_event_resume;
    UINT8   resume;
    //added for setting play position
    UINT8 skip_status;
    UINT32 frames_passed; //nof 20ms frames parsed and stored into the buffer - not the frames send to FW synth
    UINT32 set_pos; //used to store the position wanted when using set position functionality - as number of 20ms frames

} imelody_conv_statics_t;

typedef struct {
    huge UINT8       *melody_data;
    UINT32            melody_size;
    aud_format_enum   format;
    UINT16            nof_repeats;
    UINT16            caller_id;
    SDL_Pid           sender;
    UINT32  n_event_processed;
    UINT32  frames_passed;
}melody_suspend_item_type;

typedef struct {
    melody_suspend_item_type MelodySlot[AUD_NOF_SUSPENDNEST];
    UINT8 AssignedSuspendSlot; 
}aud_glob_melody_suspend_array_type;

typedef struct {
    huge UINT8                *melody_data;
    UINT32                    melody_size;
    aud_format_enum           format;  
    UINT16                    nof_repeats;
    UINT16                    caller_id;
    SDL_Pid                   sender;
    UINT16                    midi_pointer;
    melody_conv_errors_enum   melody_conv_error;
    midi_conv_statics_t       midi_conv_statics;
    imelody_conv_statics_t    imelody_conv_statics;
    UINT16                    *data_buff_read;  /* ping-pong buffers for data exchange with DSP */
    UINT16                    *data_buff_write;
    midi_data_buff_status_enum data_buff_status; /* 0-1 semaphore used for checking midi conversion completion */ 
    UINT8                     data_buff_read_index;
    UINT32                    total_playtime;
}aud_glob_midi_type;

/*---------------------------------------------*/
/*  Global variables                                                      */
/*---------------------------------------------*/
extern aud_glob_midi_type     aud_glob_midi;
extern aud_glob_melody_suspend_array_type aud_melody_suspend_array;
extern T_DSP_CMD_MIDI    				 aud_dsp_midi;

/*---------------------------------------------*/
/*  External function declaration. Interface.                   */
/*---------------------------------------------*/
extern UINT8 AUD_get_internal_midi_player_state(void);
extern UINT32 AUD_melody_get_total_playtime(aud_ringer_tone_id_enum midi_id, UINT8 huge *melody_data, UINT32 size, aud_format_enum format);

#endif //INTERNAL_POLYRINGER
#endif

