/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  Library for function related to internal polyphonic ringer for the audio driver.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_intern_midilib_lib.h
 *   Version: \main\3
 *   Date: 2007-05-29 13:26:41
 *   Responsible: jrn
 *   Comment:
 *     Added explanatory comment and removed obsolete calculation with static value - No functional change
 */
//#ifndef _AUD_MIDILIB
//#define _AUD_MIDILIB


/*---------------------------------------------*/
/* Include files.                                                           */
/*---------------------------------------------*/
#ifdef INTERNAL_POLYRINGER
//#include "scttypes.h"
//#include "ms.h"
#include "bastypes.h"


/*---------------------------------------------*/
/* Defines                                                                   */
/*---------------------------------------------*/
#define MIDI_WORDS_PER_20MS_FRAME   65
#define MIDI_NUM_20MS_FRAMES_BUFFERIZED    5
#define MIDI_BUFF_SIZE    (MIDI_WORDS_PER_20MS_FRAME*MIDI_NUM_20MS_FRAMES_BUFFERIZED)

#define OFF 0
#define ON 1
#define NOF_WORDS_TO_DSP_MIDI_INSTRUMENTS 500 //chosen value - due to SM space

/* time window of one output MIDI protocol frame in us.  */
#define FRAME_TIME            20000L

/* log2 of number of valid event start index positions per output frame
   (= log2(frame size in byte - 2)). Only 7 is supported */
#define FRAME_INDEX_SIZE    7

/* number of bytes in one output MIDI protocol frame (extension word included) */
#define FRAME_SIZE            ((1<<FRAME_INDEX_SIZE) + 2)

/* size of an output frame in bytes without extension word */
#define WRITE_INDEX_LIMIT    (1<<FRAME_INDEX_SIZE)

/* log2 of scaling factor used for calculating event
   start times expressed as extended precision frame index values. Supported range:
   CALC_INDEX_SCALING >= 1 
   CALC_INDEX_SCALING + FRAME_INDEX_SIZE <= 21 */
#define CALC_INDEX_SCALING    9

/* size of an output frame without extension word as used for calculations of
   event start times (size in byte scaled by 2^CALC_INDEX_SCALING for higher precision) */
#define CALC_INDEX_LIMIT    (1L<<(FRAME_INDEX_SIZE + CALC_INDEX_SCALING))

//loop through 12 events (0->11 = 0xB) for 16 channels (0->15 = 0xF) when resuming or setting play pos(skipping) => 0xBF
// Add 1 due to code design to ensure that event=11 for channel=16 is also executed
#define MIDI_RESUME_STATUS_ITEMS   0xC0

/* log2 of scaling factor used for calculating event
   start times expressed as extended precision frame index values. Supported range: */
#define IMELODY_CALC_INDEX_SCALING    10

//#define MAX(A,B) (((A) > (B)) ? (A) : (B))
#define MIN(A,B) (((A) < (B)) ? (A) : (B))


/*---------------------------------------------*/
/* Structure Define                                                      */
/*---------------------------------------------*/
enum melody_resume_status_enum
{
    melody_resume_status_off=0,
    melody_resume_status_on, //set when ResumeMelody interface is called
    melody_resume_status_on_final, //this flag set when nof frames passed has reached the wanted resume value - marks end of parsing through events
    melody_resume_status_last //end marker - not used
};

enum melody_skip_status_enum
{
    melody_skip_status_off=0,
    melody_skip_status_init, //not used
    melody_skip_status_on, //set when set_play_pos interface is called - used as flag to check set_play_pos is on going.
    melody_skip_status_on_final, //this flag set when nof frames passed has reached the wanted set_pos value - marks end of parsing through events
    melody_skip_status_last //end marker - not used
};
#endif //INTERNAL_POLYRINGER
//#endif

