/**
 *   Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Library/common functions for the audio driver
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_lib.c
 *   Version: \main\266
 *   Date: 2007-10-01 15:59:11
 *   Responsible: johansek
 *   Comment:
 *     Added Steon2 changes under project define.
 */

 /*===============================================
y?L1G?pow.h?Da???2?̨3??
# 騰a?L1G???3????
#===============================================*/
#if defined(_OS_TOS)
#define _OS_ECOS _OS_TOS
#elif defined(_OS_LINUX)  
#define _OS_LINUX _OS_LINUX
#endif
/*******************************************************************************
*
*                               Include files
*
*******************************************************************************/
#include "bastypes.h"        //miaolin 2013.10.18
//#include "pow.h"             //huojishan 2008.01.01
//#include "scttypes.h"           /* must be included in all files */
#include "aud_drv.h"            /* audio types and functions */
//#include "ms.h"
//#include "aud_mmi_pdef.h"
//#include "ms.h"                 /* must be included in all files */
//#include "ms_os.h"              /* Operating system interface, os_signal_send() etc. */
//#include "stdio.h"        huojishan 2008.01.08
#include "ms_os.h" 
//#include <stdio.h>         //huojishan 2008.01.08
#if !defined (XNOSTATICSTRUCTURE)
//#include "sig_code.h"
#endif
//#include "dsp.h"                /* for DSP command types */
//#include "psv.h"                /* power saving */
//#include "aud_drv.h"            /* audio types and functions */
#include "aud_data.h"           /* data describing the paths */
#include "drvs_rtt.h"                /* real-time timers */
#if defined(TRAP_HANDLING)
//#include "trap.h"               /* for error reporting */
#endif
#if defined (LIS_TRACE)
#include "los_log.h"            /* for LIS tracing */
#endif /* LIS_TRACE */
#if defined (SMPOWER3)
//#include "pmu_hal.h"            /* power saving */
#else
#include "pow_sm.h"
#endif
#include "aud_com.h"            /* audio-common types and function definitions */
//#include "aud_opcodes.h"        /* MMI log buffer */
#include "aud_ext_def.h"        /* media types */
#include "aud_path_control.h"   /* enabling hardware (used by state machines for SM Power amplifier and non-baseband resource) */
#include "aud_volume.h"         /* for updating resource gain */
#include "drvs_teak.h"
//#include "psv.h"

/***** QQQQ TL SDL PMI HACK BEGIN *****/
#if !defined (DWD_MODEM_ONLY)
#if !defined (L1_UMTS_STANDALONE)
//#include "mmi_pdef.h"
//#include "pmi_pptr.h"
#endif
#endif
/***** QQQQ TL SDL PMI HACK END *****/

/*******************************************************************************
*
*                               Local defines
*
*******************************************************************************/
#define AUD_MAX_NOF_DSP_CMD 60
#define AUD_DSP_NO_CMD      0xFE

/*******************************************************************************
*
*                               Internal data
*
*******************************************************************************/
U8  aud_dsp_buffer_index;
U8  aud_dsp_cmd_buffer[AUD_MAX_NOF_DSP_CMD];

#ifdef _USE_CUT_TEAKLIT_CODE
T_DSP_CMD_A3D_PAR aud_dsp_a3d_parms;
#endif

typedef struct {
    BOOL running;
    BOOL initiated;
    rtt_timer_list_type* p_rttSleepTimer;
} aud_lib_sleep_timer_data_type;


/*Change for porting.[Begin] [LvWenhua-2008/4/23]*/
#if 0
static os_sem_t                      aud_lib_sleep_timer_semaphore;
#endif
//static ZOSS_SEMAPHORE_ID                      aud_lib_sleep_timer_semaphore;//xiu
/*[End] [LvWenhua-2008/4/23]*/

static BOOL                          aud_lib_audio_enabled[aud_resource_end]; /* used for power saving */
static aud_SM_state_enum             aud_lib_SM_state[aud_resource_end];      /* active/idle state of the resources */
#if defined (STEON2_PROJECT)
static aud_HW_SRC_choice             aud_HW_SRC_allocation;                   /* variable holding the dynamic HW SRC allocation to a particular player */
#endif /* STEON2_PROJECT */

#ifdef _OS_OSE
extern int _vsnprintf(  char *buffer,   size_t count,   const char *format,  va_list argptr);
#elif defined(_OS_ECOS)
extern int vsnprintf( char *s, size_t size, const char *format, va_list arg );
#define _vsnprintf(s, size, formate, arg) vsnprintf(s, size, formate, arg);
#endif

/*******************************************************************************
*
*                        Externally visible functions
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_add_dsp_cmd_to_buffer
* Return.....: -
* Description: Adds a DSP command to the command buffer.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_add_dsp_cmd_to_buffer(
    U8 cmd) /* the command to add */
{
    U8 i=0;
#ifdef AUDIO_LLT
    aud_common_trace(llt_group_audio, llt_type_audio_dsp_VB_gain, 1, 0,                 /* LLT params */
                     'G', 0x31,                                                         /* LIS params */
                     aud_log_lis_display, aud_log_lis_display_data, aud_log_lis_trace,  /* LIS params */
                     (U32) cmd );
#endif
    /* Check if the command already is in the buffer */
    while(i < aud_dsp_buffer_index)
    {
        if(aud_dsp_cmd_buffer[i] == cmd)
        {
            return; /* Return, CMD already in buffer */
        }
        i++;
    }
    /* Everything is OK - add cmd to buffer */
    aud_dsp_cmd_buffer[aud_dsp_buffer_index] = cmd;
    aud_dsp_buffer_index++;
}

/*------------------------------------------------------------------------------
* Function...: aud_send_response_signal
* Return.....: -
* Description: Sends a response signal to a process that has called a function.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_send_response_signal(
    SDL_Pid sender,             /* which process to send the signal to */
    aud_resource_enum resource, /* the resource the signal concerns */
    S8 rc,                      /* the response signal */
    U32 parm1,                  /* generic parameter */
    U32 parm2,                  /* generic parameter */
    U32 parm3,                  /* generic parameter */
    U32 parm4,                  /* generic parameter */
    U8 *ptr1,                   /* generic parameter */
    U8 *ptr2)                   /* generic parameter */
{
#if 0
    T_AUD_DRV_RSP aud_drv_rsp;
    os_outsig_declare;
#if !defined (DWD_MODEM_ONLY)
/***** QQQQ TL SDL PMI HACK BEGIN *****/
#if !defined (L1_UMTS_STANDALONE)

    /*Change temporarily for porting.[Begin] [LvWenhua-2008/4/23]*/
    #if 0
    sender = pmi_pptr->Self;
    #endif
    /*[End] [LvWenhua-2008/4/23]*/
    
#endif
/***** QQQQ TL SDL PMI HACK END *****/
#endif

    aud_common_trace( llt_group_audio, llt_type_audio_dsp_VB_gain, 7, 0,                /* LLT params */
                     'G', 0x32,                                                         /* LIS params */
                     aud_log_lis_display, aud_log_lis_display_data, aud_log_lis_trace,  /* LIS params */
                     (U32) sender,
                     (U32) resource,
                     (U32) rc,
                     (U32) parm1,
                     (U32) parm2,
                     (U32) parm3,
                     (U32) parm4 );

#if defined (AUD_MODULE_TEST_IFWD)
    if(AUD_to_MMI_log_buf.LogLevel.Level.Enabled == 1)
    {
        AUD_to_MMI_log_buf.LogValues[AUD_to_MMI_log_buf.Cntr] = (U32) rc;
        if(AUD_to_MMI_log_buf.Cntr < AUD_LOG_BUFSIZE - 1)
        {
            AUD_to_MMI_log_buf.Cntr++;
        }
        if(AUD_to_MMI_log_buf.LogLevel.Level.Parameter1)
        {
            AUD_to_MMI_log_buf.LogValues[AUD_to_MMI_log_buf.Cntr] = parm1;
            if(AUD_to_MMI_log_buf.Cntr < AUD_LOG_BUFSIZE - 1)
            {
                AUD_to_MMI_log_buf.Cntr++;
            }
        }
        if(AUD_to_MMI_log_buf.LogLevel.Level.Parameter2)
        {
            AUD_to_MMI_log_buf.LogValues[AUD_to_MMI_log_buf.Cntr] = parm2;
            if(AUD_to_MMI_log_buf.Cntr < AUD_LOG_BUFSIZE - 1)
            {
                AUD_to_MMI_log_buf.Cntr++;
            }
        }
        if(AUD_to_MMI_log_buf.LogLevel.Level.Parameter3)
        {
            AUD_to_MMI_log_buf.LogValues[AUD_to_MMI_log_buf.Cntr] = parm3;
            if(AUD_to_MMI_log_buf.Cntr < AUD_LOG_BUFSIZE - 1)
            {
                AUD_to_MMI_log_buf.Cntr++;
            }
        }
        if(AUD_to_MMI_log_buf.LogLevel.Level.Parameter4)
        {
            AUD_to_MMI_log_buf.LogValues[AUD_to_MMI_log_buf.Cntr] = parm4;
            if(AUD_to_MMI_log_buf.Cntr < AUD_LOG_BUFSIZE - 1)
            {
                AUD_to_MMI_log_buf.Cntr++;
            }
        }
    }
#endif
    /* Init signal parameter for RESPONSE MSG.*/
    aud_drv_rsp.handle       = aud_resource_table[resource].status;
    aud_drv_rsp.drv_id       = aud_resource_table[resource].caller_id;
    aud_drv_rsp.func_id      = 0;
    aud_drv_rsp.return_code  = rc;
    aud_drv_rsp.parm1        = (S32) parm1;
    aud_drv_rsp.parm2        = (S32) parm2;
    aud_drv_rsp.parm3        = (S32) parm3;
    aud_drv_rsp.parm4        = (S32) parm4;

    if(NULL != ptr1)
    {
        memcpy(&aud_drv_rsp.parm5.A[0], ptr1, sizeof(T_AUD_BUF_RSP_1));
    }
    else
    {
        memset(&aud_drv_rsp.parm5.A[0], 0x00, sizeof(T_AUD_BUF_RSP_1));
    }
    if(NULL != ptr2)
    {
        memcpy(&aud_drv_rsp.parm6.A[0], ptr2, sizeof(T_AUD_BUF_RSP_2));
    }
    else
    {
        memset(&aud_drv_rsp.parm6.A[0], 0x00, sizeof(T_AUD_BUF_RSP_2));   
    }
#endif
    /* Send the RESPONSE MSG. */
/*	
    os_signal_alloc_to (sender, AUD_DRIVER_RSP, yPDef_AUD_DRIVER_RSP);
    os_signal_paramassign (AUD_DRIVER_RSP, 1, aud_drv_rsp);
    os_signal_send (sender, "AUD_DRIVER_RSP");
*/
}

/*******************************************************************************
*
*                        Generic state machine control
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_init_SM
* Return.....: -
* Description: Initialises all state machines to the idle state.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_init_SM(void)
{
    U16 cnt;
    for(cnt=0; cnt<aud_resource_end; cnt++)
    {
        aud_lib_SM_state[cnt] = S_idle;
    }
}

/*------------------------------------------------------------------------------
* Function...: aud_get_SM_state
* Return.....: state of the resource
* Description: Returns the state of a given resource's state machine.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
aud_SM_state_enum aud_get_SM_state(
    aud_resource_enum resource) /* the resource which the state is requested for */
{
    return (aud_lib_SM_state[resource]);
}

/*------------------------------------------------------------------------------
* Function...: aud_set_SM_state
* Return.....: -
* Description: Sets the state of a resource's state machine and update gains.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_set_SM_state(
    aud_resource_enum resource, /* the resource for which the state is to be set */
    aud_SM_state_enum state)    /* the new state of the resource's state machine */
{
    /* only update if the state has changed */
    if(state != aud_lib_SM_state[resource])
    {
        aud_lib_SM_state[resource] = state;
        aud_update_resource_gain(resource);
    }
}

/*------------------------------------------------------------------------------
* Function...: aud_SM_active
* Return.....: TRUE if the resource is i active state, FALSE otherwise
* Description: Returns whether a specified resource is active or not.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
U8 aud_SM_active(
    const aud_resource_enum resource)   /* the resource for which the state is requested */
{
    if(S_active == aud_lib_SM_state[resource])
    {
        return (TRUE); /* The resource is active */
    }
    else
    {
        return (FALSE); /* The resource is not active */
    }
}

/*------------------------------------------------------------------------------
* Function...: aud_one_SM_active
* Return.....: TRUE if any resource is active, FALSE otherwise
* Description: Returns whether any resource is active.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
BOOL aud_one_SM_active(void)
{
    U8 resourceID;
    for(resourceID=0; resourceID<aud_resource_end; resourceID++)
    {
        if(S_active == aud_lib_SM_state[resourceID])
        {
            return (TRUE); /* One resource is active */
        }
    }
    return (FALSE);        /* No resources are active */
}

/*------------------------------------------------------------------------------
* Function...: aud_one_baseband_SM_active
* Return.....: TRUE if any baseband resource is active, FALSE otherwise
* Description: Returns whether any baseband resource is active.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
BOOL aud_one_baseband_SM_active(void)
{
    U8 resourceID;
    for(resourceID=0; resourceID<aud_resource_end; resourceID++)
    {
        if(aud_resource_ringer==resourceID    || aud_resource_vibrator==resourceID || 
           aud_resource_amplifier==resourceID || aud_resource_radio==resourceID    ||
           aud_resource_mapi==resourceID      || aud_resource_smpower_backspeaker==resourceID)
        {
            continue;    /* Not a baseband resource, so go to next resource */
        }
        if(S_active == aud_lib_SM_state[resourceID])
        {
            return (TRUE); /* One Baseband resource is active */
        }
    }
    return (FALSE);        /* No baseband resource is active */
}

/*[Begin]This function is used to decide if cbuf biquad and cbuf gain should be set. [lvwenhua-2010/7/28]*/
/*------------------------------------------------------------------------------
* Function...: aud_one_cbuf_SM_active
* Return.....: TRUE if any cbuf resource is active, FALSE otherwise
* Description: Returns whether any cbuf resource is active.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
BOOL aud_one_cbuf_SM_active(void)
{
    if((S_active == aud_lib_SM_state[aud_resource_midi_player])
        ||(S_active == aud_lib_SM_state[aud_resource_I2S2_Rx])
        ||(S_active == aud_lib_SM_state[aud_resource_playback_pcm])
        ||(S_active == aud_lib_SM_state[aud_resource_playback_mp3]))
        
    {
        return (TRUE); /* One cbuf resource is active */
    }
    
    return (FALSE);        /* No cbuf resource is active */
}
/*[End] [lvwenhua-2010/7/28]*/

/*******************************************************************************
*
*                   State machine for SM Power backspeaker
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_send_response_signal
* Return.....: TRUE if the event is handled, FALSE otherwise
* Description: State machine for the SM Power backspeaker.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
BOOL aud_smpower_SM(
    aud_event_enum event,   /* the event to be handled */
    void *p_data)           /* the data to handle the event */
{
    BOOL func_ret = TRUE; /* for indicating whether the the event has been handled */
    switch(aud_get_SM_state(aud_resource_smpower_backspeaker))
    {
        /* Idle state */
        case S_idle:
            switch(event)
            {
                case E_smpower_enable:
                    aud_disable_standby(aud_resource_smpower_backspeaker);
                    aud_enable_path_and_resource(aud_resource_smpower_backspeaker, S_active, TRUE);
                    break;
                case E_smpower_release_disable:
                    break;
                default:
                    func_ret = FALSE; /* event not handled */
                    break;
            }
            break; /* end S_idle */

        /* Active state */
        case S_active:
            switch(event)
            {
                case E_smpower_disable:
                case E_smpower_release_disable:
                    aud_disable_path_and_resource(aud_resource_smpower_backspeaker, S_idle, TRUE);
                    aud_enable_standby(aud_resource_smpower_backspeaker);
                    break;
                default:
                    func_ret = FALSE; /* event not handled */
                    break;
            }
            break; /* end S_active */

        /* Wrong state */
        default:
            func_ret = FALSE;
            break;
    } /* end switch state */
    return (func_ret);
}

/*******************************************************************************
*
*          State machine for the non-baseband (i.e. inband) resource
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_non_baseband_resource_SM
* Return.....: TRUE if the event is handled, FALSE otherwise
* Description: State machine for the non-baseband (inband) resource. Used to
*              enable the AFE even if no baseband resource is active.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
BOOL aud_non_baseband_resource_SM(
    aud_event_enum event,   /* the event to handle */
    void *p_data)            /* the data to handle the event */
{
    BOOL func_ret = TRUE; /* for indicating whether the the event has been handled */
    switch(aud_get_SM_state(aud_resource_inband))
    {
        /* Idle state */
        case S_idle:
            switch(event)
            {
                case E_inband_start:
                    aud_disable_standby(aud_resource_inband);
                    aud_enable_path_and_resource(aud_resource_inband, S_active, TRUE);
                    break;
                case E_inband_release_stop:
                    break;
                default:
                    func_ret = FALSE; /* event not handled */
                    break;
            }
            break; /* end S_idle */

        /* Active state */
        case S_active:
            switch(event)
            {
                case E_inband_stop:
                case E_inband_release_stop:
                    aud_disable_path_and_resource(aud_resource_inband, S_idle, TRUE);
                    aud_enable_standby(aud_resource_inband);
                    break;
                default:
                    func_ret = FALSE; /* event not handled */
                    break;
            }
            break; /* end S_active */

        /* Wrong state */
        default:
            func_ret = FALSE;
            break;
    } /* end switch state */
    return (func_ret);
}

/*******************************************************************************
*
*                            Generic timer control
*
*******************************************************************************/
#ifdef _USE_CUT_TEAKLIT_CODE
/*------------------------------------------------------------------------------
* Function...: aud_drv_check_timeout
* Return.....: -
* Description: Check if any internal timeout has occured.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_drv_check_timeout(void)
{
    /* no longer used, RTT timers used for timekeeping instead */
}

/*******************************************************************************
*
*                           Miscellaneous functions
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_media_type_to_ssal_type
* Return.....: a media type converted to SSAL media type
* Description: Converts a media type to SSAL media type.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
aud_ssal_media_type aud_media_type_to_ssal_type(
    aud_media_enum type)    /* which media type to convert from */
{
    aud_ssal_media_type res;
    switch(type)
    {
        case aud_media_ffs:
            res = ((aud_ssal_media_type) AUD_SSAL_FFS_MEDIA);
            break;
        case aud_media_mmc:
#if defined (AUD_NANDDEVICE_SUPPORT)
        case aud_media_fs_cdrive:
        case aud_media_fs_edrive:
        case aud_media_fs_fdrive:
#endif
            res = ((aud_ssal_media_type) AUD_SSAL_FS_MEDIA);
            break;
        default:
            res = ((aud_ssal_media_type) AUD_SSAL_FFS_MEDIA); /* default */
            break;
    }
    return (res);
}

/*------------------------------------------------------------------------------
* Function...: aud_trap_FFS_FS
* Return.....: 0
* Description: Envokes a software trap because of illegal file system access.
* Modified...: 10.07.2007 by KBJ (changed trap function - SMS622252)
------------------------------------------------------------------------------*/
unsigned short aud_trap_FFS_FS(void)
{
#if defined(TRAP_HANDLING)
//    TRAP_envoke_sw_trap_with_filename(TRAP_AUD_FILESYSTEM_ACCESS, __LINE__, __FILE__);
#endif
    return (0x00);
}
#endif
/*******************************************************************************
*
*                           Tracing/error reporting
*
*******************************************************************************/
#define AUD_MAX_PARMS 63 /* This value comes from: MaxSizeInBytes/U32 --> 0xFF/4 = 63 */
/*------------------------------------------------------------------------------
* Function...: aud_common_trace
* Return.....: -
* Description: Stores the signals in the audio driver to enable tracing.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
#ifdef AUDIO_LLT
void aud_common_trace(
    llt_groups_enum llt_group_aud,                          /* LLT params */
    llt_types_aud_enum  llt_aud_type,                       /* LLT params */
    U8 NumOfParms,                                          /* LLT params */
    U16 struct_size,                                        /* LLT params */
    U8 lis_parm1,                                           /* LIS params */
    U8 lis_parm2,                                           /* LIS params */
    aud_log_lis_trace_option_enum log_lis_option,           /* LIS params */
    aud_log_lis_display_option_enum log_lis_display_data,   /* LIS params */
    aud_log_trace_option_enum log_option,                   /* Defines the type of trace(LIS/LLT) */
    ...)                                                    /* Parameters */
{
    /*[Begin]no use [lvwenhua-2012/4/11]*/
    U8 i = 0;
    va_list args;
    U32 ParmArray[AUD_MAX_PARMS];

    memset( ParmArray, 0, sizeof(ParmArray));
    va_start (args, log_option);
    for(i=0; i<NumOfParms; i++)
    {
        ParmArray[i] = va_arg( args, U32);
    }
    va_end (args);


#if defined (LIS_TRACE)
    if( (log_option == aud_log_lis_trace) || (log_option == aud_log_lis_llt_trace) )
    {
        U32 LIS_d[10];
        memset( LIS_d, 0, sizeof(LIS_d));
        if(aud_log_lis_display == log_lis_option)
        {
            LIS_d[0] = 0x1;
            if(aud_log_lis_display_data == log_display_data)
            {
                memcpy( &LIS_d[1], &ParmArray[0], sizeof(U32)*5);  /* Copy max 5 parms! */
            }
        }
        else if(aud_log_lis_raw_data == log_lis_option)
        {
            memcpy( &LIS_d[0], &ParmArray[0], sizeof(U32)*5);      /* Copy max 5 parms! */
        }
        LIS_log_write(lis_parm1, lis_parm2, &LIS_d[0], sizeof(LIS_d));
    }
#endif
 

#if defined (LLT)
    if( (aud_log_llt_trace == log_option) || (aud_log_lis_llt_trace == log_option) )
    {
        if(0 == struct_size)         /* We have parameters */
        {
//            LLT_PARM_TRACE( llt_group_aud, llt_aud_type, NumOfParms*sizeof(U32), (void*)ParmArray);   remove by wangjun
        }
        else if(0 != struct_size)    /* We have a structure */
        {
//            LLT_PARM_TRACE( llt_group_aud, llt_aud_type, struct_size, (void*)ParmArray[0]); remove by wangjun
        }
    }
#endif 
    /*[End] [lvwenhua-2012/4/11]*/
}
#endif

#ifdef _USE_CUT_TEAKLIT_CODE
/*------------------------------------------------------------------------------
* Function...: aud_trap_printf
* Return.....: -
* Description: Stores exceptions and traps (dependant on AUD_MODULE_TEST_IFWD
*              and MS_ERROR_SEVERITY) in the exception store.
* Modified...: dd.mm.yyyy by NN
* Note.......: This function should not be called directly - use AUD_ERROR_REPORTING instead
* Usage example:
*     aud_uplink_source_enum path = aud_headset_mic;
*     char *pathName = "aud_headset_mic";
*     AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Pathnumber %d, %s", path, pathName);
------------------------------------------------------------------------------*/
void aud_trap_printf(
    const char *p_fileName,
    U16 line,
    U8 severity,
    U16 TrapID,
    const char *p_format,
    ...)
{
    /*[Begin] no use[lvwenhua-2012/4/11]*/
    #if 0
    va_list args;
    U16 length;
    static char tmp[TRAP_MAX_SIZEOF_LOG_DATA];

    /* write the error to the exception store */
    if(severity<=AUD_ERROR_SEV_TRIGGER_EXCEPTION/*aud_error_grade2*/ && AUD_ERR_REPORT_LVL >= AUD_ERROR_REP_TRIGGER_EXCEPTION)
    {
        /* format exception string */
        va_start (args, p_format);
        length = sprintf(tmp, "TimeStamp:%08d, Severity:%d -> ", RTT_stm_get_time_10us_resolution(), severity);
        length += _vsnprintf(&tmp[length], (TRAP_MAX_SIZEOF_LOG_DATA - length), p_format, args); /*lint !e530 */
        va_end (args);
        /* store exception */
        if(length < TRAP_MAX_SIZEOF_LOG_DATA)
        {
            TRAP_store_exception_with_filename(TrapID, length, tmp, line, p_fileName);
        }
        else
        {
            TRAP_store_exception_with_filename(TrapID, TRAP_MAX_SIZEOF_LOG_DATA, tmp, line, p_fileName);
        }
    }

    /* if the error is severe, trap the target as well */
    if(severity<=AUD_ERROR_SEV_TRIGGER_TRAP/*aud_error_grade1*/ && AUD_ERR_REPORT_LVL >= AUD_ERROR_REP_TRIGGER_TRAP)
    {
        TRAP_envoke_sw_trap_with_filename(TrapID, line, p_fileName);
    }
    #endif
    /*[End] [lvwenhua-2012/4/11]*/
}
#endif
/*******************************************************************************
*
*                                Power saving
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_PC3_callback
* Return.....: -
* Description: Callback function for power saving (Power Concept 3).
* Modified...: 26.09.2007 by KBJ (made the function static)
------------------------------------------------------------------------------*/
#if 0
static void aud_PC3_callback(
    POW_DOMAIN_T domain,        /* the power domain which has changed */
    POW_CLOCK_FREQ_T config,    /* the new clock frequency */
    POW_CALLBACK_CAUSE cause)   /* the cause for the change */
{
#if defined (SMPOWER3)
    if(POW_CLK_48M_AUDIO == domain)
    {
        if(POW_FREQ_0!=config && POW_FREQ_48M!=config) /* Something is wrong with POW, AUD always expects 0 or 48 MHz for CLK_48M */
        {
            AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Audio callback function called with wrong frequency: %d. Should be %d", config, POW_FREQ_48M);
        }
    }
    else /* Something is wrong with POW, AUD called with invalid domain */
    {
        AUD_ERROR_REPORTING(aud_error_grade2, TRAP_AUD_ERROR, "Audio callback function called with wrong domain: %d. Should be %d", domain, POW_CLK_48M_AUDIO);
    }
#endif
}
#endif

/*------------------------------------------------------------------------------
* Function...: aud_init_power_save
* Return.....: -
* Description: Initialises power saving.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_init_power_save(void)
{
    U8 cnt=0;
    /* initialise the array */
    for(cnt=0; cnt<aud_resource_end; cnt++)
    {
        aud_lib_audio_enabled[cnt] = FALSE;
    }
/* huojishan 2008.04.01*/
#if 0
#if defined (SMPOWER3)
    /* configure the power consumption when standby is disabled */
    POW_SetClockRange(POW_CLK_48M_AUDIO, POW_FREQ_48M, POW_FREQ_48M);
    POW_RegisterCallback(POW_CLK_48M_AUDIO, aud_PC3_callback);
    /* enable standby */
    POW_SetClockDemands(POW_CLK_48M_AUDIO, FALSE);
    POW_psv_enable(POW_AUD_ID);
#endif
#endif
}
#ifdef _USE_CUT_TEAKLIT_CODE
/*------------------------------------------------------------------------------
* Function...: aud_ready_for_power_down
* Return.....: TRUE if all resource allow power-down, FALSE otherwise.
* Description: Check if all resources allow power-down.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
U8 aud_ready_for_power_down(void)
{
    U8 cnt=0;
    for(cnt=0; cnt<aud_resource_end; cnt++)
    {
        if(aud_lib_audio_enabled[cnt] == TRUE)
        {
            return (FALSE);
        }
    }
    return (TRUE);
}
#endif
/*------------------------------------------------------------------------------
* Function...: aud_enable_standby
* Return.....: -
* Description: Allow power saving if all resources allow so.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_enable_standby(
    aud_resource_enum resource) /* the resource which now allows power-down */
{
    aud_lib_audio_enabled[resource] = FALSE;
/*huojishan 2008.04.01*/    
#if 0    
#if defined (SMPOWER3)
    if(TRUE == aud_ready_for_power_down()) {
        POW_SetClockDemands(POW_CLK_48M_AUDIO, FALSE);
        POW_psv_enable(POW_AUD_ID);
    }
#endif
#endif
}

/*------------------------------------------------------------------------------
* Function...: aud_enable_standby_l1g
* Return.....: -
* Description: Allow power saving if all resources allow so.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_enable_standby_l1g(U8 resource)
{
#ifdef PS_RAT_GSM
    l1d_psv_enable(resource);
#endif
}


/*------------------------------------------------------------------------------
* Function...: aud_disable_standby_l1g
* Return.....: -
* Description: Disallow power saving.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_disable_standby_l1g(U8 resource)
{
    l1d_psv_disable(resource);
}


/*------------------------------------------------------------------------------
* Function...: aud_disable_standby
* Return.....: -
* Description: Disallow power saving.
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_disable_standby(
    aud_resource_enum resource) /* the resource which requires clock input */
{
    aud_lib_audio_enabled[resource] = TRUE;
 /*huojishan 2008.04.01*/   
#if 0    
#if defined (SMPOWER3)
    POW_SetClockDemands(POW_CLK_48M_AUDIO, TRUE);
    POW_psv_disable(POW_AUD_ID);
#endif
#endif
}
#ifdef _USE_CUT_TEAKLIT_CODE
/*******************************************************************************
*
*                             RAM buffer concept
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_check_pageaddr_copy
* Return.....: -
* Description: Check whether the RAM data pointer is in NAND paging memory.
* Created....: 24.07.2007 by WIP_MSM
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_check_pageaddr_copy(
    U8*   src_addr,         /* RAM data pointer */
    U32   buf_size,         /* buffer size */
    BOOL* ram_buffer_flag)  /* return value */
{
#if defined(NAND_PAGING)
    U32 StartAddr = EXTERN_RAM_BASE + EXT_RAM_DATA_SIZE + BASIC_IMAGE_SIZE;
    U32 EndAddr   = StartAddr + PAGING_IMAGE_SIZE + FW_IMAGE_SIZE + CUST_PACK_SIZE;
    if((U32)src_addr>=StartAddr && (U32)src_addr<EndAddr)
    {
        *ram_buffer_flag = TRUE; /* the data pointer is in NAND paging memory */
    }
#else
    *ram_buffer_flag = FALSE;    /* the data pointer is not in NAND paging memory */
#endif 
}
#endif

#if defined (STEON2_PROJECT)
/*******************************************************************************
*
*                       Hardware Sample Rate Conversion
*
*******************************************************************************/
/*------------------------------------------------------------------------------
* Function...: aud_get_hw_src_allocation
* Return.....: Usage of the hardware SRC.
* Description: Get the usage of the hardware SRC.
* Created....: 25.05.2007 by EPS
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
aud_HW_SRC_choice aud_get_hw_src_allocation(void)
{
    return aud_HW_SRC_allocation;
}
	
/*------------------------------------------------------------------------------
* Function...: aud_set_hw_src_allocation
* Return.....: -
* Description: Set the usage of the hardware SRC.
* Created....: 25.05.2007 by EPS
* Modified...: dd.mm.yyyy by NN
------------------------------------------------------------------------------*/
void aud_set_hw_src_allocation(
    aud_HW_SRC_choice var) /* the usage of the HW SRC */
{
    aud_HW_SRC_allocation = var;
}
#endif /* STEON2_PROJECT */

