#include "msimport.h"
//#include "scttypes.h"
#include "aud_drv.h"            /* audio types and functions */

#include "bastypes.h"

/*changed by wangjun for NV change.[20090214]*/
#include "aud_nv.h"  //#include "eep.h"

//#include "atctstif.h"
//#include "i2c.h"
//#include "trap.h"
//#include "pmu_hal.h"

//#include "dsp.h"
#include "drvs_teak.h"

#define LLT_NOF_GROUPS        40
typedef enum CC_ReturnCode
{
   CC_Success_v,          /* Successful operation                                       */
   CC_NotStarted,         /* Tried to modify or stop an user that was not yet started   */
   /* One of the parameters is not within the specified range    */
   CC_ParamOutOfRange_v,
   CC_UserIdError_v,
   CC_UseCaseError_v,
   CC_UseCaseAlreadyRunningError_v,
   CC_UseCaseNotRunningError_v,
   CC_CapComBlockNumberError_v,
   CC_CapComTimerNumberError_v,
   CC_CapComChannelNumberError_v,
   CC_IrqPriorityError_v,
   CC_HisrHandleError_v,
   CC_ClockFrequencyError_v,
   CC_TriggerEdgeError_v,
   CC_ExpirationValueError_v,
   CC_TimerTypeError_v,
   CC_TickParameterError_v,
   CC_TimerValuePointerError_v
#if defined(_WIN32)
   ,
   CC_DWD_cc_generic_error_v  // for GMTS only
#endif /* #if defined(_WIN32) */
   
} CC_ReturnCode_t;

/*---------------------------------------------------------------------------*\
|
|   Exported Types used by other modules of this FU (Declaration)
|
\*---------------------------------------------------------------------------*/
/* Typedef if the CapCom User Identification used as index in the static     */
/* array of CapCom UseCases                                                  */
typedef enum CC_UserId     //use correct order; corresponding to UseCase_a
{
  CC_RttTimerId_v   = 0,
  CC_LedPWMId_v     = 1,
  CC_FlipIntId_v    = 2,
  CC_ChargerIntId_v = 3,
  CC_ChargerPWMId_v=4,   //Rosholm
  CC_Fm_Radio_v = 5,
  CC_USB_RESUME_Id_v=6,    // Ashvani CC1CC6IO will be used for USB resume
  CC_AGPSInt_v      = 7,
#if defined(IFWD_HW_MPEH_ICE2)
  CC_BTResetInt_v   = 8,
  CC_WLANResetInt_v = 9,
  CC_MaxId_v        = 10,
#else
  CC_Ext_int =8,                        // for power saving mode interrupt
  CC_MaxId_v        = 9,
#endif 
  CC_UseCaseIdUndef_v = 0xFF
} CC_UseCaseId_t;

/* An interupt can be triggered on raising edges, falling edges or both edges*/
typedef enum CC_InterruptTriggerEdge
{
   CC_UndefEdge_v   = 0,   /* Not applicable for this use case               */
   CC_RaisingEdge_v = 1,   /* Interrupt is triggered on a raising edge       */
   CC_FallingEdge_v = 2,   /* Interrupt is triggered on a falling edge       */
   CC_BothEdge_v    = 3    /* Interrupt is triggered on any edge             */
}CC_InterruptTriggerEdge_t;

//ulong LLT_control[LLT_NOF_GROUPS]; //LLTԻ
//ubyte LLT_ctrl = 1;

#ifdef _USE_CUT_TEAKLIT_CODE
SDL_PId aud_pid;

NU_HISR AUD_Sleep_Timer_HISR_control;
T_DSP_CMD_VB_SYNC    vb_sync_parms;
#endif

typedef ubyte T_DSP_FW_STATE;
extern T_DSP_FW_STATE dsp_fw_state;

enum
{
  DSP_IDLE_STATE=0,   /* Going to this state when a DSP_IDLE command is issued */
  DSP_BB_IDLE_STATE,  /* Going to this state when a DSP_BB_OFF command is issued */
  DSP_TCH_26_STATE,   /* Going to this state when a DSP_TCH_26 command is issued */
  DSP_PDCH_STATE,     /* Going to this state when a DSP_PDCH command is issued */
  DSP_DTM_STATE,      /* Going to this state when both a DSP_TCH_26 and DSP_PDCH command has been issued */
  DSP_UMTS_STATE      /* Going to this state when a DSP_UMTS_ON command is issued */
};
typedef struct
{
  word  switch_par;
} T_DSP_CMD_UMTS_ON_PAR;

//void dsp_umts_on( BOOL switch_par ){}
#ifdef _USE_CUT_TEAKLIT_CODE
//#if 1
void aud_dsp_umts_on( BOOL switch_par )
{

  /* Update dsp fw state variable */
  if(switch_par == TRUE)
  {
    /* Enable ressources */
#if defined (DSP_PC3_CLOCKSCALE) || defined (DSP_PC3_MEMSCALE)
    DSP_enable_algorithm(DSP_UMTS_ALGO, TRUE);
#endif

    /* Set state variable */
    dsp_fw_state = DSP_UMTS_STATE;
  }
  else
  {
    /* Disable ressources */
#if defined (DSP_PC3_CLOCKSCALE) || defined (DSP_PC3_MEMSCALE)
    DSP_disable_algorithm(DSP_UMTS_ALGO, TRUE);
#endif

    /* Set state variable */
    dsp_fw_state = DSP_IDLE_STATE;
  }

  /* Send command to DSP */
  dsp_add_async_msg_2_dsp(DSP_CMD_UMTS_ON,
                          (sizeof(T_DSP_CMD_UMTS_ON_PAR) / 2) + DSP_CMD_ID_LEN,
                          (word*)&switch_par);

  return;
}

void umac_amr_sync(ubyte mode, ubyte sync, ushort start_ul_offset, ubyte hysteresis)
{
    DISABLE_CLOCK;

    vb_sync_parms.mode = mode;
    vb_sync_parms.ptr_val = start_ul_offset;
    vb_sync_parms.sync_lim =  hysteresis;

    switch(sync)
    {
       case 1:
        /* First synchronisation */
        vb_sync_parms.sync = 1;
        break;

       case 2:
        /* Re-synchronisation */
        vb_sync_parms.sync = 2;
        break;
    }

    DSP_VB_SYNC(&vb_sync_parms);

    ENABLE_CLOCK;
}


unsigned int RTT_stm_get_time_10us_resolution(void){return 0;}

CC_ReturnCode_t CC_DeactivateExtInt( const CC_UseCaseId_t UseCaseId ){return 0;}
CC_ReturnCode_t CC_ActivateExtInt( const CC_UseCaseId_t UseCaseId, 
                                                   const CC_InterruptTriggerEdge_t edge,
                                                   const NU_HISR* HisrHandle ){return 0;}//xiu

#if 0
I2C_HANDLE GetI2CHandle(short int DeviceAddress,i2c_device_mode_type I2CMode,
  i2c_address_type AddressingWidth,i2c_baud_rate_type BaudRate,
  i2c_user_type UserType){}
#endif

STATUS NU_Register_LISR(INT vector,  VOID (*new_lisr)(INT), VOID (**old_lisr)(INT)){return 0;}
#endif
/**********************  PowŴ趨ӿ************************/
/*
int PMU_set_mono_amp_anti_pop(PMU_APPL_STATE_T p_enable){}
int PMU_set_mono_amp_fast_start(PMU_APPL_STATE_T p_enable){}
int PMU_set_mono_amp_tristate(PMU_APPL_STATE_T p_enable){}
int PMU_set_amp_gain(PMU_AUD_AMP_GAIN_T  p_gain){}
int PMU_set_amp_cmv(PMU_AUD_AMP_CMV_T p_level){}
*/

/**********************  쳣***************/
/*
void TRAP_envoke_sw_trap_with_filename (unsigned short id_number,
					unsigned long line,
					char *filename)
{ 
}  

void TRAP_store_exception_with_filename(ushort id_number,
					ushort  log_data_size,
					void   *log_data,
					ulong  line,
					char   *filename)
{
}

void LLT_parm_trace(ubyte group, ubyte type, ushort size, void *data_ptr  ){}
*/

