/**
 *       Copyright (C) Infineon Technologies Denmark A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Infineon
 * Technologies Denmark A/S. Passing on and copying of this document, use
 * and communication of its contents is not permitted without prior written
 * authorisation.
 *
 * Description:
 *   Interface header file to control of the VB_ON parameter ratesw.
 *   The ratesw determines the audio scheduler sample rate.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_ratesw.h
 *   Version: \main\4
 *   Date: 2007-04-30 15:33:13
 *   Responsible: kbj
 *   Comment:
 *     Merged code guideline updates.
 */

#if !defined (_AUD_RATESW)
#define _AUD_RATESW

/*******************************************************************************
*
*                              Type definitions
*
*******************************************************************************/
typedef enum {
    aud_ratesw_8khz_mono=0,
    aud_ratesw_16khz_mono=3,
    aud_ratesw_48khz_stereo=8
} aud_ratesw_enum; /* values possible to be programmed to the DSP */

typedef struct {
    void (*func)(aud_ratesw_enum new_ratesw); /* callback function */
} aud_ratesw_control_type; /* internal control structure used by the functions below */

/*******************************************************************************
*
*                       External function declarations
*
*******************************************************************************/
aud_ratesw_enum aud_get_current_ratesw(void);
aud_ratesw_enum aud_get_next_ratesw(void);
void            aud_register_ratesw_observer(
    aud_resource_enum resource,
    void (*func)(aud_ratesw_enum new_ratesw));
aud_ratesw_enum aud_calculate_ratesw(void); /* only to be used by aud_path_afe_dsp_programming */

#endif /* _AUD_RATESW */

