/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  Main State machine for the audio driver. The file also include the
 *               interface functions
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_ringer.h
 *   Version: \main\13
 *   Date: 2006-12-05 12:48:36
 *   Comment:
 *     remove define AUD_MIDI_AUTO_RESUME_ON_IDLE
 */

#ifndef _AUD_RINGER
#define _AUD_RINGER

/* Define for Auto Resume on Idle */
//#define AUD_MIDI_AUTO_RESUME_ON_IDLE
#define DWD_EXTRINGER_RESOURCE_ACTIVE_MASK  0x0000401C /* Each bit in this is corresponding to active resources id's. So this bit pattern works as mask for functions needing to judge External ringer chip resources being active. */

#ifdef AUD_EXTERNAL_RINGER
#define AUD_INIT_MA_TIMEOUT0 0x0001
#define AUD_INIT_MA_TIMEOUT1 0x0002
#define AUD_UNMUTE_TIMEOUT1 0x0004
#define AUD_TEST_TIMEOUT 0x0008
#define MAClassicActive 0
#define MAMapiActive 1
#ifdef AUD_YAMAHA_MAPI
#define AUD_INIT_MAPI_TIMEOUT 0x0010
#endif
#define NO_UPDATE_MA_BASE 0
#define UPDATE_MA_BASE 1
#define AUD_MA_IRQ_LEVEL 1
#endif

/*---------------------------------------------*/
/* Local defines.                              */
/*---------------------------------------------*/
#ifdef AUD_EXTERNAL_RINGER
#include "REG_SGOLD_Structs.h"
//#include "REG_SGOLD_Regs.h"
#define ACC_MAx_INTR               CC1_CCINT3               //87
#define ACC_MAx_CCM                CC1_CCM0
#define ACC_MAx_CCM_DISABLE        0x0FFF                  /* Disable compare unit */ 
#define ACC_MAx_TRIGGER_MODE       0x2000                  /* Capture negative edges on pin CC0CC7IO */   

#define DISABLE_MAx_INTR           sCC1_CCSRC3.SRE   = 0;  /* Disable connector interrupt */
#define ENABLE_MAx_INTR            sCC1_CCSRC3.SRE   = 1;
#define CLEAR_MAx_INTR             sCC1_CCSRC3.CLRR  = 1;
#define MAx_IRQ_TOS                sCC1_CCSRC3.TOS = 0;
#define MA_CCM_SINGLE_EVENT_MODE   sCC1_SEM.SEM3 = 1;
#define MA_CCM_SINGLE_EVENT_ENABLE sCC1_SEE.SEE3 = 1;
#define MA_CCM_PORT_SELECT         sCC1_PISEL.C3C2IS = 1;
#endif

/*---------------------------------------------*/
/* Type definitions.                           */
/*---------------------------------------------*/
#ifdef AUD_YAMAHA_MAPI
typedef struct {
    volatile UINT8  aud_mapi_no_timeout;
    UINT8           state;
    SDL_Pid         sender;
}aud_glob_mapi_type;
#endif

typedef enum {
    S_ringer_idle,
    S_ringer_loading_tones,
    S_ringer_play_tones,
    S_ringer_acc_enabled,
    S_ringer_mapi_active,
    S_ringer_powering_up
}MA_states_enum;

typedef enum {
    S_mapi_idle,
    S_mapi_active
}mapi_states_enum;

typedef struct {
    MA_states_enum  Next_state;
    UINT8 AccOn;
    UINT8 Spk_Ampl_On;
    UINT8 VibOn;
    UINT8 Resume;
}MA_StateMach_Struct;

typedef union {
    UINT8 PowerReg;      // everything together on MA2, MA3 digitla part part
    struct {
        unsigned DP0      :1; // bit 0 
        unsigned DP1      :1; // bit 1 
#if defined(AUD_EXTERNAL_RINGER_MA2)
        unsigned AP0      :1; // bit 2 
        unsigned AP1      :1; // bit 3
        unsigned AP2      :1; // bit 4 
        unsigned AP3      :1; // bit 5 
        unsigned AP4      :1; // bit 6 
        unsigned CLR      :1; // bit 7 MSB
#elif defined(AUD_EXTERNAL_RINGER_MA3)
        unsigned DP2      :1; // bit 2 
        unsigned DP3      :1; // bit 3
        unsigned UNUSED   :4; // bit 4 -7 MSB
#endif
    } PwrBits; // structure variable 
}MaPowerMgtReg1;   

typedef union {
    UINT8 PowerReg;      // Only used for MA3
    struct {
        unsigned AP0      :1; // bit 0 
        unsigned AP1      :1; // bit 1 
        unsigned AP2      :1; // bit 2 
        unsigned AP3      :1; // bit 3
        unsigned AP4L     :1; // bit 4 
        unsigned AP4R     :1; // bit 5 
        unsigned UNUSED   :1; // bit 6 
        unsigned PLLPD    :1; // bit 7 MSB
    } PwrBits; // structure variable 
}MaPowerMgtReg2;

typedef struct {
    UINT8                VibCtrl;
    UINT8 ch;
    aud_vibrator_mode_enum VibMode;
    aud_vibrator_on_enum OnPeriod;
    aud_vibrator_off_enum    OffPeriod;
    BOOL  NewInterfaceUsed;
}aud_glob_vibrator_type;

typedef enum {
    S_MaRamp0,
    S_MaRamp1,
    S_MaRamp2,
    S_MaRamp3
}MA_Rampstates_enum;   

typedef struct {
    UINT16  nof_repeats[AUD_MAX_NOF_CHANNELS];
    UINT16  caller_id[AUD_MAX_NOF_CHANNELS];
    SINT32  MA_StreamId[AUD_MAX_NOF_CHANNELS+1];
    SINT32  MA_FileId[AUD_MAX_NOF_CHANNELS+1];
    SINT32  MelodyLength[AUD_MAX_NOF_CHANNELS];
    UINT8 PlayStatus[AUD_MAX_NOF_CHANNELS];
    UINT8 smaf_phrase_channel_volume[AUD_MAX_NOF_CHANNELS];
    UINT8 smaf_phrase_channel;
    UINT8 mute_cntr;
    UINT8 smaf_phrase_Oldchannel;
    UINT8 MsgBlock[AUD_MAX_NOF_CHANNELS];
    UINT8 Ch2Start[AUD_MAX_NOF_CHANNELS];
    UINT8 Ch2SetPlayposition[AUD_MAX_NOF_CHANNELS];
    SDL_Pid sender[AUD_MAX_NOF_CHANNELS];
    SDL_Pid info_sender;
    SDL_Pid amp_sender;
    SDL_Pid vib_sender;
    aud_ringer_tone_id_enum        tone_id;
    aud_speech_volume_enum volume;
    aud_speech_volume_enum mute_volume;
    aud_speech_volume_enum  speech_volume;
    aud_speech_volume_enum mapi_volume;
    aud_speech_volume_enum DWD_HUGE *ActiveVolume;
    aud_format_enum         format;
    aud_ringer_device_enum  device[AUD_MAX_NOF_CHANNELS];
    aud_speech_volume_enum InterfaceSpecVol;
    MA_Rampstates_enum VolumeState;
    UINT8 DWD_HUGE  *tone_data[AUD_MAX_NOF_CHANNELS+1];
    UINT32 ResumeOffset[AUD_MAX_NOF_CHANNELS]; // actual value used as ResumeOffset
    UINT32  size[AUD_MAX_NOF_CHANNELS+1];
    UINT32 LastUsedMaHwDep;
    BOOL Resumed; 
    /* used to initialize Resume offset on 1. start_user_tone */
    BOOL delay_init;
    BOOL GetTotalPlaytime;
    BOOL GetPlayposition;
}aud_glob_ringer_type,  *Paud_glob_ringer_type;

typedef struct {
    UINT8         StopSlot;
    UINT8         SuspendSlot;  
    UINT8         ResumeSlot;
    aud_glob_ringer_type RingerSlot[AUD_NOF_SUSPENDNEST];
    BOOL         StopChFlag[AUD_MAX_NOF_CHANNELS];
    BOOL         SuspendChFlag[AUD_MAX_NOF_CHANNELS];
    BOOL         ResumeChFlag[AUD_MAX_NOF_CHANNELS];
}aud_glob_ringer_array_type;


typedef struct {
    aud_ringer_tone_id_enum ringer_tone_enum;
    void DWD_HUGE     *melody_ptr;
    UINT32 size;
    aud_format_enum format;
}aud_smaf_melody_type;

/*--------------------------------------------*/  
/* External variabels declaration.             */
/*---------------------------------------------*/
extern aud_glob_ringer_type     aud_glob_ringer;

//extern const DWD_HUGE aud_smaf_melody_type aud_smaf_melody_table[];

extern aud_glob_ringer_array_type aud_SuspendArray;
extern UINT32 RingerTimer0;
extern UINT8 aud_ma_format_playing, aud_ma_phrase_channel[];

extern UINT8 ma_master_volume;
extern UINT8 aud_ringer_state;

extern UINT16 *aud_tst_data_ptr;
extern UINT32 RingerTimer0;
extern MaPowerMgtReg1 MaPwrReg1; /* used in aud_test to perform GMTS test og hp/rearspeaker testing */
extern MaPowerMgtReg2 MaPwrReg2; /* used in aud_test to perform GMTS test og hp/rearspeaker testing */
extern UINT8 aud_ma_phrase_channel[];
extern UINT8 aud_ma2_format_playing, aud_ma2_phrase_channel[];

#ifdef AUD_YAMAHA_MAPI
extern aud_glob_mapi_type aud_glob_mapi;
extern UINT8 ma_sp_volume, ma_master_volume, ma_eq_volume, time_count;
extern UINT8   ma_HPvol_L, ma_HPvol_R;
#endif

/*---------------------------------------------*/
/* External function declaration.              */
/*---------------------------------------------*/
extern void machdep_Wait( UINT32 wait_time );
extern BOOL AudRingerSM(aud_event_enum event , void* pData );
extern void UpdateExternalRingerPath(UINT32 path_dependency, UINT8 chipbase_update);
extern void aud_ma3_find_volume(aud_volume_enum volume);
#ifdef INTERNAL_POLYRINGER
extern BOOL AudInternalMidiPlayerSM(aud_event_enum event, void* pData);
#endif
extern void InitRinger(void);
extern void aud_smaf_phrase_timing_ctrl(void);
extern void HandleInitPolyToneChipTimeout(   void* pData);

#ifdef INTERNAL_POLYRINGER
extern void InitMidi(void);
extern void AUD_HandleMidiPlayerTimeout(void);
extern void AUD_update_audio_post_processor(void);
#endif

extern void InitRinger(void);
extern UINT8 AudRingerActive(void);
extern void Enable_MA2_SPK(UINT8 volume);
extern void Disable_MA2_SPK(void);
extern void smafphEgCyclicProcedureResume(void);
extern UINT8  AudMapiActive(void) ;
extern void set_volume_ma3(UINT8 MapiActive); 
extern void HandleTremblerTimeout(  void* pData);
extern UINT32 AUD_test_ringer_generic_func(void *func_req_ptr,BOOL *processed);
extern void HandleUnmuteAmp(void* pData);
#endif

