/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:  Header file for the FM radio audio driver
 *               (FM radio TEA5767HN driver)
 * Modified ........ 25.03.04 - vvn
 *                 - Adapted to SGOLDLITE and uses new SIO adapted I2C interface
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_tone.h
 *   Version: \main\11
 *   Date: 2007-08-15 10:26:18
 *   Comment:
 *     corrected lint warnings sms 598505 621733
 */

#ifndef _AUD_TONE_H
#define _AUD_TONE_H

/*---------------------------------------------*/
/* Local defines.                              */
/*---------------------------------------------*/
#define AUD_NULL_FREQ        32767
#define AUD_NULL_AMP             0
#define AUD_NORMAL_TONE_AMP 0x4000
#define AUD_TONE_TABLE_MAX  40

#define FREQ_SILENT         0

#define FREQ_D0           300 /* The comneon hardware cannot play tones below 300 Hz... */
#define FREQ_DS0          311
#define FREQ_E0           330
#define FREQ_F0           349 
#define FREQ_FS0          370
#define FREQ_G0           392
#define FREQ_GS0          415
#define FREQ_A0           440
#define FREQ_AS0          466
#define FREQ_B0           494
#define FREQ_C0           523  /* high tone */

/* 2nd octave */
#define FREQ_CS1          554  /* low tone */
#define FREQ_D1           587
#define FREQ_DS1          622
#define FREQ_E1           659
#define FREQ_F1           698 
#define FREQ_FS1          739
#define FREQ_G1           783
#define FREQ_GS1          830
#define FREQ_A1           880
#define FREQ_AS1          932
#define FREQ_B1           987
#define FREQ_C1           1046  /* high tone */

/* 3rd octave */
#define FREQ_CS2          1109  /* low tone */
#define FREQ_D2           1175
#define FREQ_DS2          1245
#define FREQ_E2           1318
#define FREQ_F2           1397
#define FREQ_FS2          1480
#define FREQ_G2           1568
#define FREQ_GS2          1661
#define FREQ_A2           1760
#define FREQ_AS2          1865
#define FREQ_B2           1976
#define FREQ_C2           2093  /* high tone */

/* 4th octave (highest) */
#define FREQ_CS3          2217  /* low tone */
#define FREQ_D3           2349
#define FREQ_DS3          2489
#define FREQ_E3           2637
#define FREQ_F3           2794
#define FREQ_FS3          2960
#define FREQ_G3           3136
#define FREQ_GS3          3322
#define FREQ_A3           3520
#define FREQ_AS3          3729
#define FREQ_B3           3951
#define FREQ_C3           4186  /* high tone */

#define FADE_IN_160_SAMPLES      160
#define FADE_OUT_160_SAMPLES     160

#define Find_Frequency_index(A,B)   (B = ((A+100)/100))

/*---------------------------------------------*/
/* Typedef's.                                  */
/*---------------------------------------------*/
typedef struct {
    UINT16    tone_number;
    UINT16    repeat_number;
    UINT32    elapsed_time;
}aud_base_tone_ctrl_type;

enum tone_priority {
    tone_prio_low,
    tone_prio_high
};

typedef struct {
    UINT16          freq1;
    UINT16          duration;
}aud_single_tone_type;

typedef struct {
    aud_single_tone_type          region;
}aud_single_tone_multi_region_type;

#define AUD_NOF_REGIONS 3 /* CEPT; ANSI; Japan*/

typedef struct {
    UINT16          freq1;
    UINT16          freq2;
    UINT16          duration;
}aud_dual_tone_type;

typedef struct {
    aud_dual_tone_type          region;
}aud_dual_tone_multi_region_type;

typedef struct {
    UINT16          freq1;
    UINT16          freq2;
    UINT16          freq3;
    UINT16          duration;
}aud_triple_tone_type;

typedef struct {
    aud_triple_tone_type          region;
}aud_triple_tone_multi_region_type;

typedef struct {
    aud_tone_type_enum   tone_type;
    UINT16          nof_tones;
    void                 *tone_data;
}aud_tone_data_type;

typedef struct {
    UINT8                   *tone_data;
    UINT32                  playtime;
    UINT32                  elapsed_time;
    UINT16                  nof_repeats;
    UINT16                  nof_tones;
    UINT16                  caller_id;
    UINT16                  repeat_number;
    UINT16                  tone_number;
    UINT8                   tone_active;
    SDL_Pid                 sender;
    aud_tone_id_enum        tone_id;
    aud_tone_type_enum      tone_type;
    UINT8                   in_use;
} aud_suspend_tone_type;

typedef struct {
    UINT8                   *tone_data;
    UINT16                  nof_repeats;
    UINT16                  nof_tones;
    UINT16                  caller_id;
    UINT8                   tone_active;
    SDL_Pid                 sender;
    aud_tone_id_enum        tone_id;
    aud_tone_type_enum      tone_type;
    SINT16                  CompTest;
    UINT32                  playtime;
    UINT32                  start_pos;
    UINT8                   slot_id;
    aud_suspend_tone_type   suspend[AUD_NOF_SUSPEND_SLOTS];
  BOOL        PlayToneInfinite;
} aud_glob_tone_type;

extern aud_glob_tone_type       aud_glob_tone;

extern BOOL AudToneGeneratorSM(aud_event_enum event, void* pData);
extern void InitToneIrq(void);

extern void DspStartToneGenerator(void); 
extern void DspStopToneGenerator(void); 

extern void AUD_Update_supervisory_tone_for_region(eep_aud_region_type AUD_region); //used for updating sv tones (via eep paramter)

extern UINT32 AUD_test_tone_generic_func(void *func_req_ptr,  BOOL *processed);
extern void HandleEarpieceCtrlTimeout( void* pData );
extern void HandleEarpieceTimeout(   void* pData   );
void Initialise_tone_vars(void);

#endif /*#define _AUD_TONE_H*/

