/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:
 *   State machine for the voice memo service (vms). Everything concerning the vms is
 *              controlled from this code.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_vms_playback.h
 *   Version: \main\15
 *   Date: 2007-07-17 16:53:41
 *   Version: \main\15
 **/

#ifndef _INC_AUD_VMS_PLAYBACK_H
#define _INC_AUD_VMS_PLAYBACK_H

#ifdef VMS_PRESENT
#include "aud_ext_def.h"  



/*---------------------------------------------*/
/* Defines.                                    */
/*---------------------------------------------*/

/* Used to verify the streamed data to the VM player */
#undef VM_MMF_DATA_VERIFY

/* Define for Auto Resume on BB_off */
#define  AUD_VMS_PLAYBACK_AUTO_RESUME_ON_BBOFF_TCH26

/* Define for Auto Resume on Idle */
#define AUD_VMS_PLAYBACK_AUTO_RESUME_ON_IDLE

/*---------------------------------------------*/
/* Local defines.                              */
/*---------------------------------------------*/
#define AUD_NOF_BYTES_IN_VMPLAYBACK_BUFFER  340

#define AUD_VM_PERFORMANCE_PROBLEMS 0xFA
#define AUD_VM_RAM_BUFFER_USED      0xF9
#define AUD_VM_PLAYED_TO_END        0xF8
#define AUD_VM_PLAYBACK_STOPPED     0xF7
#ifdef VM_MMF_DATA_VERIFY
#define VALIDATE_VM_BUFFFER_SIZE 6000
#endif

enum
{ 
    S_aud_vms_playback_idle,
    S_aud_vms_wait_for_reading_header_byte,
    S_aud_vms_wait_for_playback,
    S_aud_vms_playback,  
    S_aud_vms_temp_state
};

/*---------------------------------------------*/
/* Struct's.                                   */
/*---------------------------------------------*/

typedef struct
{
    UINT8 aud_vms_data[AUD_NOF_BYTES_IN_VMPLAYBACK_BUFFER];
}aud_vms_data_type;

#ifdef VM_MMF_DATA_VERIFY
typedef struct
{
    UINT8 VM_data[VALIDATE_VM_BUFFFER_SIZE];
}VM_streaming;
#endif

typedef struct{
    UINT32            vms_file_size;
    UINT32            vms_bytes_played;  
    UINT32            vms_header_size;
    UINT32            buffer_size;
    UINT32            start_offset;
    UINT32            play_time;

    UINT16            lNof_repeatfactor;  
    UINT16*          (*vms_getpacket_func)(UINT16);  
    UINT16            frame_number;     
    UINT16            nof_repeats;     
    UINT16 DWD_HUGE   *file_handle;  
    UINT16            media;  
    UINT32            playback_frame;
    ptr_GetAudioBufferFunction    get_buffer_func;
    aud_vm_mode_enum  vm_mode;
    BOOL              in_use;    
    aud_dsp_format_enum   format;      
    BOOL data_pagememory_status;	
}aud_vms_SuspendArray_type;

typedef struct
{
    aud_vms_SuspendArray_type suspend_data[5];
    UINT32                start_offset;
    UINT32                pos;
    UINT32                buffer_size;

    ptr_GetAudioBufferFunction get_buffer_func;
    UINT16 DWD_HUGE *     (*fp_voice_memo_getpacket)(UINT16);
    UINT16 DWD_HUGE *     file_handle;  
    UINT16                nof_repeats;
  
    SDL_Pid               sender;
    aud_vm_mode_enum      vm_mode;  
    aud_media_enum        media_type;  
    aud_dsp_format_enum   format;     
    UINT8                 rate;    
    UINT8                 slot_id;
    void *                mmf_user_data;
    aud_ssal_media_type   ssal_media_type;

#ifdef VM_MMF_DATA_VERIFY    
    aud_ssal_media_type          ssal_media_type_mine;
    aud_ffs_handle_type data_ver_file_handle;
    UINT16                data_ver_file_id; 
    UINT8  FFS_data_outstanding;
    UINT8 vm_result, file_created, file_id_created ;
    BOOL close_file;    
#endif	
}aud_glob_vms_playback_type;

typedef struct
{
SDL_Pid             sender;         
aud_media_enum              media_type;
aud_dsp_format_enum             format;      
UINT16 DWD_HUGE *               file_handle;
UINT32              buffer_size;
UINT32              start_offset;
UINT32              vms_total_playtime;
UINT32              file_size;
}aud_vms_total_playtime_type;


typedef struct
{    
    UINT32 vms_file_size;
    UINT32 vms_bytes_played;
    UINT32 vms_bytes_read;
    UINT32 vms_total_playtime;
    UINT32 vms_frames_played;
    UINT32 vms_header_size;
    UINT32 ptr_vms_header;
    UINT32 playback_frame;    
    UINT32 ram_playback_index;

    UINT16 mmf_synch_result;
    SINT16 vm_result;
    UINT16 vms_offset;
    UINT16 lNof_repeatfactor;
    SINT16 ffs_result;   
    UINT16  nof_bytes_per_frame;
    
    UINT8  aud_vms_state ;
    UINT8  aud_vm_error;
    UINT8  array_number_read;
    UINT8  next_bytes_per_frame;
    UINT8  sync_counter;

    BOOL array_number;
    BOOL data_outstanding;
    BOOL data_pending;
    BOOL memo_end;
    BOOL mmf_data;
    BOOL check_header_flag;
    BOOL rc_check_flag;
    BOOL ram_data_outstanding;
    BOOL ram_data_pending;	
    BOOL data_pagememory;	
}vms_playback_ctrl_type;

/*--------------------------------------------*/  
/* External variabels declaration.             */
/*---------------------------------------------*/
extern aud_glob_vms_playback_type   aud_glob_vms_playback;

/*---------------------------------------------*/
/* External function declaration.              */
/*---------------------------------------------*/
extern BOOL AudVmsPlaybackSM(aud_event_enum event, void* pData);
extern void AudVmsPlaybackL1EventHandle(aud_event_enum event);
extern void InitVmsPlayback(void);

extern UINT16 DWD_HUGE * voice_memo_getpacket_in_ffs(UINT16 result);
extern UINT16 DWD_HUGE * voice_memo_getpacket_in_ram(UINT16 result);
extern UINT16 DWD_HUGE * voice_memo_getpacket_in_mmf(UINT16 result);
extern void AudVmsPlaybackInterruptHandle(void);
extern void DspStopPlaybackVm(void);
extern UINT32 AUD_test_vms_generic_func(void *func_req_ptr,BOOL * processed);

#endif /* VMS_PRESENT*/
#endif /*define _INC_AUD_VMS_PLAYBACK_H */

