/**
 *       Copyright (C) Danish Wireless Design A/S. All rights reserved.
 *
 * This document contains proprietary information belonging to Danish Wireless
 * Design A/S. Passing on and copying of this document, use and communication
 * of its contents is not permitted without prior written authorisation.
 *
 * Description:
 *   State machine for the voice memo service (vms). Everything concerning the vms is
 *              controlled from this code.
 *
 * Revision Information:
 *   File name: \dwddrv\AUD\src\aud_vms_rec.h
 *   Version: \main\13
 *   Date: 2007-06-22 12:16:05
 */
#ifndef _INC_AUD_VMS_REC_H
#define _INC_AUD_VMS_REC_H

#ifdef VMS_PRESENT
#include "aud_ext_def.h"
/*---------------------------------------------*/
/* Defines.                                    */
/*---------------------------------------------*/
/* Define for Auto Resume on BB_off */
#define  AUD_VMS_RECORD_AUTO_RESUME_ON_BBOFF_TCH26

/* Define for Auto Resume on Idle */
#define AUD_VMS_RECORD_AUTO_RESUME_ON_IDLE

/*---------------------------------------------*/
/* Local defines.                              */
/*---------------------------------------------*/
#define VM_REC_BUFFER_SIZE             1024
#define AUD_VM_DELAY_BEFORE_RECORDING   2
#define AUD_VM_PERFORMANCE_PROBLEMS     0xFA
#define AUD_VM_RAM_BUFFER_USED          0xF9
// Bit descriptions of VM_MODE parameter
#define VM_MODE_DTX_BIT			0x8000
#define VM_MODE_CR2_BIT			0x4000
#define VM_MODE_CR1_BIT			0x2000 
#define VM_MODE_CR0_BIT			0x1000
#define VM_MODE_INIT_COEFF		0x0800
#define VM_MODE_TENTH_BIT			0x0400
#define VM_MODE_AMR_PLAY_BIT		0x0200
#define VM_MODE_AMR_REC_BIT		0x0100
#define VM_MODE_LOOP_BIT			0x0080
#define VM_MODE_ADPCM_REC_BIT	0x0040	
#define VM_MODE_AMR_IF2_PLAY_BIT  0x0020
#define VM_MODE_AMR_IF2_REC_BIT   0x0010
#define VM_MODE_PCM_PLAY_BIT		0x0008
#define VM_MODE_PCM_REC_BIT		0x0004
#define VM_MODE_FR_PLAY_BIT		0x0002
#define VM_MODE_FR_REC_BIT		0x0001

enum
{
    S_aud_vms_rec_idle,
    S_aud_vms_delay_before_recording,  
    S_aud_vms_wait_for_rec,  
    S_aud_vms_recording,
    S_aud_vms_finish_recording,
};

/*---------------------------------------------*/
/* Struct's.                                   */
/*---------------------------------------------*/
typedef struct 
{
    SINT16                     (*fp_voice_memo_putpacket)(UINT16 DWD_HUGE *);
    UINT16 DWD_HUGE            *file_handle;
    void                       *mmf_user_data;
    UINT32                     buffer_size;  
    UINT32                     start_offset;  
    UINT8                      rate;
    aud_media_enum             media_type;  
    aud_dsp_format_enum        format;
    aud_vm_mode_enum      vm_mode;  
    SDL_Pid                    sender;  
    ptr_GetAudioBufferFunction put_buffer_func;     
    aud_ssal_media_type           ssal_media_type;
} aud_glob_vms_rec_type;


typedef struct
{
    UINT8  data[VM_REC_BUFFER_SIZE];
}vms_rec_data_type;

typedef struct 
{
    SINT32 recording_frame;
    UINT32 bytes_recorded;
    UINT32 bytes_stored;
    UINT32 vms_mmf_remaining_buffersize;
	  
    SINT16 record_to_buffer;
    SINT16 vm_result;
    SINT16 ffs_result;
    UINT16 nof_words_per_frame;
    UINT8 vms_temp_streaming_buffer[32];
    UINT8 nof_bytes_per_frame;

    UINT8  aud_vms_rec_state;
    UINT8  aud_vms_rec_error;
    UINT8  wait_for_recording;

    BOOL array_number;
    BOOL data_outstanding;
    BOOL rc_check_record_flag;

}vms_rec_ctrl_type;

/*--------------------------------------------*/  
/* External variabels declaration.             */
/*---------------------------------------------*/
extern aud_glob_vms_rec_type        aud_glob_vms_rec;

/*---------------------------------------------*/
/* External function declaration.              */
/*---------------------------------------------*/
extern BOOL AudVmsRecSM(aud_event_enum event, void* pData);
extern void AudVmsRecL1EventHandle(aud_event_enum event);
extern void InitVmsRec(void);
extern SINT16 voice_memo_putpacket_in_ffs(UINT16 DWD_HUGE *buf);
extern SINT16 voice_memo_putpacket_in_ram(UINT16 DWD_HUGE *buf);
extern SINT16 voice_memo_putpacket_in_mmf(UINT16 DWD_HUGE *buf);
extern void AudVmsRecInterruptHandle(void);
//extern void DspStopRecordVm(void);

#endif /*VMS_PRESENT*/
#endif /* _INC_AUD_VMS_REC_H*/
