/***********************************************************************
* Copyright (C) 2007, ZTE Corporation.
* 
* File Name:     dd_voice.c
* File Mark:      
* Description:  This file contains the core routines for voice driver.
* Others:      
* Version:      v0.5
* Author:      LvWenhua
* Date:            2007-11-01
* 
* History 1:          
*     Date: 2008-06-30
*     Version:
*     Author: dangmaochang
*     Modification:  add mute, read\write, loopback function
* History 2: 
**********************************************************************/

/**************************************************************************
 *                                             Include files                                                    *
 **************************************************************************/
#include "drvs_general.h"
#include "drvs_io_voice.h"
#include "hal_voice.h"
#include "drvs_volte.h"
 /**************************************************************************
 *                                               Macro                                                        *
 **************************************************************************/

#define VOICE_2G_3G_SPLIT


/****************************************************************************
*                                     Local Type Definitions                                                *
****************************************************************************/
    typedef enum
    {
        DD_CLOSED = 0,
        DD_OPENED    ,
    
        MAX_DD_OPEN_STATUS      
    }T_Dd_OpenStatus;


/****************************************************************************
*                                     Local Function Prototypes                                           *
****************************************************************************/

static SINT32 ddVoice_Open(VOID *devData, T_ZDRVIO_FLAGS flags);
static SINT32 ddVoice_Close(VOID *devData);
static SINT32 ddVoice_Ioctl (VOID *devData, T_DRVIO_CTRL_KEY function, VOID* arg);
static SINT32 ddVoice_Read(VOID *devData, VOID *buffer, UINT32 length);
static SINT32 ddVoice_Write(VOID *devData, const VOID *buffer, UINT32 length);

/****************************************************************************
*                                     Global Constants                                                      *
****************************************************************************/


/****************************************************************************
*                                      Global Variables                                                      *
****************************************************************************/
static T_Dd_OpenStatus gDdVoice_OpenFlag = DD_CLOSED;
static T_HalVoice_Block gDdVoice_Block =
    {
        VOICE_SAMPLE_8K,
        CODEC_INPUT_MICPHONE,
        CODEC_OUTPUT_RECEIVER,
        VOICE_INPUT_VOL_LEVEL_3,
        VOICE_OUTPUT_VOL_LEVEL_3,
        {
            VOICE_MUTE_DISABLE,
            VOICE_UPLINK_AND_DOWNLINK
        }
    };

T_ZDrvIODev_Handle g_voiceIODevHandle = NULL;

#ifndef VOICE_2G_3G_SPLIT
static T_ZDrvIODev_Ops s_voiceIODevOps =
{
    .open   = ddVoice_Open,
    .close  = ddVoice_Close,
    .read   = ddVoice_Read,
    .write  = ddVoice_Write,
    .ctrl   = ddVoice_Ioctl,
};
#else
static T_ZDrvIODev_Ops s_voiceIODevOps =
{
    .open   = ddVoice_Open,
    .close  = ddVoice_Close,
    .ctrl   = ddVoice_Ioctl,
};
#endif
static T_ZDrvVp_Cfg s_voiceCfg = {0};

extern T_DrvVoice_3G_Opt  gDrvVoice_3G_Obj;

/****************************************************************************
*                                              Function Definitions                                           *
****************************************************************************/

/**************************************************************************
* Function: zDrvVoice_Init
* Description: This function is used to install voice driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*    DRV_SUCCESS:success to install device
*    DRV_ERROR:fail to install device
* Others: None
**************************************************************************/
SINT32 zDrvVoice_Init(VOID)
{

    g_voiceIODevHandle = zDrvIODev_Connect(ZDRV_DEV_VOICE, NULL, &s_voiceIODevOps);

    halVoice_InitCodec();

    return DRV_SUCCESS;
}

/**************************************************************************
* Function: zDrvVoice_Exit
* Description: This function is used to uninstall voice driver.
* Parameters: 
*   Input:None
*   Output:None
* Returns: 
*    DRV_SUCCESS:success to uninstall device
*    DRV_ERROR:fail to uninstall device
* Others: None
**************************************************************************/
SINT32 zDrvVoice_Exit(VOID)
{
    zDrvIODev_Disconnect(g_voiceIODevHandle);
    return DRV_SUCCESS;
}

#ifndef VOICE_2G_3G_SPLIT
/**************************************************************************
* Function: ddVoice_Open
* Description: This function is used to open voice device.
* Parameters: 
*   Input:
*          private:device private data
*          flags: no use
*   Output: None
* Returns:   
*         DRV_SUCCESS:success to open device
*         DRV_ERR_OPEN_TIMES: the device has been opened.
*         DRV_ERROR:fail to open device
* Others: None
**************************************************************************/
static SINT32 ddVoice_Open(VOID *devData, T_ZDRVIO_FLAGS flags)
{
    SINT32 ret = 0;

    if (gDdVoice_OpenFlag == DD_OPENED)
    {
        return DRV_ERR_OPEN_TIMES;
    }
    
    /*-------------- initialize CODEC ----------------*/
    ret = halVoice_Open();
    if ( ret < 0 )
    {
        return ret;
    }
    gDdVoice_OpenFlag = DD_OPENED;
    return DRV_SUCCESS;
}

/**************************************************************************
* Function: ddVoice_Close
* Description: This function is used to close voice device.
* Parameters: 
*   Input:
*          private:device private data
*   Output:None
* Returns: 
*    DRV_SUCCESS:success to close device
*    DRV_ERR_NOT_OPENED:device is not openned before
*    DRV_ERROR:fail to close device
* Others: None
**************************************************************************/
static SINT32 ddVoice_Close(VOID *devData)
{
    SINT32 ret = 0;

    if (gDdVoice_OpenFlag != DD_OPENED)
    {
        return DRV_ERR_NOT_OPENED;
    }
    /*-------------- exit CODEC ----------------*/
    ret = halVoice_Close();
    if ( ret < 0 )
    {
        return ret;
    }

    gDdVoice_OpenFlag = DD_CLOSED;

    return DRV_SUCCESS;
}

/**************************************************************************
* Function: ddVoice_Read
* Description: This function is used for vt read data
* Parameters:
*   Input:
*      pPrivData: pointer to the private data;
*      uiLen: the size of data
*   Output:
*      pBuf: pointer to the read buffer;
* Returns:
*   real read data length
*   DRV_ERR_NOT_OPENED:device is not openned before
*   DRV_ERROR:fail to read data
*   DRV_ERR_INVALID_PARAM: invalid paraments.
* Others: None
**************************************************************************/
static SINT32 ddVoice_Read(VOID *devData, VOID *buffer, UINT32 length)
{
    SINT32 ret = 0;
    
    if (NULL == buffer)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    ret = halVoice_Read((VOID*)buffer, length);

    return ret;
}

/**************************************************************************
* Function: ddVoice_Write
* Description: This function is used for vt write data
* Parameters:
*   Input:
*      pPrivData: device private data
*      pBuf: pointer to the written data;
*      uiLen: the size of written data;
*   Output:None
* Returns:
*   real write data lenth
*   DRV_ERR_NOT_OPENED:device is not openned before
*   DRV_ERROR:fail to write data
*   DRV_ERR_INVALID_PARAM: invalid paraments.
* Others: None
**************************************************************************/
static SINT32 ddVoice_Write(VOID *devData, const VOID *buffer, UINT32 length)
{
    SINT32 ret = 0;

    if (NULL == buffer)
    {
        return DRV_ERR_INVALID_PARAM;
    }
    ret = halVoice_Write((VOID*)buffer, length);

    return ret;

}

/**************************************************************************
* Function: ddVoice_Ioctl
* Description:  This function is used to control voice device.
* Parameters: 
*   Input:
*           private:device private data
*           cmd:command code
*           param:command parameters
*   Output:None
* Returns: 
*     DRV_SUCCESS: operate successfully.
*    DRV_ERR_INVALID_IOCTL_CMD: command error.
*    DRV_ERR_INVALID_PARAM: parameter error.
*     DRV_ERROR:other fail.

* Others:     cmd-param
                      1. CMD:IOCTL_VOICE_RECORD_START
                          param: T_ZDrvRcd_InfoParam*
                          
                      2. CMD:IOCTL_VOICE_RECORD_STOP
                          param: none
                          
                      3. CMD:IOCTL_VOICE_ENABLE
                          param: none
                          
                      4. CMD:IOCTL_VOICE_DISABLE
                          param: none       
                              
                      5. CMD: IOCTL_VOICE_SET_SAMPLE
                           param: T_ZDrvVoice_Sample*
                               
                      6. CMD:IOCTL_VOICE_SET_INPUT_PATH
                          param: T_ZDrv_VoiceInputPath*
                          
                      7. CMD:IOCTL_VOICE_SET_OUTPUT_PATH
                          param: T_ZDrv_VoiceOutputPath*
                               
                      8. CMD:IOCTL_VOICE_SET_INPUT_VOL
                          param: T_ZDrvVoice_InputVolLevel*
                          
                      5. CMD:IOCTL_VOICE_SET_OUTPUT_VOL
                          param: T_ZDrvVoice_OutputVolLevel*

                      6. CMD: CMD:IOCTL_VOICE_TEST_LOOPBACK
                          param: T_ZDrvVoice_Switch
                            
                      7. CMD:IOCTL_VOICE_SET_MUTE
                          param: T_ZDrvVoice_MuteInfo*

                      8.CMD:IOCTL_VOICE_ENABLE
                          param:none
                          
                      9.CMD:IOCTL_VOICE_DISABLE
                          param:none
                          
                      10. CMD:IOCTL_VOICE_SET_VT_START
                          param: T_ZDrvVoice_AmrInfoPtr*
                       
                      11. CMD:IOCTL_VOICE_SET_VT_STOP
                           param: none
                       
                           
                      12. CMD:MAX_IOCTL_VOICE
                              ERROR CMD INPUT
                          

**************************************************************************/
static SINT32 ddVoice_Ioctl (VOID *devData, T_DRVIO_CTRL_KEY function, VOID* arg)
{
    SINT32 ret = 0;
    
    switch(function)   
    {
         case IOCTL_VOICE_RECORD_START:
         {
            if(arg == NULL)
                return DRV_ERR_INVALID_PARAM;
            
            ret = halVoice_RCDStart ((T_ZDrvRcd_InfoParam *) arg);
            break;
         }
         
         case IOCTL_VOICE_RECORD_STOP:
         {
             ret = halVoice_RCDStop();
             break; 
         }    

         case IOCTL_VOICE_ENABLE:
         {         
            ret = halVoice_Enable();
            break;
         }

         case IOCTL_VOICE_DISABLE:
         {         
            ret = halVoice_Disable();
            break;
         }
    
         case IOCTL_VOICE_SET_SAMPLE:
         {
            if(arg == NULL)
                return DRV_ERR_INVALID_PARAM;
            
            gDdVoice_Block.sample= *(T_ZDrvVoice_Sample*)arg;
            ret = halVoice_SetSample(&gDdVoice_Block);
            break;
         }
         
         case IOCTL_VOICE_SET_INPUT_PATH:
         {
            if(arg == NULL)
                return DRV_ERR_INVALID_PARAM;
            
             gDdVoice_Block.pathin= *(T_ZDrv_VoiceInputPath*)arg;
            ret = halVoice_SetPathIn(&gDdVoice_Block);
             break; 
         }    

         case IOCTL_VOICE_SET_OUTPUT_PATH:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             gDdVoice_Block.pathout= *(T_ZDrv_VoiceOutputPath*)arg;
             ret = halVoice_SetPathOut(&gDdVoice_Block);
             break; 
         }    
         
         case IOCTL_VOICE_SET_INPUT_VOL:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             gDdVoice_Block.volin= *(T_ZDrvVoice_InputVolLevel*)arg;
             ret = halVoice_SetVolIn(&gDdVoice_Block);
             break; 
         }    
         
         case IOCTL_VOICE_SET_OUTPUT_VOL:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             gDdVoice_Block.volout= *(T_ZDrvVoice_OutputVolLevel*)arg;
             ret = halVoice_SetVolOut(&gDdVoice_Block);
             break; 
         }    

         case IOCTL_VOICE_SET_VT_START:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             ret = halVoice_VtStart((T_ZDrvVoice_AmrInfo*)arg);
             break; 
         }    

         case IOCTL_VOICE_SET_VT_STOP:
         {
             ret = halVoice_VtStop();
             break; 
         }    
         
         case IOCTL_VOICE_SET_MUTE:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             ret = halVoice_SetMute((T_ZDrvVoice_MuteInfo*)arg);
             break; 
         }    
         
         case IOCTL_VOICE_RECORD_DATA_READ:
         {
             if (arg == NULL)
             {
                 return DRV_ERR_INVALID_PARAM;
             }
             
             ret = halVoice_RecordDataRead((T_ZDrvVoice_BufInfo*)arg);
             break;
         }

         case IOCTL_VOICE_TEST_LOOPBACK:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             ret = halVoice_Loopback(*(T_ZDrvVoice_Switch*)arg);
             break; 
         }

         case IOCTL_VOICE_RCD_FREE_BUFF:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             ret = halVoice_FreeRcdBuf((VOID*)arg);
             break; 
         }
        
        default:
            return DRV_ERR_INVALID_IOCTL_CMD;
    }

    if(ret < 0)
        return ret;
    
    return DRV_SUCCESS;
}

#else
/**************************************************************************
* Function: ddVoice_Open
* Description: This function is used to open voice device.
* Parameters: 
*   Input:
*          private:device private data
*          flags: no use
*   Output: None
* Returns:   
*         DRV_SUCCESS:success to open device
*         DRV_ERR_OPEN_TIMES: the device has been opened.
*         DRV_ERROR:fail to open device
* Others: None
**************************************************************************/
static SINT32 ddVoice_Open(VOID *devData, T_ZDRVIO_FLAGS flags)
{
    //SINT32 ret = 0;

    return DRV_SUCCESS;
}
/**************************************************************************
* Function: ddVoice_Close
* Description: This function is used to close voice device.
* Parameters: 
*   Input:
*          private:device private data
*   Output:None
* Returns: 
*    DRV_SUCCESS:success to close device
*    DRV_ERR_NOT_OPENED:device is not openned before
*    DRV_ERROR:fail to close device
* Others: None
**************************************************************************/
static SINT32 ddVoice_Close(VOID *devData)
{
    SINT32 ret = 0;

    if (gDdVoice_OpenFlag != DD_OPENED)
    {
        return DRV_ERR_NOT_OPENED;
    }
    /*-------------- exit CODEC ----------------*/

	if(s_voiceCfg.mode == VOICE_GSM_MODE)
	{
	        ret = halVoice_Close();

             
	}
	else if((s_voiceCfg.mode  == VOICE_TD_MODE)||(s_voiceCfg.mode  == VOICE_WCDMA_MODE))
	{
	    if (NULL != gDrvVoice_3G_Obj.drv_voice_3G_Close) 
	    {
	        ret = gDrvVoice_3G_Obj.drv_voice_3G_Close();
	    }
	    else
	    {
	    	 zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dd_voice 3G voice close not register !\n");
	        return DRV_ERROR;
	    }


	}

    s_voiceCfg.mode = MAX_VOICE_MODE;
    gDdVoice_OpenFlag = DD_CLOSED;

    return ret;
}

/**************************************************************************
* Function: ddVoice_Ioctl
* Description:  This function is used to control voice device.
* Parameters: 
*   Input:
*           private:device private data
*           cmd:command code
*           param:command parameters
*   Output:None
* Returns: 
*     DRV_SUCCESS: operate successfully.
*    DRV_ERR_INVALID_IOCTL_CMD: command error.
*    DRV_ERR_INVALID_PARAM: parameter error.
*     DRV_ERROR:other fail.

* Others:     cmd-param
                     
                      3. CMD:IOCTL_VOICE_ENABLE
                          param: none
                          
                      4. CMD:IOCTL_VOICE_DISABLE
                          param: none       
                              
                      5. CMD: IOCTL_VOICE_SET_SAMPLE
                           param: T_ZDrvVoice_Sample*
                               
                      6. CMD:IOCTL_VOICE_SET_INPUT_PATH
                          param: T_ZDrv_VoiceInputPath*
                          
                      7. CMD:IOCTL_VOICE_SET_OUTPUT_PATH
                          param: T_ZDrv_VoiceOutputPath*
                               
                      8. CMD:IOCTL_VOICE_SET_INPUT_VOL
                          param: T_ZDrvVoice_InputVolLevel*
                          
                      5. CMD:IOCTL_VOICE_SET_OUTPUT_VOL
                          param: T_ZDrvVoice_OutputVolLevel*

                      6. CMD: CMD:IOCTL_VOICE_TEST_LOOPBACK
                          param: T_ZDrvVoice_Switch
                            
                      7. CMD:IOCTL_VOICE_SET_MUTE
                          param: T_ZDrvVoice_MuteInfo*


                          

                           param: none
                       
                           
                      12. CMD:MAX_IOCTL_VOICE
                              ERROR CMD INPUT
                          

**************************************************************************/
static SINT32 ddVoice_Ioctl (VOID *devData, T_DRVIO_CTRL_KEY function, VOID* arg)
{
    SINT32 ret = 0;
    
    switch(function)   
    {

         case IOCTL_VOICE_ENABLE:
         {    
	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
            	    ret = halVoice_Enable();
	     }
            break;
         }

         case IOCTL_VOICE_DISABLE:
         {   
	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
            	    ret = halVoice_Disable();
	     }		 	

            break;
         }
    
         
         case IOCTL_VOICE_SET_INPUT_PATH:
         {
            if(arg == NULL)
                return DRV_ERR_INVALID_PARAM;
	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
            	   gDdVoice_Block.pathin= *(T_ZDrv_VoiceInputPath*)arg;
                 ret = halVoice_SetPathIn(&gDdVoice_Block);
	     }	            

             break; 
         }    

         case IOCTL_VOICE_SET_OUTPUT_PATH:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            

	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
	           gDdVoice_Block.pathout= *(T_ZDrv_VoiceOutputPath*)arg;
	           ret = halVoice_SetPathOut(&gDdVoice_Block);
	     }	

			 
             break; 
         }    
         
         case IOCTL_VOICE_SET_INPUT_VOL:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
                 gDdVoice_Block.volin= *(T_ZDrvVoice_InputVolLevel*)arg;
                 ret = halVoice_SetVolIn(&gDdVoice_Block);
	     }	

			 
             break; 
         }    
         
         case IOCTL_VOICE_SET_OUTPUT_VOL:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
                 gDdVoice_Block.volout= *(T_ZDrvVoice_OutputVolLevel*)arg;
                 ret = halVoice_SetVolOut(&gDdVoice_Block);
	     }				 
             break; 
         }    


         
         case IOCTL_VOICE_SET_MUTE:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
            
             
	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
                 ret = halVoice_SetMute((T_ZDrvVoice_MuteInfo*)arg);
	     }		

			 
             break; 
         }      

         case IOCTL_VOICE_TEST_LOOPBACK:
         {
             if(arg == NULL)
                 return DRV_ERR_INVALID_PARAM;
 	     if(s_voiceCfg.mode == VOICE_GSM_MODE)
	     {
                 ret = halVoice_Loopback(*(T_ZDrvVoice_Switch*)arg);
	     }	           
             break; 
         }   
		 
         case IOCTL_VOICE_MODE_CONFIG:
         {
             if(arg == NULL){
                 return DRV_ERR_INVALID_PARAM;   
             	}	
			 
		if (gDdVoice_OpenFlag == DD_OPENED)
		{
		    return DRV_ERR_OPEN_TIMES;
		}

		//gDdVoice_Block.voiceMode= (T_ZDrvVoice_BufInfo)*arg;
             s_voiceCfg =*( (T_ZDrvVp_Cfg*)arg);
		if(s_voiceCfg.mode == VOICE_GSM_MODE)
		{
		    ret = halVoice_Open();
                 
		}
		else if((s_voiceCfg.mode  == VOICE_TD_MODE)||(s_voiceCfg.mode  == VOICE_WCDMA_MODE))
		{
		    if (NULL != gDrvVoice_3G_Obj.drv_voice_3G_Open) 
		    {
		        ret = gDrvVoice_3G_Obj.drv_voice_3G_Open();
		    }
		    else
		    {
		    	 zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dd_voice 3G voice open not register !\n");
		        return DRV_ERROR;
		    }


		}
	       else
	       {
                       ret = DRV_ERR_NOT_SUPPORTED;
		 }
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "dd_voice set mode = %d ,ret = %d!\n",s_voiceCfg.mode,ret);
		if(ret == DRV_SUCCESS)
		{
			gDdVoice_OpenFlag = DD_OPENED;
		}
             break; 
         }  	
        default:
            return DRV_ERR_INVALID_IOCTL_CMD;
    }

    if(ret < 0)
        return ret;
    
    return DRV_SUCCESS;
}

#endif

