/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_voiceapi.c
 * File Mark:    
 * Description:  This file contains the hardware interface for voice driver.
 * Others:        
 * Version:       V1.0
 * Author:        Dangmaochang
 * Date:          2008-07-08
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

/****************************************************************************
*                                                Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_io_voice.h"
#include "hal_voice.h"
#include "drvs_volte.h"

/****************************************************************************
*                                                Local Macros
****************************************************************************/

/****************************************************************************
*                                                Local Types
****************************************************************************/

/****************************************************************************
*                                                Local Constants
****************************************************************************/

/****************************************************************************
*                                                Local Function Prototypes
****************************************************************************/

/****************************************************************************
*                                               Global Constants
****************************************************************************/

/****************************************************************************
*                                               Global Variables
****************************************************************************/
T_HalVoice_Opt*  gHalVoice_ObjPtr = NULL;
T_DrvVoice_3G_Opt  gDrvVoice_3G_Obj = {0};

/****************************************************************************
*                                               Global Function Prototypes
****************************************************************************/

/****************************************************************************
*                                               Function Definitions
****************************************************************************/
/*******************************************************************************
* Function: halVoice_InitCodec
* Description: This function is used to init codec.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_InitCodec(VOID)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_init_codec))
    {
        return gHalVoice_ObjPtr->hal_voice_init_codec();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Open
* Description: This function is used to init hardware.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Open(VOID)
{    
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_Open))
    {
        return gHalVoice_ObjPtr->hal_voice_Open();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Close
* Description: This function is used to exit codec
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Close(VOID)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_Close))
    {
        return gHalVoice_ObjPtr->hal_voice_Close();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_RCDStart
* Description: This function is used to start record.
* Parameters: 
*   Input:
*      pParam:the info of record.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_RCDStart(T_ZDrvRcd_InfoParam *pParam)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_RCDStart))
    {
        return gHalVoice_ObjPtr->hal_voice_RCDStart(pParam);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_RCDStop
* Description: This function is used to stop record.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_RCDStop(VOID)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_RCDStop))
    {
        return gHalVoice_ObjPtr->hal_voice_RCDStop();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_SetSample
* Description: This function is used to set sample
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetSample(T_HalVoice_Block* pVoiceBlock)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_set_sample))
    {
        return gHalVoice_ObjPtr->hal_voice_set_sample(pVoiceBlock);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_SetPathIn
* Description: This function is used to set codec input path.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetPathIn(T_HalVoice_Block* pVoiceBlock)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_set_path_in))
    {
        return gHalVoice_ObjPtr->hal_voice_set_path_in(pVoiceBlock);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_SetPathOut
* Description: This function is used to set codec output path.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including output path information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetPathOut(T_HalVoice_Block* pVoiceBlock)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_set_path_out))
    {
        return gHalVoice_ObjPtr->hal_voice_set_path_out(pVoiceBlock);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_SetVolIn
* Description: This function is used to set codec input volume.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including input volume information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetVolIn(T_HalVoice_Block* pVoiceBlock)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_set_vol_in))
    {
        return gHalVoice_ObjPtr->hal_voice_set_vol_in(pVoiceBlock);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_SetVolOut
* Description: This function is used to set codec output volume.
* Parameters: 
*   Input:
*      pVoiceBlock:T_HalVoice_Block type, including output volume information.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetVolOut(T_HalVoice_Block* pVoiceBlock)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_set_vol_out))
    {
        return gHalVoice_ObjPtr->hal_voice_set_vol_out(pVoiceBlock);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Read
* Description: This function is used to read AMR data from DSP
* Parameters: 
*   Input:
*       pDataBuf: pointer to the buffer for read AMR data;
        count: the size of read data;
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Read(VOID *pDataBuf, UINT32 count)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_read))
    {
        return gHalVoice_ObjPtr->hal_voice_read(pDataBuf, count);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Write
* Description: This function is used to write AMR data to DSP
* Parameters: 
*   Input:
*       pDataBuf: pointer to the written data;
*       count:the size of written data;
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Write(VOID *pDataBuf, UINT32 count)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_write))
    {
        return gHalVoice_ObjPtr->hal_voice_write(pDataBuf, count);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_RecordDataRead
* Description: This function is used to read record data.
* Parameters: 
*   Input:
*      pVoiceDataInfo:the info of voice data.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_RecordDataRead(T_ZDrvVoice_BufInfo * pVoiceDataInfo)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_RecordDataRead))
    {
        return gHalVoice_ObjPtr->hal_voice_RecordDataRead(pVoiceDataInfo);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_SetMute
* Description: This function is used to enable/disable voice mute function
* Parameters: 
*   Input:
*      enable: the logic of enable or disable mute function.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_SetMute(T_ZDrvVoice_MuteInfo* pVoiceMuteInfo)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_set_mute))
    {
        return gHalVoice_ObjPtr->hal_voice_set_mute(pVoiceMuteInfo);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Loopback
* Description: This function is used to enable/disable voice loopback function
* Parameters: 
*   Input:
*      enable: the logic of enable or disable loop function.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Loopback(T_ZDrvVoice_Switch enable)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_loopback))
    {
        return gHalVoice_ObjPtr->hal_voice_loopback(enable);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Enable
* Description: This function is used to enable the voice channel
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Enable(VOID)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_enable))
    {
        return gHalVoice_ObjPtr->hal_voice_enable();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Disable
* Description: This function is used to disable the voice channel
* Parameters: 
*   Input: none
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Disable(VOID)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_disable))
    {
        return gHalVoice_ObjPtr->hal_voice_disable();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_VtStart
* Description: This function is used to open the amr for starting the VT
* Parameters: 
*   Input: 
*           amrInfo: the information of AMR's frame type and frame formate.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_VtStart(T_ZDrvVoice_AmrInfoPtr amrInfo)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_vt_start))
    {
        return gHalVoice_ObjPtr->hal_voice_vt_start(amrInfo);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_VtSop
* Description: This function is used to close the amr for stopping the VT
* Parameters: 
*   Input: None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_VtStop(VOID)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->hal_voice_vt_stop))
    {
        return gHalVoice_ObjPtr->hal_voice_vt_stop();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_FreeRcdBuf
* Description: This function is used to relese the buffer of record.
* Parameters: 
*   Input:
*      pBuf:the buffer of record.
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_FreeRcdBuf(VOID *pBuf)
{
    if ((NULL != gHalVoice_ObjPtr) && (NULL != gHalVoice_ObjPtr->halVoice_FreeRcdBuf))
    {
        return gHalVoice_ObjPtr->halVoice_FreeRcdBuf(pBuf);
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: zDrvVoice_SetOperations
* Description: This function is used to set the audio instance of hal layer.
* Parameters: 
*   Input:
*           VoiceObjPtr:The pointer to audio function block of hal layer
*   Output:None
*
* Returns: none
*
* Others: 
********************************************************************************/
VOID zDrvVoice_SetOperations(T_HalVoice_Opt* VoiceObjPtr)
{
    gHalVoice_ObjPtr = VoiceObjPtr;
}

/*******************************************************************************
* Function: zDrvVoice_3G_SetOperations
* Description: This function is used to set the 3G voice callback function.
* Parameters: 
*   Input:
*           VoiceObjPtr:The pointer to 3G voice callback function type. 
*   Output:None
*
* Returns: none
*
* Others: 
********************************************************************************/
VOID zDrvVoice_3G_RegCallbacks(T_DrvVoice_3G_Opt voiceObj)
{
    gDrvVoice_3G_Obj = voiceObj;
}

/*******************************************************************************
* Function: halVoice_Open3G
* Description: This function is used to open 3g voice .
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Open3G(VOID)
{    
    if  (NULL != gDrvVoice_3G_Obj.drv_voice_3G_Open)
    {
        return gDrvVoice_3G_Obj.drv_voice_3G_Open();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}

/*******************************************************************************
* Function: halVoice_Close3G
* Description: This function is used to close 3g voice .
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
SINT32 halVoice_Close3G(VOID)
{    
    if  (NULL != gDrvVoice_3G_Obj.drv_voice_3G_Close)
    {
        return gDrvVoice_3G_Obj.drv_voice_3G_Close();
    }
    else
    {
        return DRV_ERR_NOT_SUPPORTED;
    }
}


/*******************************************************************************
* Function: halVoice_Open2g3gTeak
* Description: This function is used to init teak.
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
int halVoice_Open2g3gTeak(T_HalVoice_Block* pVoiceBlock)
{  
    int ret = 0;

	ret = halVoice_Open();
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:voice_Open fail ret=%d\n",__func__,ret);
		return ret;

	}
	ret = halVoice_SetPathIn(pVoiceBlock);
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:halVoice_SetPathIn fail ret=%d\n",__func__,ret);
		
		halVoice_Close();
		return ret;

	}
	ret = halVoice_SetPathOut(pVoiceBlock);
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:halVoice_SetPathOut fail ret=%d\n",__func__,ret);
		
		halVoice_Close();
		return ret;

	}	
	ret = halVoice_SetVolOut(pVoiceBlock);
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:halVoice_SetVolOut fail ret=%d\n",__func__,ret);
		halVoice_Close();
		return ret;

	}		
	ret = halVoice_Enable();
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:halVoice_Enable fail ret=%d\n",__func__,ret);
		halVoice_Close();
		return ret;

	}		

	return ret;

	
}

/*******************************************************************************
* Function: halVoice_Close2g3gTeak
* Description: This function is used to exit teak
* Parameters: 
*   Input:None
*   Output:None
*
* Returns: 0:success
*              DRV_ERR_NOT_SUPPORTED:not support
*              other:check T_ZDrv_ErrCode or hal error code
*
* Others: 
********************************************************************************/
int halVoice_Close2g3gTeak(VOID)
{
    int ret = 0;

	ret = halVoice_Disable();
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:halVoice_Disable fail ret=%d\n",__func__,ret);

	}		
	ret = halVoice_Close();
	if(ret != 0)
	{
		zDrvRamlog_PRINTF(RAMLOG_MOD_AUDIO, "%s:halVoice_Close fail ret=%d\n",__func__,ret);

	}

	return ret;	
}


