/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    dd_uicc.c
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        wangxia
 * Date:          2008-4-18
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include    "oss_api.h"
#include    "drvs_uicc.h"
#include    "uicc.h"
#include "ring_queue.h"
#include "NvParam_drv.h" 
#include <linux/uicc_agt_client.h>

#include "USIM_reg.h"
#include "drvs_cfg.h"
#include "drvs_gpio.h"

#include <linux/clk.h>

extern T_UICC_SET_INOUT_CALLBACK UICC_uninstall_inout_callback(VOID);
extern T_UICC_CARD_SELECTOR      UICC_current_reader;
extern ZOSS_THREAD_ID      UICC_in_out_threadid;
extern ZOSS_SEMAPHORE_ID   UICC_in_out_sem;
extern ZOSS_SEMAPHORE_ID 	UICC_power_sem;
extern T_Ring_Queue 		*UICC_power_msg_queue;
extern ZOSS_THREAD_ID 		UICC_power_thread;
extern VOID UICC_PowerThread(SINT32 arg);
extern UINT8 zDrvUICC_ConfigForDetectSIM(VOID);
extern void UICC_highisr(void);
extern UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
extern UINT32 zOss_NvItemWrite(UINT32 NvItemID, UINT8 *NvItemData, UINT32 NvItemLen);
#ifdef DSDS_VSIM
extern int atio_vsim_apdu_cfg(uint8_t*apdu_req, uint16_t apdu_req_len, uint8_t *apdu_rsp, uint16_t *apdu_rsp_len,uint8_t slot,uint8_t bAuth);
#endif
/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/
UINT8 Vsim_Flag;
UINT8 Vsim_reset_flag = 0;
T_UICC_CARD_TYPE card_type_ctrl[3] = {UICC_CARD,CLOUD_CARD};

volatile UINT32  axi_ahb0_usim_base = 0;
volatile UINT32  axi_ahb0_usim_base_sim_fifo_txd = 0;
volatile UINT32  axi_ahb0_usim_base_sim_fifo_rxd = 0;
volatile tSIM_DMA* sSIM_DMA= NULL;
volatile tSIM_T1CTRL* sSIM_T1CTRL= NULL;
volatile tSIM_CTRL2* sSIM_CTRL2 = NULL;
volatile tSIM_CTRL* sSIM_CTRL = NULL;
/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/


/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

UINT8 zDrvUicc_GetPreCardType(T_ZDrvUicc_CardSelector card_selector)
{
	SINT32  ret = DRV_SUCCESS;
	UINT8 preSwitchType = 0xFF;
	T_UICC_CARD_TYPE pre_card_type_ctrl[2] = {UICC_CARD,CLOUD_CARD};

	if (1 == card_selector)
	{
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uicc1PreSwitch), (UINT8 *)&preSwitchType, DRV_SYS_NV_ITEM_SIZE(uicc1PreSwitch));
		if(ret != DRV_SUCCESS)
		{
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetPreCardType failed!!! \n!",card_selector);
			return CLOUD_CARD;
		}
		pre_card_type_ctrl[card_selector] = preSwitchType;	
	}
	else
	{
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uiccPreSwitch), (UINT8 *)&preSwitchType, DRV_SYS_NV_ITEM_SIZE(uiccPreSwitch));
		if(ret != DRV_SUCCESS)
		{
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetPreCardType failed!!! \n!",card_selector);
			return UICC_CARD;
		}
		pre_card_type_ctrl[card_selector] = preSwitchType;	
	}

	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetPreCardType (%u %u)\n!",card_selector, pre_card_type_ctrl[0] ,pre_card_type_ctrl[1]);

	if(pre_card_type_ctrl[card_selector] >= UICC_VSIM_MAX)
	{
		pre_card_type_ctrl[card_selector] = UICC_CARD;
	}

  	return pre_card_type_ctrl[card_selector];

}

UINT32 zDrvUicc_GetCardType(T_ZDrvUicc_CardSelector card_selector)
{
	SINT32  ret = DRV_SUCCESS;
	volatile UINT32 count = 0;
	UINT8 preSwitchType = 0xFF;
	
	if (1 == card_selector)
	{
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uicc1PreSwitch), (UINT8 *)&preSwitchType, DRV_SYS_NV_ITEM_SIZE(uicc1PreSwitch));
		zOss_Printf(SUBMDL_DD, PRINT_LEVEL_NORMAL, "[UICC%d]zDrvUicc_GetCardType, preSwitchType = %u, card_type_ctrl = %u\n!",card_selector, preSwitchType, card_type_ctrl[card_selector]);
		if(preSwitchType != card_type_ctrl[card_selector] && preSwitchType != 0xFF)
		{
			card_type_ctrl[card_selector] = preSwitchType;
			ret = zOss_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(uicc1modeSwitch), (UINT8 *)&preSwitchType, DRV_SYS_NV_ITEM_SIZE(uicc1modeSwitch));
		}
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uicc1modeSwitch), (UINT8 *)&card_type_ctrl[card_selector], DRV_SYS_NV_ITEM_SIZE(uicc1modeSwitch));
		if(ret != DRV_SUCCESS)
		{
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetCardType failed!!! \n!",card_selector);
			return DRV_UICC_ACTIVATION_FAILED;
		}
	}
	else
	{
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uiccPreSwitch), (UINT8 *)&preSwitchType, DRV_SYS_NV_ITEM_SIZE(uiccPreSwitch));
		zOss_Printf(SUBMDL_DD, PRINT_LEVEL_NORMAL, "[UICC%d]zDrvUicc_GetCardType, preSwitchType = %d, card_type_ctrl = %u \n!",card_selector, preSwitchType, card_type_ctrl[card_selector]);
		if(preSwitchType != card_type_ctrl[card_selector] && preSwitchType != 0xFF)
		{
			card_type_ctrl[card_selector] = preSwitchType;
			ret = zOss_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(uiccmodeSwitch), (UINT8 *)&preSwitchType, DRV_SYS_NV_ITEM_SIZE(uiccmodeSwitch));
		}
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uiccmodeSwitch), (UINT8 *)&card_type_ctrl[card_selector], DRV_SYS_NV_ITEM_SIZE(uiccmodeSwitch));
		if(ret != DRV_SUCCESS)
		{
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetCardType failed!!! \n!",card_selector);
			return DRV_UICC_ACTIVATION_FAILED;
		}
	}

	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetCardType (%u %u)\n!",card_selector, card_type_ctrl[0] ,card_type_ctrl[1]);

	if(card_type_ctrl[card_selector] >= UICC_VSIM_MAX)
	{
		card_type_ctrl[card_selector] = UICC_CARD;
	}

  	return card_type_ctrl[card_selector];

}

#ifdef DSDS_VSIM
void zDrvUiccAuth(T_ZDrvUicc_CardSelector card_selector, T_ZDrvUicc_CommandCase command_case, T_ZDrvUicc_ApduHeader c_apdu,UINT8  *apdu_data_ptr)
{
	  int ret =0;
	  u8 temp_lc =0;
	  u8 temp_le =0;
	  u16 apdu_req_len = 0;
	  u16 apdu_rsp_len	= 0;
	  u8  apdu_req[264] = {0};
	  u8  apdu_rsp[264] = {0};
	
	  switch(command_case)
	 {
		  case UICC_CMD_CASE_1: /* No Tx not Rx */
		  memcpy(apdu_req, &c_apdu, 4);
		  apdu_req_len = 4;
	
		  break;
	
		  case UICC_CMD_CASE_2: /* Rx */
		  memcpy(apdu_req, &c_apdu, 4);
		  temp_le = c_apdu.le ;
		  memcpy(apdu_req +4, &temp_le, 1);
		  apdu_req_len = 5;
		  break;
		  case UICC_CMD_CASE_3: /* Tx */
		  memcpy(apdu_req, &c_apdu, 4);
		  temp_lc = c_apdu.lc ;
		  memcpy(apdu_req +4, &temp_lc, 1);
		  if(temp_lc >0)
		  {
			  memcpy(apdu_req +5, apdu_data_ptr, temp_lc);	  
		  }
		  apdu_req_len = 5 + temp_lc;
	
		  break;
	
		  case UICC_CMD_CASE_4: /* Tx and Rx */
		  memcpy(apdu_req, &c_apdu, 4);
		  temp_lc = c_apdu.lc ;
		  memcpy(apdu_req +4, &temp_lc, 1);
	
		  if(temp_lc >0)
		  {
			  memcpy(apdu_req +5, apdu_data_ptr, temp_lc);			  
		  }
		  temp_le = c_apdu.le ;
		  memcpy(apdu_req +5+ temp_lc, &temp_le, 1);
		  apdu_req_len = 6 + temp_lc;
	
		  break;
			   default:    
			break;
	}
	  
	atio_vsim_apdu_cfg(apdu_req, apdu_req_len, apdu_rsp, &apdu_rsp_len, card_selector, 1);

}


#endif

T_ZDrvUicc_ApduReselt zDrvUicc_TransportApdu(T_ZDrvUicc_CardSelector card_selector,
                  T_ZDrvUicc_CommandCase command_case,
                  BOOL                              extended_length,
                  T_ZDrvUicc_ApduHeader    c_apdu,
                  T_ZDrvUicc_ApduFooter     *r_apdu_ptr,
                  UINT8                             *apdu_data_ptr)
{
	T_UICC_APDU_RESULT  nRet;
	
	if ((CLOUD_CARD == card_type_ctrl[card_selector]) || (SOFTSIM_CARD == card_type_ctrl[card_selector]))
	{
 	        int ret =0;
			u8 temp_lc =0;
			u8 temp_le =0;
			u16 apdu_req_len = 0;
			u16 apdu_rsp_len  = 0;
			u8  apdu_req[264] = {0};
			u8  apdu_rsp[264] = {0};
			u8  bAuth = 0;
			if (c_apdu.ins == 0x88)
			{
				bAuth = 1;
			}
		    switch(command_case)
	           {
		            case UICC_CMD_CASE_1: /* No Tx not Rx */
					memcpy(apdu_req, &c_apdu, 4);
					apdu_req_len = 4;

					break;

		            case UICC_CMD_CASE_2: /* Rx */
					memcpy(apdu_req, &c_apdu, 4);
					temp_le = c_apdu.le ;
					memcpy(apdu_req +4, &temp_le, 1);
					apdu_req_len = 5;
					break;
		            case UICC_CMD_CASE_3: /* Tx */
					memcpy(apdu_req, &c_apdu, 4);
					temp_lc = c_apdu.lc ;
					memcpy(apdu_req +4, &temp_lc, 1);
					if(temp_lc >0)
					{
						memcpy(apdu_req +5, apdu_data_ptr, temp_lc);	
					}
					apdu_req_len = 5 + temp_lc;

					break;

		            case UICC_CMD_CASE_4: /* Tx and Rx */
					memcpy(apdu_req, &c_apdu, 4);
					temp_lc = c_apdu.lc ;
					memcpy(apdu_req +4, &temp_lc, 1);

					if(temp_lc >0)
					{
						memcpy(apdu_req +5, apdu_data_ptr, temp_lc);			
					}
					temp_le = c_apdu.le ;
					memcpy(apdu_req +5+ temp_lc, &temp_le, 1);
					apdu_req_len = 6 + temp_lc;

					break;
	                     default:    
		              break;
	          } 
			#ifdef DSDS_VSIM
			ret = atio_vsim_apdu_cfg(apdu_req, apdu_req_len, apdu_rsp, &apdu_rsp_len, card_selector, bAuth);
            		#endif
			if(ret == 1)
			{
				r_apdu_ptr->sw1 = 0x00;
				r_apdu_ptr->sw2 = 0x00;
				zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[DSDS_VSIM]atio_vsim_apdu_cfg return value = 0x%x\n!", ret);		
				return 0;
			}
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[DSDS_VSIM]apdu_rsp_len = 0x%x\n!", apdu_rsp_len);		

			if(apdu_rsp_len < 2)
				apdu_rsp_len = 2;
				
			r_apdu_ptr->luicc =  apdu_rsp_len -2; 
			
			if (((r_apdu_ptr->luicc)!= (c_apdu.le))&&(c_apdu.le !=0))
			{
				zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[DSDS_VSIM]le not equal to luicc (%d %d)\n!", c_apdu.le, r_apdu_ptr->luicc);		
				r_apdu_ptr->luicc = c_apdu.le;
			}		

			if((r_apdu_ptr->luicc) > 256)
			{
				r_apdu_ptr->luicc = 256;
				zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[DSDS_VSIM]luicc too long %d >256\n!", r_apdu_ptr->luicc);		
			}

			if ((r_apdu_ptr->luicc) > 0)
			{
				memcpy(apdu_data_ptr, apdu_rsp, r_apdu_ptr->luicc);
			}

			r_apdu_ptr->sw1 = *(apdu_rsp+ 0 + apdu_rsp_len - 2);
			r_apdu_ptr->sw2 = *(apdu_rsp+ 1 + apdu_rsp_len - 2);

			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[DSDS_VSIM]luicc = %d, sw1= 0x%x, sw2 = 0x%x\n!", r_apdu_ptr->luicc,r_apdu_ptr->sw1,r_apdu_ptr->sw2);	
			 return 0;
		}
		else if (VSIM_CARD == card_type_ctrl[card_selector])
		{
#ifdef DSDS_VSIM
	//		if ((card_selector == DRV_UICC_SECONDARY_CARD_1) && (c_apdu.ins == 0x88))
			if(c_apdu.ins == 0x88)
			{
				zDrvUiccAuth(card_selector, command_case, c_apdu, apdu_data_ptr);
			}
#endif
			nRet = Vsim_TransportApdu((T_VSIM_CARD_SELECTOR)card_selector, 
		                          (T_VSIM_COMMANDCASE)command_case, 
		                          extended_length, 
		                          *(t_uicc_apduheader *)&c_apdu, 
		                          (t_uicc_apdufooter *)r_apdu_ptr, 
		                            apdu_data_ptr);
		}
/*		else if (SOFTSIM_CARD == card_type_ctrl[card_selector])
		{
			 zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]SOFTSIM_CARD APDU NOT SUPPORTED\n!",card_selector);	
			 return UICC_TRANSFER_FAILED;
		}*/
		else if (UICC_VSIM_AUTO == card_type_ctrl[card_selector])
		{
			if(Vsim_Flag == UICC_SIM_PLUGIN)
				nRet = UICC_transport_APDU( (T_UICC_CARD_SELECTOR) card_selector, 
	                             (T_UICC_COMMAND_CASE) command_case, 
	                              extended_length, 
	                             *((T_UICC_APDU_HEADER *) &c_apdu), 
	                             (T_UICC_APDU_FOOTER *) r_apdu_ptr, 
	                             (ubyte *) apdu_data_ptr);
			else
				nRet = Vsim_TransportApdu((T_VSIM_CARD_SELECTOR)card_selector, 
									  (T_VSIM_COMMANDCASE)command_case, 
									  extended_length, 
									  *(t_uicc_apduheader *)&c_apdu, 
									  (t_uicc_apdufooter *)r_apdu_ptr, 
										apdu_data_ptr);
		}
		else
		{
			nRet = UICC_transport_APDU( (T_UICC_CARD_SELECTOR) card_selector, 
		                     (T_UICC_COMMAND_CASE) command_case, 
		                      extended_length, 
		                     *((T_UICC_APDU_HEADER *) &c_apdu), 
		                     (T_UICC_APDU_FOOTER *) r_apdu_ptr, 
		                     (ubyte *) apdu_data_ptr);
		}
		 return   (T_ZDrvUicc_ApduReselt)nRet;
}


int zDrvUicc_SimInserted(UINT8 state)
{
//	zOss_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(uiccInserted), (UINT8 *)&state, DRV_SYS_NV_ITEM_SIZE(uiccInserted));
	//zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC]SimInserted (%d) zDrvUicc_SimInserted \n!", state);
	return 0;
}

T_ZDrvUicc_ResetResult zDrvUicc_ResetCard(T_ZDrvUicc_CardSelector card_selector)
{
	T_UICC_RESET_RESULT reset_result;
	SINT32  ret = DRV_SUCCESS;
	volatile UINT32 count = 0;
	UINT8 preSwitchType = 0xFF;
	UICC_create_semaphore(UICC_ACTIVATION_TAG);
	
	if(UICC_power_sem == NULL)
	{
		UICC_power_sem = zOss_CreateSemaphore("UICC_POWER_SEM",0);
	}
	
	if(UICC_power_msg_queue == NULL)
	{
		UICC_power_msg_queue = ringQueue_Create(6 * UICC_NOF_CARD_SLOTS + 1, (sizeof(T_UICC_POWER_MSG) + 3)&(~0x3), QUEUE_PROTECT_IRQ);
	}
	
	if(UICC_power_thread == NULL)
	{       
		UICC_power_thread = zOss_CreateThread("UICC_POWER_THREAD",UICC_PowerThread,0,512,7,1,1);
	} 
	
	zDrvUicc_GetCardType(DRV_UICC_PRIMARY_CARD);
	zDrvUicc_GetCardType(DRV_UICC_SECONDARY_CARD_1);
	
	if((card_type_ctrl[0] == UICC_CARD) && (card_type_ctrl[1] == UICC_CARD))
	{
		card_type_ctrl[0] = UICC_CARD;
		card_type_ctrl[1] = CLOUD_CARD;
	 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_ResetCard both UICC_CARD not supported\n!",card_selector);
	}
	
 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_ResetCard. card_type_ctrl= %u\n!",card_selector, card_type_ctrl[card_selector]);

	if ((CLOUD_CARD == card_type_ctrl[card_selector]) || (SOFTSIM_CARD == card_type_ctrl[card_selector]))
	{
		return UICC_ACTIVATION_SUCCEEDED;
	}
	else if (VSIM_CARD == card_type_ctrl[card_selector])
	{
		reset_result = Vsim_ResetCard((T_VSIM_CARD_SELECTOR)card_selector);
	 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]VSIM RESET \n!",card_selector );
	}
	else if (UICC_VSIM_AUTO == card_type_ctrl[card_selector])
	{

		Vsim_Flag = zDrvUICC_ConfigForDetectSIM();//UICC_SIM_PLUGOUT;

		if(Vsim_Flag == UICC_SIM_PLUGIN)
		{
			reset_result = UICC_ResetCard((T_UICC_CARD_SELECTOR)card_selector);
			zDrvUicc_SimInserted(1);
		 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]SIM AUTO UICC  RESET \n!",card_selector);
		}
		else
		{
			reset_result = Vsim_ResetCard((T_VSIM_CARD_SELECTOR)card_selector);
		 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]SIM AUTO VSIM  RESET \n!",card_selector);
		}
	}
	else
	{
		if (UICC_ESIM_CARD == card_type_ctrl[card_selector])
		{
		        /*mentioned: gpio pinmux:sim1 and rf*/
			zx29_gpio_config(ZX29_GPIO_133, GPIO133_SIM1_RST); 
			zx29_gpio_config(ZX29_GPIO_134, GPIO134_SIM1_CLK); 
			zx29_gpio_config(ZX29_GPIO_135, GPIO135_SIM1_DATA); 

			axi_ahb0_usim_base = (UINT32)USIM1_REG_BASE; 
			
			sSIM_DMA= ((volatile tSIM_DMA *) (USIM1_REG_BASE + 0x0084));
			sSIM_T1CTRL= ((volatile tSIM_T1CTRL *) (USIM1_REG_BASE + 0x0040));
			sSIM_CTRL2= ((volatile tSIM_CTRL2 *) (USIM1_REG_BASE + 0x003c));
			sSIM_CTRL=  (volatile tSIM_CTRL *) (USIM1_REG_BASE + 0x0020);

			axi_ahb0_usim_base_sim_fifo_txd = (UINT32)(USIM1_REG_BASE + 0x200);
			axi_ahb0_usim_base_sim_fifo_rxd = (UINT32)(USIM1_REG_BASE + 0x500);
			
			count = 10000;
			SIM_CLC = 0x100;       /*set USIM clock*/
			while(count--);    /*ʱرsoc usimҪŵAPB 4Ƶ֮ǰִ*/
		 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL,"[UICC%d]^^^ESIM^^^ SIM_CLC : %04x SIM_ID : %04x SIM_CTRL : %04x,card_type_ctrl = %u\n",card_selector, SIM_CLC, SIM_ID, SIM_CTRL, card_type_ctrl[card_selector]);
			zDrvRamlog_PRINTF(RAMLOG_MOD_UICC,"[UICC%d]^^^ESIM^^^ SIM_CLC : %04x SIM_ID : %04x SIM_CTRL : %04x,card_type_ctrl = %u\n",card_selector, SIM_CLC,SIM_ID,SIM_CTRL, card_type_ctrl[card_selector]);
			uiccramlog_Printf("[UICCNEW%d]^^^ESIM^^^ SIM_CLC : %04x SIM_ID : %04x SIM_CTRL : %04x,card_type_ctrl = %u\n", card_selector, SIM_CLC, SIM_ID, SIM_CTRL, card_type_ctrl[card_selector]);
		}
		else
		{
			axi_ahb0_usim_base = (UINT32)(GSM_MODEM2+0x100000);
			 
			sSIM_DMA= ((volatile tSIM_DMA *) ((GSM_MODEM2+0x100000) + 0x0084));
			sSIM_T1CTRL = ((volatile tSIM_T1CTRL *) ((GSM_MODEM2+0x100000) + 0x0040));
			sSIM_CTRL2 = ((volatile tSIM_CTRL2 *) ((GSM_MODEM2+0x100000) + 0x003c));
			sSIM_CTRL = ((volatile tSIM_CTRL *) ((GSM_MODEM2+0x100000) + 0x0020));
			
			axi_ahb0_usim_base_sim_fifo_txd = (UINT32)((GSM_MODEM2+0x100000) + 0x1000);
			axi_ahb0_usim_base_sim_fifo_rxd = (UINT32)((GSM_MODEM2+0x100000) + 0x1400);
			count = 10000;
			SIM_CLC = 0x100;       
			while(count--);   
			
		 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL,"[UICC%d]^^^UICC^^^ SIM_CLC : %04x SIM_ID : %04x SIM_CTRL : %04x,card_type_ctrl = %u\n",card_selector,SIM_CLC,SIM_ID,SIM_CTRL,card_type_ctrl[card_selector]);
			zDrvRamlog_PRINTF(RAMLOG_MOD_UICC,"[UICC%d]^^^UICC^^^ SIM_CLC : %04x SIM_ID : %04x SIM_CTRL : %04x,card_type,,card_type_ctrl = %u\n",card_selector,SIM_CLC,SIM_ID,SIM_CTRL,card_type_ctrl[card_selector]);
			uiccramlog_Printf("[UICCNEW%d]^^^UICC^^^ SIM_CLC : %04x SIM_ID : %04x SIM_CTRL : %04x,card_type,,card_type_ctrl = %u\n",card_selector,SIM_CLC,SIM_ID,SIM_CTRL,card_type_ctrl[card_selector]);
		}
		
  		reset_result = UICC_ResetCard((T_UICC_CARD_SELECTOR)card_selector);
		zDrvUicc_SimInserted(1);
	 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]UICC RESET\n!",card_selector);
	}
	return (T_ZDrvUicc_ResetResult)reset_result;

}


T_ZDrvUicc_CloseResult zDrvUicc_Close(T_ZDrvUicc_CardSelector card_selector)
{
	T_UICC_CLOSE_RESULT nRet;
	SINT32  ret = DRV_SUCCESS;
	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_NORMAL, "zDrvUicc_Close() entery. card_selector=%d \n!", card_selector);
	UICC_create_semaphore(UICC_ACTIVATION_TAG);

	if(UICC_power_sem == NULL)
	{
		UICC_power_sem = zOss_CreateSemaphore("UICC_POWER_SEM",0);
	}
	if(UICC_power_msg_queue == NULL)
	{
		UICC_power_msg_queue = ringQueue_Create(6 * UICC_NOF_CARD_SLOTS + 1, (sizeof(T_UICC_POWER_MSG) + 3)&(~0x3), QUEUE_PROTECT_IRQ);
	}
	if(UICC_power_thread == NULL)
	{       
		UICC_power_thread = zOss_CreateThread("UICC_POWER_THREAD",UICC_PowerThread,0,512,7,1,1);
	} 

	if (1 == card_selector)
	{
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uicc1modeSwitch), (UINT8 *)&card_type_ctrl[card_selector], DRV_SYS_NV_ITEM_SIZE(uicc1modeSwitch));
		if(ret != DRV_SUCCESS)
		{
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetCardType failed!!! \n!",card_selector);
			return DRV_UICC_ACTIVATION_FAILED;
		}
	}
	else
	{
		ret = zOss_NvItemRead(DRV_SYS_NV_ITEM_ADDR(uiccmodeSwitch), (UINT8 *)&card_type_ctrl[card_selector], DRV_SYS_NV_ITEM_SIZE(uiccmodeSwitch));
		if(ret != DRV_SUCCESS)
		{
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_GetCardType failed!!! \n!",card_selector);
			return DRV_UICC_ACTIVATION_FAILED;
		}
	}

	if(card_type_ctrl[card_selector] >= UICC_VSIM_MAX)
	{
		card_type_ctrl[card_selector] = UICC_CARD;
	}
	
 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]zDrvUicc_Close. card_type_ctrl=%u\n!",card_selector,card_type_ctrl[card_selector]);
	
	if ((CLOUD_CARD == card_type_ctrl[card_selector]) || (SOFTSIM_CARD == card_type_ctrl[card_selector]))
	{
		return UICC_DEACTIVATION_SUCCEEDED;
	}
	else if (VSIM_CARD == card_type_ctrl[card_selector])
	{
		nRet = Vsim_Close((T_VSIM_CARD_SELECTOR) card_selector);
	 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]VSIM CLOSE \n!",card_selector);
     		return   (T_ZDrvUicc_CloseResult)nRet;
	}
	else if (UICC_VSIM_AUTO == card_type_ctrl[card_selector])
	{
		if(Vsim_Flag == UICC_SIM_PLUGIN)
		{
    			nRet = UICC_close((T_UICC_CARD_SELECTOR)card_selector);
			zDrvUicc_SimInserted(0);
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]SIM AUTO UICC  CLOSE \n!",card_selector );
		}
		else
		{
			nRet = Vsim_Close((T_VSIM_CARD_SELECTOR) card_selector);
			zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]SIM AUTO VSIM  CLOSE \n!",card_selector );
		}
	}
	else 
	{
		nRet = UICC_close((T_UICC_CARD_SELECTOR) card_selector);
		zDrvUicc_SimInserted(0);
	 	zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]UICC CLOSE \n!",card_selector );
	}
	return   (T_ZDrvUicc_CloseResult)nRet;
	
}


VOID zDrvUicc_CardCharacteristics(T_ZDrvUicc_CardSelector card_selector,
                                T_ZDrvUicc_ClockStopMode clock_stop_mode,
                                UINT8                               min_clock_freq)
{
	if (UICC_CARD == card_type_ctrl[card_selector])
	{
  		UICC_card_characteristics((T_UICC_CARD_SELECTOR) card_selector, 
                                          (T_UICC_CLOCK_STOP_MODE) clock_stop_mode, 
                                          (ubyte) min_clock_freq);
	}
}

T_ZDrvUicc_HwProfile zDrvUicc_HwProfile(VOID)
{

	T_UICC_HW_PROFILE  nRet;
	nRet =  UICC_hw_profile();
	return   *((T_ZDrvUicc_HwProfile *)&nRet);

}

T_ZDrvUicc_SetInOutCallBack  zDrvUicc_SetInOutCallBack( VOID (*inout_call_back)(T_ZDrvUicc_CardAction card_action, T_ZDrvUicc_CardSelector card_selector))
{
	T_UICC_SET_INOUT_CALLBACK  nRet;
	nRet =  UICC_set_inout_callback(inout_call_back);
	return   (T_ZDrvUicc_SetInOutCallBack)nRet;
}

T_ZDrvUicc_SetInOutCallBack  zDrvUicc_UninstallInOutCallBack(VOID)
{
	T_UICC_SET_INOUT_CALLBACK  nRet;
	nRet =  UICC_uninstall_inout_callback();
	return   (T_ZDrvUicc_SetInOutCallBack)nRet;
}

UINT8 zDrvUicc_GetAtr(T_ZDrvUicc_CardSelector card_selector, UINT8 *atr)
{
	ubyte nRet = 0;
	
	if ((CLOUD_CARD == card_type_ctrl[card_selector]) || (SOFTSIM_CARD == card_type_ctrl[card_selector]))
	{
		ubyte abAtr[] = {0x3B,0x9F,0x94,0x80,0x1F,0xC7,0x80,0x31,0xE0,0x73,0xFE,0x21,0x13,0x57,0x86,0x8D,0x0B,0x86,0x98,0x6A,0x18,0x86,0xFF,0x10,0x94,0x7B,0x60};
 		if(atr == NULL)
	        {
	            return 0;
	        }		
		memcpy(atr, abAtr, sizeof(abAtr));	
		return sizeof(abAtr);
	}
	else if (VSIM_CARD == card_type_ctrl[card_selector])
	{
		nRet = Vsim_GetAtr((T_VSIM_CARD_SELECTOR)card_selector, (ubyte *)atr);
	}
/*	else if (SOFTSIM_CARD == card_type_ctrl[card_selector])
	{
		 zOss_Printf(SUBMDL_DD, PRINT_LEVEL_ABNORMAL, "[UICC%d]SOFTSIM_CARD zDrvUicc_GetAtr NOT SUPPORTED\n!",card_selector);	
		 return 0;
	} */
	else if (UICC_VSIM_AUTO == card_type_ctrl[card_selector])
	{
		if(Vsim_Flag == UICC_SIM_PLUGIN)
			nRet =  UICC_get_atr((ubyte *)atr);
		else
			nRet = Vsim_GetAtr((T_VSIM_CARD_SELECTOR)card_selector, (ubyte *)atr);
	}
	else 
	{
  		nRet =  UICC_get_atr((ubyte *)atr);
	}

  	return   (UINT8)nRet;

}

VOID zDrvUicc_Highisr(VOID)
{
	UICC_highisr();
}

