/*******************************************************************************
 * Copyright by ZTE Corporation.
 *
 * File Name:  uicc_agt_server.h
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       V1.0
 * Author:        yanhaijian
 * Date:          2016-8-25
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
********************************************************************************/
/****************************************************************************
*											   Include files
****************************************************************************/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/miscdevice.h>
#include <asm/uaccess.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <linux/string.h>
#include <linux/sysfs.h>
#include <linux/stat.h>
#include <linux/slab.h>
#include <linux/kobject.h>
#include <mach/iomap.h>
#include <linux/sched.h>  
#include <linux/proc_fs.h>  

#include <linux/soc/zte/rpm/rpmsg_sim.h>
#include "rpmsg_channel.h"

#include <linux/uicc_agt_client.h>
#include    "../infineonIp/uicc.h"
#include "drvs_uicc.h"
#include "drvs_pow.h"

MODULE_LICENSE("GPL");
MODULE_AUTHOR("YanHaiJian");

/****************************************************************************
* 	                                           Global Types
****************************************************************************/
t_uicc_apduheader UICC_apdu_header;
extern volatile unsigned char uiccPlugFlag;
extern unsigned char semaphore_created;
static ubyte vsimrpmsg_created = FALSE;
int UICCchannelOpen(unsigned int chid);
int UICCchannelClose(unsigned int chid);
int UICCTransdataFromRpmsg(unsigned int chid, const void *buffer, unsigned int length);

/****************************************************************************
*                                              Local Constants
****************************************************************************/	
T_UICC_TRANSPORT_APDU_REQ_MSG uicc_apdu_req_msg;
T_UICC_TRANSPORT_APDU_RSP_MSG uicc_apdu_resp_msg;

T_UICC_RESET_REQ_MSG uicc_reset_req_msg;
T_UICC_RESET_RSP_MSG uicc_reset_rsp_msg;

T_UICC_ATR_REQ_MSG uicc_atr_req_msg;
T_UICC_ATR_RSP_MSG uicc_atr_rsp_msg;

T_UICC_CLOSE_REQ_MSG uicc_close_req_msg;
T_UICC_CLOSE_RSP_MSG uicc_close_rsp_msg;

static unsigned char apdu_data[255];
static unsigned int VsimApduCnt = 0;

static VSIM_MSG_BUF uiccMsgBuf;

ZOSS_SEMAPHORE_ID VSIM_NETLINK_sem = NULL;/*NU_SEMAPHORE UICC_common_sem;*/

/****************************************************************************
*                                             Global Function Prototypes
****************************************************************************/
    
/****************************************************************************
*                                             Function 
****************************************************************************/     
static int s_msg_type = -1;  
 
void uicc_apdu_organization(T_VSIM_CARD_SELECTOR card_selector,
                      T_VSIM_COMMANDCASE  command_case,
                      bool                              extended_length,
                      t_uicc_apduheader        c_apdu,
                      unsigned char                             *apdu_data_ptr)
{
    char *psend = &uicc_apdu_req_msg;  
    struct vsimmsg msg; 
    int ret = 0; 

    if (c_apdu.lc > 255)
    {
        printk("VSIM_transport_APDU lc too long =%x\n", c_apdu.lc);
        c_apdu.lc = 255;
    }
		
	uicc_apdu_req_msg.card_selector	= card_selector;
	uicc_apdu_req_msg.command_case = command_case;
	memcpy(&uicc_apdu_req_msg.c_apdu, &c_apdu, sizeof(t_uicc_apduheader));
	if (c_apdu.lc !=0)
	{
	    	memcpy(&uicc_apdu_req_msg.data_req, apdu_data_ptr, c_apdu.lc);
	}

    msg.type = MSG_CMD_USIM_APDU;  
    msg.len = sizeof(T_UICC_TRANSPORT_APDU_REQ_MSG);  
    memcpy(msg.msg, psend, msg.len);  

	TransVsimdataToRpmsg(RP_MSG_UICC_VSIMAGT_CHANNEL, &msg, sizeof(T_UICC_TRANSPORT_APDU_REQ_MSG));

	printk("VSIM_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x, command_case=%x\n", \
		uicc_apdu_req_msg.c_apdu.cla, uicc_apdu_req_msg.c_apdu.ins,uicc_apdu_req_msg.c_apdu.lc,uicc_apdu_req_msg.c_apdu.le,uicc_apdu_req_msg.c_apdu.p1,uicc_apdu_req_msg.c_apdu.p2,uicc_apdu_req_msg.command_case);

	
	memset(&uicc_apdu_resp_msg, 0x00, sizeof(uicc_apdu_resp_msg));
	
	while(1)
	{
		zOss_GetSemaphore(VSIM_NETLINK_sem, ZOSS_WAIT_FOREVER);
		if(MSG_CMD_USIM_APDU == s_msg_type)
		{
			break;
		}	
	}

	memcpy(&uicc_apdu_resp_msg, uiccMsgBuf.aucDataBuf, uiccMsgBuf.usDataLen);
	
	printk("VSIM_transport_APDU cla=%x,ins=%x,lc=%x,le=%x,p1=%x,p2=%x,sw1=%x,sw2=%x\n", \
		uicc_apdu_req_msg.c_apdu.cla, uicc_apdu_req_msg.c_apdu.ins, uicc_apdu_req_msg.c_apdu.lc, uicc_apdu_resp_msg.r_apdu_ptr.luicc, uicc_apdu_req_msg.c_apdu.p1, uicc_apdu_req_msg.c_apdu.p2, uicc_apdu_resp_msg.r_apdu_ptr.sw1, uicc_apdu_resp_msg.r_apdu_ptr.sw2);

	memcpy(apdu_data, uiccMsgBuf.aucDataBuf, 255);
}

/*******************************************************************************
* Function:     zDrvUicc_TransportApdu
* Description: 
* Parameters: 
*   Input:    
*
*   Output   r_apdu_ptr  apdu_data_ptr
*
* Returns:  0:success
*
*
* Others: 
********************************************************************************/ 
T_VSIM_APDURESELT  Vsim_TransportApdu(T_VSIM_CARD_SELECTOR card_selector,
                      T_VSIM_COMMANDCASE  command_case,
                      int                              extended_length,
                      t_uicc_apduheader        c_apdu,
                      t_uicc_apdufooter        *r_apdu_ptr,
                      unsigned char                             *apdu_data_ptr)
{
    T_VSIM_APDURESELT   nRet;
#ifdef _USE_PSM
	zDrvPow_SetDevActive((UINT32)IDLE_FLAG_VSIM);
#endif
        
    UICC_obtain_semaphore(UICC_TRANSPORT_APDU_SEM);

	printk("------------VsimApduCnt=%d!--------------\n",VsimApduCnt);
	VsimApduCnt++;

	memcpy(&UICC_apdu_header, &c_apdu, sizeof(t_uicc_apduheader));
	
    uicc_apdu_organization(card_selector, command_case, extended_length, UICC_apdu_header, apdu_data_ptr);

	switch(uicc_apdu_resp_msg.r_apdu_ptr.sw1)
	{        
        case 0x61:          
		  UICC_apdu_header.cla = 0x00 | (UICC_apdu_header.cla & 0x03);
		  UICC_apdu_header.ins = 0xC0;
		  UICC_apdu_header.p1 = 0x0;
		  UICC_apdu_header.p2 = 0x0;
		  //UICC_apdu_header.le = (uicc_apdu_resp_msg.r_apdu_ptr.sw2 == 256) ? 0: uicc_apdu_resp_msg.r_apdu_ptr.sw2;
		  UICC_apdu_header.le = (unsigned short)(uicc_apdu_resp_msg.r_apdu_ptr.sw2); 
		  uicc_apdu_organization(card_selector, DRV_VSIM_CMD_CASE_2, extended_length, UICC_apdu_header, apdu_data_ptr);
          break;

        case 0x6C: /* Request to resend command using P3=xx */
          UICC_apdu_header.le = uicc_apdu_resp_msg.r_apdu_ptr.sw2;
          uicc_apdu_organization(card_selector, DRV_VSIM_CMD_CASE_2, extended_length, UICC_apdu_header, apdu_data_ptr);
          break;

        case 0x9F: /* Request to send GET RESPONSE using P3=xx */
        case 0x9E:
          if((uicc_apdu_resp_msg.r_apdu_ptr.sw2 < UICC_apdu_header.le) || (UICC_apdu_header.le == 0))
          {
            UICC_apdu_header.le = (uicc_apdu_resp_msg.r_apdu_ptr.sw2) ? 0: uicc_apdu_resp_msg.r_apdu_ptr.sw2;
          }
		  
		  UICC_apdu_header.cla = 0xA0 | (UICC_apdu_header.cla & 0x03);
		  UICC_apdu_header.ins = 0xC0;
		  UICC_apdu_header.p1 = 0x0;
		  UICC_apdu_header.p2 = 0x0;
		 // UICC_apdu_header.le = (uicc_apdu_resp_msg.r_apdu_ptr.sw2 == 256) ? 0: uicc_apdu_resp_msg.r_apdu_ptr.sw2;
		  UICC_apdu_header.le = (unsigned short)(uicc_apdu_resp_msg.r_apdu_ptr.sw2);	
          uicc_apdu_organization(card_selector, DRV_VSIM_CMD_CASE_2, extended_length, UICC_apdu_header, apdu_data_ptr);
          break;

        case 0x62: /* Warnings */                   
        case 0x63: /* Warnings */                           
          /* Remember the warning causes to be used when returning the response APDU. */
		  if(command_case != DRV_VSIM_CMD_CASE_4)
		  	break;
		  
		  UICC_apdu_header.cla = 0x00 | (UICC_apdu_header.cla & 0x03);
		  UICC_apdu_header.ins = 0xC0;
		  UICC_apdu_header.p1 = 0x0;
		  UICC_apdu_header.p2 = 0x0;
		  UICC_apdu_header.le = 0x0;
		  
		  uicc_apdu_organization(card_selector, DRV_VSIM_CMD_CASE_2, extended_length, UICC_apdu_header, apdu_data_ptr);		  
          break;

        default:
          break;
	}
    
    nRet = (T_VSIM_APDURESELT)uicc_apdu_resp_msg.func_resp;
    r_apdu_ptr->luicc = uicc_apdu_resp_msg.r_apdu_ptr.luicc;
    r_apdu_ptr->sw1 = uicc_apdu_resp_msg.r_apdu_ptr.sw1;
    r_apdu_ptr->sw2 = uicc_apdu_resp_msg.r_apdu_ptr.sw2;
        
    memcpy(apdu_data_ptr, (void *)uicc_apdu_resp_msg.data_rsp, r_apdu_ptr->luicc);
    UICC_release_semaphore(UICC_TRANSPORT_APDU_SEM);
#ifdef _USE_PSM
    zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif  
    
    return nRet;
}

/*******************************************************************************
* Function:     zDrvUicc_ResetCard
* Description:   usim resert
* Parameters: 
*   Input:    
*
*   Output   
*
* Returns:       0: success
*
*
* Others: 
********************************************************************************/ 
T_VSIM_RESETRESULT Vsim_ResetCard(T_VSIM_CARD_SELECTOR card_selector)
{
	T_VSIM_RESETRESULT reset_result = DRV_VSIM_ACTIVATION_FAILED;
    char *psend = &uicc_reset_req_msg;  
	
    struct vsimmsg msg; 
    int ret = 0;  
	if(vsimrpmsg_created == FALSE)
	{
		VSIM_NETLINK_sem = zOss_CreateSemaphore((CHAR *)"VSIM_NETLINK", 0);
		#ifndef _USE_TestHarness
		registerOpsCallback(RP_MSG_UICC_VSIMAGT_CHANNEL, UICCchannelOpen, UICCchannelClose, UICCTransdataFromRpmsg);
		#endif
		vsimrpmsg_created = TRUE;
	}
#ifdef _USE_PSM
	zDrvPow_SetDevActive((UINT32)IDLE_FLAG_VSIM);
#endif
	UINT32 status;
    UICC_obtain_semaphore(UICC_ACTIVATION_SEM);
	
	memset(&uicc_reset_req_msg, 0x00, sizeof(uicc_reset_req_msg));
	uicc_reset_req_msg.card_selector = card_selector;
	
    msg.type = MSG_CMD_USIM_RESET;  
    msg.len = sizeof(T_UICC_RESET_REQ_MSG);  
    memcpy(msg.msg, psend, msg.len); 
	
	ret = TransVsimdataToRpmsg(RP_MSG_UICC_VSIMAGT_CHANNEL, &msg, sizeof(T_UICC_RESET_REQ_MSG));
	if(ret < 0)
	{
#ifdef _USE_PSM
	zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif
		return DRV_VSIM_ACTIVATION_FAILED;
	}
	
	memset(&uicc_reset_rsp_msg, 0x1, sizeof(uicc_reset_rsp_msg));
	
	while(1)
	{
		zOss_GetSemaphore(VSIM_NETLINK_sem, ZOSS_WAIT_FOREVER);
		if(MSG_CMD_USIM_RESET == s_msg_type)
		{
			break;
		}	
	}

	memcpy(&uicc_reset_rsp_msg, uiccMsgBuf.aucDataBuf, uiccMsgBuf.usDataLen);
	printk("Vsim_ResetCard result: %d\n", (T_VSIM_RESETRESULT)uicc_reset_rsp_msg.func_resp);
    reset_result = (T_VSIM_RESETRESULT)uicc_reset_rsp_msg.func_resp;
  
	UICC_release_semaphore(UICC_ACTIVATION_SEM);
#ifdef _USE_PSM
	zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif
	return  reset_result;
}

/*******************************************************************************
* Function:     Vsim_Close
* Description:  
* Parameters: 
*   Input:    
*
*   Output   
*
* Returns:       
*
*
* Others: 
********************************************************************************/    
T_VSIM_CLOSERESULT Vsim_Close(T_VSIM_CARD_SELECTOR card_selector)
{	
	T_VSIM_CLOSERESULT close_result = DRV_VSIM_DEACTIVATION_FAILED;
	
    char *psend = &uicc_close_req_msg;  
    struct vsimmsg msg;  
    int ret = 0; 
#ifdef _USE_PSM
	zDrvPow_SetDevActive((UINT32)IDLE_FLAG_VSIM);
#endif
    UICC_obtain_semaphore(UICC_DEACTIVATION_SEM);

	memset(&uicc_close_req_msg, 0x00, sizeof(uicc_close_req_msg));
	uicc_close_req_msg.card_selector = card_selector;

    msg.type = MSG_CMD_USIM_CLOSE;  
    msg.len = sizeof(T_UICC_CLOSE_REQ_MSG);  
    memcpy(msg.msg, psend, msg.len); 
	
	ret = TransVsimdataToRpmsg(RP_MSG_UICC_VSIMAGT_CHANNEL, &msg, sizeof(T_UICC_CLOSE_REQ_MSG));
	
	if(ret < 0)
	{
#ifdef _USE_PSM
		zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif
		return DRV_VSIM_DEACTIVATION_FAILED;
	}
	memset(&uicc_close_rsp_msg, 0x0, sizeof(uicc_close_rsp_msg));

	while(1)
	{
		zOss_GetSemaphore(VSIM_NETLINK_sem, ZOSS_WAIT_FOREVER);
		if(MSG_CMD_USIM_CLOSE == s_msg_type)
		{
			break;
		}	
	}
	
	memcpy(&uicc_close_rsp_msg, uiccMsgBuf.aucDataBuf, uiccMsgBuf.usDataLen);
    
	close_result = (T_VSIM_CLOSERESULT)uicc_close_rsp_msg.func_resp;
          
    UICC_release_semaphore(UICC_DEACTIVATION_SEM);
#ifdef _USE_PSM
	zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif
    return close_result;
}
    
/*******************************************************************************
* Function:     Vsim_GetAtr
* Description:  
* Parameters: 
*   Input:    
*
*   Output    aatr
*
* Returns:      atr length
*
*
* Others: 
********************************************************************************/    
unsigned char Vsim_GetAtr(T_VSIM_CARD_SELECTOR card_selector, unsigned char *atr)
{    
    unsigned char atrLen;
    char *psend = &uicc_atr_req_msg;  
    struct vsimmsg msg;  
    int ret = 0; 
#ifdef _USE_PSM
	zDrvPow_SetDevActive((UINT32)IDLE_FLAG_VSIM);
#endif
	memset(&uicc_atr_req_msg, 0x00, sizeof(uicc_atr_req_msg));
	uicc_atr_req_msg.card_selector = card_selector;
	
    msg.type = MSG_CMD_USIM_GETATR;  
    msg.len = sizeof(T_UICC_ATR_REQ_MSG);  
    memcpy(msg.msg, psend, msg.len);  
	ret = TransVsimdataToRpmsg(RP_MSG_UICC_VSIMAGT_CHANNEL, &msg, sizeof(T_UICC_ATR_REQ_MSG));
	
	if(ret < 0)
	{
#ifdef _USE_PSM
    zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif
		return DRV_VSIM_ACTIVATION_FAILED;
	}

	memset(&uicc_atr_rsp_msg, 0x00, sizeof(uicc_atr_rsp_msg));
    
	while(1)
	{
		zOss_GetSemaphore(VSIM_NETLINK_sem, ZOSS_WAIT_FOREVER);
		if(MSG_CMD_USIM_GETATR == s_msg_type)
		{
			break;
		}	
	}

	memcpy(&uicc_atr_rsp_msg, uiccMsgBuf.aucDataBuf, uiccMsgBuf.usDataLen);

    atrLen = uicc_atr_rsp_msg.func_resp;

	memcpy(atr, uicc_atr_rsp_msg.atr_data, atrLen);
#ifdef _USE_PSM
	zDrvPow_SetDevIdle((UINT32)IDLE_FLAG_VSIM);
#endif
    return atrLen;
}

void vsim_Hisr(int arg)
{
	T_UICC_DETECT vsim_detect;
#if 0
	while(1)
	{
		while(1)
		{
			zOss_GetSemaphore(VSIM_NETLINK_sem, ZOSS_WAIT_FOREVER);
			if(MSG_CMD_USIM_DETECT == s_msg_type)
			{
				break;
			}	
		}

		switch(uiccMsgBuf.usMsgCmd)
		{
			case MSG_CMD_USIM_DETECT:

				vsim_detect = (T_UICC_DETECT)*uiccMsgBuf.aucDataBuf;
				
				if(vsim_detect == VSIM_REMOVE)
				{
					if(uiccPlugFlag == UICC_SIM_PLUGIN)
					{
						printk("vsim sim allready removed!");		
						zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "vsim sim allready removed! \n");
					}else{
						uicc_remove_isr();
						uicc_insert_isr();
						uiccPlugFlag = UICC_SIM_PLUGIN;
					}
				}else if(vsim_detect == VSIM_INSERT){
					if(uiccPlugFlag == UICC_SIM_PLUGOUT)
					{
						printk("vsim sim allready interted!");
						zOss_Printf(SUBMDL_FS, PRINT_LEVEL_ABNORMAL, "vsim sim allready interted!\n");
					}else{
						uicc_remove_isr();
						uiccPlugFlag = UICC_SIM_PLUGOUT;
					}			
				}
				break;

			default:
				break;
			
		}
	}
#endif
		
}

int TransVsimdataToRpmsg(unsigned int chid, const void *buffer, unsigned int length)
{
    #ifndef _USE_TestHarness
	rpmsg_recv_notify(chid, buffer, length);
	#endif
	return 0;
}

int UICCchannelOpen(unsigned int chid)
{
	//if(zAti2_Open(chid) != ZATI2_SUCCESS)
	{
		//printk("open channel failed!!!! %d !\n",chid);
	}
	printk("UICCchannelOpenl success %d !\n",chid);
	
	return 0;
}

int UICCchannelClose(unsigned int chid)
{
	printk("UICCchannelClose success %d !\n",chid);
	//ʵΪգATֶ֧̬ͨر
	return 0;

}

int UICCTransdataFromRpmsg(unsigned int chid, const void *buffer, unsigned int length)
{
	memcpy(&uiccMsgBuf, buffer, length);

	switch(uiccMsgBuf.usMsgCmd)	
	{  	
		case MSG_CMD_USIM_RESET: 
			s_msg_type = MSG_CMD_USIM_RESET;
			if (VSIM_NETLINK_sem != NULL)  
				zOss_PutSemaphore(VSIM_NETLINK_sem);			 
			break;	
		case MSG_CMD_USIM_GETATR:  
			s_msg_type = MSG_CMD_USIM_GETATR;
			if (VSIM_NETLINK_sem != NULL)  
				zOss_PutSemaphore(VSIM_NETLINK_sem);
			break;	
		case MSG_CMD_USIM_APDU: 
			s_msg_type = MSG_CMD_USIM_APDU;
			if (VSIM_NETLINK_sem != NULL)  
				zOss_PutSemaphore(VSIM_NETLINK_sem);
			break;	
		case MSG_CMD_USIM_CLOSE: 
			s_msg_type = MSG_CMD_USIM_CLOSE;
			if (VSIM_NETLINK_sem != NULL)  
				zOss_PutSemaphore(VSIM_NETLINK_sem);
			break; 
		case MSG_CMD_USIM_DETECT:  
			s_msg_type = MSG_CMD_USIM_DETECT;
			if (VSIM_NETLINK_sem != NULL)  
				zOss_PutSemaphore(VSIM_NETLINK_sem);
			break; 
	} 

	return 0;	
}

int Vsim_Initiate(void)
{	
    if(semaphore_created == FALSE)
    {
		UICC_create_semaphore(UICC_ACTIVATION_TAG);              
    }
	
	
	if(vsimrpmsg_created == FALSE)
	{
		VSIM_NETLINK_sem = zOss_CreateSemaphore((CHAR *)"VSIM_NETLINK", 0);
		#ifndef _USE_TestHarness
		registerOpsCallback(RP_MSG_UICC_VSIMAGT_CHANNEL, UICCchannelOpen, UICCchannelClose, UICCTransdataFromRpmsg);
		#endif
		vsimrpmsg_created = TRUE;
	}
	
    return 0;
}

