/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    hal_rtt.c
 * File Mark:    
 * Description:  
 * Others:        
 * Version:       1.0
 * Author:        wangxia
 * Date:          2010-4-29
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_timer.h"
#include "drvs_rtt.h"
extern void kill_proc(PROCESS id);


/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
static UINT32 common_user_id = 5;

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
 * Function: RTT_create_timer
 * Description: creat RTT timer
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
#ifdef RTT_DEBUG_INF
UINT32  RTT_debug[500][3];
UINT32  RTT_debug_count=0;
UINT32 g_timer_stop=0;
UINT32 g_timer_start=0;
#endif
 rtt_timer_list_type *RTT_create_timer(VOID (*timeout_func)(VOID ), 
		                             VOID *arg, 
		                             rtt_timer_user_id_enum user_id, 
					                       rtt_timer_mode_enum timer_mode)
{
     rtt_timer_list_type *timer = NULL;

     #ifdef RTT_DEBUG_INF
       zOss_Memset(RTT_debug,0,sizeof(UINT32)*1500);
     #endif
       
    zOss_ASSERT(timeout_func != NULL);
    timer = (rtt_timer_list_type *)malloc(sizeof(rtt_timer_list_type));     
    zOss_ASSERT(timer != NULL);
	
    if( user_id == rtt_common )
    {
       if( common_user_id > 14 )
        {
    	       free(timer);
		return NULL;
     	}
    	 common_user_id ++;
     	 timer->user_id = common_user_id;
     	 timer->hw_timer_id = 0;  /* system tick hardwaretimer */        
     }
    
    else  if( user_id  < 5 )
    {
        
        /* one shot: stop timer when count=0*/
         if( (timer_mode == rtt_one_shot) || (timer_mode == rtt_one_shot_timer_with_clock))
         {		  
           /*timer->process_id */timer->hw_timer_id = zDrvTimer_Create( (ZDRV_TIMER_CALLBACK)timeout_func,FALSE); 
              
         }
       /*repetitive: reload timer when count=0*/
         if( (timer_mode == rtt_repetitive) || (timer_mode == rtt_repetitive_timer_with_clock ))
         {
	       /*timer->process_id */timer->hw_timer_id = zDrvTimer_Create( (ZDRV_TIMER_CALLBACK)timeout_func,TRUE);
         }
         timer->user_id = user_id;
    }
   else if( user_id > 4 && user_id < 15 )   /* common user */
   	{ 

	 ;

     }
   else
    {


    }
   
     timer->timeout_func = timeout_func;
     timer->created = 1;
     timer->timer_mode = timer_mode;
     timer->started = 0;
     timer->duration = 0;
     timer->restart_duration = 0;
     
     return timer; 
}


/*******************************************************************************
 * Function: RTT_remove_timer
 * Description: remove RTT
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
 SINT32 RTT_remove_timer(rtt_timer_list_type *timer)
{
    if(!timer || !timer->created)
	{
	       zOss_ASSERT(FALSE);	 
	}      
	  if( timer->user_id > 4 && timer->user_id < 15 )   /* common user */ 
	  {
	  	  kill_proc(timer->process_id);
	  	  free(timer);
	  }
	  else if(timer->user_id < 5)   /* predefined user */
	  {   
            zDrvTimer_Release( timer->hw_timer_id );
	  	  free(timer);
	  }
	  else      /* ilegle user */
	  {
	    free(timer);
	  	return DRV_ERR_INVALID_PARAM;  
	  }
	  
    return DRV_SUCCESS;
}


/*******************************************************************************
 * Function: RTT_start_timer
 * Description: start RTT
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
SINT32 RTT_start_timer(rtt_timer_list_type *timer, UINT32 duration)
{
    #ifdef RTT_DEBUG_INF
        g_timer_start++;
    #endif

	if(duration == 0||timer == NULL|| !timer->created || timer->started)
	{
	  		zOss_ASSERT(FALSE);
	}
	   
   if( timer->user_id > 4 && timer->user_id < 15 )   /* common user */
   { 
     return DRV_ERR_INVALID_PARAM;
   }     
   else if(timer->user_id < 5)   /* predefined user */
   {
       if( (timer->timer_mode == rtt_one_shot) || (timer->timer_mode == rtt_one_shot_timer_with_clock))
       {
		  // return DRV_ERR_INVALID_PARAM;
       }
       if( (timer->timer_mode == rtt_repetitive) || (timer->timer_mode == rtt_repetitive_timer_with_clock ))
       {
		   //return DRV_ERR_INVALID_PARAM;
	}	 
       zDrvTimer_Start( timer->hw_timer_id, duration); /*&tTimerParam );*/
       timer->started = 1;
	   timer->duration = duration;
  }
  else           /* ilegal user */
  {
    zOss_ASSERT(FALSE);   
   }
 
#ifdef RTT_DEBUG_INF
RTT_debug[RTT_debug_count][0] = 20;  
RTT_debug[RTT_debug_count][1] = reg32(TIMER_ADD);
RTT_debug[RTT_debug_count][2] = reg32(TIMER_COUNT);
RTT_debug_count = (RTT_debug_count+1) % 500;
#endif

 return DRV_SUCCESS; /* TRUE */

}



/*******************************************************************************
 * Function: RTT_stop_timer
 * Description: stop RTT
 * Parameters: 
 *   Input:
 *
 *   Output:
 *
 * Returns: 
 *
 *
 * Others: 
 ********************************************************************************/
 SINT32 RTT_stop_timer(volatile rtt_timer_list_type * volatile timer)
{

    #ifdef RTT_DEBUG_INF
    g_timer_stop++;
    #endif 
	if(timer == NULL|| !timer->created)
	{
		zOss_ASSERT(FALSE);
		return DRV_ERR_INVALID_PARAM;
	}
    
   // zOss_ASSERT((timer->created !=0)||(timer->started != 0));
	
    if( timer->user_id > 4 && timer->user_id < 15 )  /* common user */
    {
     return DRV_ERR_INVALID_PARAM;
    }
    else if(timer->user_id < 5)  /* predefined user */
    {
        zDrvTimer_StopTimer( timer->hw_timer_id );
              timer->started = 0;
              timer->duration = 0;
    }
    else /* ilegal user */
    {      
      zOss_ASSERT(FALSE);
    }	

	
#ifdef RTT_DEBUG_INF
RTT_debug[RTT_debug_count][0] = 21;  
RTT_debug[RTT_debug_count][1] = reg32(TIMER_ADD);
RTT_debug[RTT_debug_count][2] = 0;
RTT_debug_count = (RTT_debug_count+1) % 500;
#endif

 return DRV_SUCCESS;  /* TRUE */
}

/*rtt test*/
#if 1
rtt_timer_list_type* RTT_timer = NULL;
#else
SINT32 RTT_timer=0;
#endif
UINT32 gRttCnt = 0;

VOID RTT_timeout_callback(VOID)
{
   gRttCnt++;

   RTT_stop_timer(RTT_timer);

   RTT_start_timer(RTT_timer, 2500);
}

VOID RTT_TEST(SINT32 arg)
{

    #if 1
    RTT_timer = RTT_create_timer (RTT_timeout_callback, 
                                   0,
                                   rtt_uicc,
                                   rtt_one_shot);

	RTT_start_timer(RTT_timer, 2500);
    #else
       RTT_timer = zDrvTimer_Create (RTT_timeout_callback, 1);

	//RTT_start_timer(RTT_timer, 25000);
	zDrvTimer_Start( RTT_timer, 1000);
   #endif

}
