/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    uicc_ctrl.h
 * File Mark:    
 * Description:  This header file contains extern declarations related to the Main Control statemachine of the Universal Chip Card Interface (UICC).
 * Others:        
 * Version:       v1.0
 * Author:        mtr
 * Date:          2007-03-28
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/

 
#ifndef _UICC_CTRL_H
#define _UICC_CTRL_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "oss_api.h"
#include "drvs_uicc.h"
#include "uicc.h"

/****************************************************************************
* 	                                        Macros
****************************************************************************/
#ifdef DWD_MODULE_TEST_SIM
  #define UICC_MODULE_TEST
#endif

#if defined (SGOLD3)
#if 0 /*11.1 رfifo only ģʽDMA */
  #define UICC_FIFO_ONLY
#endif
  #define UICC_FIFO_MODE /* For SGOLD3,  if define use FIFO mode, otherwise LEGACY mode*/
  #define UICC_ALFEEN_ENABLE
#endif

/* Low level trace mechanisms can be enabled via the following local compile definitions. Should NOT be 
   enable in a released system. */

/*============================*/
/* FUNCTIONAL PROFILE DEFINES */
/*============================*/
/*============================*/
#define UICC_MIN_CLOCK_FREQ                0x21 /* Clock frequency support control. 21h = 33d */
#define UICC_MAX_CLOCK_FREQ                0x21 /* which is the exuivalent of 3.3MHz. */

#define UICC_HIGHSPEED_SUPPORTED           TRUE  /* Highspeed support control. */
#define UICC_MAX_BIT_RATE                  101563L /* The max bit rate allowed on the I/O line. */



#define UICC_T_1_SUPPORTED               TRUE  /* T=1 protocol support control. */
#define UICC_52_MHZ                            /* Used - until the timer module is introduced - when calculating 
                                                    the core timer tick values. Currently does only the UMTS platform
                                                    utilise 52MHz. */  


#define UICC_Le_Lc_SUPPORTED               FALSE /* Extended Le/Lc support control. */
#define UICC_HW_CONTROLLED_T0
#define UICC_HW_CONTROLLED_T1
#define UICC_LOW_CLK_FREQ_SUPPORTED


//#define UICC_DEBUG_OK_PORT_TOGGLE    DEBUG_P0
//#define UICC_DEBUG_ERR_PORT_TOGGLE   DEBUG_P1
//#define UICC_DEBUG_IN_PORT_TOGGLE    DEBUG_P2
//#define UICC_DEBUG_DMA_PORT_TOGGLE   DEBUG_P2
//#define UICC_DEBUG_TIMER_PORT_TOGGLE DEBUG_P3


#if defined (SMPOWER3)
  #define UICC_MIN_SUPPORTED_VOLTAGE UICC_CLASS_C /* 1.8v */
  #define UICC_MAX_SUPPORTED_VOLTAGE UICC_CLASS_B /* 3v   */  

  #define CLASS_A_VOLTAGE       5000 /* 5v   */
  #define CLASS_A_MAX_CURRENT      0 /* NA   */ 
  #define CLASS_B_VOLTAGE       3000 /* 3v   */
  #define CLASS_B_MAX_CURRENT  60000 /* 70mA */
  #define CLASS_C_VOLTAGE       1800 /* 1.8v */
  #define CLASS_C_MAX_CURRENT  60000 /* 70mA */
  #define CLASS_D_VOLTAGE          0 /* TDB  */
  #define CLASS_D_MAX_CURRENT      0 /* TDB  */  
  #define CLASS_E_VOLTAGE          0 /* TDB  */
  #define CLASS_E_MAX_CURRENT      0 /* TDB  */
#else
  #define UICC_MIN_SUPPORTED_VOLTAGE UICC_CLASS_C /* 1.8v -> SM Power 1.5  */
  #define UICC_MAX_SUPPORTED_VOLTAGE UICC_CLASS_B /* 3v   */  

  #define CLASS_A_VOLTAGE       5000 /* 5v   */
  #define CLASS_A_MAX_CURRENT      0 /* NA   */ 
  #define CLASS_B_VOLTAGE       3000 /* 3v   */
  #define CLASS_B_MAX_CURRENT  20000 /* 20mA */
  #define CLASS_C_VOLTAGE       1800 /* 1.8v */
  #define CLASS_C_MAX_CURRENT  20000 /* 20mA */
  #define CLASS_D_VOLTAGE          0 /* TDB  */
  #define CLASS_D_MAX_CURRENT      0 /* TDB  */  
  #define CLASS_E_VOLTAGE          0 /* TDB  */
  #define CLASS_E_MAX_CURRENT      0 /* TDB  */
#endif

//#define USE_EEPROM_PARAMETERS  /*If not define then do not use the parameters from EEPROM, use the the default instead*/


/*============================*/
/*============================*/
/*====================================================================*/
#define UICC_SETBIT(A,B)    (A  |= 1 << (B))
#define UICC_RESETBIT(A,B)  (A  &= ~(1 << (B)))
#define UICC_TESTBIT(A,B)   ((A &  1 << (B)) >> (B))

#define UICC_UBYTE2ULONG(A,B,C,D) ((D<<24) | (C<<16) | (B<<8) | A)
#define UICC_USHORT2ULONG(A,B)    ((B<<16) | A)

#define UICC_CMD_HEADER_SIZE   5
#define UICC_MAX_PAYLOAD_SIZE  270

#define UICC_STD_TRACE_SIZE 280
#define UICC_TRACE_BUF_MAX UICC_STD_TRACE_SIZE
#define UICC_ATR_BUF_START  UICC_STD_TRACE_SIZE



#ifdef UICC_MODULE_TEST
  #define UICC_HW_RX_STORE_MAX 270
  #define UICC_HW_TX_STORE_MAX 270
#endif

/****************************************************************************
* 	                                        Types
****************************************************************************/
#ifdef UICC_ENABLE_IN_OUT_DETECTION
  typedef enum {
    ready,  
    debounce_check
  } uicc_card_presence_ctrl_state_type;
#endif
     
typedef enum /* UICC Main control states */
{
  UICC_MAIN_NONE,
  UICC_READY,
  UICC_CARD1_OPERATING,
  UICC_CARD2_OPERATING
} T_UICC_MAIN_CONTROL_STATE;


typedef enum /* UICC Card control states */
{
  UICC_CARD_NONE,
  UICC_INACTIVE,
  UICC_COLD_ACTIVATION,
  UICC_WARM_ACTIVATION,
  UICC_COLD_PPS_DETERMINATION,

  UICC_WARM_PPS_DETERMINATION,
  UICC_IDLE,
  UICC_BUSY,
  UICC_TESTMODE,
  UICC_CARD_IN_OUT_DETECTING
} T_UICC_CARD_CONTROL_STATE;

typedef enum
{
   UICC_OPERATE_CARD,
   UICC_OPERATION_ENDED
} T_UICC_MAIN_EVENT;


typedef enum /* UICC card control events */
{
  UICC_DUMMY_EVENT,
  
  /*----------------------------------------------------------------------*
   * Events from ATR engine                        
   *----------------------------------------------------------------------*/
  UICC_ATR_OK,                  /* ATR sequence succeeded.                */
  UICC_ATR_FAILED_NO_ANSWER,    /* No ATR characters received from card.  */
  UICC_ATR_FAILED,              /* One or more charatcers received but the*/
                                /* ATR sequence was somehow corrupted.    */
  /*----------------------------------------------------------------------*
   * Events from PPS engine                        
   *----------------------------------------------------------------------*/
  UICC_PPS_OK,                  /* PPS negotiation sequence succeeded.    */ 
  UICC_PPS_NOT_NEEDED,          /* No PPS negotiation sequence is needed. */
  UICC_PPS_NOT_COMPLETE,        /* No complete PPS response received.     */
  UICC_PPS_FAILED,              /* PPS evaluation failed.                 */  
  UICC_PPS_INITIATE_WARM_RESET, /* PPS response dictates warm reset.      */
      
  /*----------------------------------------------------------------------*
   * Events from Transport Handler Statemachine                        
   *----------------------------------------------------------------------*/
  UICC_INSTRUCTION_SUCCEEDED,
  UICC_INSTRUCTION_FAILED,  

  /*----------------------------------------------------------------------*
   * Events originated from host/client      
   *----------------------------------------------------------------------*/
  UICC_INSTRUCTION_REQUESTED,  
  UICC_COLD_RESET_REQUESTED,
  UICC_WARM_RESET_REQUESTED,
  UICC_DEACTIVATION_REQUESTED,

  /*----------------------------------------------------------------------*
   * Events originating from production test handler.                   
   *----------------------------------------------------------------------*/
  UICC_TESTMODE_REQUESTED,     

  /*----------------------------------------------------------------------*
   * Events from in out detection                        
   *----------------------------------------------------------------------*/
  UICC_CARD_INSERTED,
  UICC_CARD_REMOVED
} T_UICC_CARD_CTRL_EVENT;

typedef enum /* UICC interrupt events */
{
  /* 0x00  (0) */  UICC_DUMMY_INT_EVENT,
  /* 0x01  (1) */  UICC_TIMER_EXPIRED,          
  /* 0x02  (2) */  UICC_GUARD_TIMER_EXPIRED,
  /* 0x03  (3) */  UICC_CHARACTER_OK,
  /* 0x04  (4) */  UICC_T0_END,
  /* 0x05  (5) */  UICC_T1_END,
  /* 0x06  (6) */  UICC_DMA_END,
  /* 0x07  (7) */  UICC_PARITY_ERROR,
  /* 0x08  (8) */  UICC_OVERRUN_ERROR,
  /* 0x09  (9) */  UICC_CARD_IN,
  /* 0x0A (10) */  UICC_CARD_OUT,
  /* 0x0B (11) */  UICC_CHTIMEOUT,
  /* 0x0C (12) */  UICC_T1_PARITY_ERROR,
  /* 0x0D (13) */  UICC_T1_BWT_EXPIRED,
  /* 0x0E (14) */  UICC_UNKNOWN_INT,
  /* 0x0F (15) */  UICC_FIFO_INT,
  /* 0x10 (16) */  UICC_RX_LSREQ,  
  /* 0x11 (17) */  UICC_TX_LSREQ,  
  /* 0x12 (18) */  UICC_RX_SREQ,  
  /* 0x13 (19) */  UICC_TX_SREQ,    
  /* 0x14 (20) */  UICC_RX_LBREQ,  
  /* 0x15 (21) */  UICC_TX_LBREQ,  
  /* 0x16 (22) */  UICC_RX_BREQ,  
  /* 0x17 (23) */  UICC_TX_BREQ,  
  /* 0x18 (24) */  UICC_TXF_OFL_IRQ,  
  /* 0x19 (25) */  UICC_RXF_UFL_IRQ,
  /* 0x1A (26) */ UICC_FIFO_UNKNOWN_INT,
  /* 0x1B (27) */  UICC_LAST_INT_EVENT
} T_UICC_INT_EVENTS;


typedef struct {
  T_UICC_COMMAND_CASE  command_case;
  BOOL                 extended_length;
  T_UICC_APDU_HEADER   header;
  T_UICC_APDU_FOOTER   footer;  
  ubyte                *payload_ptr;
} T_UICC_APDU;

typedef struct 
{
  bb_ver_enum  version; 
  bb_rev_enum  revision;
} T_UICC_BASEBAND_PROFILE;

enum
{
  NOT_ACTIVATE,
  AWAIT_BUF_FULL,
  BUF_FULL
};

#ifdef UICC_MODULE_TEST
  enum
  {
    UICC_MODULE_TEST_ENABLED = 1,
    UICC_MODULE_TEST_DISABLED,
    UICC_MODULE_TEST_HW_DECOUPLED    
  };
  typedef ushort T_UICC_MODULE_TEST_STATE; 

  enum
  {
    REG_ID_ALL_REG,
    REG_ID_SIM_CTRL,
    REG_ID_SIM_BRF,
    REG_ID_SIM_STATUS,
    REG_ID_SIM_IRQEN,
    REG_ID_SIM_RXSPC,
    REG_ID_SIM_TXSPC,
    REG_ID_SIM_CHTIMER,
    REG_ID_SIM_CTRL2,
    REG_ID_SIM_T1CTRL,

    REG_ID_SIM_BWT,
    REG_ID_SIM_TX,
    REG_ID_SIM_RX,
    REG_ID_SIM_INS,
    REG_ID_SIM_P3,
    REG_ID_SIM_SW1_SW2,
    REG_ID_SIM_IMSC,
    REG_ID_SIM_RIS,
    REG_ID_SIM_MIS,

    REG_ID_SIM_ICR,
    REG_ID_SIM_ISR,    
    REG_ID_SIM_DMA,
    REG_ID_SIM_DMA_CNT,
    REG_ID_TIMER_VALUE,
    REG_ID_VOLTAGE_CTRL,
    REG_ID_SIM_FIFO_TXD,
    REG_ID_SIM_FIFO_RXD
  };

  enum
  {
    INT_ID_SIMOK_LISR=1,
    INT_ID_SIMERR_LISR,
    INT_ID_SIMINOUT_LISR,
    INT_ID_DMA_LISR,
    INT_ID_TIMER_LISR,
    INT_ID_SIMFIFO_LISR
  };

  enum
  {
    APDU_RESULT,
    ACTIVATION_RESULT,
    DEACTIVATION_RESULT
  };

  typedef struct
  {
    ulong  _SIM_CTRL;
    ulong  _SIM_BRF;
    ulong  _SIM_STATUS;
    ulong  _SIM_IRQEN;
    ulong  _SIM_RXSPC;
    ulong  _SIM_TXSPC;
    ulong  _SIM_CHTIMER;
    ulong  _SIM_CTRL2;
    ulong  _SIM_T1CTRL;
    ulong  _SIM_BWT;

    ulong  _SIM_TX;
    ulong  _SIM_RX;
    ulong  _SIM_INS;
    ulong  _SIM_P3;
    ulong  _SIM_SW1_SW2;
    ulong  _SIM_IMSC;
    ulong  _SIM_RIS;
    ulong  _SIM_MIS;
    ulong  _SIM_ICR;
    ulong  _SIM_ISR;    

    ulong  _SIM_DMA;
    ulong  _SIM_DMA_CNT;
    ulong  _TIMER_VALUE;
    ulong  _VOLTAGE_CTRL;
    ulong  _SIM_FIFO_MIS;
    ubyte _SIM_FIFO_TXD[16];  /*16 byte for using with BREQ & LBREG*/
    ubyte _SIM_FIFO_RXD[16];  /*16 byte for using with BREQ & LBREG*/    
  } T_UICC_SIMULATED_HW_REG;

  typedef struct {
    struct {
      ubyte  invoked;
      ushort cause;
    } status;
    struct {
      ubyte  invoked;
      ushort size;
      ubyte  sw1;
      ubyte  sw2;
      //ubyte data[255];
    } response;
  } T_UICC_SIMULATED_SIGNAL;        

  typedef struct {
    ubyte activation_result_invoked;
    ubyte apdu_result_invoked;
    ubyte deactivation_result_invoked;    
  } T_UICC_SIMULATED_FUNCTION;
     
#endif

#ifdef UICC_MONITOR_ICCID
  typedef enum {
    CMD_REQ,
    CMD_RESP
  } T_CMD_ACTION;

  extern void UICC_monitor_iccid(T_CMD_ACTION event);
#endif

typedef struct {
  ubyte state;
  ubyte event;
} T_STATE_EVENT_TRACK;


#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
  typedef enum{
    uicc_simul_inactive,
    uicc_simul_active
  } uicc_simul_state_type;
#endif

#ifdef UICC_ENABLE_IN_OUT_DETECTION
  typedef enum{
    UICC_NOT_EXECUTING,
    UICC_EXECUTING
  } T_UICC_EXECUTING;
#endif


/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/
extern ushort tracebuf_cnt;
extern T_UICC_MAIN_CONTROL_STATE UICC_main_ctrl_state;
extern T_UICC_CARD_CONTROL_STATE UICC_card_ctrl_state[];
extern T_UICC_BASEBAND_PROFILE   UICC_baseband_profile;

extern T_UICC_CARD_SELECTOR      UICC_current_reader;
extern T_UICC_APDU               UICC_apdu;

//extern NU_SEMAPHORE UICC_common_sem;
//extern ZOSS_SEMAPHORE_ID UICC_common_sem;
extern ZOSS_SEMAPHORE_ID   UICC_in_out_sem;

//extern NU_SEMAPHORE UICC_transport_apdu_sem;
//extern NU_SEMAPHORE UICC_activation_sem;
//extern NU_SEMAPHORE UICC_deactivation_sem;

extern ubyte UICC_transport_apdu_result;
extern ubyte UICC_activation_result;
extern ubyte UICC_deactivation_result;

extern ubyte UICC_power_down_allowed_flag;
extern ubyte UICC_nof_pps_attempt;

#ifdef UICC_IT3_27_12_1_PATCH
  extern ubyte UICC_authentication_cmd_executing;
#endif

#ifdef UICC_ENABLE_IN_OUT_DETECTION
  extern T_UICC_EXECUTING UICC_executing;
#endif

extern T_UICC_CARD_CONTROL_STATE UICC_testmode_state;

#if (defined(ENABLE_RUNTIME_SIM_SIMULATION) || defined(ENABLE_RUNTIME_UICC_SIMULATION))
  extern uicc_simul_state_type UICC_simul_state;
#endif

#ifdef UICC_MODULE_TEST
  extern T_UICC_SIMULATED_SIGNAL    UICC_simulated_signal;
  extern T_UICC_SIMULATED_HW_REG    UICC_simulated_hw_reg;
  extern T_UICC_MODULE_TEST_STATE   UICC_module_test_state;
  extern T_UICC_SIMULATED_FUNCTION  UICC_simulated_function;       
  extern ubyte UICC_hw_rx_store[];
  extern ubyte UICC_hw_tx_store[];
#endif

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/
extern void UICC_release_semaphore(ZOSS_SEMAPHORE_ID semaphore);
extern T_UICC_VOLTAGE_CLASS UICC_lower_supported_voltage_level(void);
extern T_UICC_VOLTAGE_CLASS UICC_higher_supported_voltage_level(void);
extern BOOL UICC_another_voltage_level_available(T_UICC_VOLTAGE_CLASS *used_voltage);

extern ubyte UICC_main_control(T_UICC_MAIN_EVENT event, T_UICC_CARD_SELECTOR card_selector);
extern void UICC_card_ctrl(T_UICC_CARD_CTRL_EVENT event);

extern void UICC_control_card_access(T_UICC_INT_EVENTS event);
extern void UICC_no_card_access(T_UICC_INT_EVENTS event);

extern void UICC_validate_state(void);
extern void UICC_stop_clock_conditional(T_UICC_CLOCK_STOP_MODE clock_stop_mode, 
                                        T_UICC_CARD_SELECTOR   current_reader);
extern ulong UICC_usec2etu(ulong usec);
extern ulong UICC_etu2usec(ulong etu);

#if defined (UICC_FIFO_MODE)
  extern void UICC_init_fifo(void);
#endif

#if defined(UICC_ENABLE_IN_OUT_DETECTION)
  extern void UICC_activate_inout_HISR(T_UICC_CARD_ACTION card_action);
#endif

void UICC_ISR_Process(void);
#endif /* _UICC_CTRL_H */
                                                 /* End of file.              */
