/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    uicc_msg_trace.h
 * File Mark:    
 * Description:  This header file MSG trace declarations.
 * Others:        
 * Version:       v1.0
 * Author:        mtr
 * Date:          2006-05-30
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ******************************************************************************/
  
#ifndef _UICC_MSG_TRACE_H
#define _UICC_MSG_TRACE_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_uicc.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
typedef struct
{  
  T_UICC_CARD_SELECTOR Card_Selector;
  T_UICC_COMMAND_CASE  Command_Case;
  T_UICC_APDU_HEADER   APDU_Header;
} Mon_Msg_Def_SI_UICC_TRANSFER_APDU;

typedef struct
{  
  T_UICC_APDU_RESULT Result;
  T_UICC_APDU_FOOTER APDU_Footer;
} Mon_Msg_Def_SI_UICC_RESPONSE_APDU;

typedef struct
{  
  T_UICC_CARD_SELECTOR     Card_Selector;
  T_UICC_RESET_MODE        Reset_Mode;
  T_UICC_VOLTAGE_CLASS     Activation_Voltage;
  T_UICC_BASEBAND_PROFILE  Baseband_Profile;
  T_UICC_PROTOCOL_MODE     Protocol_Mode;  /*add 071219*/      
} Mon_Msg_Def_SI_UICC_RESET_REQ;

typedef struct
{  
  T_UICC_RESET_RESULT    Reset_Result;
  T_UICC_VOLTAGE_CONTROL Voltage_Control;
  T_UICC_CHARACTERISTICS Characteristics;
  T_UICC_PROFILE_PARAMETER UICC_profile_parameter;
  ushort define_log;
  ubyte Nof_ATR_Characters;
  ubyte Nof_PPS_data;
} Mon_Msg_Def_SI_UICC_RESET_RSP;

typedef struct
{  
  T_UICC_CARD_SELECTOR   Card_Selector;
} Mon_Msg_Def_SI_UICC_CLOSE;

typedef struct
{  
  T_UICC_CARD_SELECTOR   Card_Selector;
  T_UICC_CLOCK_STOP_MODE Clock_Stop_Mode;
  ubyte                  Min_Clock_Freq;
} Mon_Msg_Def_SI_UICC_CARD_CHARACTERISTICS;

typedef struct
{  
  T_UICC_HW_PROFILE Profile;
} Mon_Msg_Def_SI_UICC_HW_PROFILE ;

typedef struct
{
  ubyte T1_link_ctrl_state;
  ubyte NAD;
  ubyte PCB;
  ubyte LEN;
  ubyte inf[5];
  ubyte EDC;
} SI_UICC_T1_TX_DATA_PROCESS ;

typedef struct
{
  ubyte T1_link_ctrl_state;
  ubyte event;
  ubyte NAD;
  ubyte PCB;
  ubyte LEN;
  ubyte inf_end_minus_1;
  ubyte inf_end;
  ubyte EDC;
} SI_UICC_T1_RX_DATA_PROCESS ;

typedef struct
{
  SI_UICC_T1_TX_DATA_PROCESS T1_tx_data;
  SI_UICC_T1_RX_DATA_PROCESS T1_rx_data;
} Mon_Msg_Def_SI_UICC_T1_DATA_PROCESS ;

typedef struct
{
  ubyte T0_trans_ctrl_state;
  ubyte event;
  ubyte cla;
  ubyte ins;
  ubyte p1;
  ubyte p2;
  ubyte p3;
  ubyte SW1;
  ubyte SW2;
} Mon_Msg_Def_SI_UICC_T0_DATA_PROCESS ;

typedef struct
{
  T_UICC_SET_INOUT_CALLBACK  CallBack_result;
  ulong                      CallBack_pointer;
} Mon_Msg_Def_SI_UICC_REGISTER_CALLBACK;

typedef struct
{
  T_UICC_CARD_ACTION   card_event;
  T_UICC_CARD_SELECTOR card_selector;
} Mon_Msg_Def_SI_UICC_CALLBACK_EVENT;

/****************************************************************************
 *                                           Constants
 ****************************************************************************/
                     
/****************************************************************************
 *                                           Global  Variables
 ****************************************************************************/

/****************************************************************************
*                                           Function Prototypes
****************************************************************************/


#endif /* _UICC_MSG_TRACE_H */ 
                                                     /* End of file.              */
