/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  This source file contains the T=0 transport handler statemachine engine. 
 * Others:        
 * Version:       v0.1
 * Author:        mtr
 * Date:          2005-06-13
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/


/****************************************************************************
*                                              Include files
****************************************************************************/
#include "uicc_stub.h"
#include "uicc.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_drv.h"
#include "uicc_trc.h"

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/
#ifdef T1_TRANS_HANDLER_TRACE
  #define T1_TRANS_TRACK_SIZE 100
#endif 

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/
#ifndef UICC_NO_DEBUG
      static T_UICC_T1_TRANS_CTRL_STATE debug = UICC_T1_TRANS_NONE;
#endif

/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
T_UICC_T1_TRANS_CTRL_STATE UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;

ubyte  apdu_mirror[256];

#ifdef T1_TRANS_HANDLER_TRACE
  struct {
    ubyte state;
    ubyte event;
  } t1_trans_track[T1_TRANS_TRACK_SIZE];

  ubyte t1_trans_track_cnt = 0;
#endif

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
* Function:... UICC_reset_t1_transport_handler
* Parameters:. None.
* Returns:.... Reset the Transport handler statemachine.
* Description: 
* Created:.... 20.09.02 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_reset_t1_transport_handler(void)
{
  UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;

  /* Initialise the data link handler. */
  UICC_reset_t1_data_link_handler();
}

/*******************************************************************************
* Function:... UICC_t1_transport_handler
* Parameters:. None.
* Returns:.... 
* Description: The T=1 Transport handler statemachine.
* Created:.... 20.09.02 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_t1_transport_handler(T_UICC_T1_TRANS_EVENTS event)
{
  #ifdef T1_TRANS_HANDLER_TRACE
    t1_trans_track[t1_trans_track_cnt].event = event;
    t1_trans_track[t1_trans_track_cnt].state = UICC_t1_trans_ctrl_state;
    if(++t1_trans_track_cnt >= T1_TRANS_TRACK_SIZE)
      t1_trans_track_cnt = 0;  
  #endif

  switch(UICC_t1_trans_ctrl_state)
  {
    /*=================================================*/
    /* Inactive - ready to receive instruction request */
    /*=================================================*/
    case UICC_T1_TRANS_READY:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T1_INITIATE_INS:
        /*----------------------------*/
          /* Initialise response data. */ 
          UICC_apdu.footer.luicc = 0;
          UICC_apdu.footer.sw1   = 0x33;
          UICC_apdu.footer.sw2   = 0x44;

          memcpy(&apdu_mirror[0], UICC_apdu.payload_ptr, UICC_apdu.header.lc);
          UICC_t1_tpdu_ctrl.org_tx_payload_ptr      = UICC_t1_tpdu_ctrl.current_tx_payload_ptr 
                                                    = &apdu_mirror[0];

          UICC_t1_tpdu_ctrl.org_rx_payload_ptr      = UICC_t1_tpdu_ctrl.rx_payload_ptr         
                                                    = UICC_apdu.payload_ptr;
          UICC_t1_tpdu_ctrl.current_rx_payload_cnt  = 0;

          /* Initialize the required control data. */
          switch(UICC_apdu.command_case)
          {
            case UICC_CMD_CASE_1: /* No Tx not Rx */
            /*------------------*/
              UICC_t1_trans_ctrl_state = UICC_EXECUTING_CASE_1_CMD;
              /* The Tx length: CLA, INS, P1 & P2 */ 
              UICC_t1_tpdu_ctrl.max_tx_payload_size = 4;
              /* The Rx length: SW1 & SW2 */ 
              UICC_t1_tpdu_ctrl.max_rx_payload_size = 2;
              break;

            case UICC_CMD_CASE_2: /* Rx */
            /*------------------*/
              UICC_t1_trans_ctrl_state = UICC_EXECUTING_CASE_2_CMD;
              /* The Tx length: CLA, INS, P1, P2 & Le */ 
              UICC_t1_tpdu_ctrl.max_tx_payload_size = 5;
              /* The Rx length: data[Le], SW1 & SW2 */ 

              if(UICC_apdu.header.le)
              {        
                UICC_t1_tpdu_ctrl.max_rx_payload_size = UICC_apdu.header.le + 2;
              }
              else
              { /* Le is 0; give me what you got. */
                if((UICC_apdu.extended_length) && (UICC_Le_Lc_SUPPORTED))
                  UICC_t1_tpdu_ctrl.max_rx_payload_size = 0xFFFF /*+2*/;
                else  
                  UICC_t1_tpdu_ctrl.max_rx_payload_size = 255+2;
              } 
              break;

            case UICC_CMD_CASE_3: /* Tx */
            /*------------------*/
              UICC_t1_trans_ctrl_state = UICC_EXECUTING_CASE_3_CMD;
              /* The Tx length: CLA, INS, P1, P2, Lc & data[Lc] */ 
              UICC_t1_tpdu_ctrl.max_tx_payload_size = 5 + UICC_apdu.header.lc;
              /* The Rx length: SW1 & SW2 */ 
              UICC_t1_tpdu_ctrl.max_rx_payload_size = 2;
              break;
              
            case UICC_CMD_CASE_4: /* Tx and Rx */
            /*------------------*/              
              UICC_t1_trans_ctrl_state = UICC_EXECUTING_CASE_4_CMD;
              /* The Tx length: CLA, INS, P1, P2, Lc, data[Lc] & Le */ 
              UICC_t1_tpdu_ctrl.max_tx_payload_size = 5 + UICC_apdu.header.lc + 1;
              /* The Rx length: data[Le], SW1 & SW2 */ 
              if(UICC_apdu.header.le)
              {        
                UICC_t1_tpdu_ctrl.max_rx_payload_size = UICC_apdu.header.le + 2;
              }
              else
              { /* Le is 0; give me what you got. */
                if((UICC_apdu.extended_length) && (UICC_Le_Lc_SUPPORTED))
                  UICC_t1_tpdu_ctrl.max_rx_payload_size = 0xFFFF /*+2*/;
                else  
                  UICC_t1_tpdu_ctrl.max_rx_payload_size = 255+2;
              } 

              break;
          }   
          UICC_t1_tpdu_ctrl.remaining_tx_payload_cnt = UICC_t1_tpdu_ctrl.max_tx_payload_size;
          UICC_t1_data_link_handler(UICC_INITIATE_LINK);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t1_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=================================================*/
    /*                                                 */
    /*=================================================*/
    case UICC_EXECUTING_CASE_1_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T1_CMD_SUCCEEDED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_SUCCEEDED);
          break;

        /*----------------------------*/
        case UICC_T1_CMD_FAILED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t1_trans_ctrl_state;
          #endif
          break;
      }
      break;
      
    /*=================================================*/
    /*                                                 */
    /*=================================================*/
    case UICC_EXECUTING_CASE_2_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T1_CMD_SUCCEEDED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_SUCCEEDED);
          break;

        /*----------------------------*/
        case UICC_T1_CMD_FAILED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t1_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=================================================*/
    /*                                                 */
    /*=================================================*/
    case UICC_EXECUTING_CASE_3_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T1_CMD_SUCCEEDED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_SUCCEEDED);
          break;

        /*----------------------------*/
        case UICC_T1_CMD_FAILED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t1_trans_ctrl_state;
          #endif
          break;
      }
      break;

    /*=================================================*/
    /*                                                 */
    /*=================================================*/
    case UICC_EXECUTING_CASE_4_CMD:
      switch(event)
      {
        /*----------------------------*/
        case UICC_T1_CMD_SUCCEEDED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_SUCCEEDED);
          break;

        /*----------------------------*/
        case UICC_T1_CMD_FAILED:
        /*----------------------------*/
          UICC_t1_trans_ctrl_state = UICC_T1_TRANS_READY;
          UICC_card_ctrl(UICC_INSTRUCTION_FAILED);
          break;

        /*----------------------------*/
        default:
        /*----------------------------*/
          #ifndef UICC_NO_DEBUG
            debug = UICC_t1_trans_ctrl_state;
          #endif
          break;

      }
      break;

    /*----------------------------*/
    default:
    /*----------------------------*/
      #ifndef UICC_NO_DEBUG
        debug = UICC_t1_trans_ctrl_state;
      #endif
      break;
  }

  #ifndef UICC_NO_DEBUG
    if(debug != UICC_T1_TRANS_NONE)
    {
      UICC_log_data_ptr[0] = debug;
      UICC_log_data_ptr[1] = event;
      UICC_log_data_ptr[2] = UICC_current_reader;
      UICC_log_data_ptr[3] = 0xAA;
      UICC_raise_exception(TRAP_UICC_T1_TRANS, UICC_T1_TRANS_ERROR_1, 4); 
      debug = UICC_T1_TRANS_NONE;
    }
  #endif
}    
                                                 /* End of file.              */
