/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:    
 * File Mark:    
 * Description:  This source file contains the drivers to control the low level timer. 
 * Others:        
 * Version:       v0.1
 * Author:        knm
 * Date:          2007-01-12
 * History 1:      
 *     Date: 
 *     Version:
 *     Author: 
 *     Modification:  
 * History 2: 
  ********************************************************************************/


/****************************************************************************
*                                              Include files
****************************************************************************/
#include "uicc_stub.h"
#include "uicc.h"
#include "uicc_ctrl.h"
#include "uicc_access.h"
#include "uicc_drv.h"
    
    /*  ݽṹ뺯Ϊͬͷļ */ 
#ifndef _RTT_FUN_H_
#include "drvs_rtt.h" 			/* Real-time timers */
#endif 

/****************************************************************************
* 	                                           Local Macros
****************************************************************************/

/****************************************************************************
* 	                                           Local Types
****************************************************************************/

/****************************************************************************
* 	                                           Local Constants
****************************************************************************/

/****************************************************************************
* 	                                           Local Variables
****************************************************************************/
static ubyte guard_timer = FALSE;  /* Indicates if guard timer is running or not. */


/****************************************************************************
* 	                                          Global Constants
****************************************************************************/

/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
rtt_timer_list_type* UICC_timer = NULL;
#ifdef UICC_ENABLE_IN_OUT_DETECTION
      rtt_timer_list_type* UICC_in_out_timer = NULL;
#endif

/****************************************************************************
* 	                                          Global Function Prototypes
****************************************************************************/

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/

/*******************************************************************************
* Function:... UICC_init_timer
* Parameters:. None.
* Returns:.... None.
* Description: Initialize the timer used for cart communication
* Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_init_timer(void)
{
  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
      UICC_simulated_hw_reg._TIMER_VALUE = 0;
      return;
    }
  #endif

  if(UICC_timer == NULL)
    UICC_timer = RTT_create_timer (UICC_timeout_callback, 
                                   0,
                                   rtt_uicc,
                                   rtt_one_shot);

  #ifdef UICC_ENABLE_IN_OUT_DETECTION
    if(UICC_in_out_timer == NULL)
      UICC_in_out_timer = RTT_create_timer (UICC_in_out_timeout_callback, 
                                            0,
                                            rtt_uicc,
                                            rtt_one_shot);
  #endif
}


/*******************************************************************************
* Function:... UICC_stop_timer
* Parameters:. None.
* Returns:.... None.
* Description: A previously started timer is disabled and cannot expire. Has no
*              effect if no timer was previously started.
* Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_stop_timer(void)
{
  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
      UICC_simulated_hw_reg._TIMER_VALUE = 0;
      return;
    }
  #endif

  RTT_stop_timer(UICC_timer);
}

/*******************************************************************************
* Function:... UICC_start_timer
* Parameters:. microseconds: The timer value in u-seconds (smallest value is 10us).
* Returns:.... None.
* Description: Function for starting the UICC core timer.
* Created:.... 30.10.02 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_start_timer(ulong microseconds)
{
  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
      UICC_simulated_hw_reg._TIMER_VALUE = microseconds;
      guard_timer = FALSE;
      return;
    }
  #endif

  RTT_stop_timer(UICC_timer);
  guard_timer = FALSE;
  RTT_start_timer (UICC_timer, microseconds);
}

/*******************************************************************************
* Function:... UICC_start_guard_timer
* Parameters:. usec: timer duration in useconds (range 1-255).
* Returns:.... None.
* Description: Starts a short timer to ensure a minimum guard time between two
*              consequtive characters. A previously started timer (timer or
*              guard) will no longer be running.
* Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_start_guard_timer(ushort usec)
{

  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
      UICC_simulated_hw_reg._TIMER_VALUE = usec;
      guard_timer = TRUE;
      return;
    }
  #endif

  RTT_stop_timer(UICC_timer);
  guard_timer = TRUE;
  RTT_start_timer (UICC_timer, usec);
}

/*******************************************************************************
* Function:... UICC_force_timeout
* Parameters:. None.
* Returns:.... None.
* Description: Forces an immideately timer timeout. A previously started timer
*              (timer or guard) will no longer be running.
* Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_force_timeout(void)
{
  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
      UICC_simulated_hw_reg._TIMER_VALUE = 0;
      guard_timer = FALSE;
      return;
    }
  #endif

  RTT_stop_timer(UICC_timer);
  guard_timer = FALSE;
/*ɶʱʱ̫ʱᵼ쳣ж˳ǰѳʱʱжϱӳ˶ʱʱ  */
  RTT_start_timer (UICC_timer, 1000);/*RTT_start_timer (UICC_timer, 10);*/

#ifdef UICC_NOT_TIMER
		  UICC_control_card_access(UICC_TIMER_EXPIRED);
#endif

}

/*******************************************************************************
* Function:... UICC_timeout_callback
* Parameters:. None.
* Returns:.... None.
* Description: The running timer has expired (interrupt service routine).
* Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
/* ΪOSEtimerжϻصֻʽ:void func(void) ޸Ļصĺԭ */
void UICC_timeout_callback(void)
{
        
  #ifdef INTERRUPT_TRACE
    UICC_interrupt_trace[UICC_interrupt_cnt] = guard_timer | UICC_TIMER_INT;
    if(++UICC_interrupt_cnt >= UICC_INTERRUPT_CNT_SIZE)
      UICC_interrupt_cnt = 0;  
  #endif
  
  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
	  if(guard_timer)
	  { /* The expired timer was a guard timer. */
	    guard_timer = FALSE;
	    UICC_control_card_access(UICC_GUARD_TIMER_EXPIRED);
	  }
	  else
	  { /* The expired timer must then be a normal timeout. */
	    UICC_control_card_access(UICC_TIMER_EXPIRED);
	  }
      return;
    }
  #endif

  if(guard_timer)
  { /* The expired timer was a guard timer. */
    guard_timer = FALSE;
    UICC_control_card_access(UICC_GUARD_TIMER_EXPIRED);
  }
  else
  { /* The expired timer must then be a normal timeout. */
    UICC_control_card_access(UICC_TIMER_EXPIRED);
  }
}


#ifdef UICC_ENABLE_IN_OUT_DETECTION
  /*******************************************************************************
  * Function:... UICC_start_inout_timer
  * Parameters:. usec  timeout value [usec].
  * Returns:.... None.
  * Description: Starts the timer used in the In/Out detection handling.
  * Created:.... 07.12.06 by Knud Nymann Mortensen (KNM)
  * Modified:... DD.MM.YY by (Full name / initials)
  *                Modifications note.
  *******************************************************************************/
  void UICC_start_inout_timer(ulong usec)
  {
    #ifdef UICC_MODULE_TEST
      if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
      {
        UICC_simulated_hw_reg._TIMER_VALUE = usec;
        return;
      }
    #endif

    if(UICC_in_out_timer == NULL)
    { /* Timer not allocated. */
      /* Perform timeout callback to provent a hanging scenario. */
      //UICC_in_out_timeout_callback();        
    }
    else
    {
      RTT_stop_timer(UICC_in_out_timer);  
      RTT_start_timer(UICC_in_out_timer, usec);
    }

 }
#endif

#ifdef UICC_ENABLE_IN_OUT_DETECTION
/*******************************************************************************
* Function:... UICC_stop_inout_timer
* Parameters:. None.
* Returns:.... None.
* Description: Stop the In/Out timer.
* Created:.... 07.12.06 by Knud Nymann Mortensen (KNM)
* Modified:... DD.MM.YY by (Full name / initials)
*                Modifications note.
*******************************************************************************/
void UICC_stop_inout_timer(void)
{
  #ifdef UICC_MODULE_TEST
    if(UICC_module_test_state == UICC_MODULE_TEST_HW_DECOUPLED)
    {
      UICC_simulated_hw_reg._TIMER_VALUE = 0;
      return;
    }
  #endif

  if(UICC_in_out_timer != NULL)
  { /* Timer allocated - stop it. */
    RTT_stop_timer(UICC_in_out_timer);
  }
}
#endif

#ifdef UICC_ENABLE_IN_OUT_DETECTION
  /*******************************************************************************
  * Function:... UICC_in_out_timeout_callback
  * Parameters:. None.
  * Returns:.... None.
  * Description: The running timer has expired (interrupt service routine).
  * Created:.... 25.05.00 by Knud Nymann Mortensen (KNM)
  * Modified:... DD.MM.YY by (Full name / initials)
  *                Modifications note.
  *******************************************************************************/
/* ΪOSEtimerжϻصֻʽ:void func(void) ޸Ļصĺԭ */
void UICC_in_out_timeout_callback(void)
  {
      UICC_in_out_control(UICC_CARD_IN_OUT_TIMER_EXPIRED);
  }
#endif
                                                   /* End of file.              */
