/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:hal_qalloc.h
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        geanfeng
 * Date:          2013-09-25
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _HAL_QALLOC_H
#define _HAL_QALLOC_H


/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_list.h"
/****************************************************************************
* 	                                        Macros
****************************************************************************/

/****************************************************************************
* 	                                        Types
****************************************************************************/
/*
 *  General purpose special memory pool descriptor.
 */
typedef struct _T_Quick_Pool {
	struct list_head node;	/* node*/
	struct list_head chunks;	/* list of chunks in this pool */
	UINT32 count;
	UINT8* name;
}T_Quick_Pool;

/****************************************************************************
* 	                                        Constants
****************************************************************************/

/****************************************************************************
* 	                                        Global  Variables
****************************************************************************/

/****************************************************************************
* 	                                        Function Prototypes
****************************************************************************/

/**
 * QPool_Create - create a new special memory pool
*
 * Create a new special memory pool that can be used to manage special purpose
 * memory not managed by the regular kmalloc/kfree interface.
 */
T_Quick_Pool *QPool_Create(UINT8* name);

/**
 * QPool_AddVirt - add a new chunk of special memory to the pool
 * @pool: pool to add new memory chunk to
 * @virt: virtual starting address of memory chunk to add to pool
 * @phys: physical starting address of memory chunk to add to pool
 * @size: size in bytes of the memory chunk to add to pool
 *
 * Add a new chunk of special memory to the specified pool.
 *
 * Returns 0 on success or a -ve errno on failure.
 */
SINT32 QPool_AddVirt(T_Quick_Pool *pool,UINT32 virt, UINT32 size,
							UINT32 page_size, UINT32 max_alloc_order);

/**
 * QPool_Alloc - allocate special memory from the pool
 * @pool: pool to allocate from
 * @size: number of bytes to allocate from the pool
 * @debug_info: some debug info
 *
 * Allocate the requested number of bytes from the specified pool.
 * Uses a first-fit algorithm. 
 */
UINT32 QPool_Alloc(T_Quick_Pool *pool, UINT32 size, VOID *debug_info);

/**
 * QPool_Free - free allocated special memory back to the pool
 * @pool: pool to free to
 * @addr: starting address of memory to free back to pool
 * @size: size in bytes of memory to free
 *
 */
VOID QPool_Free(T_Quick_Pool *pool, UINT32 addr, VOID *debug_info);

/**
 * QPool_Destroy - destroy a special memory pool
 *
 * Destroy the specified special memory pool. Verifies that there are no
 * outstanding allocations.
 */
VOID QPool_Destroy(T_Quick_Pool *pool);

/**
 * gen_pool_avail - get available free space of the pool
 * @pool: pool to get available free space
 *
 * Return available free space of the specified pool.
 */
UINT32 QPool_Avail(T_Quick_Pool *pool);

/**
 * QPool_Size - get size in bytes of memory managed by the pool
 * @pool: pool to get size
 *
 * Return size in bytes of memory managed by the pool.
 */
UINT32 QPool_Size(T_Quick_Pool *pool);

/**
 * QPool_Print - print the pool debug info.
 * @pool: pool to print
 *
 */
VOID QPool_Print(T_Quick_Pool *pool);

/**
 * QPool_PrintAll - print the all pool debug info.
 *
 */
VOID QPool_PrintAll(VOID);

#endif/*_HAL_TCLK_REG_H*/

