/*******************************************************************************
* Copyright (C) 2013, ZTE Corporation.
*
* File Name:    debug_print.c
* File Mark:
* Description:
* Others:
* Version:		 V1.0
* Author:		 geanfeng
* Date: 		 2013-12-16
********************************************************************************/

/****************************************************************************
* 	                                           Include files
****************************************************************************/
#include "drvs_general.h"

/****************************************************************************
* 	                              		Local Macros
****************************************************************************/
#define DEBUG_PRINTF_MAX_LEN	224

/****************************************************************************
* 	                              		 Local Types
****************************************************************************/
/****************************************************************************
* 	                                          Global Variables
****************************************************************************/
/*10ֽڴindex,2ֽڴűǷ*/
static char s_debugPrintfBuf[DEBUG_PRINTF_MAX_LEN+1]=
    {
        0
    };

volatile T_DRV_DEBUG_PRINT_CHANNEL  g_debugPrintChnSel;
/****************************************************************************
* 	                                          macro Definitions
****************************************************************************/

extern SINT32 vsnformat(char *pcBuffer, UINT32 dwMaxCount, const char *pcParamFormat, va_list vaList);

/****************************************************************************
* 	                                          Function Definitions
****************************************************************************/
/*******************************************************************************
* Function:dcc_print
* Description:
* Parameters:
*       pFormat:
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
static void dcc_print(const  char * data, int size)
{
    int             len = 0;
    unsigned long   ch, k;

    while (len < size)
    {
        ch = data[len];

	/* Wait for Terminal Ready */
        do
        {
#ifdef __GNUC__
            asm(
                "mrc 14, 0, %0, c0, c1\n"
   		   : "=r" (k)
                 :
                 );
#endif

#ifdef  __ARMCC_VERSION
            __asm
            {
                MRC	p14, 0, k, c0, c1;
            }
#endif

        }
        while (k & (0x1<<29));

	/* Write */
	
#ifdef __GNUC__
        asm(
              "mrc 14, 0, %0, c0, c5\n"
    		:: "r" (ch)
        );
#endif

#ifdef  __ARMCC_VERSION
        __asm
        {
            MCR p14, 0, ch, c0, c5;
        }
#endif


        len++;
    }
}
/*******************************************************************************
* Function:zDrvDebug_Print
* Description:  logӡ
* Parameters:
*       pFormat:ʽַ
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 debug_Print(const VOID *pFormat, ... )
{
    va_list ap;
    UINT32 printfCnt;

    ZOSS_DISABLE_IRQ();

    if (g_debugPrintChnSel == DRV_DEBUG_PRINT_DCC)
    {

  	 dcc_print("\n\r", 2);
	 
        va_start(ap,pFormat);
        printfCnt=vsnformat(s_debugPrintfBuf, DEBUG_PRINTF_MAX_LEN, pFormat, ap);
        va_end(ap);

	 dcc_print(s_debugPrintfBuf, printfCnt);
    }
    else
    {
        zDrv_ASSERT(0);
    }

    ZOSS_ENABLE_IRQ();

    return DRV_SUCCESS;
}



