/*******************************************************************************
* Copyright (C) 2009, ZTE Corporation.
*
* File Name:    hal_ramlog.c
* File Mark:
* Description:
* Others:
* Version:		 V1.0
* Author:		 yuxiang
* Date: 		 2009-11-06
* History 1:
*	  Date:     2010-01-06
*	  Version:  V1.1
*	  Author:   yuxiang
*	  Modification:added ramlog record variable, be used for look up log buffer address when sys dead.
* History 2:
********************************************************************************/

/****************************************************************************
*											   Include files
****************************************************************************/
#include "drvs_general.h"
#include "drvs_ramlog.h"

#ifdef _USE_RAMLOG
/****************************************************************************
*											   Local Macros
****************************************************************************/
/*ӡΪ244, zOss_Printf󳤶Ϊ255*/
#define RAMLOG_PRINTF_MAX_LEN	224

/*ASCIISOH,ɼַ,Ϊָ*/
#define RAMLOG_LOG_SEP_FLAG 	'\1'

/*ASCIISTX,ɼַ,Ϊ*/
#define RAMLOG_LOG_END_FLAG 	'\2'

/*shell*/
#define RAMLOG_LOG_SHELL_CMD    "ramlog"

#define HAL_NML_TRACE(s...)    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_NORMAL, s)
#define HAL_ERR_TRACE(s...)    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_ABNORMAL, s)
#define HAL_LOG_TRACE(s...)    zOss_Printf(SUBMDL_HAL, PRINT_LEVEL_DEBUG, s)

#define RAMLOG_DEBUG 0

/****************************************************************************
*											   Local Types
****************************************************************************/
typedef struct _T_Ramlog_ModuleItem
{
    T_ZOss_Node node;
    UINT16  modNo;                      /*ӡģ*/
    volatile SINT32  curlogCnt;         /*LOG*/
    volatile SINT32  logBufAddrCnt;     /*LOGַ*/
    SINT32  logBufSize;                 /*LOGС*/
    BOOL    isLoopPrint;                /*Ƿѭӡ*/
    char    *pLogBuf;                   /*LOGָ*/
	UINT32  lossLogCnt;                 /*ʧLOGͳ*/
}
T_Ramlog_ModuleItem;

typedef struct _T_Ramlog_RamlogItem
{
    T_ZOss_List modList;
    volatile SINT32 gblcurLogCnt;
	BOOL isInPrint;
}
T_Ramlog_RamlogItem;

typedef struct _T_Ramlog_ModCfg
{
    UINT16  nModNo;         /*ӡģ*/
    char    *szShellCmd;    /*shell*/
    SINT32	nBufSize;       /*LOGС*/
    BOOL	bIsLoopPrint;   /*Ƿѭӡ*/
    BOOL	bIsReg;         /*Ƿע*/
}
T_Ramlog_ModCfg;

typedef struct _T_Ramlog_SortItem
{
    SINT32	sortGblLogIdx;
    char    *sortLogBuf;
    UINT16  sortModNo;
    SINT32  sortModLogIdx;
}
T_Ramlog_SortItem;

/*ӡģϢ¼, ҪΪģ, BufferʼַֹС*/
typedef struct _T_Ramlog_Record
{
    char*   rdModName;
    char*   rdBufPtrStart;
    char*   rdBufPtrEnd;
    UINT32  rdBufSize;
}
T_Ramlog_Record;

/****************************************************************************
*											   Local Constants
****************************************************************************/

/****************************************************************************
*											   Local Function Prototypes
****************************************************************************/
static SINT32 ramlog_RegModule(UINT16 nModNo, char* pShellCmd, UINT32 nBufSize, BOOL bIsLoop);
/* no used
static SINT32 ramlog_UnRegModule(UINT16 nModNo);
*/
static SINT32 ramlog_InsertSort(T_Ramlog_SortItem item[],UINT32 cnt);
static SINT32 ramlog_ShowLog2WinTrace(UINT16 modItem[], UINT32 nModCnt, BOOL bIsSort);

static SINT32 ramlog_ShowLog2WinTrace2(UINT16 modItem);
static VOID ramlog_ShellCmdEntry2(T_Shell_CommandMessage *CmdMsg);
VOID ramlog_ShellCmdEntry(T_Shell_CommandMessage *CmdMsg);

extern SINT32 vsnformat(char *pcBuffer, UINT32 dwMaxCount, const char *pcParamFormat, va_list vaList);
/****************************************************************************
*											  Global Constants
****************************************************************************/

/****************************************************************************
*											  Global Variables
****************************************************************************/
/*ӡģ*/
static T_Ramlog_RamlogItem	*s_pRamlogList	 = NULL;

/*ʼ*/
static BOOL s_ramlogInitFlag = FALSE;

/*ӡLOGWINTRACE*/
static volatile BOOL s_ramlogShowFlag = FALSE;


/*10ֽڴindex,2ֽڴűǷ*/
static char s_szPrintfBuf[RAMLOG_PRINTF_MAX_LEN+1]=
    {
        0
    };

/*дӡģʼб,Ӵӡģڴ*/
static T_Ramlog_ModCfg s_modCfgList[]=
    {
        {RAMLOG_MOD_NO1, RAMLOG_MOD_NO1_SHELL, RAMLOG_MOD_NO1_BUF_SIZE, RAMLOG_MOD_NO1_LOOP_ON, RAMLOG_MOD_NO1_REG},
        {RAMLOG_MOD_NO2, RAMLOG_MOD_NO2_SHELL, RAMLOG_MOD_NO2_BUF_SIZE, RAMLOG_MOD_NO2_LOOP_ON, RAMLOG_MOD_NO2_REG},
        {RAMLOG_MOD_NO3, RAMLOG_MOD_NO3_SHELL, RAMLOG_MOD_NO3_BUF_SIZE, RAMLOG_MOD_NO3_LOOP_ON, RAMLOG_MOD_NO3_REG},
        {RAMLOG_MOD_NO4, RAMLOG_MOD_NO4_SHELL, RAMLOG_MOD_NO4_BUF_SIZE, RAMLOG_MOD_NO4_LOOP_ON, RAMLOG_MOD_NO4_REG},
        {RAMLOG_MOD_NO5, RAMLOG_MOD_NO5_SHELL, RAMLOG_MOD_NO5_BUF_SIZE, RAMLOG_MOD_NO5_LOOP_ON, RAMLOG_MOD_NO5_REG},
        {RAMLOG_MOD_NO6, RAMLOG_MOD_NO6_SHELL, RAMLOG_MOD_NO6_BUF_SIZE, RAMLOG_MOD_NO6_LOOP_ON, RAMLOG_MOD_NO6_REG},
        {RAMLOG_MOD_NO7, RAMLOG_MOD_NO7_SHELL, RAMLOG_MOD_NO7_BUF_SIZE, RAMLOG_MOD_NO7_LOOP_ON, RAMLOG_MOD_NO7_REG},
        {RAMLOG_MOD_NO8, RAMLOG_MOD_NO8_SHELL, RAMLOG_MOD_NO8_BUF_SIZE, RAMLOG_MOD_NO8_LOOP_ON, RAMLOG_MOD_NO8_REG},
        {RAMLOG_MOD_NO9, RAMLOG_MOD_NO9_SHELL, RAMLOG_MOD_NO9_BUF_SIZE, RAMLOG_MOD_NO9_LOOP_ON, RAMLOG_MOD_NO9_REG},
        {RAMLOG_MOD_NO10, RAMLOG_MOD_NO10_SHELL, RAMLOG_MOD_NO10_BUF_SIZE, RAMLOG_MOD_NO10_LOOP_ON, RAMLOG_MOD_NO10_REG},
        {RAMLOG_MOD_NO11, RAMLOG_MOD_NO11_SHELL, RAMLOG_MOD_NO11_BUF_SIZE, RAMLOG_MOD_NO11_LOOP_ON, RAMLOG_MOD_NO11_REG},
        {RAMLOG_MOD_NO12, RAMLOG_MOD_NO12_SHELL, RAMLOG_MOD_NO12_BUF_SIZE, RAMLOG_MOD_NO12_LOOP_ON, RAMLOG_MOD_NO12_REG},
		{RAMLOG_MOD_NO13, RAMLOG_MOD_NO13_SHELL, RAMLOG_MOD_NO13_BUF_SIZE, RAMLOG_MOD_NO13_LOOP_ON, RAMLOG_MOD_NO13_REG},
		{RAMLOG_MOD_NO14, RAMLOG_MOD_NO14_SHELL, RAMLOG_MOD_NO14_BUF_SIZE, RAMLOG_MOD_NO14_LOOP_ON, RAMLOG_MOD_NO14_REG},
		{RAMLOG_MOD_NO15, RAMLOG_MOD_NO15_SHELL, RAMLOG_MOD_NO15_BUF_SIZE, RAMLOG_MOD_NO15_LOOP_ON, RAMLOG_MOD_NO15_REG},
		{RAMLOG_MOD_NO16, RAMLOG_MOD_NO16_SHELL, RAMLOG_MOD_NO16_BUF_SIZE, RAMLOG_MOD_NO16_LOOP_ON, RAMLOG_MOD_NO16_REG},
        {RAMLOG_MOD_NO17, RAMLOG_MOD_NO17_SHELL, RAMLOG_MOD_NO17_BUF_SIZE, RAMLOG_MOD_NO17_LOOP_ON, RAMLOG_MOD_NO17_REG}
    };

/*¼ӡģϢ, ϵͳҵ, 鿴ramlogڴַ*/
static volatile T_Ramlog_Record  s_ramlogRecord[RAMLOG_MOD_MAX];
#endif
/****************************************************************************
*											  Function Definitions
****************************************************************************/

/*******************************************************************************
* Function:
* Description: ӡģʼ
* Parameters:
*	 Input:
*
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 zDrvRamLog_Initiate(VOID)
{
#ifdef _USE_RAMLOG

    T_Ramlog_ModCfg *pCfgItem = NULL;
    UINT16 modNum;
    UINT16 modIdx;
    SINT32 ret;

    if ( s_ramlogInitFlag )
    {
        return DRV_ERR_OPEN_TIMES;
    }

    /*ʼӡģ*/
    if ( NULL == s_pRamlogList )
    {
        s_pRamlogList = zOss_Malloc( sizeof( T_Ramlog_RamlogItem ) );
        if ( NULL == s_pRamlogList )
        {
            return DRV_ERR_MEM_ALLOC;
        }
        else
        {
            zOss_Memset( ( VOID * )s_pRamlogList, 0 , sizeof( T_Ramlog_RamlogItem ) );

            zOss_ListInit( &s_pRamlogList->modList );
        }
    }

	s_pRamlogList->isInPrint = FALSE;

    /*עӡģ*/
    modNum = sizeof(s_modCfgList)/sizeof(T_Ramlog_ModCfg);

    for (modIdx=0; modIdx < modNum; modIdx++)
    {
        pCfgItem = &s_modCfgList[modIdx];
        if (pCfgItem->bIsReg)
        {
            ret = ramlog_RegModule( pCfgItem->nModNo, pCfgItem->szShellCmd, pCfgItem->nBufSize, pCfgItem->bIsLoopPrint );
            if (ret)
                return ret;
        }
    }

    /*עshell*/
    ret = zOss_AddShellCmd(RAMLOG_LOG_SHELL_CMD, ramlog_ShellCmdEntry2, "ӡϢ");
    if ( ZOSS_SUCCESS != ret )
        return DRV_ERROR;

    s_ramlogInitFlag = TRUE;

#endif
    return DRV_SUCCESS;
}

/*******************************************************************************
* Function:
* Description:  logӡ
* Parameters:
*	 Input:     nModNo:ģ
*               pFormat:ʽַ
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
SINT32 ramlog_Printf( UINT16 nModNo, const VOID *pFormat, ... )
{
#ifdef _USE_RAMLOG

    T_ZOss_Node *pCurNode			= NULL;
    T_Ramlog_ModuleItem *pModItem	= NULL;
    char *pCurBuf					= NULL;

    va_list ap;
    UINT32 printfCnt;
    UINT32 cnt;
	UINT32 msr;
	
    /*Ƿʼ*/
    if (!s_ramlogInitFlag)
    {
        return DRV_ERR_NOT_OPENED;
    }
    /*ڴӡLOGWINTRACEʱ,˺ٴӡDRV_ERR_BUSY*/
    if (s_ramlogShowFlag)
    {
        return DRV_ERR_BUSY;
    }
    /**/
    if ( NULL == pFormat )
    {
        return DRV_ERR_INVALID_PARAM;
    }

    /*бѯǰģ*/
    pCurNode = zOss_ListFirst(&s_pRamlogList->modList);
    while ( pCurNode != NULL )
    {
        pModItem = ( T_Ramlog_ModuleItem * )pCurNode;
        /*Ƚģ*/
        if ( pModItem->modNo == nModNo )
        {
            break;
        }
        pCurNode = zOss_ListNext( pCurNode );
    }
    /*޴˿*/
    if ( pCurNode == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }
	
	LOCK_SAVE(msr);
	if (s_pRamlogList->isInPrint)
	{
		pModItem->lossLogCnt++;
		LOCK_RESTORE(msr);
		return DRV_ERROR;
	}
	s_pRamlogList->isInPrint = TRUE;
	LOCK_RESTORE(msr);
	
    va_start(ap,pFormat);
    /*printfCnt=vsprintf(s_szPrintfBuf, pFormat,ap);*/

    /*12ֽ,10ֽڴindex,2ֽڴűǷ*/
    printfCnt=vsnformat(s_szPrintfBuf, RAMLOG_PRINTF_MAX_LEN, pFormat, ap);
    va_end(ap);

    /*ӡռ,Ƿѭӡ,10Byte,2Byteŷָ,1ֽNULL*/
    if ( pModItem->logBufAddrCnt+printfCnt+12+1 >= pModItem->logBufSize )
    {
        /*loop print*/
        if (pModItem->isLoopPrint == TRUE)
        {
            pModItem->logBufAddrCnt=0;
            pModItem->curlogCnt=0;
        }
        else
        {
			LOCK_SAVE(msr);
			s_pRamlogList->isInPrint = FALSE;
        	LOCK_RESTORE(msr);
            return DRV_ERROR;
        }
    }
    /*ȡڴַ*/
    pCurBuf = &pModItem->pLogBuf[pModItem->logBufAddrCnt];

    /*index10Ʒʽתַʽ*/
	sprintf(pCurBuf,"%d",(int)s_pRamlogList->gblcurLogCnt);

    /*ַ*/
    cnt = strlen(pCurBuf);

    /*ӷָ*/
    //strncat(pCurBuf, "\1", 1);
    pCurBuf += cnt;
    memcpy(pCurBuf, "\1", 1);

    /*ӴӡLOGַ*/
    //strncat(pCurBuf, s_szPrintfBuf, printfCnt);
    pCurBuf += 1;
    memcpy(pCurBuf, s_szPrintfBuf, printfCnt);

    /*ӽ,ַ" 123 \1 stringlog \2 " */
    //strncat(pCurBuf, "\2", 1);
    pCurBuf += printfCnt;
    memcpy(pCurBuf, "\2", 1);

    /*Ѵֽ*/
    pModItem->logBufAddrCnt += cnt+printfCnt+2;

    /*LOG*/
    pModItem->curlogCnt++;

    /*ȫLOG*/
    s_pRamlogList->gblcurLogCnt++;

    /*,0*/
    if (s_pRamlogList->gblcurLogCnt < 0)
    {
        s_pRamlogList->gblcurLogCnt = 0;
    }
	
	LOCK_SAVE(msr);
	s_pRamlogList->isInPrint = FALSE;
	LOCK_RESTORE(msr);

#endif
    return DRV_SUCCESS;
}

#ifdef _USE_RAMLOG

/*******************************************************************************
* Function:
* Description: עӡģ
* Parameters:
*	 Input: 	nMode:ģ
*				nBufSize:LOGС
*				bIsLoop:Ƿѭӡ
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
static SINT32 ramlog_RegModule(UINT16 nModNo, char* pShellCmd, UINT32 nBufSize, BOOL bIsLoop)
{
    T_ZOss_Node *pCurNode			= NULL;
    T_Ramlog_ModuleItem *pModItem	= NULL;

    UINT16 recordIdx = 0;

    /*ûгʼ*/
    if ( s_pRamlogList ==  NULL )
    {
        return DRV_ERROR;
    }

    /*ȲѯǰģǷѾעʹ*/
    pCurNode = zOss_ListFirst( &s_pRamlogList->modList );
    while ( pCurNode != NULL )
    {
        pModItem = ( T_Ramlog_ModuleItem * )pCurNode;
        /*Ѿע᷵سɹ*/
        if ( pModItem->modNo == nModNo )
        {
            return DRV_SUCCESS;
        }
        pCurNode = zOss_ListNext( pCurNode );
    }

    /*ģ黹ûע*/
    pModItem = zOss_Malloc( sizeof( T_Ramlog_ModuleItem ) );

    if ( NULL == pModItem )
    {
        return DRV_ERR_MEM_ALLOC;
    }
    else
    {
        zOss_Memset( ( VOID * )pModItem, 0 , sizeof( T_Ramlog_ModuleItem ) );
    }

    /*ʼϢ*/
    pModItem->modNo 		= nModNo;
    pModItem->logBufSize	= nBufSize;
    pModItem->isLoopPrint	= bIsLoop;
	pModItem->lossLogCnt	= 0;
    pModItem->pLogBuf		= (char *)zOss_Malloc( sizeof(char)*nBufSize );

    if ( NULL == pModItem->pLogBuf)
    {
	 zOss_Free(pModItem);
        return DRV_ERR_MEM_ALLOC;
    }
    else
    {
        zOss_Memset( ( VOID * )pModItem->pLogBuf, 0 , sizeof(char)*nBufSize );
    }
    /*ӵ*/
    zOss_ListAdd( &s_pRamlogList->modList,( T_ZOss_Node * )pModItem );

    /*¼ӡģϢ*/
    if(s_pRamlogList->modList.count <= RAMLOG_MOD_MAX)
    {
        recordIdx = s_pRamlogList->modList.count-1;
        s_ramlogRecord[recordIdx].rdModName    = pShellCmd;
        s_ramlogRecord[recordIdx].rdBufPtrStart= pModItem->pLogBuf;
        s_ramlogRecord[recordIdx].rdBufPtrEnd  = pModItem->pLogBuf + nBufSize - 1;
        s_ramlogRecord[recordIdx].rdBufSize    = nBufSize;
    }

    return DRV_SUCCESS;
}


/*******************************************************************************
* Function:
* Description: жشӡģ
* Parameters:
*	 Input:
*
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
#if 0 /*no used*/
static SINT32 ramlog_UnRegModule(UINT16 nModNo)
{
    T_ZOss_Node *pCurNode			= NULL;
    T_Ramlog_ModuleItem *pModItem	= NULL;

    /*ûгʼ*/
    if ( s_pRamlogList ==  NULL )
    {
        return DRV_ERROR;
    }

    /*ȲѯǰģǷѾעʹ*/
    pCurNode = zOss_ListFirst( &s_pRamlogList->modList );
    while ( pCurNode != NULL )
    {
        pModItem = ( T_Ramlog_ModuleItem * )pCurNode;
        /*Ѿע᷵سɹ*/
        if ( pModItem->modNo == nModNo )
        {
            /*ͷLOGڴ*/
            zOss_Free( pModItem->pLogBuf );

            /*ͷŴӡģڵڴ*/
            zOss_Free( pModItem );

            /*Ӵӡģɾ*/
            zOss_ListDelete( &s_pRamlogList->modList, pCurNode );
            return DRV_SUCCESS;
        }
        pCurNode = zOss_ListNext( pCurNode );
    }
    /*޴˿*/
    if ( pCurNode == NULL)
    {
        return DRV_ERR_INVALID_PARAM;
    }

    return DRV_SUCCESS;
}
#endif
/*******************************************************************************
 * Function:
 * Description: 
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static SINT32 ramlog_InsertSort(T_Ramlog_SortItem item[],UINT32 cnt)
{
    SINT32 i,j;
    volatile T_Ramlog_SortItem temp;

    for (i=1; i < cnt; i++)
    {
        temp = item[i];
        for (j=i; j>0 && temp.sortGblLogIdx < item[j-1].sortGblLogIdx; j--)
            item[j]=item[j-1];
        if (j!=i)
            item[j] = temp;
    }
    return DRV_SUCCESS;
}
/*******************************************************************************
* Function:
* Description: ʾģĴӡϢ
* Parameters:
*	 Input: 	modItem:Ҫӡģָ
*				nModCnt:Ҫӡģ
*				bIsSort:Ƿ
*	 Output:
*
* Returns:
*
*
* Others:
********************************************************************************/
static SINT32 ramlog_ShowLog2WinTrace(UINT16 modItem[], UINT32 nModCnt, BOOL bIsSort)
{
    T_ZOss_Node *pCurNode           = NULL;
    T_Ramlog_ModuleItem *pModItem	= NULL;
    T_Ramlog_SortItem *pSortItem	= NULL;
    char *pStart					= NULL;
    char *pEnd						= NULL;

    char logBuf[RAMLOG_PRINTF_MAX_LEN+1];
    UINT32 modIdx=0;
    UINT32 modLogIdx=0;
    UINT32 sortLogNum=0;
    UINT32 sortLogIdx=0;
    UINT32 modBufIdx=0;

    T_Ramlog_ModuleItem *pModArray[8];
    UINT32 modArrIdx=0;
    UINT32 modArrCnt=0;
	UINT32 index = 0;
    //BOOL skipFlag = FALSE;

    s_ramlogShowFlag = TRUE;



    if ( nModCnt >= 1 )
    {
        for (modIdx=0; modIdx < nModCnt; modIdx++)
        {
            /*бѯǰģ*/
            pCurNode = zOss_ListFirst(&s_pRamlogList->modList);
            while ( pCurNode != NULL )
            {
                pModItem = ( T_Ramlog_ModuleItem * )pCurNode;
                /*Ƚģ*/
                if ( pModItem->modNo == modItem[modIdx] )
                {
                    /*LOG*/
                    sortLogNum += pModItem->curlogCnt;
                    pModArray[modArrCnt] = pModItem;

                    modArrCnt++;
                    break;
                }
                pCurNode = zOss_ListNext( pCurNode );
            }
            /*޴˿*/
            if ( pCurNode == NULL)
            {
                HAL_ERR_TRACE("ERROR: Module %d is not registered!", modItem[modIdx]);
                s_ramlogShowFlag = FALSE;
                return DRV_ERR_INVALID_PARAM;
            }
        }

        if (!sortLogNum)
        {
            HAL_ERR_TRACE("No log to print!");
            s_ramlogShowFlag = FALSE;
            return DRV_ERROR;
        }
		
		HAL_LOG_TRACE("Mod Log Loss Count = %d\n", pModItem->lossLogCnt);

        pSortItem = (T_Ramlog_SortItem*)zOss_Malloc( sizeof(T_Ramlog_SortItem)*sortLogNum );

        /*ڴʧ*/
        if (pSortItem == NULL)
        {
            zOss_Free(pSortItem);
            HAL_ERR_TRACE("ERROR: Memory malloc fail, Pls decrease the size of log buffer or num of module!");
            s_ramlogShowFlag = FALSE;
            return DRV_ERR_MEM_ALLOC;
        }

        zOss_Memset( ( VOID * )pSortItem, 0, sizeof(T_Ramlog_SortItem)*sortLogNum );

        //logȡ
        for (modArrIdx=0; modArrIdx < modArrCnt; modArrIdx++)
        {
            pModItem = pModArray[modArrIdx];

            pStart = pModItem->pLogBuf;
            modLogIdx = 0;
            modBufIdx = 0;

            while ( modBufIdx < pModItem->logBufAddrCnt && sortLogIdx < sortLogNum )
            {
                /*ڶ߳LOG*/
                /*
                if(skipFlag == TRUE)
                {
                    while(pEnd == NULL && modBufIdx < pModItem->logBufAddrCnt)
                    {
                        pEnd = strchr(pStart, RAMLOG_LOG_END_FLAG);
                        if (pEnd == NULL )
                        {
                            pStart++;
                            modBufIdx++;
                        }
                        else
                        {
                            modBufIdx += pEnd-pStart+1;
                            pStart = pEnd+1;
                        }

                    }
                    skipFlag = FALSE;
                }
                */
                /*ҷָ*/
                pEnd = strchr(pStart, RAMLOG_LOG_SEP_FLAG);
                if (pEnd == NULL )
                {
                    pStart++;
                    modBufIdx++;
                    //skipFlag = TRUE;
                    continue;
                }

                pSortItem[sortLogIdx].sortLogBuf = pEnd+1;

                /*ʼַ, 1ֽNULL*/
                memset(logBuf, 0, RAMLOG_PRINTF_MAX_LEN+1);
                if (pEnd-pStart < RAMLOG_PRINTF_MAX_LEN)
                {
                    /*LOGַʱ*/
                    memcpy(logBuf, pStart, pEnd-pStart);
                }

                modBufIdx += pEnd-pStart+1;
                pStart = pEnd+1;

                /*ҽ*/
                pEnd = strchr(pStart, RAMLOG_LOG_END_FLAG);
                if (pEnd == NULL )
                {
                    pStart++;
                    modBufIdx++;
                    //skipFlag = TRUE;
                    continue;
                }

                modBufIdx += pEnd-pStart+1;
                pStart= pEnd+1;

                /*LOGȫindex*/
				sscanf(logBuf, "%d",(int*) &index);
                pSortItem[sortLogIdx].sortGblLogIdx = index;

                /*ȡӡģ*/
                pSortItem[sortLogIdx].sortModNo = pModItem->modNo;

                /*LOGģindex*/
                pSortItem[sortLogIdx].sortModLogIdx = modLogIdx;

                modLogIdx++;
                sortLogIdx++;
            }
        }

        /*ȡʵʵLOG*/
        sortLogNum = sortLogIdx;

        if (bIsSort == TRUE)
        {
            /*LOG*/
            ramlog_InsertSort(pSortItem, sortLogNum);
        }

        for (sortLogIdx=0; sortLogIdx < sortLogNum; sortLogIdx++)
        {
            if ((sortLogIdx+1) % 30 == 0)
            {
                zOss_Sleep(300);
            }
            /*ӡLOGϢ*/
            pStart	= pSortItem[sortLogIdx].sortLogBuf;
            pEnd	= strchr(pStart, RAMLOG_LOG_END_FLAG);
            memset(logBuf, 0, RAMLOG_PRINTF_MAX_LEN+1);
            if (pEnd-pStart < RAMLOG_PRINTF_MAX_LEN)
            {
                memcpy(logBuf, pStart, pEnd-pStart);
            }
            /*ȥַβ\n*/
            if(logBuf[pEnd-pStart-1] == '\n')
            {
                logBuf[pEnd-pStart-1] = 0;
            }

            #if RAMLOG_DEBUG
            /*һ:ӡģ,ڶ:ģLOG,:ģȫLOG*/
            HAL_LOG_TRACE("RAMLOG(%d,%d,%d):%s",
                          pSortItem[sortLogIdx].sortModNo,
                          pSortItem[sortLogIdx].sortModLogIdx,
                          pSortItem[sortLogIdx].sortGblLogIdx,
                          logBuf);
            #else
            HAL_LOG_TRACE("RAMLOG(%d):%s", pSortItem[sortLogIdx].sortModLogIdx,logBuf);
            #endif
        }
        zOss_Free(pSortItem);
    }
    /*ӡ,FALSE,ֹLOGʱ޸*/
    s_ramlogShowFlag = FALSE;
    return DRV_SUCCESS;
}

/*******************************************************************************
 * Function:
 * Description: shell
 * Parameters:
 *   Input:     CmdMsg:shell
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
VOID ramlog_ShellCmdEntry(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 itemIdx=0, itemNum=0;
    UINT32 paraIdx=0;

    /*8*/
    UINT16 mdls[8];
    UINT16 modIdx=0;

    BOOL bIsShow = TRUE;
    T_Ramlog_ModCfg *pItem = NULL;

    itemNum = sizeof(s_modCfgList)/sizeof(T_Ramlog_ModCfg);

    if (CmdMsg->paraCount == 0)
    {
        /*show menu item*/
        HAL_NML_TRACE("/*----------------------------------------------------------------*/");
        HAL_NML_TRACE("/*--Now, we'll begin to print ramlog, pls selet the module item --*/");
        HAL_NML_TRACE("/*----------------------------------------------------------------*/");

        itemNum = sizeof(s_modCfgList)/sizeof(T_Ramlog_ModCfg);

        for (itemIdx=0; itemIdx<itemNum; itemIdx++)
        {
            pItem = &s_modCfgList[itemIdx];
            if(pItem->bIsReg)
            {
                HAL_NML_TRACE("(%d) %s module: please input [%s %s] to print log",
                    itemIdx+1, pItem->szShellCmd, RAMLOG_LOG_SHELL_CMD, pItem->szShellCmd);
            }
        }
        return;
    }

    if (CmdMsg->paraCount >= 1)
    {
        /*calc total ram logs*/
        for (paraIdx=0; paraIdx < CmdMsg->paraCount; paraIdx++)
        {
            for (itemIdx=0; itemIdx<itemNum; itemIdx++)
            {
                if (strcmp((const char *)(CmdMsg->para[paraIdx]), (const char *)(s_modCfgList[itemIdx].szShellCmd)) == 0)
                {
                    mdls[modIdx++]=s_modCfgList[itemIdx].nModNo;
                    break;
                }
            }
            if (itemIdx == itemNum)
            {
                bIsShow = FALSE;

                HAL_ERR_TRACE("ERROR: %s is a invalid command!",CmdMsg->para[paraIdx]);
                break;
            }
        }

        if (bIsShow == TRUE)
        {
            ramlog_ShowLog2WinTrace(mdls, modIdx, TRUE);
        }
    }

}

static SINT32 ramlog_ShowLog2WinTrace2(UINT16 modItem)
{
    T_ZOss_Node *pCurNode           = NULL;
    T_Ramlog_ModuleItem *pModItem	= NULL;

    char *logBuf                    = NULL;
	char s_TmpBuffer[200] = {0};
	
	UINT32 i,j = 0;
	
    s_ramlogShowFlag = TRUE;

    /*бѯǰģ*/
    pCurNode = zOss_ListFirst(&s_pRamlogList->modList);
    while ( pCurNode != NULL )
    {
        pModItem = ( T_Ramlog_ModuleItem * )pCurNode;
        /*Ƚģ*/
        if ( pModItem->modNo == modItem )
        {
            break;
        }
        pCurNode = zOss_ListNext( pCurNode );
    }
    /*޴˿*/
    if ( pCurNode == NULL)
    {
        HAL_ERR_TRACE("ERROR: Module %d is not registered!", modItem);
        s_ramlogShowFlag = FALSE;
        return DRV_ERR_INVALID_PARAM;
    }	

    logBuf = zOss_Malloc( pModItem->logBufSize);

	if(logBuf == NULL)
	{
		HAL_ERR_TRACE("ERROR: logBuf malloc failed!");
		return DRV_ERR_INVALID_PARAM;
	}

	zOss_Memset(logBuf, 0, pModItem->logBufSize);

	zOss_Memcpy(logBuf, &pModItem->pLogBuf[0], pModItem->logBufSize);

	for(i=pModItem->logBufAddrCnt;i<pModItem->logBufSize;i++)
	{
		s_TmpBuffer[j++] = logBuf[i];
		if(j==200) j=0;/*ֹӡΪʱԽ*/
		if(RAMLOG_LOG_END_FLAG == logBuf[i])/*ÿλзӡһ*/
		{
			HAL_ERR_TRACE("%s",s_TmpBuffer);
			zOss_Memset(&s_TmpBuffer, 0, sizeof(s_TmpBuffer));
			j = 0;
		}
		
		if(i == pModItem->logBufSize - 1)
		{
			HAL_ERR_TRACE("%s",s_TmpBuffer);
			zOss_Memset(&s_TmpBuffer, 0, sizeof(s_TmpBuffer));
			j = 0;
		}
	}
	
	for(i=0;i<pModItem->logBufAddrCnt;i++)
	{
		s_TmpBuffer[j++] = logBuf[i];
		if(j==200) j=0;/*ֹӡΪʱԽ*/
		if(RAMLOG_LOG_END_FLAG == logBuf[i])/*ÿλзӡһ*/
		{
			HAL_ERR_TRACE("%s",s_TmpBuffer);
			zOss_Memset(&s_TmpBuffer, 0, sizeof(s_TmpBuffer));
			j = 0;
		}
	}

	zOss_Free(logBuf);

    /*ӡ,FALSE,ֹLOGʱ޸*/
    s_ramlogShowFlag = FALSE;
    return DRV_SUCCESS;
}


static VOID ramlog_ShellCmdEntry2(T_Shell_CommandMessage *CmdMsg)
{
    UINT32 itemIdx=0, itemNum=0;

    /*8*/
    UINT16 mdls=0;

    BOOL bIsShow = TRUE;
    T_Ramlog_ModCfg *pItem = NULL;

    itemNum = sizeof(s_modCfgList)/sizeof(T_Ramlog_ModCfg);

    if (CmdMsg->paraCount == 0)
    {
        /*show menu item*/
        HAL_NML_TRACE("/*----------------------------------------------------------------*/");
        HAL_NML_TRACE("/*--Now, we'll begin to print ramlog, pls selet the module item --*/");
        HAL_NML_TRACE("/*----------------------------------------------------------------*/");

        itemNum = sizeof(s_modCfgList)/sizeof(T_Ramlog_ModCfg);

        for (itemIdx=0; itemIdx<itemNum; itemIdx++)
        {
            pItem = &s_modCfgList[itemIdx];
            if(pItem->bIsReg)
            {
                HAL_NML_TRACE("(%d) %s module: please input [%s %s] to print log",
                    itemIdx+1, pItem->szShellCmd, RAMLOG_LOG_SHELL_CMD, pItem->szShellCmd);
            }
        }
        return;
    }

	if (CmdMsg->paraCount > 1)
	{
		HAL_NML_TRACE("Parameter more than one, invalid!");
	}

    if (CmdMsg->paraCount == 1)
    {
        /*calc total ram logs*/
        for (itemIdx=0; itemIdx < itemNum; itemIdx++)
        {

            if (strcmp((const char *)(CmdMsg->para[0]), (const char *)(s_modCfgList[itemIdx].szShellCmd)) == 0)
            {
                mdls=s_modCfgList[itemIdx].nModNo;
                break;
            }
        }

        if (bIsShow == TRUE)
        {
            ramlog_ShowLog2WinTrace2(mdls);
        }
    }

}


#endif

