/*******************************************************************************
 * Copyright (C) 2007, ZTE Corporation.
 *
 * File Name:   hal_assert.c
 * File Mark:
 * Description:
 * Others:
 * Version:       v0.1
 * Author:        weizhigang
 * Date:          2009-7-2
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 *     Date: 2009-12-02
 *     Version: V0.2
 *     Author:  Qian Chen
 *     Modification:implement zDrv_assertInternal
*******************************************************************************/

/*******************************************************************************
*                                             Include files
*******************************************************************************/
#include "drvs_general.h"
#include "drvs_cfg.h"
#include "drvs_ramlog.h"


/*******************************************************************************
*                                             Local Macros
*******************************************************************************/
#if 0
#define HAL_EXCEPTION_MAX_NAME_LEN     (64) /* include '\0' */
#define HAL_EXCEPTION_INFO_ITEMS_NUM   (8)  /* 2^n, n>0 */
#define HAL_EXCEPTION_ILLEGAL_DATA_ADDRESS     (0x9000000DUL)
#define HAL_EXCEPTION_FLASH_LOGIC_ADDRESS      (NAND_BASE+0x027C0000)
#define HAL_EXCEPTION_RAM_LOG_INDEX            (*(UINT32*)(0x00070000UL))
#define HAL_EXCEPTION_RAM_LOG_ADDRESS          (0x00070004UL)
#define HAL_EXCEPTION_LABEL         "Assert"
#define HAL_EXCEPTION_LOG_ETC       "..."
#define HAL_EXCEPTION_LOG_HEAD      "\tHAL Assert:"
#define HAL_EXCEPTION_LOG_INDEX     "\tindex:%d"
#define HAL_EXCEPTION_LOG_EXP       "\texpression:%s"
#define HAL_EXCEPTION_LOG_FILE_NAME "\tfile name:%s"
#define HAL_EXCEPTION_LOG_FUNC_NAME "\tfunction name:%s"
#define HAL_EXCEPTION_LOG_LINE_NUM  "\tline#:%d"
#define HAL_EXCEPTION_LOG_SP        "\tSP:0x%8X"
#define HAL_EXCEPTION_LOG_CPSR      "\tCPSR:0x%8X"
#define HAL_EXCEPTION_LOG_SPSR      "\tSPSR:0x%8X"
#define HAL_EXCEPTION_LOG_PID       "\tPID:%d"
#define HAL_EXCEPTION_LOG_PNAME     "\tThreadName:%s"
#define HAL_EXCEPTION_LOG_FORMAT    HAL_EXCEPTION_LOG_HEAD \
                                    HAL_EXCEPTION_LOG_INDEX \
                                    HAL_EXCEPTION_LOG_EXP \
                                    HAL_EXCEPTION_LOG_FILE_NAME \
                                    HAL_EXCEPTION_LOG_FUNC_NAME \
                                    HAL_EXCEPTION_LOG_LINE_NUM \
                                    HAL_EXCEPTION_LOG_SP \
                                    HAL_EXCEPTION_LOG_CPSR \
                                    HAL_EXCEPTION_LOG_SPSR \
                                    HAL_EXCEPTION_LOG_PID \
                                    HAL_EXCEPTION_LOG_PNAME


/*******************************************************************************
*                                             Local Types
*******************************************************************************/
typedef struct _T_HalAssert_Info
{
    CHAR m_label[8];
    UINT32 m_index;
    CHAR m_expression[HAL_EXCEPTION_MAX_NAME_LEN];
    CHAR m_fileName[HAL_EXCEPTION_MAX_NAME_LEN];
    CHAR m_funcName[HAL_EXCEPTION_MAX_NAME_LEN];
    UINT32 m_lineNum;
    UINT32 *m_sp;
    UINT32 m_cpsr;
    UINT32 m_spsr;
    ZOSS_THREAD_ID m_pid;
    CHAR m_threadName[HAL_EXCEPTION_MAX_NAME_LEN];
}
T_HalAssert_Info;

typedef struct _T_DrvAssert_Info
{
    ZOSS_THREAD_ID pThread;
    const CHAR* pExp;
    const CHAR* pFile;
    const CHAR* pFunc;
    UINT32 dwLine;
}
T_DrvAssert_Info;
#endif
/*******************************************************************************
*                                             Local Constants
*******************************************************************************/

/*******************************************************************************
*                                             Local Function Prototypes
*******************************************************************************/

/*******************************************************************************
*                                            Global Constants
*******************************************************************************/

/*******************************************************************************
*                                            Global Variables
*******************************************************************************/
#if 0
static BOOL s_bUsed = FALSE; /* ʶǷΪһν쳣ֹ쳣Ƕ */
static UINT32 s_infoItemIndex;
#if 0
static T_HalAssert_Info s_aAssertInfo[HAL_EXCEPTION_INFO_ITEMS_NUM];
#else
static T_HalAssert_Info *s_pAssertInfo = {(T_HalAssert_Info*)(HAL_EXCEPTION_RAM_LOG_ADDRESS)};
static T_HalAssert_Info* s_aAssertInfo[HAL_EXCEPTION_INFO_ITEMS_NUM] = {NULL};
#endif
static BOOL s_bExcepInitialized = FALSE;
#endif

//static volatile T_DrvAssert_Info g_zDrvAssertInfo = {0,};
/*******************************************************************************
*                                            Global Function Prototypes
*******************************************************************************/
//static VOID   halExcep_Abort(UINT32 Abort);
#if 0
static SINT32 halExcep_ShortFileName(const CHAR *inpath, CHAR *outfile, UINT32 len);
static VOID   halExcep_Info2RamLog(VOID);
static VOID   halExcep_PrintInfoRamLog(const T_HalAssert_Info *pInfo);
static SINT32 halExcep_GenerateLog(CHAR *strLog, T_HalAssert_Info *pInfo);
//extern SINT32 nand_Read(UINT32 dwStart, UINT32 dwLen, UINT8* to);
//extern SINT32 nand_Program(UINT32 dwStart, UINT32 dwLen, UINT8* from);
//extern SINT32 zDrvLcd_Initiate(VOID);
//extern SINT32 zDrvBlg_Initiate(VOID);
extern SINT32 zDrvExcep_Initiate(VOID);
#endif

#ifdef _OS_TOS
extern void tos_assert_failed(const char *exp, const char *file, const char *func, int line);
#endif

/*******************************************************************************
*                                            Function Definitions
*******************************************************************************/

/*******************************************************************************
 * Function: zDrvExcep_Handler
 * Description: driver assert function
 * Parameters:

 * Input:
   pcFileName: pointer to the file name when assert occurred
   pcFuncName:  pointer to the pcFuncName when assert occurred
   dwLineNum: the error lines when assert occurred
 * Output:None
 *
 * Returns:
 *           none
 * Others:
 ******************************************************************************/
#if 0
VOID zDrvExcep_Handler(CHAR *pExp, const CHAR * pcFileName, const CHAR * pcFuncName, UINT32 dwLineNum)
{
    SINT32 ret = DRV_SUCCESS;

    g_zDrvAssertInfo.pThread = zOss_GetCurThreadID();
    
    ZOSS_DISABLE_IRQ();

    g_zDrvAssertInfo.pExp = pExp;
    g_zDrvAssertInfo.pFile = pcFileName;
    g_zDrvAssertInfo.pFunc = pcFuncName;
    g_zDrvAssertInfo.dwLine = dwLineNum;

#ifdef _OS_WIN
    _assert(pExp, pcFileName, (unsigned int)dwLineNum);
#elif defined (_OS_OSE)
    ose_assertion_failed((char *)pExp, (char *)pcFileName, (unsigned int)dwLineNum);
#elif defined (_OS_TOS)
    tos_assert_failed((const char *)pExp, pcFileName, pcFuncName, dwLineNum);
#elif defined (_OS_LINUX)
    linux_assert_failed((const char *)pExp, pcFileName, pcFuncName, dwLineNum);
#endif

#if 0

    SINT32 ret = DRV_SUCCESS;
    SINT32 i = 0, offset = 0;
    UINT32 len = 0;
    UINT32 reg = 0;
    #ifndef _USE_DATACARD
    CHAR *pStrLog = NULL;
    #endif
    T_HalAssert_Info *pInfo = NULL;
    ZOSS_THREAD_ID pThread  = NULL;
    

    if (!s_bUsed && (pExp != NULL) && (pcFileName != NULL) && (pcFuncName != NULL))
    {
        s_bUsed = TRUE;

        /* Initial static log variables, when they are not initialized */
        if (!s_bExcepInitialized)
        {
            /* information index */
            s_infoItemIndex = HAL_EXCEPTION_RAM_LOG_INDEX;

            /* all pointers to RAM space of information  */
            for (i = 0; i < HAL_EXCEPTION_INFO_ITEMS_NUM; i++)
            {
                s_aAssertInfo[i] = (T_HalAssert_Info*)(HAL_EXCEPTION_RAM_LOG_ADDRESS + offset);

                /* make sure that all strings are legal */
                pInfo = s_aAssertInfo[i];
                pInfo->m_expression[HAL_EXCEPTION_MAX_NAME_LEN - 1] = '\0';
                pInfo->m_fileName[HAL_EXCEPTION_MAX_NAME_LEN - 1]   = '\0';
                pInfo->m_funcName[HAL_EXCEPTION_MAX_NAME_LEN - 1]   = '\0';
                pInfo->m_threadName[HAL_EXCEPTION_MAX_NAME_LEN - 1] = '\0';
                offset += sizeof(T_HalAssert_Info);
            }

            pInfo = (T_HalAssert_Info*)zOss_Malloc(sizeof(T_HalAssert_Info));
            if (pInfo != NULL)
            {
                ret = nand_Read(HAL_EXCEPTION_FLASH_LOGIC_ADDRESS, sizeof(T_HalAssert_Info), (UINT8 *)pInfo);
                if (ret == 0)
                {
                    /* Update index and store it */
                    s_infoItemIndex = pInfo->m_index + 1;
                    HAL_EXCEPTION_RAM_LOG_INDEX = s_infoItemIndex;

                    zOss_Memcpy((VOID*)(&s_pAssertInfo[pInfo->m_index&(HAL_EXCEPTION_INFO_ITEMS_NUM-1)]), (VOID*)pInfo, sizeof(T_HalAssert_Info));
                }
                zOss_Free((VOID*)pInfo);
            }
        }

        pInfo = &s_pAssertInfo[s_infoItemIndex&(HAL_EXCEPTION_INFO_ITEMS_NUM-1)];

        /* Mask all interrupts */
        zDrv_DisableIrq();

        /* Set the current thread as highest priority one */
        pThread = zOss_GetCurThreadID();
        if (pThread != NULL)
        {
            (VOID)zOss_SetThreadPri(pThread, 0);
            zOss_GetThreadInfo(pThread, (CHAR*)pInfo->m_threadName, NULL, NULL, NULL);
            pInfo->m_pid = pThread;
        }

        /* Initialize log label and index */
        sprintf((char*)pInfo->m_label, HAL_EXCEPTION_LABEL);
        pInfo->m_index = s_infoItemIndex;

        /* expression string */
        len = strlen((const char*)pExp);
        if (len < HAL_EXCEPTION_MAX_NAME_LEN)
        {
            sprintf((char*)pInfo->m_expression, "%s", (const char*)pExp);
        }
        else /* the first HAL_EXCEPTION_MAX_NAME_LEN-4 chars plus "..." and end of string */
        {
            len = sizeof(HAL_EXCEPTION_LOG_ETC);
            strncpy((char*)pInfo->m_expression, (const char*)pExp, HAL_EXCEPTION_MAX_NAME_LEN-(len + 1));
            sprintf((char*)(pInfo->m_expression + HAL_EXCEPTION_MAX_NAME_LEN -(len + 1)), HAL_EXCEPTION_LOG_ETC);
        }

        /* file name */
        ret = halExcep_ShortFileName(pcFileName, pInfo->m_fileName, HAL_EXCEPTION_MAX_NAME_LEN);

        /* function name */
        len = strlen((const char*)pcFuncName);
        len = (len >= HAL_EXCEPTION_MAX_NAME_LEN)?(HAL_EXCEPTION_MAX_NAME_LEN - 1):len;
        strncpy((char*)pInfo->m_funcName, (const char*)pcFuncName, len);
        pInfo->m_funcName[len] = '\0';

        /* line# */
        pInfo->m_lineNum = dwLineNum;

        /* CPSR SPSR */
#ifndef _OS_WIN

        /* CPSR */
#if __ARMCC_VERSION > 220000 /* RVCT */
        __asm
        {
            MRS reg, CPSR
        }
#else
#ifdef __GNUC__ /* gcc */
        __asm__("MRS     R0, CPSR");
__asm__("str     r0, %0": "=m"(reg));
#endif /* #ifdef __GNUC__ */
#endif /* #if __ARMCC_VERSION > 200000 */
        pInfo->m_cpsr = reg;

        /* SPSR */
#ifdef  __ARMCC_VERSION
#if __ARMCC_VERSION > 220000
        __asm
        {
            MRS reg, SPSR
        }
#else
#ifdef __GNUC__
        __asm__("MRS     R0, SPSR");
__asm__("str     r0, %0": "=m"(reg));
#endif /* #ifdef __GNUC__ */
#endif /* #if __ARMCC_VERSION > 200000 */
#endif /* #ifdef  __ARMCC_VERSION */
        pInfo->m_spsr = reg;

#if __ARMCC_VERSION > 220000 /*rvct*/
        {
            __asm
            {
                mov reg, __current_sp()
            }
        }
#else /*RVCT*/
#ifdef __GNUC__
__asm__("str   r11, %0": "=m"(pfp)); /*ջϲָ֡(fp)*/
__asm__("str   r13, %0": "=m"(psp)); /*ջַ(sp)*/
#else /*RVCT,GCC*/
#endif /*end #ifdef __GNUC__*/
#endif /*end #if __ARMCC_VERSION > 220000*/
        pInfo->m_sp = (UINT32 *)reg;
#endif /* #ifndef _OS_WIN */





        /* RAM log */
        halExcep_PrintInfoRamLog(pInfo);

        if (s_bExcepInitialized)
        {
            /* LCD for modem or handset, LED for datacard */
#ifndef _USE_DATACARD
            /* log string */
            pStrLog = (CHAR*)zOss_Malloc(512);
            if (pStrLog != NULL)
            {
                len = halExcep_GenerateLog(pStrLog, pInfo);

                /* LCD&backlight */
                ret = zDrvBlg_Initiate();   /* backlight */
                if (ret == DRV_SUCCESS)
                {
                    ret = halBlg_Open();
                }
                if (ret == DRV_SUCCESS)
                {
                    ret = halBlg_LcdEnable(TRUE);
                }
                if (ret == DRV_SUCCESS)
                {
                    ret = halBlg_LcdSetBrightness(255);
                }

                ret = zDrvLcd_Initiate();   /* LCD */
                ret += zDrvLcd_Init();
                if (ret == DRV_SUCCESS)
                {
                    ret = halLcd_Open(LCD_MAIN);
                }
                if (ret == DRV_SUCCESS && pStrLog != NULL)
                {
                    zDrvLcd_DisplayText(0, 0, pStrLog, len);
                }
                zOss_Free((VOID*)pStrLog);
            }
#else
            /* yellow LED */
            ret = zDrvLED_Set(LED_YELLOW);
#endif
        }

        /* FLASH */
        ret = nand_Program(HAL_EXCEPTION_FLASH_LOGIC_ADDRESS, sizeof(T_HalAssert_Info), (UINT8*)pInfo);

        /* Update index and store it */
        s_infoItemIndex++;
        HAL_EXCEPTION_RAM_LOG_INDEX = s_infoItemIndex;
    }/* if (!s_bUsed && (pExp != NULL) && (pcFileName != NULL) && (pcFuncName != NULL)) */
    #endif

    /* ARM exception */
    halExcep_Abort(1);
    ZOSS_ENABLE_IRQ();
    (VOID)ret;
    return;
}

/*******************************************************************************
 * Function: halExcep_Abort
 * Description: abort function, results in ARM exception.
 * Parameters:

 * Input: None
 * Output:None
 *
 * Returns:
 *           none
 * Others:
 ******************************************************************************/
static VOID halExcep_Abort(UINT32 Abort)
{
    UINT32 unAlignAddr = 0x01;
    volatile UINT32 tmp = 0;
    
    /*unAlign exception*/
    tmp = *(volatile UINT32*)unAlignAddr;

    /*div 0 exception*/
    tmp = tmp/(Abort-0x1);
#ifdef BUG_ON
    BUG_ON(1);
#endif
    // tmp = *(volatile UINT32*)HAL_EXCEPTION_ILLEGAL_DATA_ADDRESS; /* Alignment trap */
    //(VOID)tmp;
    while(Abort);
    return;
}
#endif
#if 0
static SINT32 halExcep_ShortFileName(const CHAR *inpath, CHAR *outfile, UINT32 len)
{
    const char *p = NULL;
    UINT32 n = 0;

    p = strrchr((char *)inpath, '\\');
    if (NULL != p)
    {
        p++;
    }
    else
    {
        p = (char *)inpath;
    }
    n = strlen(p);

    if (len <= n)
    {
        p += (n - len) + 1;
        strncpy((char *)outfile, p, len - 1);
        n = len-1;
    }
    else
    {
        strncpy((char *)outfile, p, n);
    }

    outfile[n] = '\0';
    return((SINT32)n);
}


/*******************************************************************************
 * Function: halExcep_PrintInfoRamLog
 * Description: print log according to exception information
 *              in RAM or FLASH.
 * Parameters:

 * Input: None
 * Output:None
 *
 * Returns:
 *           none
 * Others:
 ******************************************************************************/
static VOID halExcep_PrintInfoRamLog(const T_HalAssert_Info *pInfo)
{
    if (pInfo == NULL)
    {
        return;
    }
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_HEAD);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_INDEX,       pInfo->m_index);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_EXP,         pInfo->m_expression);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_FILE_NAME,   pInfo->m_fileName);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_FUNC_NAME,   pInfo->m_funcName);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_LINE_NUM,    pInfo->m_lineNum);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_SP,          pInfo->m_sp);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_CPSR,        pInfo->m_cpsr);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_SPSR,        pInfo->m_spsr);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_PID,         pInfo->m_pid);
    (VOID)zDrvRamlog_PRINTF(RAMLOG_MOD_ASSERT, (const VOID *)HAL_EXCEPTION_LOG_PNAME,       pInfo->m_threadName);

    return;
}


/*******************************************************************************
 * Function: halExcep_Info2RamLog
 * Description: generate log according to exception information
 *              in RAM or FLASH.
 * Parameters:

 * Input: None
 * Output:None
 *
 * Returns:
 *           none
 * Others:
 ******************************************************************************/
static VOID halExcep_Info2RamLog(VOID)
{
    T_HalAssert_Info *pInfoArray[HAL_EXCEPTION_INFO_ITEMS_NUM] = {NULL};
    T_HalAssert_Info *pInfo = s_pAssertInfo;
    SINT32 ret = 0;
    UINT32 validInfoNum = 0;

#ifdef _USE_RAMLOG
    T_HalAssert_Info *pTemp = NULL;
    UINT32 i = 0, k = 0;

    /* search information */
    for (i = 0; i < HAL_EXCEPTION_INFO_ITEMS_NUM; i++)
    {
        /* compare information head string with HAL_EXCEPTION_LABEL(including end of string '\0') */
        ret = strncmp((char*)pInfo->m_label, HAL_EXCEPTION_LABEL, strlen(HAL_EXCEPTION_LABEL)+1);
        if (ret == 0)
        {
            pInfoArray[validInfoNum] = pInfo;
            validInfoNum++;
        }
        pInfo++;
    }

    /* sort information */
    for (i = 0; i < validInfoNum; i++)
    {
        for (k = 0; k < validInfoNum-i-1; k++)
        {
            if (pInfoArray[k]->m_index > pInfoArray[k+1]->m_index)
            {
                pTemp = pInfoArray[k];
                pInfoArray[k] = pInfoArray[k+1];
                pInfoArray[k+1] = pTemp;
            }
        }
    }

    /* print ram log */
    for (i = 0; i < validInfoNum; i++)
    {
        pInfo = pInfoArray[i];

        /* print log string */
        halExcep_PrintInfoRamLog(pInfo);
    }

#endif

    pInfo = (T_HalAssert_Info*)zOss_Malloc(sizeof(T_HalAssert_Info));

    if (pInfo != NULL)
    {
        //ret = nand_Read(HAL_EXCEPTION_FLASH_LOGIC_ADDRESS, sizeof(T_HalAssert_Info), (UINT8 *)pInfo);
        if (ret == 0)
        {
            /* if there isn't any log in RAM, try to parse flash log */
            if (validInfoNum == 0)
            {
                /* if it's a valid information? */
                ret = strncmp((char*)pInfo->m_label, HAL_EXCEPTION_LABEL, strlen(HAL_EXCEPTION_LABEL));
                if (ret == 0)
                {
                    /* print log string */
                    halExcep_PrintInfoRamLog(pInfo);
                }
            }

            /* Update index and store it */
            s_infoItemIndex = pInfo->m_index + 1;
            HAL_EXCEPTION_RAM_LOG_INDEX = s_infoItemIndex;

            zOss_Memcpy((VOID*)(&s_pAssertInfo[pInfo->m_index&(HAL_EXCEPTION_INFO_ITEMS_NUM-1)]), (VOID*)pInfo, sizeof(T_HalAssert_Info));
        }
        zOss_Free((VOID*)pInfo);
    }

    return;
}


/*******************************************************************************
 * Function: halExcep_GenerateLog
 * Description: generate log string according to excetion information.
 * Parameters:

 * Input:
 *          pInfo:exception information.
 * Output:
 *          strLog: log string.
 * Returns:
 *          length of strLog
 * Others:
 ******************************************************************************/
static SINT32 halExcep_GenerateLog(CHAR *strLog, T_HalAssert_Info *pInfo)
{
    if (strLog == NULL || pInfo == NULL)
    {
        return(DRV_ERR_INVALID_PARAM);
    }
    return((SINT32)sprintf((char*)strLog, HAL_EXCEPTION_LOG_FORMAT, \
                           pInfo->m_index, \
                           pInfo->m_expression, \
                           pInfo->m_fileName, \
                           pInfo->m_funcName, \
                           pInfo->m_lineNum, \
                           pInfo->m_sp, \
                           pInfo->m_cpsr, \
                           pInfo->m_spsr, \
                           pInfo->m_pid, \
                           pInfo->m_threadName));
}


#ifdef _USE_DATACARD
/********************************************************************************
 * Function: zDrvExcep_ShowDcAssertLed
 * Description: show LED on data card for exception.
 * Parameters:
 *   Input:  None
 *   Output: None
 * Returns:DRV_SUCCESS
 * Others:
*******************************************************************************/
VOID zDrvExcep_ShowDcAssertLed(VOID)
{
    (VOID)zDrvLED_Set(LED_WHITE);
    return;
}
#endif

#endif
/********************************************************************************
 * Function: zDrvExcep_Initiate
 * Description:initialize exception for hal_init.c
 * Parameters:
 *   Input:  None
 *   Output: None
 * Returns:DRV_SUCCESS
 * Others:
*******************************************************************************/
SINT32 zDrvExcep_Initiate(VOID)
{
 #if 0
    SINT32 i = 0, offset = 0;
    T_HalAssert_Info *pInfo = NULL;

    if (s_bExcepInitialized)
    {
        return(DRV_SUCCESS);
    }

    /* information index */
    s_infoItemIndex = HAL_EXCEPTION_RAM_LOG_INDEX;

    /* all pointers to RAM space of information  */
    for (i = 0; i < HAL_EXCEPTION_INFO_ITEMS_NUM; i++)
    {
        s_aAssertInfo[i] = (T_HalAssert_Info*)(HAL_EXCEPTION_RAM_LOG_ADDRESS + offset);

        /* make sure that all strings are legal */
        pInfo = s_aAssertInfo[i];
        pInfo->m_expression[HAL_EXCEPTION_MAX_NAME_LEN - 1] = '\0';
        pInfo->m_fileName[HAL_EXCEPTION_MAX_NAME_LEN - 1]   = '\0';
        pInfo->m_funcName[HAL_EXCEPTION_MAX_NAME_LEN - 1]   = '\0';
        pInfo->m_threadName[HAL_EXCEPTION_MAX_NAME_LEN - 1] = '\0';
        offset += sizeof(T_HalAssert_Info);
    }

    halExcep_Info2RamLog();
    s_bExcepInitialized = TRUE;
  #endif
    return(DRV_SUCCESS);
}


