/**
 * @file oss_clib.h
 * @brief Cͷļ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * 
 */
#ifndef _OSS_CLIB_H
#define _OSS_CLIB_H

#define _USE_CLIB

#ifdef _USE_CLIB
/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#if defined (_OS_LINUX)
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/string.h>
#else
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <math.h>
#include <ctype.h>
#endif

#ifdef _OS_WIN
#include <stddef.h>
#endif
#include "oss_pub.h"
#include "oss_compiler.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#ifdef _OS_LINUX
/*
 * stdio.h
 */
#define printf(fmt, ...)  printk(fmt, ##__VA_ARGS__)

/*
 * random
 */
#define RAND_MAX        (0x7FFFFFFF)
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,14,0))
# define srand(s)        prandom_seed(s)
# define rand()          (prandom_u32() & RAND_MAX)
#else
# define srand(s)        srandom32(s)
# define rand()          (random32() & RAND_MAX)
#endif

/*
 * stdlib.h
 */
#define atol(nptr)      simple_strtol(nptr, (char **)NULL, 10)
#define atoi(nptr)      simple_strtoul(nptr, (char **)NULL, 10)

#define strtol          simple_strtol
#define strtoul         simple_strtoul

#define malloc(size)    kmalloc(size, GFP_ATOMIC)
#define free(ptr)       kfree(ptr)

/*
 * assert.h
 */
#define assert(exp)     zOss_ASSERT(exp)

/*
 * time
 */
#define settimeofday    sys_settimeofday

/*
 * unistd.h
 */
#define exit(nr)        do_exit(nr)

#define zOss_Malloc(size)                           kmalloc(size, GFP_ATOMIC)  
#define zOss_MallocEx(size)                         kmalloc(size, GFP_KERNEL | __GFP_PAGEMODEM)
#define zOss_Realloc(mem_ptr, new_size)             krealloc(mem_ptr, new_size, GFP_ATOMIC)
#define zOss_Free(mem_ptr)                          kfree(mem_ptr) 
#define zOss_Memcpy(dest_ptr, src_ptr, size)        memcpy(dest_ptr, src_ptr, size)
#define zOss_Memset(dest_ptr, value, size)          memset(dest_ptr, value, size)
    
#define zOss_Memmove(dest_ptr, src_ptr, count)      memmove(dest_ptr, src_ptr, count)
#define zOss_Memcmp(f_buf_ptr, s_buf_ptr, count)    memcmp(f_buf_ptr, s_buf_ptr, count)

#else
/**
 * @brief ̬ڴ溯
 * @param size ΣڴĴС
 * @return ɹطڴָ룬ʧܷؿָ
 * @retval void*͵ָ   ɹ
 * @retval NULL              ʧ
 */
#define zOss_Malloc(size)                           mem_malloc(size, ZOSS_FILE, ZOSS_LINE)    

/**
 * @brief ̬ڴ
 * @param mem_ptr  ΣҪڴָ
 * @param new_size ΣҪڴС
 * @return ɹصڴָ룬ʧܷؿָ
 * @retval void*͵ָ   ɹ
 * @retval NULL              ʧ
 */
#define zOss_Realloc(mem_ptr, new_size)             mem_re_alloc(mem_ptr, new_size, ZOSS_FILE, ZOSS_LINE)

/**
 * @brief ͷڴ溯
 * @param mem_ptr ΣҪͷŵڴָ
 * @return void
 */
#define zOss_Free(mem_ptr)                          mem_free_extend(mem_ptr, ZOSS_FILE, ZOSS_LINE) 

/**
 * @brief ڴ濽
 * @param dest_ptr  ΣĿڴָ
 * @param src_ptr   ΣԴڴָ
 * @param size      ΣҪĴС
 * @return dest_ptrָ
 */
#define zOss_Memcpy(dest_ptr, src_ptr, size)        mem_memcpy(dest_ptr, src_ptr, size, ZOSS_FILE, ZOSS_LINE)

/**
 * @brief ڴʼ
 * @param dest_ptr  ΣҪʼĿڴָ
 * @param value     Σʼֵ
 * @param size      ΣʼڴС
 * @return رʼڴָ루void*
 */
#define zOss_Memset(dest_ptr, value, size)          mem_memset(dest_ptr, value, size, ZOSS_FILE, ZOSS_LINE)
    
/**
 * @brief ڴ
 * @param dest_ptr  ΣҪƵĿڴָ
 * @param src_ptr   ΣƵԴڴָ
 * @param count     ΣڴС
 * @return dest_ptrָ
 */
#define zOss_Memmove(dest_ptr, src_ptr, count)      mem_memmove(dest_ptr, src_ptr, count)

/**
 * @brief ڴȽϺ
 * @param f_buf_ptr  ΣҪȽϵһڴָ
 * @param s_buf_ptr  ΣҪȽϵһڴָ
 * @param count      ΣҪȽϵڴС
 * @return ͬ0ͬ
 */
#define zOss_Memcmp(f_buf_ptr, s_buf_ptr, count)    mem_memcmp(f_buf_ptr, s_buf_ptr, count)

#endif

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/

/**
 * @brief ZOSS_TIME_TͶ
 */
typedef UINT32  ZOSS_TIME_T;

/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
 * @brief شӹԪ197011յUTCʱ0ʱ00
 * @param t       ΣӹԪ197011յUTCʱ0ʱ00
                    òΪNULL
 * @return ӹԪ197011յUTCʱ0ʱ00
 * @note 
 * @warning 
 */
ZOSS_TIME_T zOss_Time(ZOSS_TIME_T *t);

#ifndef DOXYGEN_SHOULD_SKIP_THIS

VOID *zOss_CacheMalloc(UINT32 size);

VOID zOss_CacheFree(VOID *ptr);

/* תַ */
char *itoa(int num, char *str, int radix);

/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/
#if defined(_MEM_USE_HEAP)

#if defined (_OS_TOS)
static inline VOID *mem_malloc(UINT32 size, const CHAR *file, UINT32 line)
{
    return (VOID *)tos_heap_alloc(size, file, line);
}

static inline VOID *mem_re_alloc(VOID *mem_ptr, UINT32 new_size, const CHAR *file, UINT32 line)
{
    return (VOID *)tos_heap_realloc(mem_ptr, new_size, file, line);
}

static inline VOID mem_free_extend(VOID *mem_ptr, const CHAR *file, UINT32 line)
{
    (VOID)tos_heap_free(mem_ptr, file, line);
}
#elif defined (_OS_LINUX)
static inline VOID *mem_malloc(UINT32 size, const CHAR *file, UINT32 line)
{
    return (VOID *)kmalloc(size, GFP_KERNEL);
}

static inline VOID *mem_re_alloc(VOID *mem_ptr, UINT32 new_size, const CHAR *file, UINT32 line)
{
    return (VOID *)krealloc(mem_ptr, new_size, GFP_KERNEL);
}

static inline VOID mem_free_extend(VOID *mem_ptr, const CHAR *file, UINT32 line)
{
    (VOID)kfree(mem_ptr);
}
#endif

static inline VOID *mem_memcpy(VOID *dest_ptr, const VOID *src_ptr, UINT32 size, const CHAR *file, UINT32 line)
{
    return memcpy(dest_ptr, src_ptr, size);
}

static inline VOID *mem_memset(VOID *dest_ptr, SINT32 value, UINT32 size, const CHAR *file, UINT32 line)
{
    return memset(dest_ptr, value, size);
}

static inline VOID *mem_memmove(VOID *dest_ptr, const VOID *src_ptr, UINT32 count)
{
    return memmove(dest_ptr, src_ptr, count);
}

static inline SINT32 mem_memcmp(const VOID *f_buf_ptr, const VOID *s_buf_ptr, UINT32 count)
{
    return memcmp(f_buf_ptr, s_buf_ptr, count);
}

#else

VOID *mem_malloc(UINT32 size, const CHAR *file, UINT32 line);
VOID *mem_re_alloc(VOID *mem_ptr, UINT32 new_size, const CHAR *file, UINT32 line);
VOID mem_free_extend(VOID *mem_ptr, const CHAR *file, UINT32 line);
VOID *mem_memcpy(VOID *dest_ptr, const VOID *src_ptr, UINT32 size, const CHAR *file, UINT32 line);
VOID *mem_memset(VOID *dest_ptr, SINT32 value, UINT32 size, const CHAR *file, UINT32 line);
VOID *mem_memmove(VOID *dest_ptr, const VOID *src_ptr, UINT32 count);
SINT32 mem_memcmp(const VOID *f_buf_ptr, const VOID *s_buf_ptr, UINT32 count);

#endif

#endif//#ifndef DOXYGEN_SHOULD_SKIP_THIS

#ifdef __cplusplus
}
#endif

#endif //#ifdef _USE_CLIB

#endif //#ifndef _OSS_CLIB_H

