/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_compiler.h
* ļ : 
* ʵֹ : صĺ궨
*      : chenxingfang
*      : V1.0
*  : 2012-08-10 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_COMPILER_H
#define _OSS_COMPILER_H

#define _USE_COMPILER
#ifdef _USE_COMPILER

/**************************************************************************
* #include
**************************************************************************/
#ifdef _OS_TOS
# include "tos_link_info.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/
#ifdef _OS_LINUX

#ifdef _USE_TCM
# define __tcm_func          __tcmfunc
# define __tcm_call_func     __attribute__((long_call))
# define __tcm_local_func    __tcmlocalfunc
# define __tcm_data          __tcmdata
# define __tcm_const         __tcmconst
# define __gprof             __attribute__((section(".gprof"), instrument_functions))
#else
# define __tcm_func
# define __tcm_call_func
# define __tcm_local_func
# define __tcm_data
# define __tcm_const
# define __gprof
#endif
#ifdef CONFIG_MODEM_CODE_IS_MAPPING
# define __ps_static_func         __attribute__((section(".ps_static_func"), long_call)) noinline
# define __ps_4g_func             __attribute__((section(".ps_4g_func"), long_call)) noinline
# define __ps_3g_func             __attribute__((section(".ps_3g_func"), long_call)) noinline
# define __ps_2g_func             __attribute__((section(".ps_2g_func"), long_call)) noinline
# define __ps_comm_func             __attribute__((section(".ps_comm_func"), long_call)) noinline
#else
# define __ps_static_func         
# define __ps_4g_func             
# define __ps_3g_func             
# define __ps_2g_func             
# define __ps_comm_func           
#endif
#else   // #ifdef _OS_LINUX

#if (__GNUC__ == 4) && (__GNUC_MINOR__ == 3) && (__GNUC_PATCHLEVEL__ == 2)
# define barrier()  asm volatile( "" : : : "memory" )
#else
# define barrier()
#endif

#if defined(__GNUC__) && defined (_USE_TCM)
# define __tcm_func         __attribute__((section(".itcm"), long_call)) noinline
# define __tcm_call_func    __attribute__((long_call))
# define __tcm_data         __attribute__((section(".dtcm")))
# define __gprof            __attribute__((section(".gprof"), instrument_functions))
#elif defined (__ARMCC_VERSION) && defined (_USE_TCM)
# define __tcm_func         __attribute__((section(".itcm")))
# define __tcm_call_func    
# define __tcm_data         __attribute__((section(".dtcm")))
# define __gprof 
#else
# define __tcm_func
# define __tcm_call_func
# define __tcm_data
# define __gprof
#endif

#ifdef __GNUC__
# define inline         __inline__
# define always_inline  __inline__ __attribute__((always_inline))
# define noinline       __attribute__((noinline))
#elif defined (__ARMCC_VERSION)
# define inline         __inline
# define always_inline  __forceinline
# define noinline
#elif defined (_MSC_VER)
# define inline         inline
# define always_inline  inline
# define noinline
#else
# define inline
# define always_inline
# define noinline
#endif

#endif  // #ifdef _OS_LINUX

#ifdef __GNUC__
//#pragma GCC optimize("-O0")
//#pragma GCC optimize("-O2")
# define __optimize(x)  __attribute__((optimize(__str(x))))
#else
# define __optimize(x)
#endif

#ifdef __ARMCC_VERSION
# define PRAGMA(X)          _Pragma(#X)
# define RODATA_BEGIN(X)    PRAGMA(arm section rodata=#X)   
# define RWDATA_BEGIN(X)    PRAGMA(arm section rwdata=#X)   
# define ZIDATA_BEGIN(X)    PRAGMA(arm section zidata=#X)  
# define CODE_BEGIN(X)      PRAGMA(arm section code=#X)   

# define RODATA_END         _Pragma("arm section rodata")
# define RWDATA_END         _Pragma("arm section rwdata")
# define ZIDATA_END         _Pragma("arm section zidata")
# define CODE_END           _Pragma("arm section code")
#else
# define PRAGMA(X)
# define RODATA_BEGIN(X)
# define RWDATA_BEGIN(X)
# define ZIDATA_BEGIN(X)
# define CODE_BEGIN(X)

# define RODATA_END
# define RWDATA_END
# define ZIDATA_END
# define CODE_END
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* 
**************************************************************************/

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _USE_COMPILER    */

#endif  /* _OSS_COMPILER_H  */


