/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_mem.h
* ļ : 
* ʵֹ : ڴ롢ͷŽӿ
*      : chenxingfang
*      : V1.0
*  : 2012-08-10 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_MEM_H
#define _OSS_MEM_H

/**************************************************************************
* #include
**************************************************************************/
#ifdef _OS_TOS
#include "tos_pool.h"
#include "tos_heap.h"
#elif defined _OS_LINUX
#include "oss_pool.h"
#include "linux/mm.h"
#endif
#include "oss_pub.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/
/* UB */
#define zOss_GetUB(size)            mem_getub(size, ZOSS_FILE, ZOSS_LINE)
#define zOss_RetUB(msg_ptr)         mem_retub(msg_ptr, ZOSS_FILE, ZOSS_LINE)

/* UBڴò */
#define MEM_MAX_LEAK_UB             200     /* ڴй¶ѯص   */ 
#define ZOSS_UB_MAX_POOLNUM         15      /* ڴظ, ܳ255  */
#define ZOSS_UBHEAD_FILENAME_LEN    31      /* UBڴļ             */

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID *ZOSS_UB_BLOCK;    /* ڴַָ */

typedef struct 
{
    UINT32 nMemUsed;            /* ʹڴСֽڱʾ   */
    UINT32 nMemTotal;           /* ڴܵĴСֽڱʾ     */
    UINT32 nMemMaxFree;			/* ڴ           */
}T_Mem_MemInfo;              /* ڴϢ                 */

typedef struct 
{
    UINT32  pool_size;          /* ڴشС,λΪbyte    */
    UINT32  total_block_num;    /* ԤڴĿ           */
}T_ZOss_UBPOOL;              /* ڴñ             */

typedef struct 
{
    UINT32  pool_size;          /* ڴشС,λΪbyte    */
    UINT16  total_block_num;    /* ڴĿ             */
    UINT16  free_block_num;     /* ڴĿ           */
    UINT32  peak_value;         /* ڴʹø       */
}T_Mem_UBPoolInfo;          /* ڴϢ               */

typedef struct 
{
    ZOSS_UB_BLOCK   ubBlock;                            /* ڴָ               */
    UINT32          ubBlockSize;                        /* ڴС,λΪbyte    */
    UINT32          usingSize;                          /* ʵռôС             */
    CHAR            name[ZOSS_UBHEAD_FILENAME_LEN + 1]; /* λļ           */
    UINT32          line;                               /* λк             */
    ZOSS_THREAD_ID  threadId;                           /* ߳ID               */
    ZOSS_TASK_ID    taskId;                             /*                */
    UINT32          applyTimeTick;                      /* ʱ(TICK)           */
}T_Mem_UBBlockInfo;                                 /* й¶ڴڴͷϢ     */

typedef struct 
{
    UINT8               pool_num;   /* ڴ   */
    T_Mem_UBPoolInfo    pool_info[ZOSS_UB_MAX_POOLNUM];
}T_Mem_UBPoolGrpInfo;           /* ڴϢ */
 
typedef struct 
{
    UINT16              ub_leak_num;    /* ڴй¶Ŀ,ΪMEM_MAX_LEAK_UB   */
    T_Mem_UBBlockInfo   ubHeadInfo[MEM_MAX_LEAK_UB];
}T_Mem_UBLeakInfo;                  /* ڴй¶Ϣ                         */

/**************************************************************************
* 
**************************************************************************/    
#ifdef _OS_LINUX

#if defined(_UB_USE_HEAP_DEBUG)
extern void *ub_debug_alloc(unsigned long size, const char *file, unsigned long line);
extern void ub_debug_free(void *ptr);
static inline VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line)
{
	return ub_debug_alloc(size, file, line);
}
static inline UINT32 mem_retub(VOID *msg_ptr, const CHAR *file, UINT32 line)
{
	ub_debug_free(msg_ptr);

    return ZOSS_SUCCESS;
}
#elif defined(_UB_USE_HEAP)
static inline VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line)
{
	//zOss_ASSERT(PAGE_SIZE == 4096);
	if(size <= PAGE_SIZE)
		return kmalloc(size, GFP_KERNEL);
	else
		return vmalloc(size);
}
static inline UINT32 mem_retub(VOID *msg_ptr, const CHAR *file, UINT32 line)
{
	if(!is_vmalloc_addr(msg_ptr))
		kfree(msg_ptr);
	else
		vfree(msg_ptr);

    return ZOSS_SUCCESS;
}
#elif defined(_UB_USE_POOL)
static inline VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line)
{
    return pool_alloc(size, file, line);
}
static inline UINT32 mem_retub(VOID *msg_ptr, const CHAR *file, UINT32 line)
{
    pool_free(msg_ptr, file, line);
    return ZOSS_SUCCESS;
}
#endif

#else

#if defined(_UB_USE_HEAP)
static inline VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line)
{
    return tos_heap_alloc(size, file, line);
}
static inline UINT32 mem_retub(VOID *msg_ptr, const CHAR *file, UINT32 line)
{
    tos_heap_free(msg_ptr, file, line);
    return ZOSS_SUCCESS;
}
#elif defined(_UB_USE_POOL)
static inline VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line)
{
    return pool_alloc(size, file, line);
}
static inline UINT32 mem_retub(VOID *msg_ptr, const CHAR *file, UINT32 line)
{
    pool_free(msg_ptr, file, line);
    return ZOSS_SUCCESS;
}
#else
VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line);
UINT32 mem_retub(VOID *msg_ptr, const CHAR *file, UINT32 line);
#endif

#endif  // #ifdef _OS_LINUX

FLOAT zOss_GetUBFreeRate(UINT32 ubSize);
VOID zOss_MemLeakStart(UINT32 leak_threadhold);
VOID zOss_MemLeakEnd(VOID);
VOID zOss_CheckMem(VOID);
VOID zOss_SetUbDbgSwitch(UINT32 dbgFlag);
BOOL zOss_GetMemInitState(VOID);
UINT32 zOss_GetSysMemInfo(T_Mem_MemInfo *mem_info);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _OSS_MEM_H */

