/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_psm.h
* ļ : 
* ʵֹ : ʡģ
*      : chenxingfang
*      : V1.0
*  : 2012-08-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_PSM_H
#define _OSS_PSM_H
       
/**************************************************************************
* #include
**************************************************************************/
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID *ZOSS_COMPENSATE_ID;                       /* ˯߲ID           */
typedef VOID (*psm_SleepInitHook)(VOID);                /* ˯߳ʼhook       */
typedef VOID (*psm_SleepFinishHook)(VOID);              /* ˯߽hook         */
typedef VOID (*psm_SleepBeforeHook)(VOID);              /* ˯ǰhook           */
typedef VOID (*psm_SleepAfterHook)(VOID);               /* ˯ߺhook           */
typedef VOID (*psm_CompensateHook)(UINT32 sleepTime);   /* ˯ʱ䲹Ӻ */

typedef enum
{
    PSM_BOOT_DEFAULT,   /* ʼֵ                           */
    PSM_SYSINIT_FINISH, /* ϵͳʼ,ͺŻSysEntry  */
    PSM_BOOT_FINISH     /* ɣͺŻִ       */
}T_zPsm_BootStage;  /* ׶                             */

#ifdef _USE_CPU_DFM
typedef struct  
{
    UINT32  cpuClk;
    BOOL    isUsed;
}T_zPsm_CpuFreq;                    /* Ƶṹ     */

typedef struct  
{
    UINT32  pullCpuPercent;
    UINT32  upCpuPercent;
    UINT32  downCpuPercent;
}T_zPsm_CpuPercentThreshold;    /* CPUƵֵṹ  */

typedef struct 
{
    UINT32  curCpuFreq;
    UINT32  downCpuFreq; 
    UINT32  upCpuFreq;
    UINT32  pullCpuFreq;
}T_zPsm_CpuFm;                      /* CPUƵṹ      */
#endif

typedef struct 
{ 
    UINT32          deepSleepTimeThreshold; /* ϵͳ˯ߵķֵ             */
    UINT32          shadowSleepTimeThreshold;        
#ifdef _USE_CPU_DFM
    UINT32          dfmPeriod;              /* Ƶڣ5ms*/
    UINT32          dfmThrdPri;             /* Ƶȼ                 */
    UINT32          dfmCnt;                 /* ƵĴ                   */
    T_zPsm_CpuFm    *desClk;                /* δusbcpuƵ           */
    UINT32          desClkNum;              /* δusbcpuƵĸ     */
    T_zPsm_CpuFm    *usbDesClk;             /* usbcpuƵ           */
    UINT32          usbDesClkNum;           /* usbcpuƵĸ     */
    T_zPsm_CpuFreq  *minClk;                /* Ƶ                     */
    T_zPsm_CpuPercentThreshold scaleCpuPcnt;/* cpuƵķֵ                */
    CHAR            **pIgnoreThreadNameArry;/* ̵߳           */
    UINT32          ignoreThreadCnt;        /* ̵߳ĸ               */
    UINT32          *usbSysClk;             /* usbʱϵͳֵ֧Ƶ    */
    UINT32          usbSysClkNum;           /* usbʱϵͳֵ֧Ƶ*/
    UINT32          *sysClk;                /* δusbʱϵͳֵ֧Ƶ    */
    UINT32          sysClkNum;              /* δusbʱϵͳֵ֧Ƶ*/
#endif
    UINT32          chargeringSleepTime;    /* ˯ʱ䣬λms       */
    UINT32          airPlaneSleepTime;      /* ģʽµ˯ʱ䣬λms */
    UINT32          bootOverClk;            /* boot sleep ĿƵ  */
}T_zPsm_Param;  /* ʡòṹ            */

/**************************************************************************
* 
**************************************************************************/
UINT32 zOss_PsmInit(VOID);
VOID   zOss_SetBootStage(T_zPsm_BootStage stage);
UINT32 zOss_SetPSMAppIdle(UINT32 appId);
UINT32 zOss_SetPSMAppActive(UINT32 appId);
UINT32 zOss_ApplyCpuFreq(UINT32 appId, BOOL isUsed);
VOID   zOss_SetSleepHookOpt(psm_SleepInitHook  initHook, psm_SleepFinishHook  finishHook, psm_SleepBeforeHook  beforeHook, psm_SleepAfterHook afterHook);
ZOSS_COMPENSATE_ID zOss_RegSleepCompensateFunc(psm_CompensateHook funcOpt);
VOID   zOss_DeregSleepCompensateFunc(ZOSS_COMPENSATE_ID psmCmpnstId);
VOID   zOss_SetIgnoreThreadTimeRate(FLOAT timeRate);
VOID   zOss_DfmSettingInit(VOID);
VOID   zOss_SetIgnoreThread(ZOSS_THREAD_ID threadId);
VOID   zOss_PsmTraceInfo(VOID);
VOID   zOss_DfmTraceInfo(VOID);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _OSS_PSM_H */


