/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_psm.h
* ļ : 
* ʵֹ : ʡģ
*      : chenxingfang
*      : V1.0
*  : 2012-08-10
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_PSM_H
#define _OSS_PSM_H
       
/**************************************************************************
* #include
**************************************************************************/
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef VOID (*PSM_SleepFunc)(SINT32 arg);  /* ʡ˯ߺ     */
typedef VOID (*PSM_SleepHookFunc)(VOID);    /* ʡ˯HOOK */ 

typedef enum 
{
    PSM_MODULE_APP = 1,     /* ϲӦ             */
    PSM_MODULE_PS,          /* Эջ               */
    PSM_MODULE_DRV          /* ²             */
}T_PSM_IdleModule;          /* ʡֵģ */       

typedef enum
{
    PSM_NO_SLEEP,
    PSM_KENEL_SLEEP,
    PSM_SHALLOW_SLEEP,
    PSM_DEEP_SLEEP,
    PSM_BOOTING_SLEEP,      /* PIN롢ֻʡ˯  */
    PSM_LOSSCOVERAGE_SLEEP, /* ʧʡ˯                 */
    PSM_AIRPLANE_SLEEP,     /* ģʽʡ˯                 */
    PSM_CHARGERING_SLEEP,   /* 翪ʡ˯                 */
    PSM_MAX_SLEEP
}T_Psm_SleepMode;           /* ˯ģʽ                         */

typedef enum
{
    PSM_BOOT_DEFAULT,       /* ʼֵ                           */
    PSM_SYSINIT_FINISH,     /* ϵͳʼ,ͺŻSysEntry  */
    PSM_BOOT_FINISH         /* ɣͺŻִ       */
}T_Psm_BootStage;           /* ׶                             */

#ifdef _USE_APPFLAG_DFM
typedef struct  
{
    UINT32  PSM_AppPowFlag;
    UINT32  PSM_AppPow;
}T_ZOss_PSM_AppPow;         /* Ӧñ־λƵṹ */
#endif

#ifdef _USE_CPU_DFM
typedef struct  
{
    UINT32  CPUCLK;
    BOOL    isUsed;
}T_ZOSS_CPU_Clock;          /* Ƶṹ */

typedef struct  
{
    UINT32  pullCpuPercent;
    UINT32  upCpuPercent;
    UINT32  downCpuPercent;
}ARMScaleCpu;               /* CPUƵֵṹ */

typedef struct 
{
    CHAR *threadname;
}PSM_IgnoreThread;          /* ߳̽ṹ */

typedef struct 
{
    UINT32  currentARMClock;
    UINT32  downARMCLock;
    UINT32  upARMClock;
    UINT32  pushARMClock;
}T_ZPSM_ARMClockSet;        /* CPUƵṹ */
#endif

#ifdef _USE_PSM  
typedef struct 
{ 
    UINT32              deepSleepTimeLen;       /* ϵͳ˯ߵķֵ                 */
    UINT32              secondSleepTimeLen;     /* ϵͳڶ˯ߵķֵ             */
    UINT32              shadowSleepTimeLen;        
    UINT32              tddT1PichSleepTimeLen;
#ifdef _USE_APPFLAG_DFM
    T_ZOss_PSM_AppPow   *appDfm;                /* δusbӦõƵ                  */
    UINT32              appDfmNum;              /* δusbӦõƵĸ            */
    T_ZOss_PSM_AppPow   *appUsbDfm;             /* usbӦõƵ                  */
    UINT32              appUsbDfmNum;           /* usbӦõƵĸ            */
#endif 
#ifdef _USE_CPU_DFM
    UINT32              minTimeLen;             /* Ƶ                       */
    UINT32              cpuThreadPrior;         /* Ƶȼ                     */
    UINT32              cpuAdjustNum;           /* ƵĴ                       */
    T_ZPSM_ARMClockSet  *desClock;              /* δusbcpuƵ               */
    UINT32              desClockNum;            /* δusbcpuƵĸ         */
    T_ZPSM_ARMClockSet  *usbDesClock;           /* usbcpuƵ               */
    UINT32              usbDesClockNum;         /* usbcpuƵĸ         */
    T_ZOSS_CPU_Clock    *minClock;              /* Ƶ                         */
    UINT32              minClockNum;
    ARMScaleCpu         scaleCpuPcnt;           /* cpuƵķֵ                    */
    PSM_IgnoreThread    *psmThreadName;         /* ̵߳                   */
    UINT32              psmThrdNameNum;         /* ̵߳ĸ                   */
    UINT32              *usbSysClk;             /* usbʱϵͳֵ֧Ƶ        */
    UINT32              usbSysClkNum;           /* usbʱϵͳֵ֧Ƶ    */
    UINT32              *sysClk;                /* δusbʱϵͳֵ֧Ƶ        */
    UINT32              sysClkNum;              /* δusbʱϵͳֵ֧Ƶ    */
#endif
    UINT32              chargeringSleepTime;    /* ˯ʱ䣬λms           */
}T_PSM_PARAM;
#endif

typedef struct 
{
    PSM_SleepHookFunc   SleepHook;  /* ϵͳ˯ǰĻص */
    PSM_SleepHookFunc   WakeupHook; /* ϵͳĻص */
}T_ZOSS_PSM_HOOK;

/**************************************************************************
* 
**************************************************************************/
VOID zOss_InstallSleep(PSM_SleepFunc shallowSleep, PSM_SleepFunc deepSleep, PSM_SleepFunc kernelSleep);
VOID zOss_InstallPsmHook(T_ZOSS_PSM_HOOK *hook);
VOID zOss_SetBootStage(T_Psm_BootStage stage);
VOID zOss_SetLcdPsmFlag(BOOL flag);
UINT32 zOss_SetAppIdle(UINT32 appId);
UINT32 zOss_SetAppActive(UINT32 appId);
UINT32 zOss_SetPSMAppIdle(UINT32 appId);
UINT32 zOss_SetPSMAppActive(UINT32 appId);
UINT32 zOss_SetDevIdle(UINT32 devId);
UINT32 zOss_SetDevActive(UINT32 devId);
UINT32 zOss_ApplyCpuFreq(UINT32 appId, BOOL isUsed);
UINT32 zOss_PsmClearArm1SleepTime(VOID);
UINT32 zOss_GetSleepTimeForGui(VOID);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _OSS_PSM_H */


