/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : oss_pub.h
* ļ : 
* ʵֹ : ͡ģššϢŶ
*      : chenxingfang
*      : V1.0
*  : 2012-08-10 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
#ifndef _OSS_PUB_H
#define _OSS_PUB_H

/**************************************************************************
* #include
**************************************************************************/
#if defined _OS_TOS
#include <pkgconf/kernel.h>
#include <cyg/hal/hal_intr.h>
#include <cyg/kernel/kapi.h>
#elif defined _OS_OSE
#include "ose.h"
#include "osetypes.h"
#include "ose_spi/arm/cpu_intlock.h"
#elif defined (_OS_LINUX)
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/jiffies.h>
#include <asm/param.h>
#ifdef _USE_TCM
#include <asm/tcm.h>
#endif
#elif defined _OS_WIN
# ifndef _USE_OS_SOCK
#define _WINSOCK2_H  
#define _WINSOCK_H 
#define _WINSOCK2API_ 
#define _WINSOCKAPI_
# endif
#include <windows.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 
**************************************************************************/
/* ϵͳ, 0x00001000 --- 0x00001fff */
#define ZOSS_ERR                (0x00001000)


/* ƽ̨Ϣ */
#define EV_ZPLAT_BASE           (0x00001000)

/* ϵͳϢ, 0x1000 */
#define EV_ZOSS_BASE            (EV_ZPLAT_BASE)

/* ƽ̨Ϣ */
#define EV_ZOSS_SCHE_BASE       (EV_ZOSS_BASE)
#define EV_ZOSS_SYSM_BASE       (EV_ZOSS_BASE + 50)
#define EV_ZOSS_EXCEP_BASE      (EV_ZOSS_BASE + 100)
#define EV_ZOSS_TRACE_BASE      (EV_ZOSS_BASE + 150)
#define EV_ZOSS_MEM_BASE        (EV_ZOSS_BASE + 300)
#define EV_ZOSS_COMM_BASE       (EV_ZOSS_BASE + 350)

/* ϵͳģϢ */
#define EV_INIT                 (EV_ZOSS_SYSM_BASE + 0) /* ʼϢ   */
#define EV_POWERON              (EV_ZOSS_SYSM_BASE + 1) /* ϵϢ     */
#define EV_POWEROFF             (EV_ZOSS_SYSM_BASE + 2) /* µϢ     */
#define EV_POWERON_OK           (EV_ZOSS_SYSM_BASE + 3) /* ϵϢ */
#define EV_PS_START             (EV_ZOSS_SYSM_BASE + 4) /* ЭջϢ   */
#define EV_TASKSTOP             (EV_ZOSS_SYSM_BASE + 5) /* ЭջͣϢ   */
#define EV_TASKRESUM            (EV_ZOSS_SYSM_BASE + 6) /* ЭջָϢ   */
#define EV_SYSM_DOWN            (EV_ZOSS_SYSM_BASE + 7) /* ػϢ         */

/* GUIϢ */
#define EV_ZGUI_BASE            (0x00002000)

/* ЭջԹϢ */
#define EV_ZPTE_BASE            (EV_ZPLAT_BASE + 0x00008000) 

/* ϵͳӡģ */
#define SUBMDL_SYSBASE          (1)
#define SUBMDL_PUB              (SUBMDL_SYSBASE + 0)    /* ϵͳ     */
#define SUBMDL_RAM              (SUBMDL_SYSBASE + 1)    /* RAMӡ    */
#define SUBMDL_FILE             (SUBMDL_SYSBASE + 2)    /* ļӡ   */
#define SUBMDL_LCD              (SUBMDL_SYSBASE + 3)    /* LCDӡ    */

/* OSSӡģ */
#define SUBMDL_OSSBASE          (10)
#define SUBMDL_COMMON           (SUBMDL_OSSBASE + 0)    /* ģ         */
#define SUBMDL_OSA              (SUBMDL_OSSBASE + 1)    /* OSAģ          */
#define SUBMDL_SCHE             (SUBMDL_OSSBASE + 2)    /* ͨѶ         */
#define SUBMDL_MEM              (SUBMDL_OSSBASE + 3)    /* ڴ         */
#define SUBMDL_SYSM             (SUBMDL_OSSBASE + 4)    /* SYSMģ         */
#define SUBMDL_TIMER            (SUBMDL_OSSBASE + 5)    /* ʱģ       */
#define SUBMDL_EXCEP            (SUBMDL_OSSBASE + 6)    /* 쳣         */
#define SUBMDL_NET              (SUBMDL_OSSBASE + 7)    /* NETģ          */
#define SUBMDL_FS               (SUBMDL_OSSBASE + 8)    /* ļģ     */
#define SUBMDL_TRACE            (SUBMDL_OSSBASE + 9)    /* traceģ        */
#define SUBMDL_TEST             (SUBMDL_OSSBASE + 10)   /* testģ         */
#define SUBMDL_EVENT            (SUBMDL_OSSBASE + 11)   /* Eventģ        */
#define SUBMDL_NV               (SUBMDL_OSSBASE + 12)   /* NVģ       */
#define SUBMDL_SHELL            (SUBMDL_OSSBASE + 13)   /* SHELLģ    */
#define SUBMDL_AMT              (SUBMDL_OSSBASE + 14)   /* AMTģ      */

/* ЭջԹģ */
#define SUBMDL_PTE              (SUBMDL_OSSBASE + 15) 

/* DRVӡģ */
#define SUBMDL_DRVBASE          (25)
#define SUBMDL_DAL              (SUBMDL_DRVBASE + 0)    /* DALģ  */
#define SUBMDL_DD               (SUBMDL_DRVBASE + 1)    /* DDģ   */
#define SUBMDL_HAL              (SUBMDL_DRVBASE + 2)    /* HALģ  */
#define SUBMDL_MUX              (SUBMDL_DRVBASE + 3)    /* MUXģ  */

#define SUBMDL_IMS              (31)                    /* IMSģ */

/* MULTIMEDIAӡģ */
#define SUBMDL_MMBASE           (60)
/* MONITORģ */
#define SUBMDL_MONAGENT         (128)

#define SUBMDL_Z_EXTMOD         (BYTE)0xff
#define SUBMDL_ZPS_EXTMOD       SUBMDL_Z_EXTMOD

/* FALSE/TRUE */
#ifndef _OS_WIN
#ifdef  TRUE
#undef  TRUE
#endif
#define TRUE    (BOOL)1
            
#ifdef  FALSE
#undef  FALSE
#endif
#define FALSE   (BOOL)0

/* ֵ/Сֵ */
#ifdef _OS_LINUX
# define oss_max(a,b)   (((a) > (b)) ? (a) : (b))
# define oss_min(a,b)   (((a) < (b)) ? (a) : (b))
#else
# define max(a,b)       (((a) > (b)) ? (a) : (b))
# define min(a,b)       (((a) < (b)) ? (a) : (b))
#endif

#endif

#ifdef _DEBUG
# define ZOSS_FILE __FILE__
# define ZOSS_LINE __LINE__
#else
# define ZOSS_FILE NULL
# define ZOSS_LINE 0
#endif

#define ___str(x)   #x
#define __str(x)    ___str(x)

#define ZOSS_UNUSED_PARAM(_name_)   _name_ = _name_;
#define ZOSS_UNUSED_PTR(_name_)     if (_name_) _name_ = _name_;
#define ZOSS_MACRO_START            do {
#define ZOSS_MACRO_END              } while (0)

#define ALIGN_TO(base, align)       ((base + (align - 1)) & ~(align - 1))
#ifndef _OS_LINUX
#define ARRAY_SIZE(array)           (sizeof(array)/sizeof(array[0]))
#endif
#define ARRAY_START(array)          (&array[0])
#define ARRAY_END(array)            (&array[sizeof(array)/sizeof(array[0])])

/* 1ϵͳδĺ */
#if defined _OS_TOS
# define ZOSS_MS_PER_TICK   (CYGNUM_HAL_RTC_PERIOD / 1000)   
#elif defined _OS_OSE
# define ZOSS_MS_PER_TICK   (system_tick() / 1000) 
#elif defined _OS_WIN
# define ZOSS_MS_PER_TICK   1
#elif defined _OS_LINUX
# define ZOSS_MS_PER_TICK   1
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
/*  */
typedef signed char         SINT8;
typedef unsigned char       UINT8;
typedef short               SINT16;
typedef unsigned short      UINT16;
typedef long                SINT32;
typedef UINT8               BITS;

#ifndef _OS_WIN
typedef unsigned long       UINT32;
typedef unsigned long long  UINT64;
typedef long long           SINT64;
typedef float               FLOAT;
typedef double              DOUBLE;
typedef int                 BOOL;

#ifndef VOID
#define VOID                void
#endif

#ifndef CHAR
#define CHAR                char
#endif
 
typedef UINT32              SSIZE_T;
typedef UINT8               BYTE;
typedef SINT16              SHORT;
typedef SINT32              LONG;
typedef UINT16              WORD;
typedef UINT32              DWORD;
typedef UINT32              HANDLE;
typedef SINT8               *PSTR;
typedef UINT8               *PBYTE;
typedef UINT16              *PWORD;
typedef UINT32              *PDWORD;
typedef VOID                *PVOID;
typedef UINT32              *PHANDLE;
#else 
typedef __int64             SINT64;  
typedef unsigned __int64    UINT64;
typedef int                 mode_t; 
#endif

#if defined (_OS_TOS) || defined(_OS_LINUX)
typedef SINT8   S8;
typedef UINT8   U8;
typedef SINT16  S16;
typedef UINT16  U16;
typedef SINT32  S32; 
typedef UINT32  U32;

typedef UINT32  PROCESS;
typedef UINT32  OSADDRESS;
typedef UINT8   OSPRIORITY;
typedef UINT32  OSTIME;
typedef UINT32  SIGSELECT;
typedef UINT16  OSVECTOR;
typedef UINT32  OSUSER;

typedef VOID (OSENTRYPOINT)(VOID);

enum PROCESS_TYPE 
{
    OS_PRI_PROC = 0,
    OS_BG_PROC  = 64,
    OS_INT_PROC = 128,
    OS_TI_PROC  = 256,
    OS_PHANTOM  = 512,
    OS_BLOCK    = 1024,
    OS_ZOOMBIE  = 2048,
    OS_ILLEGAL  = 4096
};

struct OS_redir_entry
{
    SIGSELECT   sig;
    PROCESS     pid;
};
#endif

#ifdef _OS_LINUX
typedef struct {
    int quot;   /* quotient  */
    int rem;    /* remainder */
} div_t;
#endif

/**************************************************************************
* 
**************************************************************************/ 
SINT32 zOss_GetLastError(VOID);

/**************************************************************************
* ȫֱ
**************************************************************************/

#ifdef __cplusplus
}
#endif

#endif  /* _OSS_PUB_H */


