/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : oss_event.c 
*    : oss_event.c
* ļ : 
* ʵֹ : ʵ32λ¼ӿ
*      : κ
*      : V1.0
*  : 2008/05/18
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : 
* ޸ : 2009/03/19
* ޸ : ޸ʵ
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define EVENT_CLEAR (ZOSS_EVENTS_OR_CLEAR & ZOSS_EVENTS_AND_CLEAR)  /*  */

/**************************************************************************
* ݽṹ
**************************************************************************/ 
typedef struct 
{
    UINT32              currentEvents;      /* ¼鵱ǰ               */
    T_ZOss_List         eventSuspendList;   /* ǰ߳             */
    ZOSS_MUTEX_ID       ListWriteMutex;     /* д         */
}T_ZOss_Event;                              /* ¼ƿ                   */

/* ߳Ϣ */
typedef struct
{
    T_ZOss_Node         eventNode;          /* ͷ                    */
    ZOSS_SEMAPHORE_ID   threadSem;          /* ߳ź߳  */
    UINT32              suspendOption;      /* ̷߳ʽ                  */
    UINT32              events;             /* Ҫȡ¼              */
    UINT32              eventsReceived;     /* ȡ¼              */
}T_ZOssSuspendThreadsNode;

/**************************************************************************
* : zOss_CreateEvent
* : һ32λ¼.¼ڲһ32λ
            ־32λ¼λʼΪ0
* ˵: (IN)
                name:¼
*   ֵ: ɹ:¼ID;ʧ:NULL
* ˵:
**************************************************************************/
ZOSS_EVENT_ID zOss_CreateEvent(const CHAR *name)
{
    /* ¼ƿռ */
    T_ZOss_Event *pEvent = (T_ZOss_Event *)zOss_Malloc(sizeof(T_ZOss_Event));
    zOss_AssertEx(pEvent != NULL, NULL);
    zOss_Memset(pEvent, 0, sizeof(T_ZOss_Event));
    
    /* ʼ¼ƿ */
    pEvent->currentEvents = 0;
    
    pEvent->ListWriteMutex = zOss_CreateMutex(name, ZOSS_INHERIT);
    if(pEvent->ListWriteMutex == NULL)
    {
        zOss_ASSERT(pEvent->ListWriteMutex);
        zOss_Free(pEvent);
        return NULL;
    }
    zOss_ListInit(&pEvent->eventSuspendList); /* ʼ߳ */
    
    return (ZOSS_EVENT_ID)pEvent;             /* ¼id */
}

/**************************************************************************
* : zOss_GetEvent
* : ȡ¼
* ˵: (IN)
                event_id:¼id
                events:32λ¼
                get_options:λȡ¼
                            ZOSS_EVENTS_AND:ʾeventsָ¼ǶҪ
                            ZOSS_EVENTS_OR:ʾeventsָ¼ֻҪκһ
                                                    ϼ
                            ZOSS_EVENTS_AND_CLEAR:ʾZOSS_EVENTS_ANDʽȡ,
                                                  ¼Ϊ0
                            ZOSS_EVENTS_OR_CLEAR:ʾZOSS_EVENTS_ORʽȡ,
                                                 ¼Ϊ0
                pEventsReceived:Żȡ¼־ָ,Ϊ
                timeout:ʱ.ZOSS_WAIT_FOREVER, ZOSS_NO_WAIT,ʱ
                        λ
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_GetEvent(ZOSS_EVENT_ID eventId, UINT32  events, UINT32 getOptions,
                     UINT32 *pEventsReceived, UINT32 timeout)
{
    T_ZOss_Event    *pEvent     = NULL;
    BOOL            isSatisfied = FALSE;
    UINT32          result      = 0;
    
    zOss_AssertEx(eventId != NULL && pEventsReceived != NULL && events > 0, ZOSS_ERROR);

    if (getOptions > ZOSS_EVENTS_AND_CLEAR)
    {
        return ZOSS_ERROR;  /* 붨δ */
    }
    
    pEvent = (T_ZOss_Event *)eventId;

    result = pEvent->currentEvents & events;
    /* ݲͬĻȡʽж¼Ƿ */
    if(ZOSS_EVENTS_AND & getOptions)
    {
        isSatisfied = (BOOL)(result == events);
    }
    else
    {
        isSatisfied = (BOOL)result;
    }
    /* ж¼Ƿ */
    if(isSatisfied)                  /*  */
    {
        *pEventsReceived = result;
        if(EVENT_CLEAR & getOptions) /* Ҫ */ 
        {
            pEvent->currentEvents &= ~result;
        }
        return ZOSS_SUCCESS;
    }
    else /* δ */
    {
        if(!timeout)
        {
            /*  */
            *pEventsReceived = 0;
            return ZOSS_ERROR;
        }
        else  /* ȴʽ */
        {
            static UINT32    semNameNum  = 0;
            CHAR             semName[20] = {0};
            
            /* Ҫ̵߳ĻϢʼ */
            T_ZOssSuspendThreadsNode *susThreadNode = (T_ZOssSuspendThreadsNode *)zOss_Malloc(sizeof(T_ZOssSuspendThreadsNode));
            zOss_AssertEx(susThreadNode != NULL, ZOSS_ERROR);
            
            zOss_Memset(susThreadNode, 0, sizeof(T_ZOssSuspendThreadsNode));
            sprintf((char *)semName, "%d", (unsigned int)(++semNameNum));
            susThreadNode->events        = events;
            susThreadNode->suspendOption = getOptions;
            /* ź */
            susThreadNode->threadSem = zOss_CreateSemaphore(semName, 0);
            if(susThreadNode->threadSem == NULL)
            {
                zOss_ASSERT(susThreadNode->threadSem);
                zOss_Free(susThreadNode);
                return ZOSS_ERROR;
            }
            /* ̵߳ĻϢ */
            
            /* ȡ */
            zOss_GetMutex(pEvent->ListWriteMutex, ZOSS_WAIT_FOREVER);
            /* ߳Ϣ̶߳ */
            zOss_ListAdd(&pEvent->eventSuspendList, &susThreadNode->eventNode);
            /* ͷŻ */
            zOss_PutMutex(pEvent->ListWriteMutex);
            
            /* ȡź߳ */           
            if((zOss_GetSemaphore(susThreadNode->threadSem, timeout) == ZOSS_ERROR) && (susThreadNode->threadSem != NULL)) /* ʱɾ߳еĹ߳̽ */
            {
                /* ȡ */
                zOss_GetMutex(pEvent->ListWriteMutex, ZOSS_WAIT_FOREVER);
                zOss_ListDelete(&pEvent->eventSuspendList, &susThreadNode->eventNode);
                zOss_PutMutex(pEvent->ListWriteMutex);
            }
            /* ɾźźָÿ */
            zOss_DeleteSemaphore(susThreadNode->threadSem);
            susThreadNode->threadSem = NULL;
            
            if(ZOSS_EVENTS_AND & getOptions)     /* ¼뷢 */
            {
                isSatisfied = (BOOL)(susThreadNode->eventsReceived == events);
            }
            else                         /* һ */
            {
                isSatisfied = (BOOL)(susThreadNode->eventsReceived);
            }
            *pEventsReceived = susThreadNode->eventsReceived;
            
            zOss_Free((T_ZOssSuspendThreadsNode *)susThreadNode);
            
            if(isSatisfied)
            {
                return ZOSS_SUCCESS;
            }
            else
            {
                return ZOSS_ERROR;
            }
        }        
    }
}

/**************************************************************************
* : zOss_SetEvent
* : ¼¼־λ뵱ǰ¼λ
* ˵: (IN)
                 eventId:¼id
                 events:32-bit unsigned variable that represents the requested event flags.
                 setOptions:ø¼
                            ZOSS_EVENTS_AND: eventsʹã32Ϊ㹦ܡʱeventsΪ0
                            ZOSS_EVENTS_OR eventsͬǰֵл
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_SetEvent(ZOSS_EVENT_ID eventId, UINT32  events, UINT32 setOptions)
{
    T_ZOss_Event                *pEvent     = NULL;
    BOOL                        isSatisfied = FALSE;
    UINT32                      result      = 0;
    UINT32                      status      = 0;
    T_ZOssSuspendThreadsNode    *pNode      = NULL;
    T_ZOssSuspendThreadsNode    *pNodeCopy  = NULL;

    zOss_AssertEx(eventId != NULL, ZOSS_ERROR);
    
    if((setOptions != ZOSS_EVENTS_AND) && (setOptions != ZOSS_EVENTS_OR))
    {
        return ZOSS_ERROR;
    }
    pEvent = (T_ZOss_Event *)eventId;
    
    if(setOptions == ZOSS_EVENTS_AND)
    {
        if(events == 0)
        {
            pEvent->currentEvents &= events;
            return ZOSS_SUCCESS;
        }
        else
        {
            return ZOSS_ERROR;
        }
    }

    /* ¼ */   
    result = pEvent->currentEvents;
    pEvent->currentEvents |= events;
    if ((result == pEvent->currentEvents) || (pEvent->eventSuspendList.HEAD == NULL))   /* ޸ı,޹߳*/
    {
        return ZOSS_SUCCESS;
    }

    pNode = (T_ZOssSuspendThreadsNode *)pEvent->eventSuspendList.HEAD;
    /* ȡ,Ƴ߳ */
    zOss_GetMutex(pEvent->ListWriteMutex, ZOSS_WAIT_FOREVER);
    
    /* ߳ */
    while(pNode != NULL)
    {
        UINT32 eventResult = pEvent->currentEvents & pNode->events;
        /* ݲͬĻȡʽж¼Ƿ */
        if(ZOSS_EVENTS_AND & pNode->suspendOption)
        {
            isSatisfied = (BOOL)(eventResult == pNode->events);
        }
        else
        {
            isSatisfied = (BOOL)eventResult;
        }
        if(isSatisfied)   /* ¼ */
        {
            pNodeCopy = pNode;

            pNodeCopy->eventsReceived = eventResult; /* õ¼ */
                
            if(EVENT_CLEAR & pNodeCopy->suspendOption) /* Ҫ */ 
            {
                pEvent->currentEvents &= ~pNodeCopy->eventsReceived;
            }

            if(pNode == (T_ZOssSuspendThreadsNode *)pEvent->eventSuspendList.HEAD)
            {
                /* ߳̽Ƴ */
                zOss_ListDelete(&pEvent->eventSuspendList, &pNodeCopy->eventNode);

                pNode = (T_ZOssSuspendThreadsNode *)pEvent->eventSuspendList.HEAD;
                
                /* ͷź */
                if(pNodeCopy->threadSem == NULL)
                {
                    zOss_ASSERT(pNodeCopy->threadSem);
                    return ZOSS_ERROR;
                }
                status = zOss_PutSemaphore(pNodeCopy->threadSem);
                if(status == ZOSS_ERROR)
                {
                    zOss_ASSERT(status);
                    return status;
                }
                continue;
            }
            else
            {
                /* ߳̽Ƴ */
                zOss_ListDelete(&pEvent->eventSuspendList, &pNodeCopy->eventNode);
                pNode = (T_ZOssSuspendThreadsNode *)pNodeCopy->eventNode.previous;
                
                /* ͷź */
                if(pNodeCopy->threadSem == NULL)
                {
                    zOss_ASSERT(pNodeCopy->threadSem);
                    return ZOSS_ERROR;
                }
                status = zOss_PutSemaphore(pNodeCopy->threadSem);
                if(status == ZOSS_ERROR)
                {
                    zOss_ASSERT(status);
                    return status;
                }
            }
        }
        pNode = (T_ZOssSuspendThreadsNode *)pNode->eventNode.next;
    }
    
    zOss_PutMutex(pEvent->ListWriteMutex);
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* : zOss_DeleteEvent
* : ɾ¼
* ˵: (IN)
                event_id:¼id
*   ֵ: ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵:
**************************************************************************/
UINT32 zOss_DeleteEvent(ZOSS_EVENT_ID eventId)
{
    T_ZOss_Event    *pEvent = NULL;
    SINT32          i       = 0;
    
    zOss_AssertEx(eventId != NULL, ZOSS_ERROR);

    pEvent = (T_ZOss_Event *)eventId;

    /* ߳Ϊգֱɾ¼ƿ */
    if(pEvent->eventSuspendList.HEAD == NULL)
    { 
        zOss_DeleteMutex(pEvent->ListWriteMutex);  /* ɾź */
        zOss_Free(pEvent);
        return ZOSS_SUCCESS;
    }
    else     /* ߳Ϊ */
    {
        SINT32 suspendCount = 0;
        zOss_GetMutex(pEvent->ListWriteMutex, ZOSS_WAIT_FOREVER);
        suspendCount = pEvent->eventSuspendList.count;
        for(i = 0 ; i < suspendCount; i++)
        {
            T_ZOssSuspendThreadsNode *pNode = (T_ZOssSuspendThreadsNode *)pEvent->eventSuspendList.HEAD;
            zOss_ListDelete(&pEvent->eventSuspendList, &pNode->eventNode);
            /* ָ̣߳ǻȡʧܡ */
            if(pNode->threadSem == NULL)
            {
                zOss_ASSERT(pNode->threadSem);
                return ZOSS_ERROR;
            }
            zOss_PutSemaphore(pNode->threadSem);
        }
        zOss_PutMutex(pEvent->ListWriteMutex); 
    }
    
    if(pEvent->eventSuspendList.HEAD == NULL)
    {
        zOss_DeleteMutex(pEvent->ListWriteMutex);  /* ͷŻź */
        zOss_Free(pEvent);
        return ZOSS_SUCCESS;
    }
    
    return ZOSS_ERROR ;

}
/**************************************************************************
* : zOss_QueryEvent
* :ѯ¼鵱ǰ־ֵ
* ˵: (IN)	
                event_id:¼id
*   ֵ: ¼鵱ǰ־ֵ
* ˵:  
**************************************************************************/ 
UINT32 zOss_QueryEvent(ZOSS_EVENT_ID eventId)
{
    zOss_AssertEx(eventId != NULL, ZOSS_ERROR);

    return ((T_ZOss_Event *)eventId)->currentEvents;
}

/**************************************************************************
* : zOss_WaitingEvent
* :ѯǷ̵߳ȴ¼
* ˵: (IN)	
                event_id:¼id
*   ֵ: ̵߳ȴ:True ;̵߳ȴ:False
* ˵:  
**************************************************************************/ 
BOOL zOss_WaitingEvent(ZOSS_EVENT_ID eventId)
{
    zOss_AssertEx(eventId != NULL, FALSE);

    return (((T_ZOss_Event *)eventId)->eventSuspendList.HEAD != NULL);
}

#ifdef __cplusplus
}
#endif

