/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : oss_fs.c
* ļ : ose_file_api.c,tos_file_api.c
* ʵֹ : ϲosetosϵͳļ
*      : zhangxiaofei
*      : V1.0
*  : 2012/10/19
* ˵ :          
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"

#ifdef _OS_OSE
#include "efs.h"
#include "fss.h"
#include "efs.sig"
#include "fm.sig"
#include "sys/stat.h"
#elif defined _OS_TOS
#include <cyg/io/file.h>
#include <cyg/fileio/fileio.h>
#endif

#ifdef _OS_LINUX
#include <linux/unistd.h>
#include <linux/ctype.h>
#include <linux/syscalls.h>
#include <linux/statfs.h>
#else
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <dirent.h>
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#ifdef USE_CPPS_KO
#define CPPS_KO_FUNC(func) kernel_##func
#else
#define CPPS_KO_FUNC(func) func
#endif

/**************************************************************************
* 궨
**************************************************************************/
/* #define DEBUG */
#ifdef DEBUG
# define DBG(fmt...)    zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, fmt)
#else
# define DBG(fmt...)
#endif

#ifndef _OS_WIN
#ifndef stricmp
#define stricmp strcasecmp
#endif
#endif

#define ZOSS_FS_WINPATH_LEN     3
#define ZOSS_FS_LINUXPATH_LEN   19

/**************************************************************************
* ݽṹ
**************************************************************************/
#ifdef _OS_LINUX
struct old_linux_dirent
{
    unsigned long   d_ino;
    unsigned long   d_offset;
    unsigned short  d_namlen;
    char            d_name[1];
};

typedef struct
{
    int     fd;
    long    offset;
    long    total_len;
    char    *buf;
    long    size;
} oss_dir_t;
#endif

typedef struct
{
    T_ZOss_Node node;
    CHAR        winPath[ZOSS_FS_WINPATH_LEN+1];       /* windows·     */
    CHAR        linuxPath[ZOSS_FS_LINUXPATH_LEN+1];   /* linux·     */
}T_zOss_FsPathMapNode;

/**************************************************************************
* ȫֳ/
**************************************************************************/
static T_DISK_PARAM *gDiskParam                 = NULL;
static T_ZOss_List   g_zFsPathDynamicMapList    = {0}; /* ·̬ӳ */
static ZOSS_MUTEX_ID g_zFsPathMapMutex          = NULL;

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣOsa_GetLinuxPathByWinPath
* winPathȡLinuxPath
* ˵(IN) 
*               pWinPath:window·
*   ֵɹ:linuxPath;ʧ:NULL.
* ˵
**************************************************************************/ 
static CHAR* Osa_GetLinuxPathByWinPath(const CHAR *pWinPath)
{    
    UINT32 i;
    T_zOss_FsPathMapNode *pFsPathNode = NULL;

    zOss_AssertEx(pWinPath, NULL);
    DBG("Osa_GetLinuxPathByWinPath windows path: %s\n", pWinPath);

    /*̬ӳ*/
    for (i = 0; i < gDiskParam->diskNum; i++)
    {
        if (tolower(pWinPath[0]) == tolower(gDiskParam->diskMap[i].WinDisk[0]))
            return gDiskParam->diskMap[i].LinuxPath;
    }

    /*̬ӳ*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    while( pFsPathNode != NULL)
    {
       if (tolower(pFsPathNode->winPath[0]) == tolower(pWinPath[0])) //Ƚ̷
       {
            zOss_PutMutex(g_zFsPathMapMutex);
            return pFsPathNode->linuxPath;
       }
       pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListNext(&(pFsPathNode->node));
    }
    zOss_PutMutex(g_zFsPathMapMutex);

    zOss_AssertEx(0, NULL);

    return NULL;
}

/**************************************************************************
* ƣOsa_GetWinPathByLinuxPath
* LinuxPathȡwinPath
* ˵(IN) 
*               pWinPath:   linux·
*               pPath:      linux·
*   ֵɹ:ZOSS_SUCCESS;ʧ:NULL.
* ˵
**************************************************************************/ 
static CHAR* Osa_GetWinPathByLinuxPath(const CHAR *pLinuxPath, CHAR **pPath)
{    
    UINT32 i;
    T_zOss_FsPathMapNode *pFsPathNode = NULL;

    zOss_AssertEx(pLinuxPath && pPath, NULL);
    DBG("Osa_GetWinPathByLinuxPath linux path: %s\n", pLinuxPath);

    /*Ѿ̬ӳ*/
    for (i = 0; i < gDiskParam->diskNum; i++ )
    {
        if (0 == strncasecmp(pLinuxPath, (char *)gDiskParam->diskMap[i].LinuxPath, strlen(gDiskParam->diskMap[i].LinuxPath)))
        {
            *pPath = (CHAR *)(pLinuxPath + strlen(gDiskParam->diskMap[i].LinuxPath));
            DBG("Osa_GetWinPathByLinuxPath windows path: %s\n", *pPath);
            return gDiskParam->diskMap[i].WinDisk;
        }
    }

    /*Ѷ̬ӳ*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    while( pFsPathNode != NULL)
    {
       if (0 == strncasecmp(pLinuxPath, pFsPathNode->linuxPath, strlen(pFsPathNode->linuxPath)))
       {
            zOss_PutMutex(g_zFsPathMapMutex);
            *pPath = (CHAR *)(pLinuxPath + strlen(gDiskParam->diskMap[i].LinuxPath));
            DBG("Osa_GetWinPathByLinuxPath windows path: %s\n", *pPath);
            return pFsPathNode->winPath;
       }
       pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListNext(&(pFsPathNode->node));
    }
    zOss_PutMutex(g_zFsPathMapMutex);

    zOss_AssertEx(0, NULL);

    return NULL;
}

/**************************************************************************
* ƣOsa_WinToLinuxPathMap
* windows·ӳlinux·
* ˵(IN) 
*               pWinPath:window·
*               pLinuxPath:linux·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵
**************************************************************************/ 
static UINT32 Osa_WinToLinuxPathMap(const CHAR *pWinPath, CHAR *pLinuxPath)
{
    CHAR    *pSrcPos        = NULL;
    CHAR    *pDestPos       = NULL;
#ifdef DEBUG
    CHAR    *str            = pLinuxPath;
#endif

    zOss_AssertEx(pWinPath && *pWinPath && pLinuxPath, ZOSS_ERROR);
    DBG("Osa_WinToLinuxPathMap windows path: %s\n", pWinPath);

    if (pWinPath[1] == ':') //·
    {
        pDestPos = Osa_GetLinuxPathByWinPath(pWinPath);
        if (pDestPos == NULL)
        {
            zOss_AssertEx(0, ZOSS_ERROR);
            return ZOSS_ERROR;
        }
        strcpy((char *)pLinuxPath, (char *)pDestPos);
        pLinuxPath += strlen((char *)pDestPos);
        pSrcPos    =  (CHAR *)&pWinPath[2];
    }
    else //·̷һĸ
    {
        pSrcPos = (CHAR *)strchr((char *)pWinPath, ':');
        if (pSrcPos != NULL)
        {
            zOss_AssertEx(0, ZOSS_ERROR);
            return ZOSS_ERROR;
        }
        pSrcPos = (CHAR *)pWinPath;
    }
    
    while (*pSrcPos != '\0')
    {
        *pLinuxPath = '\\' != *pSrcPos ? *pSrcPos : '/';
        pLinuxPath++;
        pSrcPos++;
    }
    *pLinuxPath = '\0';

    DBG("Osa_WinToLinuxPathMap linux path: %s\n", str);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣOsa_LinuxToWinPathMap
* linux·ӳwindows·
* ˵(IN) 
*               pLinuxPath : linux·
*               pWinPath   : window·
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵
**************************************************************************/ 
static UINT32 Osa_LinuxToWinPathMap(const CHAR *pLinuxPath, CHAR * pWinPath)
{
    CHAR   *pSrcPos     = NULL;
    CHAR   *pDestPos    = NULL;
#ifdef DEBUG
    CHAR    *str        = pWinPath;
#endif

    zOss_AssertEx(pLinuxPath && pWinPath, ZOSS_ERROR);
    DBG("Osa_LinuxToWinPathMap linux path: %s\n", pLinuxPath);

    if ('/' != *pLinuxPath)
    {
        zOss_AssertEx(0, ZOSS_ERROR);
        return ZOSS_ERROR;
    }

    pDestPos = Osa_GetWinPathByLinuxPath(pLinuxPath, &pSrcPos);
    if (pDestPos == NULL || pSrcPos == NULL)
    {
        zOss_AssertEx(0, ZOSS_ERROR);
        return ZOSS_ERROR;
    }
    strcpy(pWinPath, (char *)pDestPos);
    pWinPath += strlen((char *)pDestPos);

    while(*pSrcPos != '\0')
    {
        *pWinPath = ((*pSrcPos == '/') ? '\\' : *pSrcPos);
        pWinPath++;
        pSrcPos++;
    }
    *pWinPath = '\0';

    DBG("Osa_LinuxToWinPathMap windows path: %s\n", str);

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣVerifyDisk
* ȷ̷
* ˵(IN)   src_win:̷
*   ֵɹ:̷;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
static UINT32 VerifyDisk(const CHAR *src_win)
{
    UINT32 i = 0;

    for (; i < gDiskParam->diskNum; i++)
    {
        if (!strncasecmp((const char *)src_win, (const char *)gDiskParam->diskMap[i].WinDisk, 1))
        {
            return i;
        }
    }

    return ZOSS_ERROR;
}

#ifdef _OS_OSE
/**************************************************************************
* ƣOsa_GetFsVolume
* ȡļϵͳϢ
* ˵vmPid:      ļϵͳ߳id
            total_size: ļϵͳܴСŵַ
            free_size:  ļϵͳдСŵַ
            used_size:  ļϵͳʹôСŵַ
*   ֵȡļϵͳϢǷɹ
* ˵void
**************************************************************************/ 
static EfsStatus Fs_GetVolumeInfo(PROCESS vmPid,UINT64 *total_size,UINT64 *free_size,UINT64 *used_size)
{   
    EfsStatus              status   = 0;
    static const SIGSELECT sigsel[] = {2, OS_ATTACH_SIG, FM_EXAMINE_VOL_REPLY};
    struct FmExamineVolReply *reply = NULL;
    OSATTREF                 ar     = attach(NULL, vmPid);

    sendFmExamineVolRequest(vmPid);    
    reply = (struct FmExamineVolReply *)receive((SIGSELECT *)sigsel);    
    if (reply->sigNo == FM_EXAMINE_VOL_REPLY)
    {
        detach(&ar);
        if (reply->status == EFS_SUCCESS)
        {
            struct FmVolumeInfo *vi = &reply->info;
         
            *total_size = vi->blockSize * ((vi->hiBlock - vi->loBlock) + 1);
            *free_size  = vi->blockSize * (vi->freeBlocks);
            *used_size  = *total_size - *free_size;
        }
        status = reply->status;
    }
    else /* Received attach signal, VM terminated before sending reply. */
    {
        status = EFS_SUCCESS; /* Silent ignore. */
    }
 
    free_buf((union SIGNAL **)&reply);

    return status;
}

/**************************************************************************
* ƣFS_Get_VmPid
* ȡļϵͳ߳ID
* ˵
            (IN)
                disk: ̷
*   ֵvmPid
* ˵void
**************************************************************************/ 
static PROCESS Fs_Get_VmPid(const CHAR *disk)
{
    PROCESS vmPid                   = 0;
    static const SIGSELECT sigsel[] = {1, HUNT_FSS};
    static const SIGSELECT fssSig[] = {1, FSS_RESOLVE_REPLY};
    union SIGNAL *sig   = alloc(sizeof(SIGSELECT), HUNT_FSS);
    union SIGNAL *sig_p = NULL;
    
    hunt( "ose_fss", 0, NULL, &sig);
    sig = receive(sigsel);
    sendFssResolveRequest((const char *)disk, FSS_TYPE_VOLUME, FSS_TMO_NONE, sender(&sig)); 
    free_buf(&sig);
    sig_p = receive(fssSig);
    vmPid = sender(&sig_p);
    free_buf(&sig_p);
    return vmPid;
}
#endif

#ifdef _OS_LINUX
/*******************************************************************************
* :     ׼typeתPOSIXflags
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static int libc_type_to_posix_flags(const char *file_name, const char *type)
{
    int fd;
    int flags = O_RDONLY;

    zOss_ASSERT(type != NULL);

    if (strcmp(type, "r") == 0 || strcmp(type, "rb") == 0) {
        flags = O_RDONLY;
    } else if (strcmp(type, "w") == 0 || strcmp(type, "wb") == 0) {
        flags = O_WRONLY;
        fd = CPPS_KO_FUNC(sys_open)(file_name, O_RDONLY, 0);
        if (fd == -ENOENT)
            flags |= O_CREAT;
        else
            sys_close(fd);
    } else if (strcmp(type, "a") == 0 || strcmp(type, "ab") == 0) {
        flags = O_APPEND;
    } else if (strcmp(type, "r+") == 0 || strcmp(type, "r+b") == 0 || strcmp(type, "rb+") == 0) {
        flags = O_RDWR;
    } else if (strcmp(type, "w+") == 0 || strcmp(type, "w+b") == 0 || strcmp(type, "wb+") == 0) {
        flags = O_RDWR;
        fd = CPPS_KO_FUNC(sys_open)(file_name, O_RDONLY, 0);
        if (fd == -ENOENT)
            flags |= O_CREAT;
        else {
            flags |= O_TRUNC;
            sys_close(fd);
        }
    } else if (strcmp(type, "a+") == 0 || strcmp(type, "a+b") == 0 || strcmp(type, "ab+") == 0) {
        flags = O_RDWR | O_APPEND;
        fd = CPPS_KO_FUNC(sys_open)(file_name, O_RDONLY, 0);
        if (fd == -ENOENT)
            flags |= O_CREAT;
        else
            sys_close(fd);
    }

    return flags;
}
#endif

/**************************************************************************
* ƣFs_GetDiskSpace
* ȡʣռ䣻
* ˵
            (IN)
                diskname: ̷
                isTotal:  TRUE:FALSE:ʣռ䡣
            (OUT)
                space:    ̿ռ    
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵void
**************************************************************************/ 
UINT32 Fs_GetDiskSpace(CHAR diskname, UINT64 *space, BOOL isTotal)
{
    UINT32  uiRet;
    
    zOss_AssertEx(space != NULL, ZOSS_ERROR);

#ifndef _OS_TOS
    uiRet = VerifyDisk(&diskname);
    if (uiRet == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }
#endif

#ifdef _OS_OSE
    EfsStatus status    = 0;
    PROCESS vmPid       = 0;
    UINT64  total_space = 0;
    UINT64  free_space  = 0;
    UINT64  used_space  = 0;

    vmPid  = Fs_Get_VmPid(gDiskParam->diskMap[uiRet].LinuxPath);
    status = Fs_GetVolumeInfo(vmPid, &total_space, &free_space, &used_space);
    if (status == EFS_SUCCESS)
    {
        if(isTotal)
        {
            *space = total_space;
        }
        else
        {
            *space = free_space;
        }

        return ZOSS_SUCCESS;
    }
    
    return ZOSS_ERROR;
#elif defined (_OS_TOS)
    struct cyg_fs_disk_usage info;

    if (isTotal)
    {
        uiRet = cyg_fs_getinfo(Osa_GetLinuxPathByWinPath(&diskname), FS_INNO_DISK_CAPACITY, 
                               &info, sizeof(struct cyg_fs_disk_usage));
        zOss_AssertEx((uiRet == ENOERR), ZOSS_ERROR);
        *space = (UINT64)info.block_size * info.total_blocks; 
    }
    else
    {
        uiRet = cyg_fs_getinfo(Osa_GetLinuxPathByWinPath(&diskname), FS_INFO_DISK_USAGE, 
                               &info, sizeof(struct cyg_fs_disk_usage));
        zOss_AssertEx((uiRet == ENOERR), ZOSS_ERROR);
        *space = (UINT64)info.block_size * info.free_blocks;
    }
    
    return ZOSS_SUCCESS;
#elif defined (_OS_LINUX)
    struct statfs statfs;

    uiRet = CPPS_KO_FUNC(sys_statfs)((const char *)&gDiskParam->diskMap[uiRet].LinuxPath, &statfs);
    if (uiRet != 0x00)
        return ZOSS_ERROR;

    if (isTotal)
        *space = statfs.f_blocks * statfs.f_bsize;
    else
        *space = statfs.f_bfree * statfs.f_bsize;

    return ZOSS_SUCCESS;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣzOss_FCreate
* ļ
* ˵(IN)  filename:ļ,windows·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR.
* ˵OSEļڶΪļԣΪɶд
**************************************************************************/ 
UINT32 zOss_FCreate(const CHAR *filename)
{
#ifdef _OS_TOS
    UINT32  status                                  = 0;
    CHAR    dest_linux[ZOSS_MAX_FILENAME_LEN + 1]   = {0};

    zOss_AssertEx(filename != NULL, ZOSS_ERROR);

    status = Osa_WinToLinuxPathMap(filename, dest_linux);

    if (ZOSS_SUCCESS == status)
    {
        SINT32 result = creat((char *)dest_linux, S_IRUSR | S_IWUSR);/* ɹfd-1 */

        if (result == -1)
        {
            status = ZOSS_ERROR;
        }
        else
        {
            close(result);/* رļ */
            status = ZOSS_SUCCESS;
        }
    }

    return status;
#elif defined (_OS_LINUX)
    long    fd;
    UINT32  ret;
    CHAR    path_name[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(filename != NULL, ZOSS_ERROR);
    DBG("zOss_FCreate filename: %s\n", filename);

    ret = Osa_WinToLinuxPathMap(filename, path_name);
    if (ret != ZOSS_SUCCESS)
        return ret;

    fd = CPPS_KO_FUNC(sys_creat)((const char *)path_name, S_IRUSR | S_IWUSR);
    if (fd < 0)
        return ZOSS_ERROR;

    sys_close(ret);

    return ZOSS_SUCCESS;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣ zOss_FOpen
* һļ
* ˵(IN)  filename:ļ,windows·
                  mode:򿪷ʽ.
                      "r": Open text file for reading. 
                      "w": Truncate to zero length or create text file for writing. 
                      "a": Append; open or create text file for writing at end of file. 
                      "rb": Open binary file for reading. 
                      "wb": Truncate to zero length or create binary file for writing. 
                      "ab": Append; open or create binary file for writing at end of file 
                      "r+": Open text file for update (reading and writing). 
                      "w+": Truncate to zero length or create text file for update. 
                      "a+": Append open or create text file for update, writing at end of file. 
                      "r+b" or "rb+": Open binary file for update (reading and writing). 
                      "w+b" or "wb+": Truncate to zero length or create binary file for update. 
                      "a+b" or "ab+": Append; open or create binary file for update, writing at end of file. 
*   ֵ ɹ:ļָ;ʧ:ZOSS_NULL.
* ˵ OSEϵͳУصļָֻɵõ߳ʹã߳ʹûļдɹ
**************************************************************************/ 
FILE *zOss_FOpen(const CHAR * filename, const CHAR * mode)
{
#ifdef _OS_TOS
    UINT32  status                                  = 0;
    CHAR    dest_linux[ZOSS_MAX_FILENAME_LEN + 1]   = {0};
    FILE    *pfile                                  = NULL;

    zOss_AssertEx(filename != NULL && mode != NULL, ZOSS_NULL);

    status = Osa_WinToLinuxPathMap(filename, dest_linux);

    if (ZOSS_SUCCESS == status)
    {
        pfile = fopen((char *)dest_linux, (char *)mode);
    }
    else
    {
        pfile = ZOSS_NULL;
    }

    return pfile;
#elif defined (_OS_LINUX)
    UINT32  ret;
    int     fd, flags;
    CHAR    file_name[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(filename != NULL, NULL);
    DBG("zOss_FOpen filename: %s\n", filename);

    ret = Osa_WinToLinuxPathMap(filename, file_name);
    if (ret != ZOSS_SUCCESS)
        return NULL;

    flags = libc_type_to_posix_flags((const char *)file_name, mode);
    fd = CPPS_KO_FUNC(sys_open)((const char *)file_name, flags, 0);
    if (fd < 0)
    	return NULL;
	
    return (FILE *)fd;
#else
    return NULL;
#endif
}

/**************************************************************************
* ƣzOss_FSeek
* λļеĶдλ
* ˵(IN)   fd: ļ,zOss_Open()ķֵ
                   offset:ԭʼλÿʼҪƶƫ
                   whence:
                        ZOSS_SEEK_SET :ļʼ
                        ZOSS_SEEK_CUR :ǰλ
                        ZOSS_SEEK_END :ļβ
*   ֵɹ:ZOSS_SUCCESS;ʧ:.
* ˵
**************************************************************************/ 
UINT32 zOss_FSeek(FILE *stream, SINT32 offset, SINT32 whence)
{ 
    switch (whence)
    {
    case ZOSS_SEEK_CUR:
        {
            whence = SEEK_CUR;
            break;
        }        
    case ZOSS_SEEK_SET:
        {
            whence = SEEK_SET;
            break;
        }        
    case ZOSS_SEEK_END:
        {
            whence = SEEK_END;
            break;
        }        
    default:
        {
            return ZOSS_ERROR;
        }
    }   

#ifdef _OS_TOS
    zOss_AssertEx(stream != NULL, ZOSS_ERROR);
    if (fseek(stream, (long)offset, whence) == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    if (CPPS_KO_FUNC(sys_lseek)((unsigned int)stream, (off_t)offset, (unsigned int)whence) >= 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_FRead
* ļ
* ˵(IN)    data:Ŷȡݵڴָ
                    size:ݵԪĴС
                    count:ȡĸ
                    stream:ļָ
*   ֵʵʶȡݵԪ
* ˵
**************************************************************************/ 
SSIZE_T zOss_FRead(VOID *data, SSIZE_T size, SSIZE_T count, FILE *stream)
{
    zOss_AssertEx(data != NULL && count > 0 && size != 0, 0);

#ifdef _OS_TOS
    zOss_AssertEx(stream != NULL, 0);
    return (SSIZE_T)fread(data, (size_t)size, (size_t)count, stream);
#elif defined (_OS_LINUX)
    return (SSIZE_T)CPPS_KO_FUNC(sys_read)((unsigned int)stream, (char *)data, (size_t)size*count);
#else
    return 0x00;
#endif
}

/**************************************************************************
* ƣzOss_FWrite
* дļ
* ˵(IN)    data:дݵڴָ
                    size:ݵԪĴС
                    count:дĸ
                    stream:ļָ
*   ֵʵдݵԪ
* ˵
**************************************************************************/ 
SSIZE_T zOss_FWrite(const VOID *data, SSIZE_T size, SSIZE_T count, FILE *stream)
{
    zOss_AssertEx(data != NULL && count > 0 && size != 0, 0);    

#ifdef _OS_TOS
    zOss_AssertEx(stream != NULL, 0);
    return (SSIZE_T)fwrite(data, (size_t)size, (size_t)count, stream);
#elif defined (_OS_LINUX)
    return (SSIZE_T)CPPS_KO_FUNC(sys_write)((unsigned int)stream, (const char *)data, (size_t)size*count);
#else
    return 0x00;
#endif
}

/**************************************************************************
* ƣzOss_FEof
* Ƿļβ
* ˵(IN)    stream:ļָ
*   ֵʾǰļָѵļβ,ʾû
* ˵
**************************************************************************/ 
UINT32 zOss_FEof(FILE *stream)
{
#ifdef _OS_TOS
    zOss_AssertEx(stream != NULL, 0);
    return (UINT32)feof(stream);
#elif defined (_OS_LINUX)
    char c;
    int ret;

    ret = CPPS_KO_FUNC(sys_read)((unsigned int)stream, &c, sizeof(c));
    if (ret == 0)
        return true;
    else
        return false;
#else
    return 0x00;
#endif
}

/**************************************************************************
* ƣzOss_FError
* ȡļ
* ˵(IN)    stream:ļָ
*   ֵ⵽󷵻ط0 ֵ򣬷0
* ˵
**************************************************************************/ 
UINT32 zOss_FError(FILE *stream)
{
#ifdef _OS_TOS
    zOss_AssertEx(stream != NULL, ZOSS_ERROR);
    return (UINT32)ferror(stream);
#elif defined (_OS_LINUX)
    return 0x00;
#else
    return 0x00;
#endif
}

/**************************************************************************
* ƣzOss_FTruncate
* üļС
* ˵(IN)    stream:ļָ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵ļstreamԸдķʽ.
**************************************************************************/ 
UINT32 zOss_FTruncate(FILE *stream, UINT32 size)
{
    int     result  = 0;
    int     fd      = 0;

#ifdef _OS_TOS    
    zOss_AssertEx(stream != NULL, ZOSS_ERROR);
    result  = fflush(stream);
    fd      = fileno(stream);
    result  =  ftruncate(fd, (off_t)size);
    if (result == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    ret = CPPS_KO_FUNC(sys_ftruncate)((unsigned int)stream, (unsigned long)size);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣ zOss_FFlush
*  ͬļļڵдļ
* ˵ (IN)    stream:ļָ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_FFlush(FILE *stream)
{  
#ifdef _OS_TOS
	zOss_AssertEx(stream != NULL, ZOSS_ERROR);
    if (fflush(stream) == -1)
    {
        return ZOSS_ERROR;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
#elif defined (_OS_LINUX)
    int ret;

    ret = CPPS_KO_FUNC(sys_fsync)((unsigned int)stream);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣ zOss_FTell
*  شļʼĵǰļָλ
* ˵ (IN)    stream:ļָ
*   ֵɹ:ļʼĵǰļָλ;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_FTell(FILE *stream)
{
    long result = 0;

#ifdef _OS_TOS
    zOss_AssertEx(stream != NULL, ZOSS_ERROR);
    result = ftell(stream);

    if (result == EOF)
    {
        return ZOSS_ERROR;
    }
    else
    {
        return(UINT32)result;
    }
#elif defined (_OS_LINUX)
    result = CPPS_KO_FUNC(sys_lseek)((unsigned int)stream, 0x00, SEEK_CUR);
#endif

    return result;
}

/**************************************************************************
* ƣzOss_FClose
* رļ
* ˵(IN)   stream:ļָ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_FClose(FILE *stream)
{
#ifdef _OS_TOS
	zOss_AssertEx(stream != NULL, ZOSS_ERROR);
    if (fclose(stream) == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    ret = sys_close((unsigned int)stream);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_FRename
* ļ
* ˵(IN)   old_filename:ԭļ,windows·
                   new_filename:ļ,windows·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_FRename(const CHAR *old_filename, const CHAR *new_filename)
{
    CHAR old_dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};
    CHAR new_dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(old_filename != NULL && new_filename != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(old_filename, old_dest_linux) == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }
    if (Osa_WinToLinuxPathMap(new_filename, new_dest_linux) == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_TOS
    /*The destination will be removed if it exists by calling rename()*/
    if (access((char *)new_dest_linux, F_OK) == 0)
    {
        return ZOSS_ERROR;    
    }

    if (rename((char *)old_dest_linux, (char *)new_dest_linux) == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_FRename old_filename: %s, new_filename: %s\n", old_filename, new_filename);

    ret = CPPS_KO_FUNC(sys_rename)((const char *)old_dest_linux, (const char *)new_dest_linux);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_FDelete
* ɾļ
* ˵(IN)   filename:ļ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32  zOss_FDelete(const CHAR * filename)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(filename != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(filename, dest_linux) != ZOSS_SUCCESS)
        return ZOSS_ERROR;

#ifdef _OS_TOS
    if (remove((char *)dest_linux) == 0)
        return ZOSS_SUCCESS;
#elif defined (_OS_LINUX)
    DBG("zOss_FDelete filename: %s\n", filename);
    if (CPPS_KO_FUNC(sys_unlink)((char *)dest_linux) == 0)
        return ZOSS_SUCCESS;
#endif

    return ZOSS_ERROR;   
}

/**************************************************************************
* ƣzOss_FLength
* ȡļ
* ˵(IN)   stream:ļָ
*   ֵļ
* ˵OSE֧
**************************************************************************/ 
UINT32 zOss_FLength(FILE *stream)
{
    int         fd  = 0;
    struct stat buf = {0};

#ifdef _OS_TOS
	zOss_AssertEx(stream != NULL, 0);
    fd = fileno( stream );
    
    if( -1 == fd || 0 != fstat(fd, &buf))
    {
        return 0;
    }
#elif defined (_OS_LINUX)
    if(0 != CPPS_KO_FUNC(sys_newfstat)((unsigned int)stream, &buf))
    {
        return 0;
    }
#endif

    return (UINT32)buf.st_size;
}

/**************************************************************************
* ƣzOss_FExist
* бļǷ
* ˵(IN)   filename:ļ,windows·
*   ֵ:TRUE;:FALSE
* ˵бļĿ¼Ƿ
**************************************************************************/ 
BOOL zOss_FExist(const CHAR *filename)
{    
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(filename != NULL, FALSE);

    if (Osa_WinToLinuxPathMap(filename, dest_linux) != ZOSS_SUCCESS)
    {
        return FALSE;
    }

#ifdef _OS_TOS
    if (access((char *)dest_linux, F_OK) == 0)
    {
        return TRUE;
    }
    else
    {
        return FALSE;    
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_FExist filename: %s\n", filename);
    ret = CPPS_KO_FUNC(sys_access)((const char *)dest_linux, S_IROTH);
    if (ret == 0)
        return true;
    else
        return false;
#else
    return FALSE;
#endif
}

/**************************************************************************
* ƣzOss_Mkdir
* Ŀ¼
* ˵(IN)   dirname:Ŀ¼,windows·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR 
* ˵OSEĿ¼ڶΪĿ¼ԣΪûɶд
**************************************************************************/ 
UINT32 zOss_Mkdir(const CHAR * dirname)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(dirname != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(dirname, dest_linux) != ZOSS_SUCCESS)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_TOS
    if (mkdir((char *)dest_linux, S_IRWXU) == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_Mkdir dirname: %s\n", dirname);
    ret = CPPS_KO_FUNC(sys_mkdir)((const char *)dest_linux, S_IRWXU);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_Rmdir
* ɾĿ¼
* ˵(IN)   dirname:Ŀ¼,windows·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_Rmdir(const CHAR * dirname)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(dirname != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(dirname, dest_linux) != ZOSS_SUCCESS)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_TOS
    if (rmdir((char *)dest_linux) == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_Rmdir dirname: %s\n", dirname);
    ret = CPPS_KO_FUNC(sys_rmdir)((const char *)dest_linux);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_Rndir
* Ŀ¼
* ˵(IN)   old_dirname:ԭĿ¼,windows·
                   new_dirname:Ŀ¼,windows·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵windows·
**************************************************************************/ 
UINT32 zOss_Rndir(const CHAR * old_dirname, const CHAR *new_dirname)
{
    CHAR old_dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};
    CHAR new_dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(old_dirname != NULL && new_dirname != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(old_dirname, old_dest_linux) != ZOSS_SUCCESS)
    {
        return ZOSS_ERROR;
    }

    if (Osa_WinToLinuxPathMap(new_dirname, new_dest_linux) != ZOSS_SUCCESS)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_TOS    
    if (rename((char *)old_dest_linux, (char *)new_dest_linux) == 0)
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_Rndir old_dirname: %s, new_dirname: %s\n", old_dirname, new_dirname);
    ret = CPPS_KO_FUNC(sys_rename)((const char *)old_dest_linux, (const char *)new_dest_linux);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_GetPwd
* ȡǰĿ¼
* ˵(IN)   dirname:Ŀ¼,windows·
                   dirnamelen:Ŀ¼
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵ǰ·dirnamelen
**************************************************************************/ 
UINT32 zOss_GetPwd(CHAR *dirname, UINT32 dirnamelen)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1]  = {0};
    UINT32  dirlen                              = 0;

    zOss_AssertEx(dirname != NULL, ZOSS_ERROR);

#ifdef _OS_TOS
    if (NULL != getcwd((char *)dest_linux, dirnamelen))
    {
        if (0 == strcmp((char *)dest_linux, "/"))
        {
            chdir((char *)gDiskParam->diskMap[0].LinuxPath);
            
            if (NULL == getcwd((char *)dest_linux, dirnamelen))
            {
                return ZOSS_ERROR;
            }
        }

        Osa_LinuxToWinPathMap(dest_linux, dirname);

        dirlen = strlen((const char *)dirname);
        
        if (dirname[dirlen-1] == '\\' && dirlen != 3)
        {
            dirname[dirlen-1] = '\0';
        }

        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    if (CPPS_KO_FUNC(sys_getcwd)((char *)dest_linux, dirnamelen) >= 0) {
        if (strcmp((char *)dest_linux, "/") == 0) {
            CPPS_KO_FUNC(sys_chdir)((char *)gDiskParam->diskMap[0].LinuxPath);
            if (CPPS_KO_FUNC(sys_getcwd)((char *)dest_linux, dirnamelen) < 0)
                return ZOSS_ERROR;
        }

        Osa_LinuxToWinPathMap(dest_linux, dirname);
        dirlen = strlen((const char *)dirname);        
        if (dirname[dirlen-1] == '\\' && dirlen != 3)
            dirname[dirlen-1] = '\0';
        DBG("zOss_GetPwd dirname: %s\n", dirname);

        return ZOSS_SUCCESS;
    } else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_ChDir
* õǰ·
* ˵(IN)   dirname:Ŀ¼
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_ChDir(CHAR * dirname)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(dirname != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(dirname, dest_linux) == ZOSS_ERROR)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_TOS
    if (0 == chdir((char *)dest_linux))
    {
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_ChDir dirname: %s\n", dirname);
    ret = CPPS_KO_FUNC(sys_chdir)((const char *)dest_linux);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_IsDir
* бǷΪĿ¼
* ˵(IN)   dirname:Ŀ¼,windows·
*   ֵĿ¼:TRUE;ļ:FALSE
* ˵OSEб
**************************************************************************/ 
BOOL zOss_IsDir(const CHAR *dirname)
{
    struct stat buf                                 = {0};
    CHAR    dest_linux[ZOSS_MAX_FILENAME_LEN + 1]   = {0};

    zOss_AssertEx(dirname != NULL, FALSE);

    if (Osa_WinToLinuxPathMap(dirname, dest_linux) != ZOSS_SUCCESS)
    {
        return FALSE;
    }

#ifdef _OS_TOS
    if (stat((char *)dest_linux, &buf) == 0 && S_ISDIR(buf.st_mode))
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
#elif defined (_OS_LINUX)
    int ret;

    DBG("zOss_IsDir dirname: %s\n", dirname);
    ret = CPPS_KO_FUNC(sys_newstat)((const char *)dest_linux, &buf);
    if (ret == 0 && S_ISDIR(buf.st_mode))
        return true;
    else
        return false;
#endif
    return FALSE;
}

/**************************************************************************
* ƣ zOss_OpenDir
* ָĿ¼ȡĿ¼
* ˵ (IN)   dirname:Ŀ¼,windows·
             (OUT)  dir_entry_ptr:Ŀ¼
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_OpenDir(const CHAR *dirname, VOID **dir_entry_ptr)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1]  = {0};

    zOss_AssertEx(dirname != NULL, ZOSS_ERROR);
    zOss_AssertEx(dir_entry_ptr != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(dirname, dest_linux) != ZOSS_SUCCESS)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_TOS
    *dir_entry_ptr = opendir((char *)dest_linux);

	if (NULL == *dir_entry_ptr)
	{
		return ZOSS_ERROR;	  
	}
	else
	{
		return ZOSS_SUCCESS;
	} 

#elif defined (_OS_LINUX)
    int fd, ret;
    oss_dir_t *dir;
    struct stat stat_buf;

    DBG("zOss_OpenDir dirname: %s\n", dirname);
    fd = CPPS_KO_FUNC(sys_open)(dest_linux, O_RDONLY | O_DIRECTORY, 0);
    if (fd < 0)
        return ZOSS_ERROR;

    ret = CPPS_KO_FUNC(sys_newfstat)(fd, &stat_buf);
    if (ret < 0) {
        sys_close(fd);
        return ZOSS_ERROR;
    }

    dir = (oss_dir_t *)malloc(sizeof(oss_dir_t));
    memset(dir, 0, sizeof(oss_dir_t));

    dir->fd     = fd;
    dir->offset = 0;
    dir->size   = stat_buf.st_blksize;
    dir->buf    = (char *)malloc(dir->size);
    memset(dir->buf, 0, dir->size);

    *dir_entry_ptr = dir;
    
    return ZOSS_SUCCESS; 
#endif

}

/**************************************************************************
* ƣOSS_CloseDir
* رĿ¼
* ˵(IN)   dir_entry_ptr:Ŀ¼;
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_CloseDir(VOID **dir_entry_ptr)
{
    zOss_AssertEx(dir_entry_ptr != NULL, ZOSS_ERROR);
    
#ifdef _OS_TOS
    if (closedir((DIR *)*dir_entry_ptr) == 0)
    {
        return ZOSS_SUCCESS;    
    }
    else
    {
        return ZOSS_ERROR;
    }
#elif defined (_OS_LINUX)
    int ret;
    oss_dir_t *oss_dir = (oss_dir_t *)*dir_entry_ptr;
    int fd = oss_dir->fd;
    
    if (oss_dir->buf != NULL)
        free(oss_dir->buf);
    free(oss_dir);
    
    ret = sys_close(fd);
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_ReadDir
* ȡָĿ¼µļĿ¼
* ˵(IN)   dir_entry_ptr:Ŀ¼;
                   dir_item_ptr:Ŀ¼ϢĽṹָ,û
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_ReadDir(VOID **dir_entry_ptr,ZOSS_S_DIRENT *dir_item_ptr)
{
    zOss_AssertEx(dir_entry_ptr != NULL && dir_item_ptr != NULL, ZOSS_ERROR);
    
#ifdef _OS_TOS
    struct dirent *dir;

    dir = readdir((DIR *)*dir_entry_ptr);
    if (NULL == dir)
    {
        return ZOSS_ERROR;    
    }
    else
    {
        #ifdef CYGPKG_FILEIO_DIRENT_DTYPE
        dir_item_ptr->d_type = dir->d_type;
        #endif
        strcpy((char *)dir_item_ptr->d_name, (const char *)dir->d_name);
        return ZOSS_SUCCESS;
    }
#elif defined (_OS_LINUX)
    int ret;
    size_t cnt;
    struct old_linux_dirent *dir;
    oss_dir_t *oss_dir = (oss_dir_t *)*dir_entry_ptr;

    if (oss_dir->offset == 0)
    {
        ret = CPPS_KO_FUNC(sys_getdents)(oss_dir->fd, (struct linux_dirent *)oss_dir->buf, oss_dir->size);
        if (ret > 0)
        {
            dir = (struct old_linux_dirent *)oss_dir->buf;
            cnt = oss_min(ZOSS_MAX_FILENAME_LEN, strlen((const char *)dir->d_name));
            strncpy(dir_item_ptr->d_name, dir->d_name, cnt);
            oss_dir->offset = dir->d_namlen;
            oss_dir->total_len = ret;
            return ZOSS_SUCCESS;
        }
        else
        {
            return ZOSS_ERROR;
        }
    }
    else if(oss_dir->offset < oss_dir->total_len)
    {
        dir = (struct old_linux_dirent *)(oss_dir->buf + oss_dir->offset);
        cnt = oss_min(ZOSS_MAX_FILENAME_LEN, strlen((const char *)dir->d_name));
        strncpy(dir_item_ptr->d_name, dir->d_name, cnt);
        oss_dir->offset += dir->d_namlen;
    }
    else
    {
        return ZOSS_ERROR;
    }
    
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* : zOss_Rewinddir
* : λĿ¼ͷʼĿ¼
* ˵: 
            (IN)  
                dir_entry_ptr:Ŀ¼;
           
*   ֵ: 
* ˵:
**************************************************************************/ 
VOID zOss_Rewinddir(VOID *dir_entry_ptr)
{
#ifdef _OS_TOS
    zOss_AssertExN(dir_entry_ptr != NULL);
    rewinddir((DIR *)dir_entry_ptr);        
#elif defined (_OS_LINUX)
    CPPS_KO_FUNC(sys_lseek)((unsigned int)dir_entry_ptr, 0x00, SEEK_SET);
#endif
}

/**************************************************************************
* ƣ zOss_ChMod
* ļĿ¼
* ˵ (IN)   pathname:ļĿ¼,windows·
                    attrs:ļĿ¼µ
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_ChMod(const CHAR *pathname,mode_t attrs)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1] = {0};

    zOss_AssertEx(pathname != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(pathname, dest_linux) == ZOSS_SUCCESS)
    {
#ifdef _OS_TOS
        if (chmod((char *)dest_linux,attrs) == 0)
        {
            return ZOSS_SUCCESS;
        }
#elif defined (_OS_LINUX)
        int ret;

        DBG("zOss_ChMod pathname: %s\n", pathname);
        ret = CPPS_KO_FUNC(sys_chmod)((const char *)dest_linux, (umode_t)attrs);
        if (ret == 0)
            return ZOSS_SUCCESS;
        else
            return ZOSS_ERROR;
#endif
    }

    return ZOSS_ERROR;     
}

/**************************************************************************
* ƣzOss_Stat
* ȡļĿ¼ϸϢ
* ˵(IN)   
                pathname:ļĿ¼,windows·
            (OUT)
                buf:ڴ洢Ϣstatṹ,ûռ            
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_Stat(const CHAR *pathname,ZOSS_S_STAT *buf)
{
    CHAR dest_linux[ZOSS_MAX_FILENAME_LEN + 1]  = {0};

    zOss_AssertEx(pathname != NULL, ZOSS_ERROR);

    if (Osa_WinToLinuxPathMap(pathname, dest_linux) == ZOSS_SUCCESS)
    {
        struct stat stat_info;
#ifdef _OS_TOS
        if (stat((char *)dest_linux, &stat_info) == 0)
        {
            buf->st_dev     = (UINT32)stat_info.st_dev;
            buf->st_ino     = (UINT32)stat_info.st_ino;
            buf ->st_mode   = stat_info.st_mode;
            buf->st_nlink   = (UINT16)stat_info.st_nlink;
            buf->st_uid     = (UINT32)stat_info.st_uid;
            buf->st_gid     = (UINT32)stat_info.st_gid;
            buf->st_rdev    = 0;
            buf->st_size    = (UINT32)stat_info.st_size;
            buf->st_atime   = stat_info.st_atime;
            buf->st_mtime   = stat_info.st_mtime;
            buf->st_ctime   = stat_info.st_ctime;
            return ZOSS_SUCCESS;
        }
#elif defined (_OS_LINUX)
        DBG("zOss_Stat pathname: %s\n", pathname);
        if (CPPS_KO_FUNC(sys_newstat)((const char *)dest_linux,  &stat_info) == 0) {
            buf->st_dev     = (UINT32)stat_info.st_dev;
            buf->st_ino     = (UINT32)stat_info.st_ino;
            buf->st_mode    = stat_info.st_mode;
            buf->st_nlink   = (UINT16)stat_info.st_nlink;
            buf->st_uid     = (UINT32)stat_info.st_uid;
            buf->st_gid     = (UINT32)stat_info.st_gid;
            buf->st_rdev    = 0;
            buf->st_size    = stat_info.st_size;
            buf->st_atime   = stat_info.st_atime;
            buf->st_mtime   = stat_info.st_mtime;
            buf->st_ctime   = stat_info.st_ctime;

            return ZOSS_SUCCESS;
        }
#endif
    }
    
    return ZOSS_ERROR;         
}

/**************************************************************************
* ƣzOss_MountDisk
* ش
* ˵(IN)   diskname:̷
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_MountDisk(CHAR diskname)
{
    int     ret  = 0;
    UINT32 uiRet = VerifyDisk(&diskname);    

    if (ZOSS_ERROR == uiRet)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_OSE
    if (0 == fss_resolve((const char *)gDiskParam->diskMap[uiRet].Device, FSS_TYPE_BLOCKDEV, 1000))
    {
        return ZOSS_ERROR;
    }
    
    if (0 == fss_resolve((const char *)gDiskParam->diskMap[uiRet].Format, FSS_TYPE_FORMAT, 1000))
    {
        return ZOSS_ERROR;
    }
    
    ret = efs_mount((const char *)gDiskParam->diskMap[uiRet].LinuxPath, 
                    (const char *)gDiskParam->diskMap[uiRet].Format,
                    (const char *)gDiskParam->diskMap[uiRet].Device,
                    (const char *)gDiskParam->diskMap[uiRet].Params);

#elif defined _OS_TOS
    ret = mount(gDiskParam->diskMap[uiRet].Device,
                gDiskParam->diskMap[uiRet].LinuxPath,
                gDiskParam->diskMap[uiRet].Format);
#elif defined _OS_LINUX
    DBG("zOss_MountDisk Device: %s, LinuxPath: %s, Format: %s\n",
        gDiskParam->diskMap[uiRet].Device,
        gDiskParam->diskMap[uiRet].LinuxPath,
        gDiskParam->diskMap[uiRet].Format);
    ret = CPPS_KO_FUNC(sys_mount)(gDiskParam->diskMap[uiRet].Device,
                    gDiskParam->diskMap[uiRet].LinuxPath,
                    gDiskParam->diskMap[uiRet].Format,
                    MS_SILENT,
                    NULL);
#endif
    
    if (ret)
    {
        return ZOSS_ERROR;
    }
    
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_UnMountDisk
* жش
* ˵(IN)   diskname:̷
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_UnMountDisk(CHAR diskname)
{
    int     ret     = 0;
    UINT32  uiRet   = VerifyDisk(&diskname);

    if (ZOSS_ERROR == uiRet)
    {
        return ZOSS_ERROR;
    }

#ifdef _OS_OSE
    ret = efs_unmount((const char *)gDiskParam->diskMap[uiRet].LinuxPath, FALSE);
#elif defined _OS_TOS
    ret = umount(gDiskParam->diskMap[uiRet].LinuxPath);
#elif defined _OS_LINUX
    DBG("zOss_UnMountDisk LinuxPath: %s\n", gDiskParam->diskMap[uiRet].LinuxPath);
    ret = CPPS_KO_FUNC(sys_umount)(gDiskParam->diskMap[uiRet].LinuxPath, MNT_DETACH);
#endif

    if (ret)
    {
        return ZOSS_ERROR;
    }

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_MountDynamicDisk
* ̬ش
* ˵(IN)   
*               pWinDir  : windows·
*               pLinuxDir: linux·
*               pDevName : 豸
*               pFsName  : ļϵͳ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵֧TOSϵͳ
**************************************************************************/ 
UINT32 zOss_MountDynamicDisk(CHAR *pWinDir, CHAR *pLinuxDir, CHAR *pDevName, char *pFsName)
{
#ifdef _OS_LINUX
    return ZOSS_SUCCESS;
#else
    T_zOss_FsPathMapNode *pBuff = NULL;
    /*ش*/
    zOss_AssertEx((pWinDir != NULL) && (pLinuxDir != NULL) && (pDevName != NULL) && (pFsName != NULL), ZOSS_ERROR);
    
    if (mount(pDevName, pLinuxDir, pFsName))
        return ZOSS_ERROR;
    
    pBuff = (T_zOss_FsPathMapNode *)zOss_Malloc(sizeof(T_zOss_FsPathMapNode)); 
    zOss_Memset(pBuff, 0, sizeof(T_zOss_FsPathMapNode));
    strncpy(pBuff->winPath, pWinDir, ZOSS_FS_WINPATH_LEN);
    strncpy(pBuff->linuxPath, pLinuxDir, ZOSS_FS_LINUXPATH_LEN);
   
    /*·ӳӵ·̬ӳ*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(&g_zFsPathDynamicMapList, &pBuff->node);
    zOss_PutMutex(g_zFsPathMapMutex);
    
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣzOss_UnMountDynamicDisk
* ̬жش
* ˵(IN)   
*               pWinDir  : windows·
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵֧TOSϵͳ
**************************************************************************/ 
UINT32 zOss_UnMountDynamicDisk(CHAR *pWinDir)
{
#ifdef _OS_LINUX
    return ZOSS_SUCCESS;
#else
    T_zOss_FsPathMapNode *pFsPathNode   = NULL;
    CHAR                 *pLinuxPath    = NULL;
    
    /*̷Ƿڶ̬*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    while(pFsPathNode != NULL)
    {
        if(0 == strcmp(pWinDir, pFsPathNode->winPath))
        {
            pLinuxPath = pFsPathNode->linuxPath;
            zOss_ListDelete(&g_zFsPathDynamicMapList, &(pFsPathNode->node));
            zOss_Free(pFsPathNode);
            break;
        }
        pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListNext(&(pFsPathNode->node));
    }
    zOss_PutMutex(g_zFsPathMapMutex);

    if (pLinuxPath == NULL)
        return ZOSS_ERROR;
    
    /*жش*/
    if (umount(pLinuxPath))
    {
        pFsPathNode = (T_zOss_FsPathMapNode *)zOss_Malloc(sizeof(T_zOss_FsPathMapNode)); 
        zOss_Memset(pFsPathNode, 0, sizeof(T_zOss_FsPathMapNode));
        strncpy(pFsPathNode->winPath, pWinDir, ZOSS_FS_WINPATH_LEN);
        strncpy(pFsPathNode->linuxPath, pLinuxPath, ZOSS_FS_LINUXPATH_LEN);
        
        /*·ӳӵ·̬ӳ*/
        zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
        zOss_ListAdd(&g_zFsPathDynamicMapList, &pFsPathNode->node);
        zOss_PutMutex(g_zFsPathMapMutex);

        return ZOSS_ERROR;
    }
    else
        return ZOSS_SUCCESS;
#endif
}

/*******************************************************************************
* :     жеİװ
* ˵:     
*   ()  VOID
*   ()  
*   ֵ:     ɹ: ZOSS_SUCCESSʧ: ZOSS_ERROR
* ˵:     úӦڶʧܵʱ򱻵ãļϵͳramݵnand
                flashУԱ´οʱٻָļϵͳ
*******************************************************************************/
UINT32 zOss_UnMountAllDisk(VOID)
{
    SINT32 ret     = 0;
    UINT32 cnt     = 0;
    SINT32 fail    = 0;
    T_zOss_FsPathMapNode *pFsPathNode   = NULL;
    
    /*жؾ̬ص*/
    for (cnt = 0; cnt < gDiskParam->diskNum; cnt++) 
    {
#ifdef _OS_OSE
        ret = efs_unmount((const char *)gDiskParam->diskMap[cnt].LinuxPath, FALSE);
#elif defined (_OS_TOS)
        ret = umount(gDiskParam->diskMap[cnt].LinuxPath);
#elif defined (_OS_LINUX)
        ret = CPPS_KO_FUNC(sys_umount)(gDiskParam->diskMap[cnt].LinuxPath, MNT_DETACH);
#endif
        if(ret)
            fail++;
    }
    
    /*жض̬ص*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    while(pFsPathNode != NULL)
    {
#ifdef _OS_OSE 
        if (efs_unmount((const char *)pFsPathNode->linuxPath), FALSE)
#elif defined (_OS_TOS)
        if (umount(pFsPathNode->linuxPath))
#elif defined (_OS_LINUX)
        if (CPPS_KO_FUNC(sys_umount)(pFsPathNode->linuxPath, MNT_DETACH))
#endif
            fail++;
        zOss_ListDelete(&g_zFsPathDynamicMapList, &(pFsPathNode->node));
        zOss_Free(pFsPathNode);
        pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    }    
    zOss_PutMutex(g_zFsPathMapMutex);

    return fail ? ZOSS_ERROR : ZOSS_SUCCESS; 
}

/**************************************************************************
* ƣzOss_GetDiskFreeSpace
* ȡ̵ָʣռ
* ˵(IN)   diskname:̷,CD.
            (OUT)  space:ʣռĴС,λbyte.
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_GetDiskFreeSpace(CHAR diskname, UINT64 *space)
{
    return Fs_GetDiskSpace(diskname, space, FALSE);
}

/**************************************************************************
* ƣ zOss_GetDiskCapacity
*  ȡ
* ˵ (IN)   diskname:̷,CD.
             (OUT) space:ʣռĴС,λbyte.
*   ֵ ɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/ 
UINT32 zOss_GetDiskCapacity(CHAR diskname, UINT64 *space)
{
    return Fs_GetDiskSpace(diskname, space, TRUE);
}

/**************************************************************************
* ƣ zOss_GetAllDynamicDisk
*  ȡж̬mount̷
* ˵ (IN)   disk: ̷ָ
			 (IN)	size: С
*   ֵ ̬mount̷
* ˵ disk̷Сдʽcd̷ֻһĸ
**************************************************************************/ 
UINT32 zOss_GetAllDynamicDisk(CHAR *disk, UINT32 size)
{
    UINT32 count = 0;
    T_zOss_FsPathMapNode *pFsPathNode = NULL;

    zOss_AssertEx(disk != NULL, 0);
    
    /*̬ӳ*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    while( pFsPathNode != NULL)
    {
    	if (count >= size)
    	{
			zOss_ASSERT(0);
			zOss_PutMutex(g_zFsPathMapMutex);
			return 0;
    	}
		
        disk[count++] = tolower(pFsPathNode->winPath[0]);
        
        pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListNext(&(pFsPathNode->node));
    }
    zOss_PutMutex(g_zFsPathMapMutex);

    return count;
}

/**************************************************************************
* ƣ zOss_SyncFS
*  ļϵͳͬ
* ˵ (IN)
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵
**************************************************************************/
UINT32 zOss_SyncFS(VOID)
{
#ifdef _OS_OSE
    ZOSS_THREAD_ID thread_id1 = NULL;
    ZOSS_THREAD_ID thread_id2 = NULL;
    ZOSS_THREAD_ID thread_id3 = NULL;
    
    UINT32 thread_priority1 = 0;
    UINT32 thread_priority2 = 0;
    UINT32 thread_priority3 = 0;
    
    thread_id1 = zOss_GetThreadIDByName((const CHAR*)"ose_cfs_jeff_/c");
    thread_id2 = zOss_GetThreadIDByName((const CHAR*)"ose_cfs_jeff");
    thread_id3 = zOss_GetThreadIDByName((const CHAR*)"ose_ffx");

    if (thread_id1 == NULL || thread_id2 == NULL || thread_id3 == NULL)
    {
        return ZOSS_ERROR;
    }

    zOss_GetThreadPri(thread_id1, &thread_priority1);
    zOss_GetThreadPri(thread_id2, &thread_priority2);
    zOss_GetThreadPri(thread_id3, &thread_priority3);

    zOss_SetThreadPri(thread_id1, 8);
    zOss_SetThreadPri(thread_id2, 8);
    zOss_SetThreadPri(thread_id3, 9);

    efs_sync("/c");

    zOss_SetThreadPri(thread_id1, thread_priority1);
    zOss_SetThreadPri(thread_id2, thread_priority2);
    zOss_SetThreadPri(thread_id3, thread_priority3);
#elif defined (_OS_TOS)
    SINT32 ret      = 0;
    UINT32 cnt      = 0;
    UINT32 fail     = 0;
    UINT32 num      = gDiskParam->diskNum;
    T_zOss_FsPathMapNode *pFsPathNode   = NULL;

    /*̬ͬӳеļϵͳ*/
    for (cnt = 0; cnt < num; cnt++)
    {
        ret = cyg_fs_setinfo(gDiskParam->diskMap[cnt].LinuxPath, FS_INFO_SYNC, NULL, 0);
        if (ret)
            fail++;
    }
    
    /*̬ͬӳļϵͳ*/
    zOss_GetMutex(g_zFsPathMapMutex, ZOSS_WAIT_FOREVER);
    pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListFirst(&g_zFsPathDynamicMapList);
    while(pFsPathNode != NULL)
    {
        ret = cyg_fs_setinfo(pFsPathNode->linuxPath, FS_INFO_SYNC, NULL, 0);
        if (ret)
            fail++;
        pFsPathNode = (T_zOss_FsPathMapNode *)zOss_ListNext(&(pFsPathNode->node));
    }    
    zOss_PutMutex(g_zFsPathMapMutex);
    
    if (fail)
    {
        return ZOSS_ERROR;
    }
#elif defined _OS_LINUX
    int ret;

    ret = CPPS_KO_FUNC(sys_sync)();
    if (ret == 0)
        return ZOSS_SUCCESS;
    else
        return ZOSS_ERROR;
#endif

    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣzOss_FsMount
* OSS CFGõļϵͳ
* ˵ 
*   ֵɹ ZOSS_SUCCESSʧܷZOSS_ERROR 
* ˵
**************************************************************************/
UINT32 zOss_FsMount(VOID)
{
#ifdef _OS_LINUX
    return ZOSS_SUCCESS;
#else
    UINT32 cnt;

    for(cnt = 0; cnt < gDiskParam->diskNum; cnt++)
    {
        int ret = mount(gDiskParam->diskMap[cnt].Device, gDiskParam->diskMap[cnt].LinuxPath, gDiskParam->diskMap[cnt].Format);
        zOss_AssertEx(ret == ZOSS_SUCCESS, ZOSS_ERROR);
    }
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣ FS_Init
*  ļϵͳʼ
* ˵ (IN)
             (OUT)
*   ֵ ɹZOSS_SUCCESS,ʧܷZOSS_ERROR
* ˵
**************************************************************************/
VOID  FS_Init(VOID)
{    
    T_OSS_PARAM *pOssParam  = NULL;

#ifdef _OS_OSE
    ZOSS_THREAD_ID threadID = NULL;
    threadID = zOss_GetThreadIDByName((const CHAR*)"ose_ffx");/* ļϵͳ̵߳ȼ*/

    if (threadID != NULL)
    {
        zOss_SetThreadPri(threadID, 29); /* 3029 */
    }
    threadID = zOss_GetThreadIDByName((const CHAR*)"ose_ffxwriter");/*ļϵͳд̵߳ȼ?*/
    if (threadID != NULL)
    {
        zOss_SetThreadPri(threadID, 30); /* 3130 */
    }
#endif
    
    pOssParam   = zOss_GetOssCfg();
    gDiskParam  = &(pOssParam->DiskMap);
    
#if defined (_OS_TOS) || defined (_OS_LINUX)
    zOss_ListInit(&g_zFsPathDynamicMapList);
    g_zFsPathMapMutex = zOss_CreateMutex("fsPathMutex", ZOSS_INHERIT);
#endif
}

#ifdef __cplusplus
} 
#endif

