/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : oss_list.c 
*    : oss_list.c
* ļ : 
* ʵֹ : 
*      : xuxingkui
*      : V1.0
*  : 2007/05/21
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : xiaxinguo
* ޸ : 2007/08/01
* ޸ : DALƶCOMMONΪӿ
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : hongkun
* ޸ : 2007/08/27
* ޸ : ɾLISTṹеnodeԪ
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0004
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/

#if !defined (_OS_TOS) && !defined (_OS_LINUX)

/**************************************************************************
* :  zOss_ListInit
* :  ʼ˫
* ˵
             (IN)
                pList:ָ
             (OUT)
*   ֵ:
**************************************************************************/
VOID zOss_ListInit(T_ZOss_List *pList)
{
    zOss_AssertExN(pList != NULL);

    pList->HEAD  = NULL;
    pList->TAIL  = NULL;
    pList->count = 0;
}

/**************************************************************************
* : zOss_ListAdd
* : βӽڵ
* ˵
            (IN)
                pList:ָ
                pNode:ӽڵָ
            (OUT)
*   ֵ:
**************************************************************************/
CODE_BEGIN(.PLAT_TCM_CODE)
VOID zOss_ListAdd (T_ZOss_List *pList, T_ZOss_Node *pNode)
{
    zOss_AssertExN(pList != NULL && pNode != NULL);

    zOss_ListInsert(pList, pList->TAIL, pNode);
}

/**************************************************************************
* :  zOss_ListCount
* :  ȡܹĽڵ
* ˵
             (IN)
                pList:ָ
             (OUT)
*   ֵ:  ڵ
**************************************************************************/
SINT32 zOss_ListCount(T_ZOss_List *pList)
{
    zOss_AssertEx(pList != NULL, -1);

    return (pList->count);
}

/**************************************************************************
* : zOss_ListDelete
* : ƳָĽڵ
* ˵
            (IN)
                pList:ָ
                pNode:ɾڵָ
            (OUT)
*   ֵ:
**************************************************************************/
VOID zOss_ListDelete(T_ZOss_List *pList, T_ZOss_Node *pNode)
{
    zOss_AssertExN(pList != NULL && pNode != NULL);

    if (pNode->previous != NULL)
    {
        pNode->previous->next = pNode->next;
    }
    else
    {
        pList->HEAD = pNode->next;
    }

    if (pNode->next != NULL)
    {
        pNode->next->previous = pNode->previous;
    }
    else
    {
        pList->TAIL = pNode->previous;
    }

    /* update node count */
    pList->count--;
}

/**************************************************************************
* : zOss_ListFirst
* : ȡ׽ڵ
* ˵
            (IN)
                pList:ָ
            (OUT)
*   ֵ: ڵָ(ûнڵʱؿ)
**************************************************************************/
T_ZOss_Node* zOss_ListFirst(T_ZOss_List *pList)
{
    zOss_AssertEx(pList != NULL, NULL);

    return (pList->HEAD);
}

/**************************************************************************
* : zOss_ListInsert
* : ָĽڵڵ
* ˵
            (IN)
                pList:ָ
                pPrev:ڵָ룬pPrevΪʱʾ뵽λ
                pNode:Ľڵָ
            (OUT)
*   ֵ:
**************************************************************************/
VOID zOss_ListInsert (T_ZOss_List *pList, T_ZOss_Node *pPrev, T_ZOss_Node *pNode)
{
    T_ZOss_Node *pNext = NULL;

    zOss_AssertExN(pList != NULL);
    zOss_AssertExN(pNode != NULL);

    if (pPrev != NULL)
    {
        pNext = pPrev->next;    /* make prev node point fwd to new */
        pPrev->next = pNode;
    }
    else
    {
     	pNext = pList->HEAD;    /* new node is to be first in list */
    	pList->HEAD = pNode;
    }

    if (pNext != NULL)
    {    	
       pNext->previous = pNode; /* make next node point back to new */
    }
    else
    {
        pList->TAIL = pNode;    /* new node is to be last in list */
    }

    /* set pointers in new node, and update node count */
    pNode->next     = pNext;
    pNode->previous = pPrev;

    pList->count++;
}

/**************************************************************************
* : zOss_ListLast
* : ȡָڵĺһڵ
* ˵
            (IN)
                pNode:ָڵָ
            (OUT)
*   ֵ: ڵָ(ûнڵʱؿ)
**************************************************************************/
T_ZOss_Node* zOss_ListLast(T_ZOss_List *pList)
{
    zOss_AssertEx(pList != NULL, NULL);

    return (pList->TAIL);
}

/**************************************************************************
* : zOss_ListNext
* : ȡָڵǰһڵ
* ˵
            (IN)
                pNode:ڵָ
            (OUT)
*   ֵ: ڵָ(ڵһڵʱؿ)
**************************************************************************/
T_ZOss_Node* zOss_ListNext(T_ZOss_Node *pNode)
{
    zOss_AssertEx(pNode != NULL, NULL);

    return (pNode->next);
}

/**************************************************************************
* : zOss_ListPrevious
* : ȡָڵǰһڵ
* ˵
            (IN)
                pNode:ָڵָ
            (OUT)
*   ֵ: ڵָ(ڵһڵʱؿ)
**************************************************************************/
T_ZOss_Node *zOss_ListPrevious(T_ZOss_Node *pNode)
{
    zOss_AssertEx(pNode != NULL, NULL);

    return (pNode->previous);
}

/**************************************************************************
* : zOss_ListNStep
* : ȡָڵnStepĽڵ
* ˵
            (IN)
                pNode:ڵָ
                nStep:. :nextڵ㣬previousڵ
            (OUT)
*   ֵ: ڵָ(ڼnStepڵβʱؿ)
**************************************************************************/
T_ZOss_Node *zOss_ListNStep(T_ZOss_Node *pNode, SINT32 nStep)
{
    int i       = 0;
    
    zOss_AssertEx(pNode != NULL, NULL);
    
    if (nStep > 0)
    {
        for (i = nStep; i > 0; i--)
        {
            pNode = pNode->next;
            
            if (pNode == NULL)
            {
                break;
            }
        }
    }
    else
    {
        for (i = nStep; i < 0; i++)
        {
            pNode = pNode->previous;
            
            if (pNode == NULL)
            {
                break;
            }
        }
    }
    return (pNode);
}

/**************************************************************************
* : zOss_ListFind
* : еĽڵ
* ˵
            (IN)
                pList:ָ
                pNode:ҽڵָ
            (OUT)
*   ֵ: ָڵ:ڵе(1ʼ)
                        ָڵ:-1
**************************************************************************/
SINT32 zOss_ListFind (T_ZOss_List *pList, T_ZOss_Node *pNode)
{
    T_ZOss_Node *pNextNode      = NULL;
    int         iNodePosition   = 1;

    zOss_AssertEx(pList != NULL && pNode != NULL, -1);

    pNextNode = zOss_ListFirst (pList);

    while ((pNextNode != NULL) && (pNextNode != pNode))
    {
        iNodePosition++;
        
        pNextNode = zOss_ListNext (pNextNode);
    }

    if (pNextNode != NULL)
    {
        return (iNodePosition);
    }
    else
    {
        return (-1);
    }
}

/**************************************************************************
* : zOss_ListConnect
* : һ
* ˵
            (IN)
                pList1: 1
                pList2: 2
            (OUT)
* ֵ:
* ˵    pList2ӵpList1βpList2ͷݲı
**************************************************************************/
VOID zOss_ListConnect(T_ZOss_List *pList1, T_ZOss_List *pList2)
{
    if (pList1->count == 0)
    {
        pList1->HEAD    = pList2->HEAD;
        pList1->TAIL    = pList2->TAIL;
    }
    else
    {
        if (pList2->count != 0)
        {
            pList1->TAIL ->next     = pList2->HEAD;
            pList2->HEAD->previous  = pList1->TAIL;
            pList1->TAIL            = pList2->TAIL;
        }
    }
    pList1->count += pList2->count;
}

CODE_END

#endif

#ifdef __cplusplus
 }
#endif

