/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     oss_math_scalbn.c
* ļʶ:     oss_math_scalbn.c
* ժҪ:     OSS֧Ųѧscalbnʵģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/08/01      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_math.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _OS_LINUX

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static const double two54   =  1.80143985094819840000e+16; /* 0x43500000, 0x00000000 */
static const double twom54  =  5.55111512312578270212e-17; /* 0x3C900000, 0x00000000 */
static const double huge    = 1.0e+300;
static const double tiny    = 1.0e-300;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

double scalbn (double x, int n)
{
    int  k, hx, lx;

    hx = LIBM_HI(x);
    lx = LIBM_LO(x);
    k = (hx&0x7ff00000)>>20;                /* extract exponent */
    if (k == 0) {                           /* 0 or subnormal x */
        if ((lx|(hx&0x7fffffff)) == 0)
            return x; /* +-0 */

        x *= two54;
        hx = LIBM_HI(x);
        k = ((hx&0x7ff00000)>>20) - 54; 
        if (n< -50000)
            return tiny*x;                  /*underflow*/
    }

    if (k == 0x7ff)
        return x + x;                       /* NaN or Inf */

    k = k + n;
    if (k > 0x7fe)
        return huge*copysign(huge, x);      /* overflow  */

    if (k > 0) {                            /* normal result */
        LIBM_HI(x) = (hx&0x800fffff)|(k<<20);
        return x;
    }

    if (k <= -54) {
        if (n > 50000)                      /* in case integer overflow in n+k */
            return huge*copysign(huge,x);   /*overflow*/
        else
            return tiny*copysign(tiny,x);   /*underflow*/
    }
    k += 54;                                /* subnormal result */
    LIBM_HI(x) = (hx&0x800fffff)|(k<<20);

    return x*twom54;
} 

#endif  // #ifdef _OS_LINUX

#ifdef __cplusplus
}
#endif

