/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : oss_mem.c
* ļ : mem.c
* ʵֹ : ϲosewindowsϵͳļ
*      : zhangxiaofei
*      : V1.0
*  : 2012/10/19
* ˵ :  
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#ifdef _OS_OSE
#include "efs.h"
#include "heap.sig"
#include "heapapi.h"
#include "cpu_intlock.h"
#endif
#ifdef _OS_TOS
#include <pkgconf/system.h>
#include <cyg/hal/tos_cache.h>
#endif
#include "oss_api.h"
#include "sup.h"
#include "osa.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#if defined(_OS_TOS)
# define ZOSS_DCACHE_LINE_SIZE TOS_DCACHE_LINE_SIZE_GET()
#elif defined(_OS_LINUX)
# define ZOSS_DCACHE_LINE_SIZE L1_CACHE_BYTES
#else
# define ZOSS_DCACHE_LINE_SIZE 32
#endif

/**************************************************************************
* ȫֳ/
**************************************************************************/
#ifndef _OS_LINUX
T_ZOss_UBPOOL   *gMem_UBPoolCfg     = NULL;     /* ڴñ          */
UINT32          gMem_UBPoolNum      = 0;        /* ڴظ            */
static BOOL     gMem_IsInit         = FALSE;    /* ڴģʼ־    */
UINT32          gMem_UBStart        = 0;        /* ڴʼָ        */
UINT32          gMem_UBEnd          = 0;        /* ڴؽָ        */
UINT32          gMem_ErrCode        = 0;        /* ڴģ        */
UINT32          gUBSuperviseSitch   = 0;

#ifdef _DEBUG
UINT32    ubBlockBorder = 4;                    /* 4ֽڴ߽ */
#else
UINT32    ubBlockBorder = 0;
#endif

#ifdef _USE_HEAP_DEBUG
static T_ZOss_List      s_mem_list                  = { 0 };
static ZOSS_MUTEX_ID    s_mem_mutex                 = NULL;
#if defined (_OS_OSE) || defined (_OS_WIN)
static UINT32           s_mem_leak_tick_start       = 0;
static UINT32           s_mem_leak_tick_threadhold  = 0;
#endif
#endif

#ifdef _OS_TOS
T_Mem_MemInfo           g_zOss_HeapInfo             = { 0 };
#endif

/**************************************************************************  
* ⲿ
**************************************************************************/
#ifdef _OS_OSE
extern int sysparam_readattr_long(const char *param_name, const char *attr, long *value);
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣMem_ValidateUBCfg
* ֤ڴ
* ˵(IN)
*   ֵȷTRUEʧܷFALSE
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
static UINT32 Mem_ValidateUBCfg(VOID)
{
    UINT32 i            = 0;
    UINT32 tmpmaxsize   = 0;

    if (gMem_UBPoolNum == 0)
    {
        gMem_ErrCode = ZOSS_MEM_UB_CFG_ERR;
        return gMem_ErrCode;
    }

    tmpmaxsize = gMem_UBPoolCfg[i].pool_size;
    for (; i < gMem_UBPoolNum; i++)
    {
        if ((gMem_UBPoolCfg[i].pool_size == 0) || (gMem_UBPoolCfg[i].total_block_num == 0) || (gMem_UBPoolCfg[i].pool_size < tmpmaxsize))
        {
            gMem_ErrCode = ZOSS_MEM_UB_CFG_ERR;
            return ZOSS_MEM_UB_CFG_ERR;
        }
        else
        {
            tmpmaxsize                          = gMem_UBPoolCfg[i].pool_size;
            gMem_UBPoolCfg[i].total_block_num   = gMem_UBPoolCfg[i].total_block_num;
            if (0 == (gMem_UBPoolCfg[i].pool_size % 4))
            {
                gMem_UBPoolCfg[i].pool_size = gMem_UBPoolCfg[i].pool_size;
            }
            else
            {
                gMem_UBPoolCfg[i].pool_size = (gMem_UBPoolCfg[i].pool_size + 3) & (~0x3);
            }
        }
    }

    return ZOSS_SUCCESS;
}
#endif

/**************************************************************************
* ƣMem_GetUBSize
* ڴشС
* ˵(IN)
*   ֵɹڴܴСʧܷ0
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
static UINT32 Mem_GetUBSize(VOID)
{
    UINT32 i    = 0;
    UINT32 size = gMem_UBPoolNum * sizeof(T_Mem_UBPoolCtl); /* ڴƿĴС */
    /* ڴܴС */
    for (; i < gMem_UBPoolNum; i++)
    {
        size += (4 + gMem_UBPoolCfg[i].pool_size + ubBlockBorder + sizeof(T_Mem_UBListNode)) * gMem_UBPoolCfg[i].total_block_num;
    }

    return size;
}
#endif

/**************************************************************************
* ƣMem_SubStr
* һַлȡļ
* ˵(IN)ַ
*   ֵļָ
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
#ifdef _DEBUG
static CHAR* Mem_SubStr(const CHAR *s)
{
    CHAR *last = (CHAR *)strrchr((const char *)s, '\\');

    if (NULL != last)
    {
        return (last + 1);
    }

    /* eclipse뻷ļ·ָΪ'/' */
    last = (CHAR *)strrchr((const char *)s, '/');

    if (NULL != last)
    {
        return (last + 1);
    }
    else
    {
        return NULL;
    }
}
#endif
#endif
/**************************************************************************
* ƣUB_Init
* ʼڴڴ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
static VOID UB_Init(VOID)
{
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl     *pUbControl         = NULL;
    T_Mem_UBListNode    *pUbListNodeStart   = NULL;
    T_Mem_UBListNode    *pUbListNodeTemp    = NULL;
    ZOSS_UB_BLOCK       pUbBlockStart       = NULL;
    UINT32              *pUbBlockStartTemp  = NULL;
    
    UINT32 i = 0;
    UINT32 j = 0;
    
    /* ڴؿƿʼַ */
    pUbControlStart     = (T_Mem_UBPoolCtl *)gMem_UBStart;
    /* 㼴ڴͷʼַ */
    pUbListNodeStart    = (T_Mem_UBListNode *)(pUbControlStart + gMem_UBPoolNum);
    pUbListNodeTemp     = pUbListNodeStart;
    /* ڴʼַ */
    for (i = 0; i < gMem_UBPoolNum; i++)
    {
        pUbListNodeTemp = pUbListNodeTemp + gMem_UBPoolCfg[i].total_block_num;
    }
    pUbBlockStart = (ZOSS_UB_BLOCK)pUbListNodeTemp;
    /* ʼڴ */
    for (i = 0; i < gMem_UBPoolNum; i++)
    {
        CHAR mutexName[10] = {0};
        sprintf((char *)mutexName, "%d", (int)i + 1);
        /* iڴؿƿ */
        pUbControl = (T_Mem_UBPoolCtl *)pUbControlStart + i;
        /* ʼڴؿƿ */
        pUbControl->ubMemHeaderStart    = pUbListNodeStart;
        pUbControl->ubBlockNum          = gMem_UBPoolCfg[i].total_block_num;
        pUbControl->ubBlockStart        = pUbBlockStart;
        pUbControl->ubSize              = gMem_UBPoolCfg[i].pool_size;
        pUbControl->freeUbListHead      = pUbListNodeStart;
        pUbControl->freeUbNum           = pUbControl->ubBlockNum;
#ifdef _DEBUG
        pUbControl->maxUsedUbNum        = 0;
#endif
#ifdef _OS_OSE
        pUbControl->ubMutex             = NULL;
#elif defined _OS_WIN
        pUbControl->ubMutex             = zOss_CreateMutex((const CHAR *)mutexName, ZOSS_INHERIT);
#endif
        for (j = 0; j < gMem_UBPoolCfg[i].total_block_num; j++)
        {
            if (j == gMem_UBPoolCfg[i].total_block_num - 1)
            {
                pUbListNodeStart->nextNode = NULL;
                pUbControl->freeUbListTail = pUbListNodeStart;
            }
            else
            {
                pUbListNodeStart->nextNode = pUbListNodeStart + 1;
            }
            /* ʼڴеڴͷָ */
            pUbBlockStartTemp   = (UINT32 *)pUbBlockStart;
            *pUbBlockStartTemp  = (UINT32)pUbListNodeStart;
#ifdef _DEBUG
            /* ʼڴ߽ */
            memset((char *)pUbBlockStart + 4 + gMem_UBPoolCfg[i].pool_size, (int)MEM_UB_BLOCK_DIVIDE_VALUE, 4);
#endif
            pUbListNodeStart++;
            pUbBlockStart = (CHAR *)pUbBlockStart + 4 + gMem_UBPoolCfg[i].pool_size + ubBlockBorder;
        }
    }
}
#endif
/**************************************************************************
* ƣGetUbBlockAdd
* ڴؿƿ鼰öӦڴַ
*   ֵɹ:ڴַ;ʧ:ZOSS_NULL
* ˵
**************************************************************************/
static ZOSS_UB_BLOCK GetUbBlockAdd(T_Mem_UBPoolCtl *ubControl, T_Mem_UBListNode *ubListNode)
{
    UINT32 serialNum = 0;
    if ((ubControl == NULL) || (ubListNode == NULL))
    {
        return ZOSS_NULL;
    }
    serialNum = (UINT32)(ubListNode - ubControl->ubMemHeaderStart);
    return (ZOSS_UB_BLOCK)((CHAR *)ubControl->ubBlockStart + serialNum * (4 + ubControl->ubSize + ubBlockBorder) + 4);
}

/**************************************************************************
* ƣGetUbPoolCtrAdd
* ַöӦڴؿƿַ
*   ֵɹ:ڴַ;ʧ:ZOSS_NULL
* ˵
**************************************************************************/
#ifdef _DEBUG
static T_Mem_UBPoolCtl* GetUbPoolCtrAdd(T_Mem_UBListNode *ubListNode)
{
    T_Mem_UBPoolCtl *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl *pUbControl         = NULL;
    
    UINT32 i = 0;
    if (ubListNode == NULL)
    {
        return NULL;
    }

    pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;
    pUbControl      = pUbControlStart + 1;

    /* ڴڵڴ */
    for (; i < gMem_UBPoolNum - 1; i++)
    {
        if (ubListNode < pUbControl->ubMemHeaderStart)
        {
            break;
        }
        pUbControl++;
    }
    pUbControl--;
    return pUbControl;
}
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣUbBlockCoyCheak
* ǷΪȷڴַ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵
**************************************************************************/
#ifdef _DEBUG
UINT32 UbBlockCoyCheak(VOID *msg_ptr, UINT32 size)
{
    T_Mem_UBPoolCtl *pUbControlStart    = (T_Mem_UBPoolCtl *)gMem_UBStart;
    UINT32          status              = ZOSS_ERROR;

    /* ǷUBڴ濽 */
    if (((UINT32)msg_ptr >= (UINT32)pUbControlStart->ubBlockStart) && ((UINT32)msg_ptr < gMem_UBEnd))
    {
        T_Mem_UBPoolCtl     *pUbControl         = NULL;
        UINT32              serialNum           = 0;
        UINT32              i                   = 0;
        T_Mem_UBListNode    *ubBlockHeaderNode  = NULL;

        pUbControl = pUbControlStart + 1;
        /*ڴڵڴ*/
        for (i = 0; i < gMem_UBPoolNum - 1; i++)
        {
            if ((UINT32 *)msg_ptr < (UINT32 *)pUbControl->ubBlockStart)
            {
                break;
            }
            pUbControl++;
        }
        pUbControl--;
        serialNum = (UINT32)(((UINT8 *)msg_ptr - 4) - (UINT8 *)pUbControl->ubBlockStart) / (4 + pUbControl->ubSize + ubBlockBorder);
        ubBlockHeaderNode = pUbControl->ubMemHeaderStart + serialNum;

        if (ubBlockHeaderNode->ubBlockHeader.isUsed)
        {
            UINT32 ubBlockEndAdd    = 0;
            UINT32 blockDivid       = 0;
            UINT32 ubBlockStart     = 0;
            UINT32 blockHeaderAdd   = 0;
            //UINT8 temp = 0;
            ubBlockEndAdd = (UINT32)((CHAR *)pUbControl->ubBlockStart + serialNum * (4 + pUbControl->ubSize + ubBlockBorder) + 4 + ubBlockHeaderNode->ubBlockHeader.usingSize);
            /*Ƿ񿽱Խ*/
            if ((UINT32)((CHAR *)msg_ptr + size) > ubBlockEndAdd)
            {
                /*UBڴ濽Խ*/
                zOss_ASSERT(0);
                return ZOSS_ERROR;
            }
            /*ڴڴͷǷȷ*/
            ubBlockStart = (UINT32)(((CHAR *)ubBlockEndAdd - ubBlockHeaderNode->ubBlockHeader.usingSize) - 4);
            memcpy(&blockHeaderAdd, ((CHAR *)ubBlockEndAdd - ubBlockHeaderNode->ubBlockHeader.usingSize) - 4, 4);
            if ((UINT32)ubBlockHeaderNode != blockHeaderAdd)
            {
                /*UBڴ濽ڴڴͷַ*/
                zOss_ASSERT(0);
                return ZOSS_ERROR;
            }
            /*  for ub ߲鿴ùûûУʱע
            ʵʹñ߽Ƿ
            if (pUbControl->ubSize - ubBlockHeaderNode->ubBlockHeader.usingSize > 0)
            {
                memcpy(&temp, (CHAR *)ubBlockEndAdd, 1);
                if (temp != MEM_UB_BLOCK_REALUSED_SIGNAL)
                {
                    status = zOss_Printf(SUBMDL_MEM, PRINT_LEVEL_ABNORMAL, "UBڴ%pڴڴʵʹñ߽类ƻ\n", msg_ptr);
                    zOss_ASSERT(0);
                    return ZOSS_ERROR;
                }
            }
            */
            /*ǰ߽Ƿ*/
            if (ubBlockStart != (UINT32)pUbControlStart->ubBlockStart)
            {
                memcpy(&blockDivid, (CHAR *)ubBlockStart - ubBlockBorder, 4);
                if (blockDivid != MEM_UB_BLOCK_DIVIDE_VALUE)
                {
                    /* UBڴ濽ڴǰ߽类ƻ */
                    zOss_ASSERT(0);
                    return ZOSS_ERROR;
                }
            }
        }
        else
        {
            return ZOSS_ERROR;
        }
        status = status != ZOSS_SUCCESS ? ZOSS_ERROR : ZOSS_SUCCESS;
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_SUCCESS;
    }
}
#endif

/**************************************************************************
* ƣHeapDbg_Init
* heapϢʼ
* ˵: (IN) 
*   ֵ   
* ˵
**************************************************************************/
VOID HeapDbg_Init(VOID)
{
#ifdef _USE_HEAP_DEBUG
#if defined (_OS_OSE) || defined (_OS_WIN)
    static BOOL heapDgbInit = FALSE;

    if (!heapDgbInit)
    {
        zOss_ListInit(&s_mem_list);
        s_mem_mutex = zOss_CreateMutex((const CHAR*)"mem_mutex", ZOSS_INHERIT);
        zOss_ASSERT(NULL != s_mem_mutex);
        heapDgbInit = TRUE;
    }
#endif
#endif
}

/**************************************************************************
* ƣMEM_Init
* ʼϵͳڴϢ
* ˵(IN)
*   ֵɹ:ZOSS_SUCCESS;ʧ:
* ˵
**************************************************************************/
UINT32 MEM_Init(VOID)
{
#if defined (_OS_OSE) || defined (_OS_WIN)
    UINT32          size        = 0;
    VOID            *ubPtr      = NULL;
    T_OSS_PARAM     *pPlatCfg   = NULL;

    /* Ѿʼ */
    if (gMem_IsInit)
    {
        return ZOSS_SUCCESS;
    }

    /* ȡ̬ò */
    pPlatCfg = zOss_GetOssCfg();

    if (NULL == pPlatCfg)
    {
        return ZOSS_ERROR;
    }
    gMem_UBPoolCfg = pPlatCfg->MemCfg.UBPool;
    gMem_UBPoolNum = pPlatCfg->MemCfg.ub_pool_num;

    /*  */
    if (ZOSS_SUCCESS != Mem_ValidateUBCfg())
    {
        gMem_ErrCode = ZOSS_MEM_UB_CFG_ERR;
        return ZOSS_MEM_UB_CFG_ERR;
    }

    /* ȡڴܴС */
    size = Mem_GetUBSize();
    if (0 == size)
    {
        gMem_ErrCode = ZOSS_MEM_CALCU_SIZE_ERR;
        return ZOSS_MEM_CALCU_SIZE_ERR;
    }

    /* Ӷڴؿռ */
    ubPtr = zOss_Malloc(size);
    if (NULL == ubPtr)
    {
        gMem_ErrCode = ZOSS_MEM_ALLOC_HEAP_ERR;
        return ZOSS_MEM_ALLOC_HEAP_ERR;
    }

    gMem_UBStart    = (UINT32)ubPtr;
    gMem_UBEnd      = (UINT32)ubPtr + size;

    memset(ubPtr, 0, size);
    UB_Init();
    gMem_IsInit = TRUE;
#endif
    return ZOSS_SUCCESS;
}
/**************************************************************************
* ƣmem_malloc
* Ӷзڴ
* ˵(IN)    size:Ҫֽ
*   ֵ VOID ͵ָ룬ָڴ飻ʧܣ򷵻 ZOSS_NULL
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
VOID* mem_malloc(UINT32 size, const CHAR *file, UINT32 line)
{
#if defined _OS_OSE || defined _OS_WIN
    UINT32          allocSize       = 0;
#endif

#ifdef _USE_HEAP_DEBUG
    UINT32          context_size    = 0;
    T_Mem_DebugInfo *p_mem_context  = NULL;
    UINT32          file_name_size  = 0;
    UINT32          *lr_save        = NULL;
#endif
    /* СΪ04ֽ */
#if defined _OS_OSE || defined _OS_WIN
    if (0 == size)
    {
        allocSize = 4;
    }
    else
    {
        allocSize = size;
    }
#endif

#ifdef _USE_HEAP_DEBUG
    
    mem_getLR( lr_save );

    if (file != NULL)
    {
        file_name_size = strlen((const char *)file) + 1;
    }
    context_size    = sizeof(T_Mem_DebugInfo) + allocSize + MEM_MAGIC_SIZE + file_name_size;
# ifdef _OS_OSE
    p_mem_context   = (T_Mem_DebugInfo *)heap_alloc_shared(context_size, (const char *) file, line );
# elif defined _OS_WIN
    p_mem_context   = (T_Mem_DebugInfo *)calloc(1, context_size);
# endif
    if ( NULL == p_mem_context )
    {
        return NULL;
    }
# ifdef _OS_OSE        
    mem_memset( p_mem_context, 0, context_size, (CHAR *)file, line );
# endif
    
    p_mem_context->size                 = context_size;
    p_mem_context->mem                  = mem_context_mem( p_mem_context );
    p_mem_context->mem_size             = allocSize;
    p_mem_context->uiLR                 = (UINT32)lr_save;
    p_mem_context->tick_malloced        = zOss_GetTickCount();
    p_mem_context->file_name_size       = file_name_size;
    p_mem_context->file_name            = (CHAR *)mem_context_file_name( p_mem_context );
    p_mem_context->line                 = line;
    p_mem_context->thread_id            = zOss_GetCurThreadID();
    *mem_context_magic(p_mem_context)   = MEM_MAGIC_NUM;
    if (file != NULL)
    {
        mem_memcpy( p_mem_context->file_name, file, file_name_size, (CHAR *)file, line);
    }
    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(&s_mem_list, (T_ZOss_Node *)p_mem_context);
    zOss_PutMutex(s_mem_mutex);
    
    return p_mem_context->mem;
#else

# ifdef _OS_OSE    
    return (VOID *)heap_alloc_shared(allocSize, (const char*)file, line);
# elif defined _OS_WIN
    return (VOID *)malloc(allocSize);
# endif

#endif

}
#endif

/**************************************************************************
* ƣmem_free_extend
* ͷmem_malloc()ڴ
* ˵(IN)    mem_ptr:Ҫͷŵڴĵַָ
*   ֵ
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
VOID mem_free_extend(VOID *mem_ptr, const CHAR *file, UINT32 line)
{
#ifdef _USE_HEAP_DEBUG
    T_Mem_DebugInfo *p_mem_context = NULL;
#endif
    zOss_AssertExN(NULL != mem_ptr);
#ifdef _USE_HEAP_DEBUG
    p_mem_context = mem_context(mem_ptr);
    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    zOss_ListDelete(&s_mem_list, (T_ZOss_Node *)p_mem_context);
    zOss_PutMutex(s_mem_mutex);
# ifdef _OS_OSE         
    heap_free_shared(p_mem_context);
# elif defined _OS_WIN
    free(p_mem_context);
# endif
#else
# ifdef _OS_OSE    
    heap_free_shared(mem_ptr);
# elif defined _OS_WIN
    free(mem_ptr);
# endif

#endif
}
#endif

/**************************************************************************
* ƣmem_re_alloc
* ΪһzOss_Mallocڴָ·ռ,ptrΪԭеĿռַ,newsizeĵַ

* ˵(IN)    mem_ptr:ԭеĿռַ
                    newsize:ĵַ
*   ֵ(OUT) VOID ͵ָ룬ָڴ飻ʧܣ򷵻 ZOSS_NULL
* ˵һҪzOss_Mallocڴָ
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
VOID* mem_re_alloc(VOID *mem_ptr, UINT32 new_size, const CHAR *file, UINT32 line)
{
#ifdef _USE_HEAP_DEBUG
    UINT32          context_size    = 0;
    T_Mem_DebugInfo *p_mem_context  = NULL;
    UINT32          file_name_size  = 0;
    UINT32          *lr_save        = NULL;
#endif

    if (NULL == mem_ptr)
    {
        return mem_malloc(new_size, file, line);
    }
    
    if (0 == new_size)
    {
        mem_free_extend(mem_ptr, file, line);
        return ZOSS_NULL;
    }
#ifdef _USE_HEAP_DEBUG
    mem_getLR( lr_save );
    if (file != NULL)
    {
        file_name_size = strlen((const char *)file) + 1;
    }
    context_size    = sizeof(T_Mem_DebugInfo) + new_size + MEM_MAGIC_SIZE + file_name_size;
    p_mem_context   = mem_context(mem_ptr);
    
    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    zOss_ListDelete(&s_mem_list, (T_ZOss_Node *)p_mem_context);
    zOss_PutMutex(s_mem_mutex);
    
    p_mem_context = (T_Mem_DebugInfo *)realloc(p_mem_context, context_size);
    if ( NULL == p_mem_context )
    {
        return NULL;
    }
    mem_memset(p_mem_context, 0, context_size, (CHAR *)file, line);
    
    p_mem_context->size                 = context_size;
    p_mem_context->mem                  = mem_context_mem( p_mem_context );
    p_mem_context->mem_size             = new_size;
    p_mem_context->uiLR                 = (UINT32)lr_save;
    p_mem_context->tick_malloced        = zOss_GetTickCount();
    p_mem_context->file_name_size       = file_name_size;
    p_mem_context->file_name            = (CHAR *)mem_context_file_name( p_mem_context );
    p_mem_context->line                 = line;
    p_mem_context->thread_id            = zOss_GetCurThreadID();
    *mem_context_magic(p_mem_context)   = MEM_MAGIC_NUM;
    if (file!= NULL)
    {
        mem_memcpy( p_mem_context->file_name, file, file_name_size, (CHAR *)file, line);
    }
    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    zOss_ListAdd(&s_mem_list, (T_ZOss_Node *)p_mem_context);
    zOss_PutMutex(s_mem_mutex);
    
    return p_mem_context->mem;
#else
    return realloc(mem_ptr, new_size);
#endif
}
#endif

/**************************************************************************
* ƣzOss_GetSysMemInfo
* ѯϵͳڴϢ
* ˵(IN)ڴ洢ϵͳڴϢT_Mem_MemDataṹ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ش
* ˵: debug汾
**************************************************************************/
#ifdef _OS_OSE
UINT32 zOss_GetSysMemInfo(T_Mem_MemInfo *mem_info)
{
    struct HeapListRequest      *pHeapListReq           = NULL;
    struct HeapListReply        *pHeapListReply         = NULL;
    const SIGSELECT             HeapListReplySig[]      = {1, HEAP_LIST_REPLY};
    PROCESS                     HeapPid                 = 0;
    UINT32                      LoopCnt                 = 0;
    UINT32                      HeapMaxSize             = 0;
    UINT32                      RamSize                 = 0;
    struct HeapStatsExRequest   *pHeapStatsExReq        = NULL;
    struct HeapStatsExReply     *pHeapStatsExReply      = NULL;
    const SIGSELECT             HeapStatsExReplySig[]   = {1, HEAP_STATSEX_REPLY};
    
    zOss_AssertEx(NULL != mem_info, ZOSS_MEM_NULL_PARAM_ERR);
    mem_info->nMemTotal = 0;
    mem_info->nMemUsed  = 0;

    hunt("ose_heapd", 0, &HeapPid, NULL);
    if (HeapPid == 0)
    {
        return ZOSS_ERROR;
    }

    pHeapListReq = (struct HeapListRequest *)alloc(sizeof(struct HeapListRequest), HEAP_LIST_REQUEST);
    if (pHeapListReq == NULL)
    {
        return ZOSS_ERROR;
    }

    send((union SIGNAL **)&pHeapListReq, HeapPid);
    pHeapListReply = (struct HeapListReply *)receive(HeapListReplySig);
    if (pHeapListReply->status != HEAP_SUCCESS)
    {
        free_buf((union SIGNAL **)&pHeapListReply);
        return ZOSS_ERROR;
    }
    pHeapStatsExReply = (struct HeapStatsExReply *)alloc(sizeof(struct HeapStatsExReply), HEAP_STATSEX_REPLY);
    if (pHeapStatsExReply == NULL)
    {
        free_buf((union SIGNAL **)&pHeapListReply);
        return ZOSS_ERROR;
    }
    for (LoopCnt = 0; LoopCnt < pHeapListReply->num_heaps; LoopCnt++)
    {
        pHeapStatsExReq         = (struct HeapStatsExRequest *)pHeapStatsExReply;
        pHeapStatsExReq->sigNo  = HEAP_STATSEX_REQUEST;
        pHeapStatsExReq->href   = pHeapListReply->heaps[LoopCnt].href;
        
        send((union SIGNAL **)&pHeapStatsExReq, HeapPid);
        
        pHeapStatsExReply = (struct HeapStatsExReply *)receive(HeapStatsExReplySig);

        if (pHeapStatsExReply->status != HEAP_SUCCESS)
        {
            free_buf((union SIGNAL **)&pHeapListReply);
            free_buf((union SIGNAL **)&pHeapStatsExReply);
            return ZOSS_ERROR;
        }

        mem_info->nMemTotal += pHeapStatsExReply->total_used + pHeapStatsExReply->total_free;
        mem_info->nMemUsed  += pHeapStatsExReply->total_used;
    }

    free_buf((union SIGNAL **)&pHeapListReply);
    free_buf((union SIGNAL **)&pHeapStatsExReply);
    sysparam_readattr_long("krn/log_mem/RAM", "size", (long *)&RamSize);
    sysparam_readattr_long("heap", "max_size", (long *)&HeapMaxSize);
    
    HeapMaxSize         = HeapMaxSize > RamSize ? RamSize : HeapMaxSize;
    mem_info->nMemTotal = mem_info->nMemTotal < HeapMaxSize ? HeapMaxSize : mem_info->nMemTotal;
    return ZOSS_SUCCESS;
}
#elif defined _OS_WIN
UINT32 zOss_GetSysMemInfo(T_Mem_MemInfo *mem_info)
{
#ifdef _DEBUG
    zOss_AssertEx(NULL != mem_info, ZOSS_MEM_NULL_PARAM_ERR);

    mem_info->nMemTotal = 0;
    mem_info->nMemUsed  = 0;

    return ZOSS_SUCCESS;
#else
    return ZOSS_ERROR;
#endif
}
#elif defined _OS_TOS
UINT32 zOss_GetSysMemInfo(T_Mem_MemInfo *mem_info)
{
    struct mallinfo heap_info = {0};

    zOss_AssertEx(mem_info != NULL, ZOSS_ERROR);
    
    heap_info = mallinfo();
    mem_info->nMemTotal = (UINT32)heap_info.arena;
    mem_info->nMemUsed  = (UINT32)heap_info.uordblks;
    mem_info->nMemMaxFree  = (UINT32)heap_info.maxfree;
	
    return ZOSS_SUCCESS;
}

VOID zOss_GetMallInfoForT32(VOID)
{  
    struct mallinfo heap_info = mallinfo();

    g_zOss_HeapInfo.nMemTotal   = (UINT32)heap_info.arena;
    g_zOss_HeapInfo.nMemUsed    = (UINT32)heap_info.uordblks;
    g_zOss_HeapInfo.nMemMaxFree = (UINT32)heap_info.maxfree;

    while (1)
        ;
}
#endif

#ifdef _OS_TOS
/**************************************************************************
* :     ȡڴʹϢ
* ˵:     
*   ()  void
*   ()  pMonHeapInfo:   ڴʹϢĴŵַ
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID z0ss_GetHeapInfo(T_ZOss_Mon_Heap *pMonHeapInfo)
{
#ifdef _USE_MONITOR
    T_Mem_MemInfo memInfo = {0};

    if (pMonHeapInfo)
    {
        zOss_GetSysMemInfo(&memInfo);
        pMonHeapInfo->base = tos_heap_vma_start();
        pMonHeapInfo->size = memInfo.nMemTotal;
        pMonHeapInfo->used = memInfo.nMemUsed;
    }
#endif
}
#endif

/**************************************************************************
* ƣMem_GetSysMemDebugInfo
* ѯϵͳڴϸϢ
* ˵(IN)ڴ洢ϵͳڴϸϢLISTṹ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵debug汾
**************************************************************************/
UINT32 Mem_GetSysMemDebugInfo(T_ZOss_List *mem_debug_info_lst)
{
    return ZOSS_SUCCESS;
}

/**************************************************************************
* ƣmem_getub
* ڴзڴ
* ˵(IN)    size:Ҫֽ
*   ֵ VOID ͵ָ룬ָڴ飻ʧܣ򷵻 ZOSS_NULL
* ˵ҪϢͨѶ
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
VOID *mem_getub(UINT32 size, const CHAR *file, UINT32 line)
{
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl     *pUbControl         = NULL;
    T_Mem_UBListNode    *pUbListNode        = NULL;
    ZOSS_UB_BLOCK       freeUbBlock         = NULL;    
    
    UINT32  i           = 0;
    UINT32  pool_num    = 0;
#ifdef _OS_OSE
    Msr     oldMsr      = 0;
#ifdef _DEBUG
    T_ZOsa_ThreadUserArea *pUa = NULL;
#endif
#elif defined _OS_WIN
    UINT32  status      = ZOSS_ERROR;
#ifdef _DEBUG
    T_ZOss_TCB  *pTCB   = NULL;
#endif
#endif

    /* μ */
    if (0 == size || size > gMem_UBPoolCfg[gMem_UBPoolNum - 1].pool_size)
    {
        zOss_ASSERT(size > 0);
        zOss_ASSERT(size <= gMem_UBPoolCfg[gMem_UBPoolNum - 1].pool_size);
        gMem_ErrCode = ZOSS_MEM_GETUB_SIZE_ERR;
        return ZOSS_NULL;
    }

    /* ڴδʼ */
    zOss_ASSERT(gMem_IsInit);

    if (!gMem_IsInit)
    {
        gMem_ErrCode = ZOSS_MEM_NOT_INIT_ERR;
        return ZOSS_NULL;
    }

    /* μڴغ,öַ */
    for (i = 0; i < gMem_UBPoolNum; i++)
    {
        if (gMem_UBPoolCfg[i].pool_size >= size)
        {
            pool_num = i;
            break;
        }
    }

    /* ڴؿƿʼַ */
    pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;
    /* öӦڴصڴؿƿ */
    pUbControl      = pUbControlStart + pool_num;

#ifdef _OS_OSE
    LOCK_SAVE(oldMsr);
#elif defined _OS_WIN
    status          = zOss_GetMutex(pUbControl->ubMutex, ZOSS_WAIT_FOREVER);    /* 屣                     */
    zOss_AssertEx(status != ZOSS_ERROR, ZOSS_NULL);
#endif    

    /* жϸڴǷпڴ */
    if (pUbControl->freeUbListHead == NULL) /* ޿ڴ飬ʹmalloc */
    {
#ifdef _OS_OSE    
        LOCK_RESTORE(oldMsr);
#elif defined _OS_WIN
        if (0!= gUBSuperviseSitch)  /* vc 汾ubй¶øúнй¶ */
        {
            OSA_UBLeakInfo(pool_num);
        }
        status = zOss_PutMutex(pUbControl->ubMutex);
        zOss_AssertEx(status != ZOSS_ERROR, ZOSS_NULL);
#endif 
        freeUbBlock = mem_malloc(size, file, line);
        return freeUbBlock;
    }
    pUbListNode = pUbControl->freeUbListHead;

    /* дʵʹñ߽ */
    freeUbBlock = GetUbBlockAdd(pUbControl, pUbListNode);
#ifdef _OS_OSE    
    if (freeUbBlock == ZOSS_NULL)
    {
        LOCK_RESTORE(oldMsr);
        zOss_ASSERT(freeUbBlock);
        return freeUbBlock;
    }
#endif    
    pUbControl->freeUbNum--;
#ifdef _DEBUG
    /* for ub ߲鿴ùûûУʱע
    if (pUbControl->ubSize - size >=1)
    {
        memset((CHAR *)freeUbBlock + size, MEM_UB_BLOCK_REALUSED_SIGNAL, 1);
    }
    */
    /* ʹڴ */
    pUbControl->maxUsedUbNum = (pUbControl->maxUsedUbNum < (pUbControl->ubBlockNum - pUbControl->freeUbNum)) ? (pUbControl->ubBlockNum - pUbControl->freeUbNum) : pUbControl->maxUsedUbNum;

#endif
    /* ӿڴժ */
    if (pUbControl->freeUbListHead == pUbControl->freeUbListTail)
    {
        /* ҽһ */
        pUbControl->freeUbListHead  = NULL;
        pUbControl->freeUbListTail  = NULL;
        pUbListNode->nextNode       = NULL;
    }
    else
    {
        pUbControl->freeUbListHead  = pUbControl->freeUbListHead->nextNode;
        pUbListNode->nextNode       = NULL;
    }
#ifdef _OS_OSE    
    /* ͷŻ */
    LOCK_RESTORE(oldMsr);
#elif defined _OS_WIN
    status = zOss_PutMutex(pUbControl->ubMutex);
    zOss_AssertEx(status != ZOSS_ERROR, ZOSS_NULL);
#endif    

    /* ڴͷϢ */
#ifdef _DEBUG
    if (0 != gUBSuperviseSitch)
    {
#ifdef _OS_OSE    
        /* ޸̺߳UA */
        pUa = Osa_GetThreadUserArea(zOss_GetCurThreadID(), FALSE);
        if (pUa != NULL)
        {
            pUa ->ubsize += pUbControl->ubSize;

            if (pUa->curtaskid != NULL)
            {
                ((T_ZOss_TCB *)pUa->curtaskid)->ub_size += pUbControl->ubSize;
            }
            pUbListNode->ubBlockHeader.taskId   = pUa->curtaskid;
            pUbListNode->ubBlockHeader.threadId = pUa->threadid;
        }
        else
        {
            pUbListNode->ubBlockHeader.taskId   = zOss_GetSelfTaskID();
            pUbListNode->ubBlockHeader.threadId = zOss_GetCurThreadID();
        }
#elif defined _OS_WIN
        pUbListNode->ubBlockHeader.taskId           = zOss_GetSelfTaskID();
        pUbListNode->ubBlockHeader.threadId         = zOss_GetCurThreadID();
#endif        
        pUbListNode->ubBlockHeader.line             = line;
        pUbListNode->ubBlockHeader.applyTimeTick    = zOss_GetTickCount();
        
        strncpy((char *)pUbListNode->ubBlockHeader.name, (char *)Mem_SubStr((CHAR *)file), ZOSS_UBHEAD_FILENAME_LEN + 1);

        pUbListNode->ubBlockHeader.name[ZOSS_UBHEAD_FILENAME_LEN] = 0;

#ifdef _OS_WIN
        /* ޸̺߳UA */
        pTCB = (T_ZOss_TCB *)(pUbListNode->ubBlockHeader.taskId);
        if (NULL != pTCB)
        {
            pTCB->ub_size += pUbControl->ubSize;
        }
#endif        
    }
#endif

    pUbListNode->ubBlockHeader.usingSize    = size;
    pUbListNode->ubBlockHeader.isUsed       = TRUE;
    /* ڴַ */
    return freeUbBlock;
}
#endif

/**************************************************************************
* ƣzOss_RetUB
* ӦzOss_GetUBͷŸڴ
* ˵(IN) msg_ptr:Ҫͷŵڴĵַָ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ش
* ˵
**************************************************************************/
#if defined (_OS_OSE) || defined (_OS_WIN)
UINT32 mem_retub(VOID * msg_ptr, const CHAR *file, UINT32 line)
{
    UINT32              serialNum           = 0;
    UINT32              i                   = 0;
    //UINT32              ubBlockAdd          = 0;
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl     *pUbControl         = NULL;
    T_Mem_UBListNode    *ubBlockHeaderNode  = NULL;
#ifdef _OS_WIN
    UINT32              status              = ZOSS_ERROR;
#endif
    
#ifdef _OS_OSE
    Msr                     oldMsr  = 0;
#ifdef _DEBUG
    T_ZOsa_ThreadUserArea   *pUa    = NULL;
#endif
#endif   

#ifdef _DEBUG
    UINT32                  blockDivid      = 0;
    T_ZOss_TCB              *pTCB           = NULL;
    UINT32                  blockHeaderAdd  = 0;
#endif
    /* μ */
    zOss_AssertEx(NULL != msg_ptr, ZOSS_MEM_NULL_PARAM_ERR);
    zOss_AssertEx(gMem_IsInit, ZOSS_MEM_NOT_INIT_ERR);

    /* ڴؿƿʼַ */
    pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;

    /* ָ뷶Χжub뻹mallocָ */
    if (((UINT32)msg_ptr < (UINT32)pUbControlStart->ubBlockStart) || ((UINT32)msg_ptr > gMem_UBEnd))
    {
        mem_free_extend(msg_ptr, file, line);
        return ZOSS_SUCCESS;
    }
    pUbControl = pUbControlStart + 1;

    /* ڴڵڴ */
    for (i = 0; i < gMem_UBPoolNum - 1; i++)
    {
        if ((UINT32 *)msg_ptr < (UINT32 *)pUbControl->ubBlockStart)
        {
            break;
        }
        pUbControl++;
    }
    pUbControl--;

    /* ǷΪȷڴַ */
    if (((UINT32)msg_ptr - (4 + (UINT32)pUbControl->ubBlockStart)) % (4 + pUbControl->ubSize + ubBlockBorder) != 0)
    {
        /* ͷŵָԭָʹùбƫ */
        /* ȷڴȷĵַΪĵַ */
        //ubBlockAdd = (UINT32)((CHAR *)pUbControl->ubBlockStart + i * (pUbControl->ubSize + 4 + ubBlockBorder) + 4);
        zOss_Printf(SUBMDL_MEM, PRINT_LEVEL_ABNORMAL, "ͷŵָԭָʹùбƫ,ļ:%s  к:%d\n", file, line);
        zOss_ASSERT(0);
        return ZOSS_MEM_POINTER_RANGE_ERR;

    }
    serialNum           = ((UINT32)msg_ptr - (4 + (UINT32)pUbControl->ubBlockStart)) / (4 + pUbControl->ubSize + ubBlockBorder);
    ubBlockHeaderNode   = pUbControl->ubMemHeaderStart + serialNum;
    //ubBlockHeader = (T_Mem_UBListNode *)((CHAR *)msg_ptr - 4);
    /* Ƿظͷ */
    zOss_AssertEx(ubBlockHeaderNode->ubBlockHeader.isUsed, ZOSS_MEM_UB_REFREE_ERR);

#ifdef _DEBUG
    if (0 != gUBSuperviseSitch)
    {
        /* ڴеڴͷǷʵڴͷַͬ */
        memcpy(&blockHeaderAdd, (CHAR *)msg_ptr - 4, 4);
        if (blockHeaderAdd != (UINT32)ubBlockHeaderNode)
        {
            /* ڴ߽类 ԭһڴԽ */
            zOss_Printf(SUBMDL_MEM, PRINT_LEVEL_ABNORMAL, "ڴ߽类 ԭһڴԽ,ļ:%s  к:%d\n", file, line);
            zOss_ASSERT(0);
            return ZOSS_MEM_UB_OVERFLOW_ERR;
        }
        /* ڴʵʹñ߽ */
        /* for ub ߲鿴ùûûУʱע
        if (pUbControl->ubSize - ubBlockHeaderNode->ubBlockHeader.usingSize > 0)
        {
            memcpy(&temp, (CHAR *)msg_ptr + ubBlockHeaderNode->ubBlockHeader.usingSize, 1);
            if (temp != MEM_UB_BLOCK_REALUSED_SIGNAL)
            {
                status = zOss_Printf(SUBMDL_MEM, PRINT_LEVEL_ABNORMAL, "ڴʵʹñ߽类 ԭǲԽ,ļ:%s  к:%d\n", file, line);
                zOss_ASSERT(0);
                return ZOSS_MEM_UB_OVERFLOW_ERR;
            }
        }
        */
        /* ڴ߽ */
        if ((UINT32)((CHAR *)msg_ptr - 4) != (UINT32)pUbControlStart->ubBlockStart)
        {
            memcpy(&blockDivid, ((CHAR *)msg_ptr - 4) - ubBlockBorder, 4);
            if (blockDivid != MEM_UB_BLOCK_DIVIDE_VALUE)
            {
                /* ڴ߽类 ԭһڴԽ */
                zOss_Printf(SUBMDL_MEM, PRINT_LEVEL_ABNORMAL, "ڴʵʹñ߽类 ԭǲԽ,ļ:%s  к:%d\n", file, line);
                zOss_ASSERT(0);
                return ZOSS_MEM_UB_OVERFLOW_ERR;
            }
        }
    }
#endif

    /* ʵʹñ */
#ifdef _DEBUG
    if (0 != gUBSuperviseSitch)
    {
        if (pUbControl->ubSize - ubBlockHeaderNode->ubBlockHeader.usingSize > 0)
        {
            memset((CHAR *)msg_ptr + ubBlockHeaderNode->ubBlockHeader.usingSize, 0, 1);
        }
        /* ޸̺߳UA */
        pTCB = (T_ZOss_TCB *)(ubBlockHeaderNode->ubBlockHeader.taskId);
        if (NULL != pTCB)
        {
            pTCB->ub_size -= pUbControl->ubSize;
        }
#ifdef _OS_OSE        
        if (NULL != ubBlockHeaderNode->ubBlockHeader.threadId)
        {
            pUa = Osa_GetThreadUserArea(ubBlockHeaderNode->ubBlockHeader.threadId, FALSE);
            if (pUa != NULL)
            {
                pUa->ubsize -= pUbControl->ubSize;
            }
        }
#endif        
    }
#endif

#ifdef _OS_OSE
    LOCK_SAVE(oldMsr);
#elif defined _OS_WIN
    status = zOss_GetMutex(pUbControl->ubMutex, ZOSS_WAIT_FOREVER);   /* 屣 */
    zOss_AssertEx(status != ZOSS_ERROR, ZOSS_ERROR);
#endif    

    /* ޸ڴͷ */
    ubBlockHeaderNode->ubBlockHeader.isUsed = FALSE;
    /* ¿ڴ */
    pUbControl->freeUbNum++;
    /* ýβ */
    if (pUbControl->freeUbListTail == NULL)
    {
        pUbControl->freeUbListTail  = ubBlockHeaderNode;
        pUbControl->freeUbListHead  = ubBlockHeaderNode;
        ubBlockHeaderNode->nextNode = NULL;
    }
    else
    {
        pUbControl->freeUbListTail->nextNode    = ubBlockHeaderNode;
        ubBlockHeaderNode->nextNode             = NULL;
        pUbControl->freeUbListTail              = ubBlockHeaderNode;
    }
#ifdef _OS_OSE    
    /* ͷŻ */
    LOCK_RESTORE(oldMsr);
#elif defined _OS_WIN
    status = zOss_PutMutex(pUbControl->ubMutex);
    zOss_AssertEx(status != ZOSS_ERROR, ZOSS_ERROR);
#endif    

    return ZOSS_SUCCESS;
}
#endif

/**************************************************************************
* ƣMem_GetUBUseInfo
* ѯڴͳϢ
* ˵(IN)ڴ洢ڴͳϢT_Mem_UBPoolGrpInfoṹ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵debug汾
**************************************************************************/
UINT32 Mem_GetUBUseInfo(T_Mem_UBPoolGrpInfo *ub_pool_grp_info, UINT8 poolNum)
{
#if defined (_OS_OSE) || defined (_OS_WIN)
#ifdef _DEBUG
    UINT8           i           = 0;
    T_Mem_UBPoolCtl *pUbControl = NULL;
    if (0 != gUBSuperviseSitch)
    {
        zOss_AssertEx(NULL != ub_pool_grp_info, ZOSS_MEM_NULL_PARAM_ERR);
        zOss_AssertEx(gMem_IsInit, ZOSS_MEM_NOT_INIT_ERR);
        
        //*ub_pool_grp_info = gMem_UBPoolGrpInfo;
        pUbControl                  = (T_Mem_UBPoolCtl *)gMem_UBStart;
        ub_pool_grp_info->pool_num  = (UINT8)gMem_UBPoolNum;

        zOss_AssertEx(gMem_UBPoolNum <= ZOSS_UB_MAX_POOLNUM, ZOSS_ERROR);

        for (i = 0; i < gMem_UBPoolNum; i++)
        {
            ub_pool_grp_info->pool_info[i].pool_size        = pUbControl->ubSize;
            ub_pool_grp_info->pool_info[i].total_block_num  = (UINT16)pUbControl->ubBlockNum;
            ub_pool_grp_info->pool_info[i].free_block_num   = (UINT16)pUbControl->freeUbNum;
            ub_pool_grp_info->pool_info[i].peak_value       = pUbControl->maxUsedUbNum;
            pUbControl++;
        }

        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#else
    return ZOSS_SUCCESS;
#endif
#else 
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣMem_CheckUBLeak
* ڴвڴй¶Ϣ
* ˵(IN)    ub_leak_info:ڴ洢ڴڴй¶ϢT_Mem_UBLeakInfoṹ
                    ub_leak_time:жڴй¶ʱ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵debug汾
**************************************************************************/
UINT32 Mem_CheckUBLeak(T_Mem_UBLeakInfo *ub_leak_info, UINT32 ub_leak_time, UINT8 poolNum, UINT32 size)
{
#if defined (_OS_OSE) || defined (_OS_WIN)
#ifdef _DEBUG
    UINT16              ubLeakNum           = 0;
    UINT32              now_time            = 0;
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl     *pUbControl         = NULL;
    T_Mem_UBListNode    *ubBlockHeaderStart = NULL;
    T_Mem_UBListNode    *ubBlockHeaderNode  = NULL;
    if (0 != gUBSuperviseSitch)
    {
        zOss_AssertEx(NULL != ub_leak_info, ZOSS_MEM_NULL_PARAM_ERR);
        zOss_AssertEx(gMem_IsInit, ZOSS_MEM_NOT_INIT_ERR);
        
        /* ڴؿƿʼַ */
        pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;
        /* ȡǰʱ(tick) */
        now_time = zOss_GetTickCount();
        /* ڴͷʼַ */
        ubBlockHeaderStart  = pUbControlStart->ubMemHeaderStart;
        ubBlockHeaderNode   = ubBlockHeaderStart;
        /* ڴй¶Ŀ0 */
        ub_leak_info->ub_leak_num = 0;

        while (ubLeakNum < MEM_MAX_LEAK_UB)
        {
            if ((UINT32)ubBlockHeaderNode == (UINT32)pUbControlStart->ubBlockStart)
                break;
            if ((ubBlockHeaderNode->ubBlockHeader.isUsed) && (ubBlockHeaderNode->ubBlockHeader.usingSize>size))
            {
                if ((now_time - ubBlockHeaderNode->ubBlockHeader.applyTimeTick) > ub_leak_time*1000)
                {
                    ub_leak_info->ubHeadInfo[ubLeakNum].applyTimeTick   = ubBlockHeaderNode->ubBlockHeader.applyTimeTick;
                    ub_leak_info->ubHeadInfo[ubLeakNum].line            = ubBlockHeaderNode->ubBlockHeader.line;
                    
                    strncpy((char *)ub_leak_info->ubHeadInfo[ubLeakNum].name, 
                            (char *)ubBlockHeaderNode->ubBlockHeader.name, 
                            ZOSS_UBHEAD_FILENAME_LEN);
                    
                    ub_leak_info->ubHeadInfo[ubLeakNum].name[ZOSS_UBHEAD_FILENAME_LEN]  = 0;
                    ub_leak_info->ubHeadInfo[ubLeakNum].taskId                          = ubBlockHeaderNode->ubBlockHeader.taskId;
                    ub_leak_info->ubHeadInfo[ubLeakNum].threadId                        = ubBlockHeaderNode->ubBlockHeader.threadId;
                    ub_leak_info->ubHeadInfo[ubLeakNum].usingSize                       = ubBlockHeaderNode->ubBlockHeader.usingSize;
                    pUbControl                                                          = GetUbPoolCtrAdd(ubBlockHeaderNode);
                    zOss_AssertEx(pUbControl != NULL, ZOSS_ERROR);
                    ub_leak_info->ubHeadInfo[ubLeakNum].ubBlock                         = GetUbBlockAdd(pUbControl, ubBlockHeaderNode);
                    ub_leak_info->ubHeadInfo[ubLeakNum].ubBlockSize                     = pUbControl->ubSize;
                    ubLeakNum++;
                }
            }
            ubBlockHeaderNode++;
        }
        ub_leak_info->ub_leak_num = ubLeakNum;
        return ZOSS_SUCCESS;
    }
    else
    {
        return ZOSS_ERROR;
    }
#else
    return ZOSS_SUCCESS;
#endif
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣMem_ThreadUBInfo
* ڴвͬһ߳UBڴϢ
* ˵(IN)
*           threadId: ߳ID
*           num: ϣѯڴĿ
*           poolNum:ѯڴغ
*           (OUT)
*           threadUbInfo:ѯڴϢ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵debug汾
**************************************************************************/
UINT32 Mem_ThreadUBInfo(ZOSS_THREAD_ID threadId, T_Mem_UBBlockInfo *threadUbInfo, UINT32 num, UINT8 poolNum)
{
#if defined (_OS_OSE) || defined (_OS_WIN)
#ifdef _DEBUG
    UINT32              threadUbNum         = 0;
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl     *pUbControl         = NULL;
    T_Mem_UBListNode    *ubBlockHeaderStart = NULL;
    T_Mem_UBListNode    *ubBlockHeaderNode  = NULL;

    if (0 != gUBSuperviseSitch)
    {
        zOss_AssertEx((NULL != threadUbInfo) && (num != 0), ZOSS_MEM_NULL_PARAM_ERR);
        zOss_AssertEx(gMem_IsInit, ZOSS_MEM_NOT_INIT_ERR);
  
        /* ڴؿƿʼַ */
        pUbControlStart     = (T_Mem_UBPoolCtl *)gMem_UBStart;
        /* ڴͷʼַ */
        ubBlockHeaderStart  = pUbControlStart->ubMemHeaderStart;
        ubBlockHeaderNode   = ubBlockHeaderStart;

        while (threadUbNum < num)
        {
            if ((UINT32)ubBlockHeaderNode == (UINT32)pUbControlStart->ubBlockStart)
            {
                break;
            }
            if (ubBlockHeaderNode->ubBlockHeader.isUsed)
            {
                if (ubBlockHeaderNode->ubBlockHeader.threadId == threadId)
                {
                    threadUbInfo->applyTimeTick                     = ubBlockHeaderNode->ubBlockHeader.applyTimeTick;
                    threadUbInfo->line                              = ubBlockHeaderNode->ubBlockHeader.line;

                    strncpy((char *)threadUbInfo->name, 
                            (char *)ubBlockHeaderNode->ubBlockHeader.name, 
                            ZOSS_UBHEAD_FILENAME_LEN);

                    threadUbInfo->name[ZOSS_UBHEAD_FILENAME_LEN]    = 0;
                    threadUbInfo->taskId                            = ubBlockHeaderNode->ubBlockHeader.taskId;
                    threadUbInfo->threadId                          = threadId;
                    threadUbInfo->usingSize                         = ubBlockHeaderNode->ubBlockHeader.usingSize;
                    pUbControl                                      = GetUbPoolCtrAdd(ubBlockHeaderNode);
                    zOss_AssertEx(pUbControl != NULL, ZOSS_ERROR);
                    threadUbInfo->ubBlockSize                       = pUbControl->ubSize;
                    threadUbInfo->ubBlock                           = GetUbBlockAdd(pUbControl, ubBlockHeaderNode);
                    threadUbInfo++;
                    threadUbNum++;
                }
            }
            ubBlockHeaderNode++;
        }
        return threadUbNum;
    }
    else
    {
        return ZOSS_ERROR;
    }
#else
    return ZOSS_ERROR;
#endif
#else
    return ZOSS_SUCCESS;
#endif
}

/**************************************************************************
* ƣMem_TaskUBInfo
* ڴвͬһUBڴϢ
* ˵(IN)
*           taskId: ID
*           num: ϣѯڴĿ
*           poolNum:ѯڴغ
*           (OUT)
*           taskUbInfo:ѯڴϢ
*   ֵɹ:ZOSS_SUCCESS;ʧ:ZOSS_ERROR
* ˵debug汾
**************************************************************************/
UINT32 Mem_TaskUBInfo (ZOSS_TASK_ID taskId, T_Mem_UBBlockInfo *taskUbInfo, UINT32 num, UINT8 poolNum)
{
#ifdef _DEBUG
    UINT32              taskUbNum           = 0;
    T_Mem_UBPoolCtl     *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl     *pUbControl         = NULL;
    T_Mem_UBListNode    *ubBlockHeaderStart = NULL;
    T_Mem_UBListNode    *ubBlockHeaderNode  = NULL;

    if (0 != gUBSuperviseSitch)
    {
        zOss_AssertEx((NULL != taskUbInfo) && (num != 0), ZOSS_MEM_NULL_PARAM_ERR);
        zOss_AssertEx(gMem_IsInit, ZOSS_MEM_NOT_INIT_ERR);

        /* ڴؿƿʼַ */
        pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;
        /* ڴͷʼַ */
        ubBlockHeaderStart = pUbControlStart->ubMemHeaderStart;
        ubBlockHeaderNode = ubBlockHeaderStart;

        while (taskUbNum < num)
        {
            if ((UINT32)ubBlockHeaderNode == (UINT32)pUbControlStart->ubBlockStart)
            {
                break;
            }
            if (ubBlockHeaderNode->ubBlockHeader.isUsed)
            {
                if (ubBlockHeaderNode->ubBlockHeader.taskId == taskId)
                {
                    taskUbInfo->applyTimeTick                   = ubBlockHeaderNode->ubBlockHeader.applyTimeTick;
                    taskUbInfo->line                            = ubBlockHeaderNode->ubBlockHeader.line;

                    strncpy((char *)taskUbInfo->name, 
                            (char *)ubBlockHeaderNode->ubBlockHeader.name,
                            ZOSS_UBHEAD_FILENAME_LEN);
                    
                    taskUbInfo->name[ZOSS_UBHEAD_FILENAME_LEN]  = 0;
                    taskUbInfo->taskId                          = taskId;
                    taskUbInfo->threadId                        = ubBlockHeaderNode->ubBlockHeader.threadId;
                    taskUbInfo->usingSize                       = ubBlockHeaderNode->ubBlockHeader.usingSize;
                    pUbControl                                  = GetUbPoolCtrAdd(ubBlockHeaderNode);
                    zOss_AssertEx(pUbControl != NULL, ZOSS_ERROR);
                    taskUbInfo->ubBlockSize                     = pUbControl->ubSize;
                    taskUbInfo->ubBlock                         = GetUbBlockAdd(pUbControl, ubBlockHeaderNode);
                    taskUbInfo++;
                    taskUbNum++;
                }
            }
            ubBlockHeaderNode++;
        }

        return taskUbNum;
    }
    else
    {
        return ZOSS_ERROR;
    }
#else
    return ZOSS_ERROR;
#endif
}

/**************************************************************************
* ƣzOss_GetUBFreeRate
* ȡUBС
* ˵ubSize:ub ĴС
*   ֵub
* ˵
**************************************************************************/
FLOAT zOss_GetUBFreeRate(UINT32 ubSize)
{  
#if defined (_OS_OSE) || defined (_OS_WIN)
    T_Mem_UBPoolCtl *pUbControlStart    = NULL;
    T_Mem_UBPoolCtl *pUbControl         = NULL;
    UINT32          i                   = 0;
    UINT32          pool_num            = 0;
    FLOAT           ubRate              = 0;
#ifdef _OS_OSE    
    Msr             oldMsr              = 0;
#elif defined _OS_WIN
    UINT32          status              = ZOSS_ERROR;
#endif    

    /* μ */
    if (0 == ubSize || ubSize > gMem_UBPoolCfg[gMem_UBPoolNum - 1].pool_size)
    {
        zOss_ASSERT(ubSize > 0);
        zOss_ASSERT(ubSize <= gMem_UBPoolCfg[gMem_UBPoolNum - 1].pool_size);
        gMem_ErrCode = ZOSS_MEM_GETUB_SIZE_ERR;
        return 0;
    }

    /* μڴغ,öַ */
    for (;i < gMem_UBPoolNum; i++)
    {
        if (gMem_UBPoolCfg[i].pool_size >= ubSize)
        {
            pool_num = i;
            break;
        }
    }

    /* ڴؿƿʼַ */
    pUbControlStart = (T_Mem_UBPoolCtl *)gMem_UBStart;
    /* öӦڴصڴؿƿ */
    pUbControl      = pUbControlStart + pool_num;
#ifdef _OS_OSE
    LOCK_SAVE(oldMsr);
#elif defined _OS_WIN
    status = zOss_GetMutex(pUbControl->ubMutex, ZOSS_WAIT_FOREVER);
    zOss_AssertEx(status != ZOSS_ERROR, 0);
#endif    
    ubRate          = (FLOAT)(pUbControl->freeUbNum) / (pUbControl->ubBlockNum);
#ifdef _OS_OSE
    LOCK_RESTORE(oldMsr);
#elif defined _OS_WIN
    status = zOss_PutMutex(pUbControl->ubMutex);
    zOss_AssertEx(status != ZOSS_ERROR, 0);
#endif
    return ubRate;
#else
    return (FLOAT)(0.8);
#endif
}

/**************************************************************************
* ƣzOss_PrintMemLog
* ڴϢϢ
* ˵
*   ֵub
* ˵
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
VOID zOss_PrintMemLog( VOID )
{
    T_Mem_DebugInfo     *p_mem_context  = NULL;
    UINT32              retCode         = ZOSS_ERROR;
    
    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    
    p_mem_context = (T_Mem_DebugInfo *)zOss_ListFirst(&s_mem_list);
    while (NULL != p_mem_context)
    {
        retCode = zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "[threadeid]: 0x%x,[lr]: 0x%x,[file name]: %s, [line number]: %d, [memory size]: %d\n", p_mem_context->thread_id, p_mem_context->uiLR, p_mem_context->file_name, p_mem_context->line, p_mem_context->mem_size);
        if (retCode == ZOSS_ERROR)
        {
            zOss_Sleep(10);
            retCode = zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "[threadeid]: 0x%x,[lr]: 0x%x,[file name]: %s, [line number]: %d, [memory size]: %d\n", p_mem_context->thread_id, p_mem_context->uiLR, p_mem_context->file_name, p_mem_context->line, p_mem_context->mem_size);
        }
        p_mem_context = (T_Mem_DebugInfo *)zOss_ListNext((T_ZOss_Node *)p_mem_context);
    }
    zOss_PutMutex(s_mem_mutex);
}
#endif

/**************************************************************************
* ƣzOss_DebugMem
* ڴǷԽ
* ˵
*   ֵub
* ˵
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
VOID zOss_DebugMem( VOID )
{
    T_Mem_DebugInfo     *p_mem_context  = NULL;
    UINT32              retCode         = ZOSS_ERROR;
    
    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    
    p_mem_context = (T_Mem_DebugInfo *)zOss_ListFirst(&s_mem_list);
    while (NULL != p_mem_context)
    {
        if (MEM_MAGIC_NUM != *mem_context_magic(p_mem_context))
        {
            retCode = zOss_Printf(SUBMDL_OSA,PRINT_LEVEL_NORMAL, "[threadeid]: 0x%x, [lr]: 0x%x, [file name]: %s, [line number]: %d, [memory size]: %d\n", p_mem_context->thread_id,p_mem_context->uiLR,p_mem_context->file_name, p_mem_context->line, p_mem_context->mem_size);
            if (retCode == ZOSS_ERROR)
            {
                zOss_Sleep(10);
                retCode = zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "[threadeid]: 0x%x, [lr]: 0x%x, [file name]: %s, [line number]: %d, [memory size]: %d\n", p_mem_context->thread_id,p_mem_context->uiLR,p_mem_context->file_name, p_mem_context->line, p_mem_context->mem_size);
            }
        }
        p_mem_context = (T_Mem_DebugInfo *)zOss_ListNext((T_ZOss_Node *)p_mem_context );
    }
    zOss_PutMutex(s_mem_mutex);
}
#endif

/**************************************************************************
* ƣzOss_MemLeakStart
* ڴй¶ʼʱй¶ֵ
* ˵(IN)
                leak_threadhold:й¶ķֵ
            (OUT)
*   ֵ
* ˵
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
VOID zOss_MemLeakStart(UINT32 leak_threadhold)
{
#ifdef _OS_TOS
    tos_heap_trace_leak_start(leak_threadhold);
#else
    s_mem_leak_tick_start      = zOss_GetTickCount();
    s_mem_leak_tick_threadhold = leak_threadhold;
#endif
}
#endif

/**************************************************************************
* ƣzOss_MemLeakEnd
* ĳʱmemй¶
* ˵(IN)
            (OUT)
*   ֵ
* ˵
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
VOID zOss_MemLeakEnd( VOID )
{
#if defined (_OS_OSE) || defined (_OS_WIN)
    T_Mem_DebugInfo     *p_mem_context  = NULL;
    UINT32              retCode         = ZOSS_ERROR;
    UINT32              tick_cur        = zOss_GetTickCount();    

    zOss_GetMutex(s_mem_mutex, ZOSS_WAIT_FOREVER);
    
    p_mem_context = (T_Mem_DebugInfo *)zOss_ListFirst(&s_mem_list);
    while (NULL != p_mem_context)
    {
        if ((s_mem_leak_tick_start <= p_mem_context->tick_malloced)
                && (s_mem_leak_tick_threadhold <= tick_cur - p_mem_context->tick_malloced))
        {
            retCode = zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "[threadeid]: 0x%x,[lr]: 0x%x,[file name]: %s, [line number]: %d, [memory size]: %d\n", p_mem_context->thread_id, p_mem_context->uiLR, p_mem_context->file_name, p_mem_context->line, p_mem_context->mem_size);
            if (retCode == ZOSS_ERROR)
            {
                zOss_Sleep(10);
                retCode = zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "[threadeid]: 0x%x, [lr]: 0x%x, [file name]: %s, [line number]: %d, [memory size]: %d\n", p_mem_context->thread_id, p_mem_context->uiLR, p_mem_context->file_name, p_mem_context->line, p_mem_context->mem_size);
            }
        }

        p_mem_context = (T_Mem_DebugInfo *)zOss_ListNext((T_ZOss_Node *)p_mem_context);
    }
    zOss_PutMutex(s_mem_mutex);
#elif defined _OS_TOS	
    tos_heap_trace_leak_end();
#endif
}
#endif

/**************************************************************************
* ƣzOss_CheckMem
* memʹϢ
* ˵(IN)
            (OUT)
*   ֵ
* ˵
**************************************************************************/
#ifdef _USE_HEAP_DEBUG
VOID zOss_CheckMem(VOID)
{
#ifdef _OS_TOS
    tos_heap_print_leak(0);
    tos_heap_trace_overflow();
#else
    zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "\t==========ڴʹϢ==========");
    zOss_PrintMemLog();
    zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, "\t==========ڴԽϢ==========");
    zOss_DebugMem();
#endif
}
#endif

/**************************************************************************
* ƣzOss_SetMemDbgSwitch
* ubĵԿ
* ˵(IN)
                ֵʾ
                ֵʾر
            (OUT)
*   ֵ
* ˵
**************************************************************************/
VOID zOss_SetUbDbgSwitch(UINT32 dbgFlag)
{
#if defined (_OS_OSE) || defined (_OS_WIN)
    gUBSuperviseSitch = dbgFlag;
#endif
}

/**************************************************************************
* ƣzOss_GetMemInitState
* ȡڴĳʼ״̬
* ˵(IN)
            (OUT)
*   ֵڴɳʼ棬򷵻ؼ
* ˵VOID
**************************************************************************/
#ifdef _OS_OSE
BOOL zOss_GetMemInitState(VOID)
{
    return gMem_IsInit;
}
#endif

#endif

/**************************************************************************
* :     ȡcache lineַĿռ
* ˵:     
*   ()  size: ռС
*   ()  void
*   ֵ:     ûռַ
* ˵:     void
**************************************************************************/
VOID *zOss_CacheMalloc(UINT32 size)
{
	VOID *ptr;
	VOID *head;
	UINT32 total_size;
	UINT32 dcache_line_size = 0;
	
	if (size == 0)
		return NULL;

    dcache_line_size = ZOSS_DCACHE_LINE_SIZE;
	total_size = size + dcache_line_size * 3;

	head = zOss_Malloc(total_size);

	if (head == NULL)
		return NULL;

	ptr = (VOID *)ALIGN_TO((UINT32)head, dcache_line_size);
	ptr = (VOID *)((UINT32)ptr + dcache_line_size);

	*(UINT32 *)((UINT32)ptr - sizeof(VOID *)) = (UINT32)head;

	return ptr;
}

/**************************************************************************
* :     ͷcache lineַĿռ
* ˵:     
*   ()  ptr: ռָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
VOID zOss_CacheFree(VOID *ptr)
{
	VOID *head;
	
	head = (VOID *)(*(UINT32 *)((UINT32)ptr - sizeof(VOID *)));

	zOss_Free(head);
}

#if defined(_OS_LINUX) && defined(_UB_USE_HEAP_DEBUG)
#define POOL_DEBUG_MAGIC 0x5AA55AA5
typedef struct pool_debug_node
{
    T_ZOss_Node	        node;
    UINT32              magic;
    const char          *file;                  /* λļ  */
    UINT32              line;                   /* λк  */      
    UINT32              size;                   /* С      */
    void                *thread_id;              /* ߳ID*/	 
    UINT32              time;
} pool_debug_node_t;

typedef struct pool_debug_info
{
	UINT32      total_size;
	T_ZOss_List head;
} pool_debug_info_t;

pool_debug_info_t g_PoolAllocInfo;

void *ub_debug_alloc(unsigned long size, const char *file, unsigned long line)
{
    UINT32 intr;
    UINT32 tmp_sz;
    pool_debug_node_t *node;

    tmp_sz = sizeof(pool_debug_node_t) + size;
	
    if(tmp_sz <= PAGE_SIZE)
        node = (pool_debug_node_t *)kmalloc(tmp_sz, GFP_KERNEL);
    else
        node = (pool_debug_node_t *)vmalloc(tmp_sz);

    node->file = file;
    node->line = line;
    node->size = size;
    node->thread_id = current;
    node->time = zOss_GetTickCount();
    node->magic = POOL_DEBUG_MAGIC;

    ZOSS_SAVE_IRQ(intr);
    zOss_ListAdd(&g_PoolAllocInfo.head, (T_ZOss_Node *)node);
    g_PoolAllocInfo.total_size += size;
    ZOSS_RESTORE_IRQ(intr);

    return (void *)((char *)node + sizeof(pool_debug_node_t));
}

void ub_debug_free(void *ptr)
{
    UINT32 intr;
    UINT32 size;
    pool_debug_node_t *node;

    node = (pool_debug_node_t *)(ptr - sizeof(pool_debug_node_t));

    if (node->magic != POOL_DEBUG_MAGIC)
        zOss_ASSERT(0);
    node->magic = 0;
    size = node->size;

    ZOSS_SAVE_IRQ(intr);
    zOss_ListDelete(&g_PoolAllocInfo.head, (T_ZOss_Node *)node);
    g_PoolAllocInfo.total_size -= size;
    ZOSS_RESTORE_IRQ(intr);  

    if(!is_vmalloc_addr((void *)node))
        kfree((void *)node);
    else
        vfree((void *)node);
}
#endif

#ifdef __cplusplus
}
#endif

