/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     oss_pool.c
* ļʶ:     oss_pool.c
* ժҪ:     oss֧Ųڴعģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/08/25      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "oss_monitor.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#ifndef _USE_OSS_MIN
#define POOL_MAGIC
#define POOL_FREE_CHECK
#endif

#ifdef POOL_REALLOC
#define POOL_SIZE_CHECK
#endif

#define POOL_INDEX_0_MAGIC  (0x12345678)    /* the magic of index 0 pool node   */
#define POOL_INDEX_1_MAGIC  (0x23456789)    /* the magic of index 1 pool node   */
#define POOL_INDEX_2_MAGIC  (0x3456789a)    /* the magic of index 2 pool node   */
#define POOL_INDEX_3_MAGIC  (0x456789ab)    /* the magic of index 3 pool node   */
#define POOL_INDEX_4_MAGIC  (0x56789abc)    /* the magic of index 4 pool node   */
#define POOL_INDEX_5_MAGIC  (0x6789abcd)    /* the magic of index 5 pool node   */
#define POOL_INDEX_6_MAGIC  (0x789abcde)    /* the magic of index 6 pool node   */
#define POOL_INDEX_7_MAGIC  (0x89abcdef)    /* the magic of index 7 pool node   */
#define POOL_INDEX_8_MAGIC  (0x9abcdef1)    /* the magic of index 8 pool node   */
#define POOL_INDEX_9_MAGIC  (0xabcdef12)    /* the magic of index 9 pool node   */
#define POOL_INDEX_10_MAGIC (0xbcdef123)    /* the magic of index 10 pool node  */
#define POOL_INDEX_11_MAGIC (0xcdef1234)    /* the magic of index 11 pool node  */
#define POOL_INDEX_12_MAGIC (0xdef12345)    /* the magic of index 12 pool node  */
#define POOL_INDEX_13_MAGIC (0xef123456)    /* the magic of index 13 pool node  */
#define POOL_INDEX_14_MAGIC (0xf1234567)    /* the magic of index 14 pool node  */
#define POOL_INDEX_15_MAGIC (0x12345678)    /* the magic of index 15 pool node  */

#define POOL_MAP            ((1<<POOL_INDEX_NUM) - 1)

#define POOL_ERROR_NONE                 0
#define POOL_ERROR_NOT_INIT             1
#define POOL_ERROR_SIZE_ZERO            2
#define POOL_ERROR_SIZE_OVERFLOW        3
#define POOL_ERROR_MAGIC_CORRUPT        4
#define POOL_ERROR_FREE_NULL            5
#define POOL_ERROR_FREE_NOT_ALIGN       6
#define POOL_ERROR_FREE_INVALID         7
#define POOL_ERROR_FREE_HEAD_NULL       8
#define POOL_ERROR_FREE_HEAD_INVALID    9
#define POOL_ERROR_SIZE_NULL            10
#define POOL_ERROR_SIZE_NOT_ALIGN       11
#define POOL_ERROR_SIZE_INVALID         12
#define POOL_ERROR_SIZE_HEAD_NULL       13
#define POOL_ERROR_SIZE_HEAD_INVALID    14

#ifdef POOL_DEBUG
//zOss_Printf(SUBMDL_OSA, PRINT_LEVEL_NORMAL, fmt, ##__VA_ARGS__);
# define DBG(fmt, ...)                                                      \
    ZOSS_MACRO_START                                                        \
        printk(fmt, ##__VA_ARGS__);                                         \
    ZOSS_MACRO_END
#else
# define DBG(fmt, ...)
#endif

#ifndef POOL_LEAK_CHECK_TIMEOUT
# define POOL_LEAK_CHECK_TIMEOUT        (100)
#endif

#ifndef POOL_ALLOC_STATISTIC_NUM
# define POOL_ALLOC_STATISTIC_NUM       (8)
#endif

#define POOL_LOCK(flags)        ZOSS_SAVE_IRQ(flags)
#define POOL_UNLOCK(flags)      ZOSS_RESTORE_IRQ(flags)

#ifdef _OS_TOS
# define POOL_CURRENT_TIME()    cyg_current_time_lo()
# define POOL_MALLOC(size)      malloc(size)
# define POOL_FREE(ptr)         free(ptr)
#elif defined (_OS_LINUX)
# define POOL_CURRENT_TIME()    jiffies
# define POOL_MALLOC(size)      kmalloc(size, GFP_KERNEL)
# define POOL_FREE(ptr)         kfree(ptr)
#endif
#define POOL_THREAD_SELF()      zOss_GetCurThreadID()

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
enum 
{
#if (POOL_INDEX_0_NUM)
    POOL_INDEX_0,
#endif
    
#if (POOL_INDEX_1_NUM)
    POOL_INDEX_1,
#endif
    
#if (POOL_INDEX_2_NUM)
    POOL_INDEX_2,
#endif
    
#if (POOL_INDEX_3_NUM)
    POOL_INDEX_3,
#endif
    
#if (POOL_INDEX_4_NUM)
    POOL_INDEX_4,
#endif
    
#if (POOL_INDEX_5_NUM)
    POOL_INDEX_5,
#endif
    
#if (POOL_INDEX_6_NUM)
    POOL_INDEX_6,
#endif
    
#if (POOL_INDEX_7_NUM)
    POOL_INDEX_7,
#endif
    
#if (POOL_INDEX_8_NUM)
    POOL_INDEX_8,
#endif
    
#if (POOL_INDEX_9_NUM)
    POOL_INDEX_9,
#endif
    
#if (POOL_INDEX_10_NUM)
    POOL_INDEX_10,
#endif
    
#if (POOL_INDEX_11_NUM)
    POOL_INDEX_11,
#endif
    
#if (POOL_INDEX_12_NUM)
    POOL_INDEX_12,
#endif
    
#if (POOL_INDEX_13_NUM)
    POOL_INDEX_13,
#endif
    
#if (POOL_INDEX_14_NUM)
    POOL_INDEX_14,
#endif
    
#if (POOL_INDEX_15_NUM)
    POOL_INDEX_15,
#endif
    
    POOL_INDEX_NUM,
};

typedef struct pool_node 
{
    struct pool_node    *free_next;
#ifdef POOL_LEAK_CHECK
    struct pool_node    **alloc_prev;
    struct pool_node    *alloc_next;
#endif
#ifdef POOL_REALLOC
    unsigned long       size;
#endif
#ifdef POOL_DEBUG
    const char          *file;
    unsigned long       line;
    unsigned long       time;
    ZOSS_THREAD_ID      thread_id;
#endif
#ifdef POOL_MAGIC
    unsigned long       magic;
#endif
} pool_node_t;

typedef struct 
{
    unsigned long       map;
    struct pool_node    *free_head[POOL_INDEX_NUM];

#ifdef POOL_LEAK_CHECK
    struct pool_node    *alloc_head[POOL_INDEX_NUM];
    unsigned long       trace_leak_time;
#endif

#ifdef POOL_INIT_CHECK
    unsigned long       init_flag;
#endif

#ifdef POOL_DEBUG
    unsigned long       fail_count[POOL_INDEX_NUM];
    unsigned long       free_count[POOL_INDEX_NUM];
    unsigned long       min_free_count[POOL_INDEX_NUM];
    unsigned long       alloc_statistic[POOL_INDEX_NUM][POOL_ALLOC_STATISTIC_NUM];
    int                 errno;
    struct pool_node    *alloc_error_node;
    unsigned long       alloc_error_size;
    const char          *alloc_error_file;
    unsigned long       alloc_error_line;
    struct pool_node    *free_error_node;
    void                *free_error_ptr;
    const char          *free_error_file;
    unsigned long       free_error_line;
#endif
} pool_svc_t;

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/
#if (POOL_INDEX_0_NUM)
static char pool_index_0_node[POOL_INDEX_0_NUM][sizeof(pool_node_t)   + POOL_INDEX_0_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_1_NUM)
static char pool_index_1_node[POOL_INDEX_1_NUM][sizeof(pool_node_t)   + POOL_INDEX_1_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_2_NUM)
static char pool_index_2_node[POOL_INDEX_2_NUM][sizeof(pool_node_t)   + POOL_INDEX_2_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_3_NUM)
static char pool_index_3_node[POOL_INDEX_3_NUM][sizeof(pool_node_t)   + POOL_INDEX_3_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_4_NUM)
static char pool_index_4_node[POOL_INDEX_4_NUM][sizeof(pool_node_t)   + POOL_INDEX_4_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_5_NUM)
static char pool_index_5_node[POOL_INDEX_5_NUM][sizeof(pool_node_t)   + POOL_INDEX_5_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_6_NUM)
static char pool_index_6_node[POOL_INDEX_6_NUM][sizeof(pool_node_t)   + POOL_INDEX_6_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_7_NUM)
static char pool_index_7_node[POOL_INDEX_7_NUM][sizeof(pool_node_t)   + POOL_INDEX_7_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_8_NUM)
static char pool_index_8_node[POOL_INDEX_8_NUM][sizeof(pool_node_t)   + POOL_INDEX_8_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_9_NUM)
static char pool_index_9_node[POOL_INDEX_9_NUM][sizeof(pool_node_t)   + POOL_INDEX_9_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_10_NUM)
static char pool_index_10_node[POOL_INDEX_10_NUM][sizeof(pool_node_t) + POOL_INDEX_10_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_11_NUM)
static char pool_index_11_node[POOL_INDEX_11_NUM][sizeof(pool_node_t) + POOL_INDEX_11_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_12_NUM)
static char pool_index_12_node[POOL_INDEX_12_NUM][sizeof(pool_node_t) + POOL_INDEX_12_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_13_NUM)
static char pool_index_13_node[POOL_INDEX_13_NUM][sizeof(pool_node_t) + POOL_INDEX_13_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_14_NUM)
static char pool_index_14_node[POOL_INDEX_14_NUM][sizeof(pool_node_t) + POOL_INDEX_14_SIZE] __attribute__((aligned(8)));
#endif

#if (POOL_INDEX_15_NUM)
static char pool_index_15_node[POOL_INDEX_15_NUM][sizeof(pool_node_t) + POOL_INDEX_15_SIZE] __attribute__((aligned(8)));
#endif

__tcm_data static pool_svc_t pool_svc;

#ifdef POOL_DEBUG
__tcm_const static const unsigned long pool_num[] = {
#if (POOL_INDEX_0_NUM)
    POOL_INDEX_0_NUM,
#endif

#if (POOL_INDEX_1_NUM)
    POOL_INDEX_1_NUM,
#endif

#if (POOL_INDEX_2_NUM)
    POOL_INDEX_2_NUM,
#endif

#if (POOL_INDEX_3_NUM)
    POOL_INDEX_3_NUM,
#endif

#if (POOL_INDEX_4_NUM)
    POOL_INDEX_4_NUM,
#endif

#if (POOL_INDEX_5_NUM)
    POOL_INDEX_5_NUM,
#endif

#if (POOL_INDEX_6_NUM)
    POOL_INDEX_6_NUM,
#endif

#if (POOL_INDEX_7_NUM)
    POOL_INDEX_7_NUM,
#endif

#if (POOL_INDEX_8_NUM)
    POOL_INDEX_8_NUM,
#endif

#if (POOL_INDEX_9_NUM)
    POOL_INDEX_9_NUM,
#endif

#if (POOL_INDEX_10_NUM)
    POOL_INDEX_10_NUM,
#endif

#if (POOL_INDEX_11_NUM)
    POOL_INDEX_11_NUM,
#endif

#if (POOL_INDEX_12_NUM)
    POOL_INDEX_12_NUM,
#endif

#if (POOL_INDEX_13_NUM)
    POOL_INDEX_13_NUM,
#endif

#if (POOL_INDEX_14_NUM)
    POOL_INDEX_14_NUM,
#endif

#if (POOL_INDEX_15_NUM)
    POOL_INDEX_15_NUM,
#endif
};
#endif

__tcm_const static const unsigned long pool_size[] = {
#if (POOL_INDEX_0_NUM)
    POOL_INDEX_0_SIZE,
#endif

#if (POOL_INDEX_1_NUM)
    POOL_INDEX_1_SIZE,
#endif

#if (POOL_INDEX_2_NUM)
    POOL_INDEX_2_SIZE,
#endif

#if (POOL_INDEX_3_NUM)
    POOL_INDEX_3_SIZE,
#endif

#if (POOL_INDEX_4_NUM)
    POOL_INDEX_4_SIZE,
#endif

#if (POOL_INDEX_5_NUM)
    POOL_INDEX_5_SIZE,
#endif

#if (POOL_INDEX_6_NUM)
    POOL_INDEX_6_SIZE,
#endif

#if (POOL_INDEX_7_NUM)
    POOL_INDEX_7_SIZE,
#endif

#if (POOL_INDEX_8_NUM)
    POOL_INDEX_8_SIZE,
#endif

#if (POOL_INDEX_9_NUM)
    POOL_INDEX_9_SIZE,
#endif

#if (POOL_INDEX_10_NUM)
    POOL_INDEX_10_SIZE,
#endif

#if (POOL_INDEX_11_NUM)
    POOL_INDEX_11_SIZE,
#endif

#if (POOL_INDEX_12_NUM)
    POOL_INDEX_12_SIZE,
#endif

#if (POOL_INDEX_13_NUM)
    POOL_INDEX_13_SIZE,
#endif

#if (POOL_INDEX_14_NUM)
    POOL_INDEX_14_SIZE,
#endif

#if (POOL_INDEX_15_NUM)
    POOL_INDEX_15_SIZE,
#endif
};

#ifdef POOL_MAGIC
__tcm_const static const unsigned long pool_magic[] = {
#if (POOL_INDEX_0_NUM)
    POOL_INDEX_0_MAGIC,
#endif

#if (POOL_INDEX_1_NUM)
    POOL_INDEX_1_MAGIC,
#endif

#if (POOL_INDEX_2_NUM)
    POOL_INDEX_2_MAGIC,
#endif

#if (POOL_INDEX_3_NUM)
    POOL_INDEX_3_MAGIC,
#endif

#if (POOL_INDEX_4_NUM)
    POOL_INDEX_4_MAGIC,
#endif

#if (POOL_INDEX_5_NUM)
    POOL_INDEX_5_MAGIC,
#endif

#if (POOL_INDEX_6_NUM)
    POOL_INDEX_6_MAGIC,
#endif

#if (POOL_INDEX_7_NUM)
    POOL_INDEX_7_MAGIC,
#endif

#if (POOL_INDEX_8_NUM)
    POOL_INDEX_8_MAGIC,
#endif

#if (POOL_INDEX_9_NUM)
    POOL_INDEX_9_MAGIC,
#endif

#if (POOL_INDEX_10_NUM)
    POOL_INDEX_10_MAGIC,
#endif

#if (POOL_INDEX_11_NUM)
    POOL_INDEX_11_MAGIC,
#endif

#if (POOL_INDEX_12_NUM)
    POOL_INDEX_12_MAGIC,
#endif

#if (POOL_INDEX_13_NUM)
    POOL_INDEX_13_MAGIC,
#endif

#if (POOL_INDEX_14_NUM)
    POOL_INDEX_14_MAGIC,
#endif

#if (POOL_INDEX_15_NUM)
    POOL_INDEX_15_MAGIC,
#endif
};
#endif

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
#ifdef _USE_MONITOR
static T_ZOss_Mon_Pool pool_info = {0};
#endif

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

#ifdef POOL_DEBUG
/*******************************************************************************
* :     ¼pool_allocʱĵò
* ˵:     
*   ()  node:   ڴڵ
                errno:  
                size:   ڴС
                file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void pool_alloc_error(struct pool_node   *node,
                                int                 errno,
                                unsigned long       size,
                                const char          *file,
                                unsigned long       line)
{
    unsigned long flags;

    POOL_LOCK(flags);
    pool_svc.errno              = errno;
    pool_svc.alloc_error_node   = node;
    pool_svc.alloc_error_size   = size;
    pool_svc.alloc_error_file   = file;
    pool_svc.alloc_error_line   = line;
    POOL_UNLOCK(flags);

    switch (errno)
    {
        case POOL_ERROR_SIZE_OVERFLOW:
        {
            //pool_print_leak(0);
            //pool_print_free();
            //pool_print_alloc_fail();
            //pool_print_alloc_statistic();
            //pool_trace_leak_end(0);
            zOss_ASSERT(0);
            break;
        }

        default:
        {
            zOss_ASSERT(0);
            break;
        }
    }
}

/*******************************************************************************
* :     ¼pool_freeʱĵò
* ˵:     
*   ()  node:   ڴڵ
                errno:  
                ptr:    ͷŵڴָ
                file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void pool_free_error(struct pool_node    *node,
                               int                  errno,
                               void                 *ptr,
                               const char           *file,
                               unsigned long        line)
{
    unsigned long flags;

    POOL_LOCK(flags);
    pool_svc.errno              = errno;
    pool_svc.free_error_node    = node;
    pool_svc.free_error_ptr     = ptr;
    pool_svc.free_error_file    = file;
    pool_svc.free_error_line    = line;
    POOL_UNLOCK(flags);

    switch (errno) 
    {
        default:
        {
            zOss_ASSERT(0);
            break;
        }
    }
}

/*******************************************************************************
* :     ¼pool_sizeʱĵò
* ˵:     
*   ()  node:   ڴڵ
                errno:  
                ptr:    ͷŵڴָ
                file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
#ifdef POOL_REALLOC
static void pool_size_error(struct pool_node    *node,
                               int                  errno,
                               void                 *ptr,
                               const char           *file,
                              unsigned long         line)
{
    unsigned long flags;

    POOL_LOCK(flags);
    pool_svc.errno              = errno;
    pool_svc.free_error_node    = node;
    pool_svc.free_error_ptr     = ptr;
    pool_svc.free_error_file    = file;
    pool_svc.free_error_line    = line;
    POOL_UNLOCK(flags);
    
    switch (errno) 
    {
        default:
        {
            zOss_ASSERT(0);
            break;
        }
    }
}
#endif

#endif

/*******************************************************************************
* :     ȡ
* ˵:     
*   ()  size:   ڴС
*   ()  void
*   ֵ:     
* ˵:     1. б;
                2. ûйڵúвù;
*******************************************************************************/
__tcm_func static int pool_get_index(unsigned long size)
{
    int map;
    int index;
#ifdef POOL_DEBUG
    int base_index;
#endif

    map = (int)pool_svc.map;
    for (index = 0; index < POOL_INDEX_NUM; index++)
    {
        if (size > pool_size[index])
        {
            continue;
        }

#ifdef POOL_DEBUG
        base_index = index;
#endif
        for ( ; index < POOL_INDEX_NUM; index++)
        {
            if (map & (1<<index))
            {
#ifdef POOL_DEBUG
                if (index > base_index)
                {
                    pool_svc.fail_count[base_index]++;
                }
#endif
                return index;
            }
        }
    }
    
    return -1;
}

/*******************************************************************************
* :     ʼͷڵ
* ˵:     
*   ()  pool:   жӦڴ
                size:   ÿڵڴС
                num:    еĽڵ
                index:  
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void pool_node_init(char *pool, int size, int num, int index)
{
    int cnt;
    unsigned long flags;
    pool_node_t *node = NULL;

    zOss_ASSERT(pool != NULL && size > 0 && size % 4 == 0 && num > 0);
    zOss_ASSERT(index >= 0 && index < POOL_INDEX_NUM);

    POOL_LOCK(flags);
    pool_svc.free_head[index] = (pool_node_t *)pool;

#ifdef POOL_LEAK_CHECK
    pool_svc.alloc_head[index] = NULL;
#endif
    
#ifdef POOL_DEBUG
    pool_svc.fail_count[index]      = 0;
    pool_svc.free_count[index]      = pool_num[index];
    pool_svc.min_free_count[index]  = pool_num[index];
    for (cnt = 0; cnt < POOL_ALLOC_STATISTIC_NUM; cnt++)
    {
        pool_svc.alloc_statistic[index][cnt] = 0;
    }
#endif
    POOL_UNLOCK(flags);

    size += (int)sizeof(pool_node_t);
    for (cnt = 0; cnt < num; cnt++)
    {
        node = (pool_node_t *)pool;
        pool += size;
        node->free_next = (pool_node_t *)pool;

#ifdef POOL_MAGIC
        node->magic = pool_magic[index];
#endif

#ifdef POOL_DEBUG
        node->file = NULL;
        node->line = 0;
        node->time = 0;
#endif
    }
    node->free_next = NULL;
}

#ifdef POOL_DEBUG
/*******************************************************************************
* :     pallocͳϢ
* ˵:     
*   ()  size:   ǰpallocڴС
                index:  
*   ()  void
*   ֵ:     void
* ˵:     ûйڵúвù
*******************************************************************************/
static inline void pool_alloc_statistic(unsigned long size, int index)
{
    int cnt = 0;

    if (size > pool_svc.alloc_statistic[index][0]) 
    {
        for (cnt = 1; cnt < POOL_ALLOC_STATISTIC_NUM; cnt++)
        {
            if (size < pool_svc.alloc_statistic[index][cnt])
                break;
            else if (size == pool_svc.alloc_statistic[index][cnt])
                return;
        }

        pool_svc.alloc_statistic[index][cnt - 1] = size;
    }
}
#endif

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ʼڴ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     pool_alloc/pool_freeӿҪڸúɺܵ
*******************************************************************************/
void pool_init(void)
{
    int index = 0;
    unsigned long flags;

    zOss_ASSERT(sizeof(pool_node_t)%4 == 0);

#if (POOL_INDEX_0_NUM)
    pool_node_init((char *)pool_index_0_node,  POOL_INDEX_0_SIZE,  POOL_INDEX_0_NUM,  index++);
#endif

#if (POOL_INDEX_1_NUM)
    pool_node_init((char *)pool_index_1_node,  POOL_INDEX_1_SIZE,  POOL_INDEX_1_NUM,  index++);
#endif

#if (POOL_INDEX_2_NUM)
    pool_node_init((char *)pool_index_2_node,  POOL_INDEX_2_SIZE,  POOL_INDEX_2_NUM,  index++);
#endif

#if (POOL_INDEX_3_NUM)
    pool_node_init((char *)pool_index_3_node,  POOL_INDEX_3_SIZE,  POOL_INDEX_3_NUM,  index++);
#endif

#if (POOL_INDEX_4_NUM)
    pool_node_init((char *)pool_index_4_node,  POOL_INDEX_4_SIZE,  POOL_INDEX_4_NUM,  index++);
#endif

#if (POOL_INDEX_5_NUM)
    pool_node_init((char *)pool_index_5_node,  POOL_INDEX_5_SIZE,  POOL_INDEX_5_NUM,  index++);
#endif

#if (POOL_INDEX_6_NUM)
    pool_node_init((char *)pool_index_6_node,  POOL_INDEX_6_SIZE,  POOL_INDEX_6_NUM,  index++);
#endif

#if (POOL_INDEX_7_NUM)
    pool_node_init((char *)pool_index_7_node,  POOL_INDEX_7_SIZE,  POOL_INDEX_7_NUM,  index++);
#endif

#if (POOL_INDEX_8_NUM)
    pool_node_init((char *)pool_index_8_node,  POOL_INDEX_8_SIZE,  POOL_INDEX_8_NUM,  index++);
#endif

#if (POOL_INDEX_9_NUM)
    pool_node_init((char *)pool_index_9_node,  POOL_INDEX_9_SIZE,  POOL_INDEX_9_NUM,  index++);
#endif

#if (POOL_INDEX_10_NUM)
    pool_node_init((char *)pool_index_10_node, POOL_INDEX_10_SIZE, POOL_INDEX_10_NUM, index++);
#endif

#if (POOL_INDEX_11_NUM)
    pool_node_init((char *)pool_index_11_node, POOL_INDEX_11_SIZE, POOL_INDEX_11_NUM, index++);
#endif

#if (POOL_INDEX_12_NUM)
    pool_node_init((char *)pool_index_12_node, POOL_INDEX_12_SIZE, POOL_INDEX_12_NUM, index++);
#endif

#if (POOL_INDEX_13_NUM)
    pool_node_init((char *)pool_index_13_node, POOL_INDEX_13_SIZE, POOL_INDEX_13_NUM, index++);
#endif

#if (POOL_INDEX_14_NUM)
    pool_node_init((char *)pool_index_14_node, POOL_INDEX_14_SIZE, POOL_INDEX_14_NUM, index++);
#endif

#if (POOL_INDEX_15_NUM)
    pool_node_init((char *)pool_index_15_node, POOL_INDEX_15_SIZE, POOL_INDEX_15_NUM, index++);
#endif

    POOL_LOCK(flags);
    pool_svc.map = POOL_MAP;
#ifdef POOL_INIT_CHECK
    pool_svc.init_flag = true;
#endif
    POOL_UNLOCK(flags);

#ifdef _USE_MONITOR
    pool_info.num = POOL_INDEX_NUM;
    pool_info.ele = (T_ZOss_Mon_Pool_Ele *)zOss_Malloc(pool_info.num * sizeof(T_ZOss_Mon_Pool_Ele));
    zOss_ASSERT(pool_info.ele != NULL);
#endif
}

/*******************************************************************************
* :     ڴڴ
* ˵:     
*   ()  size:   ڴС
                file:   ڴļ
                line:   ڴļ
*   ()  void
*   ֵ:     뵽ڴַ
* ˵:     pool_alloc stands for pool alloc
*******************************************************************************/
__tcm_func void *pool_alloc(unsigned long size, const char *file, unsigned long line)
{
    int index;
    pool_node_t *node;
    unsigned long flags;
    
#ifdef POOL_DEBUG
    unsigned long free_count = 0;
#endif

#ifdef POOL_INIT_CHECK
    zOss_ASSERT(pool_svc.init_flag == (unsigned long)true);
    if (pool_svc.init_flag == false)
    {
#ifdef POOL_DEBUG
        pool_alloc_error(NULL, POOL_ERROR_NOT_INIT, size, file, line);
#endif
        return NULL;
    }
#endif

    if (size == 0) 
    {
#ifdef POOL_DEBUG
        pool_alloc_error(NULL, POOL_ERROR_SIZE_ZERO, size, file, line);
#endif
        return NULL;
    }

    POOL_LOCK(flags);

    index = pool_get_index(size);
    if (index == -1) 
    {
        POOL_UNLOCK(flags);
        
#ifdef POOL_DEBUG
        pool_alloc_error(NULL, POOL_ERROR_SIZE_OVERFLOW, size, file, line);
#endif

#ifdef POOL_EXHAUST_FROM_HEAP
        return POOL_MALLOC(size);
#else
        return NULL;
#endif
    }

    node = pool_svc.free_head[index];
    pool_svc.free_head[index] = node->free_next;
    if (node->free_next == NULL)
    {
        pool_svc.map &= (~((unsigned long)(1<<index)));
    }
    node->free_next = (pool_node_t *)&pool_svc.free_head[index];

#ifdef POOL_LEAK_CHECK
    node->alloc_prev = &pool_svc.alloc_head[index];
    node->alloc_next = pool_svc.alloc_head[index];
    if (pool_svc.alloc_head[index])
    {
        pool_svc.alloc_head[index]->alloc_prev = &node->alloc_next;
    }
    pool_svc.alloc_head[index] = node;
#endif

#ifdef POOL_DEBUG
    free_count = --pool_svc.free_count[index];
    if (free_count < pool_svc.min_free_count[index])
    {
        pool_svc.min_free_count[index] = free_count;
    }
    pool_alloc_statistic(size, index);
#endif

    POOL_UNLOCK(flags);

#ifdef POOL_MAGIC
    zOss_ASSERT(node->magic == pool_magic[index]);
    if (node->magic != pool_magic[index]) 
    {
#ifdef POOL_DEBUG
        pool_alloc_error(node, POOL_ERROR_MAGIC_CORRUPT, size, file, line);
#endif
    }
#endif

#ifdef POOL_REALLOC
    node->size = size;
#endif

#ifdef POOL_DEBUG
    node->file      = file;
    node->line      = line;
    node->time      = POOL_CURRENT_TIME();
    node->thread_id = POOL_THREAD_SELF();
#endif

    return (void *)(node + 1);
}

/*******************************************************************************
* :     ڴͷڴ
* ˵:     
*   ()  ptr:    ͷڴĵַ
                file:   ͷڴļ
                line:   ͷڴļ
*   ()  void
*   ֵ:     void
* ˵:     pool_free stands for pool free
*******************************************************************************/
__tcm_func void pool_free(void *ptr, const char *file, unsigned long line)
{
    int index;
    pool_node_t *node;
    pool_node_t **free_head;
    unsigned long flags;

    zOss_ASSERT(ptr != NULL);
    if (ptr == NULL)
    {
#ifdef POOL_DEBUG
        pool_free_error(NULL, POOL_ERROR_FREE_NULL, ptr, file, line);
#endif
        return;
    }

#ifdef POOL_EXHAUST_FROM_HEAP
    if (ptr >= (void *)CYGMEM_SECTION_heap1)
    {
        DBG("pool_free calls free(%p)!\n", ptr);
        POOL_FREE(ptr);
        return;
    }
#endif

    /* Check ptr valid or not! */
#ifdef POOL_FREE_CHECK
    zOss_ASSERT((unsigned long)ptr%4 == 0);
    if ((unsigned long)ptr%4)
    {
#ifdef POOL_DEBUG
        pool_free_error(NULL, POOL_ERROR_FREE_NOT_ALIGN, ptr, file, line);
#endif
        return;
    }

    zOss_ASSERT((unsigned long)ptr > sizeof(pool_node_t));
    if ((unsigned long)ptr <= sizeof(pool_node_t))
    {
#ifdef POOL_DEBUG
        pool_free_error(NULL, POOL_ERROR_FREE_INVALID, ptr, file, line);
#endif
        return;
    }
#endif

    /* Convert ptr to pool_node_t pointer and get free_head pointer ! */
    node = (pool_node_t *)((char *)ptr - sizeof(pool_node_t));
    free_head = (pool_node_t **)node->free_next;
    index = free_head - &pool_svc.free_head[0];

    /* Check free_head valid or not! */
#ifdef POOL_FREE_CHECK
    zOss_ASSERT(free_head != NULL);
    if (free_head == NULL)
    {
#ifdef POOL_DEBUG
        pool_free_error(node, POOL_ERROR_FREE_HEAD_NULL, ptr, file, line);
#endif
        return;
    }

    zOss_ASSERT(free_head >= &pool_svc.free_head[0]);
    zOss_ASSERT(free_head <= &pool_svc.free_head[POOL_INDEX_NUM - 1]);
    if (free_head < &pool_svc.free_head[0] ||
        free_head > &pool_svc.free_head[POOL_INDEX_NUM - 1])
    {
#ifdef POOL_DEBUG
        pool_free_error(node, POOL_ERROR_FREE_HEAD_INVALID, ptr, file, line);
#endif
        return;
    }
#endif

    /* Check magic! */
#ifdef POOL_MAGIC
    zOss_ASSERT(node->magic == pool_magic[index]);
    if (node->magic != pool_magic[index])
    {
#ifdef POOL_DEBUG
        pool_free_error(node, POOL_ERROR_MAGIC_CORRUPT, ptr, file, line);
#endif
        return;
    }
#endif

    /* Insert pool node back to pool_svc and update map! */
    POOL_LOCK(flags);
    node->free_next = *free_head;
    *free_head = node;
    if ((pool_svc.map & (1<<index)) == 0)
    {  
        pool_svc.map |= (1<<index);
    }
#ifdef POOL_LEAK_CHECK
    *(node->alloc_prev) = node->alloc_next;
    if (node->alloc_next)
    {
        node->alloc_next->alloc_prev = node->alloc_prev;
    }
#endif

#ifdef POOL_REALLOC
    node->size = 0;
#endif

#ifdef POOL_DEBUG
    node->file      = file;
    node->line      = line;
    node->time      = 0;
    node->thread_id = NULL;
    pool_svc.free_count[index]++;
#endif

    POOL_UNLOCK(flags);
}

/*******************************************************************************
* :     ´ڴڴ
* ˵:     
*   ()  old_ptr:    ԭָ
                new_size:   ڴС
                file:       ڴļ
                line:       ڴļ
*   ()  void
*   ֵ:     뵽ڴַ
* ˵:     pool_realloc stands for pool realloc
*******************************************************************************/
void *pool_realloc(void *old_ptr, unsigned long new_size, const char *file, unsigned long line)
{
#ifdef POOL_REALLOC
    if (old_ptr == NULL)
    {
        return pool_alloc(new_size, file, line);
    } 
    else if (new_size == 0)
    {
        pool_free(old_ptr, file, line);
        return NULL;
    } 
    else
    {
        void          *new_ptr;
        pool_node_t   *node    = (pool_node_t *)old_ptr;
        unsigned long old_size = (--node)->size;

        zOss_AssertEx(new_size != old_size, NULL);

        new_ptr = pool_alloc(new_size, file, line);
        zOss_AssertEx(new_ptr != NULL, NULL);

        memcpy(new_ptr, old_ptr, (new_size > old_size) ? old_size : new_size);
        pool_free(old_ptr, file, line);
        return new_ptr;
    }
#else
    zOss_ASSERT(0);

    return NULL;
#endif
}

/*******************************************************************************
* :     ȡڴڵĴС
* ˵:     
*   ()  ptr:    ȡСڴַ
                file:   ûȡСļ
                line:   ûȡСļ
*   ()  void
*   ֵ:     ڴڵĴС
* ˵:     pool_node_size stands for pool node size
*******************************************************************************/
unsigned long pool_node_size(void *ptr, const char *file, unsigned long line)
{
#ifdef POOL_REALLOC
    int index;
    pool_node_t *node;
    pool_node_t **free_head;

    zOss_ASSERT(ptr != NULL);
    if (ptr == NULL)
    {
    #ifdef POOL_DEBUG
        pool_size_error(NULL, POOL_ERROR_SIZE_NULL, ptr, file, line);
    #endif
        return 0;
    }

    /* Check ptr valid or not! */
#ifdef POOL_SIZE_CHECK
    zOss_ASSERT((unsigned long)ptr%4 == 0);
    if ((unsigned long)ptr%4)
    {
    #ifdef POOL_DEBUG
        pool_size_error(NULL, POOL_ERROR_SIZE_NOT_ALIGN, ptr, file, line);
    #endif
        return 0;
    }

    zOss_ASSERT((unsigned long)ptr > sizeof(pool_node_t));
    if ((unsigned long)ptr <= sizeof(pool_node_t))
    {
    #ifdef POOL_DEBUG
        pool_size_error(NULL, POOL_ERROR_SIZE_INVALID, ptr, file, line);
    #endif
        return 0;
    }
#endif

    /* Convert ptr to pool_node_t pointer and get free_head pointer ! */
    node = (pool_node_t *)((char *)ptr - sizeof(pool_node_t));
    free_head = (pool_node_t **)node->free_next;
    index = free_head - &pool_svc.free_head[0];

    /* Check free_head valid or not! */
#ifdef POOL_SIZE_CHECK
    zOss_ASSERT(free_head != NULL);
    if (free_head == NULL)
    {
    #ifdef POOL_DEBUG
        pool_size_error(node, POOL_ERROR_SIZE_HEAD_NULL, ptr, file, line);
    #endif
        return 0;
    }

    zOss_ASSERT(free_head >= &pool_svc.free_head[0]);
    zOss_ASSERT(free_head <= &pool_svc.free_head[POOL_INDEX_NUM - 1]);
    if (free_head < &pool_svc.free_head[0] ||
        free_head > &pool_svc.free_head[POOL_INDEX_NUM - 1]) 
    {
    #ifdef POOL_DEBUG
        pool_size_error(node, POOL_ERROR_SIZE_HEAD_INVALID, ptr, file, line);
    #endif
        return 0;
    }
#endif

    /* Check magic! */
#ifdef POOL_MAGIC
    zOss_ASSERT(node->magic == pool_magic[index]);
    if (node->magic != pool_magic[index]) 
    {
    #ifdef POOL_DEBUG
        pool_size_error(node, POOL_ERROR_MAGIC_CORRUPT, ptr, file, line);
    #endif
        return 0;
    }
#endif

    return node->size;

#else
    zOss_ASSERT(0);

    return 0;
#endif
}

/*******************************************************************************
* :     ڴǷй¶
* ˵:     
*   ()  timeout:    жڴй¶ĳʱֵ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void pool_print_leak(unsigned long timeout)
{
#if defined(POOL_LEAK_CHECK) && defined(POOL_DEBUG)
    int cnt;
    pool_node_t *node;
    unsigned long  current_time;

    DBG("********************************************************************\n");
    DBG("***********************pool leak information************************\n");
    DBG("********************************************************************\n");
    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++)
    {
        node = pool_svc.alloc_head[cnt];
        while (node) 
        {
            current_time = POOL_CURRENT_TIME();
            if (current_time - node->time >= timeout)
            {
                DBG("Thread:%p,  File:%s,  Line:%lu\n",
                    node->thread_id, node->file, node->line);
            }
            node = node->alloc_next;
        }
    }
#endif
}

/*******************************************************************************
* :     ӡpallocʧܵĴ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void pool_print_alloc_fail(void)
{
#ifdef POOL_DEBUG
    int cnt;

    DBG("********************************************************************\n");
    DBG("********************pool alloc fail information*********************\n");
    DBG("********************************************************************\n");
    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++) 
    {
        DBG("queue node size:%6lu,  queue fail count:%3lu\n",
            pool_size[cnt], pool_svc.fail_count[cnt]);
    }
#endif
}

/*******************************************************************************
* :     ӡڴͳϢ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void pool_print_alloc_statistic(void)
{
#ifdef POOL_DEBUG
    int cnt;
    int pos;
    int flag;
    
    DBG("********************************************************************\n");
    DBG("******************pool alloc statistic information******************\n");
    DBG("********************************************************************\n");
    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++) 
    {
        for (pos = 0, flag = 0; pos < POOL_ALLOC_STATISTIC_NUM; pos++) 
        {
            if (pool_svc.alloc_statistic[cnt][pos]) 
            {
                flag = 1;
                break;
            }
        }
        
        if (flag)
        {
            DBG("queue node size:%6lu", pool_size[cnt]);
            for (pos = 0; pos < POOL_ALLOC_STATISTIC_NUM; pos++)
            {
                DBG("queue alloc_statistic[%d]:%6lu\n",
                    pos,
                    pool_svc.alloc_statistic[cnt][pos]);
            }
        }
    }
#endif
}

/*******************************************************************************
* :     ӡڴؿڴʹ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void pool_print_free(void)
{
#ifdef POOL_DEBUG
    int cnt;

    DBG("********************************************************************\n");
    DBG("************************pool free information***********************\n");
    DBG("********************************************************************\n");
    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++) 
    {
        DBG("queue node size:%6lu,  queue total nodes:%4lu,  queue free nodes:%4lu,  queue max alloc nodes:%4lu\n",
            pool_size[cnt],
            pool_num[cnt],
            pool_svc.free_count[cnt],
            pool_num[cnt] - pool_svc.min_free_count[cnt]);
    }
#endif
}

/*******************************************************************************
* :     ʼpoolڴй¶
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void pool_trace_leak_start(void)
{
#if defined(POOL_LEAK_CHECK) && defined(POOL_DEBUG)
    unsigned long flags;

    POOL_LOCK(flags);
    pool_svc.trace_leak_time = POOL_CURRENT_TIME();
    POOL_UNLOCK(flags);
#endif
}

/*******************************************************************************
* :     poolڴй¶
* ˵:     
*   ()  timeout:    жڴй¶ĳʱֵ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void pool_trace_leak_end(unsigned long timeout)
{
#if defined(POOL_LEAK_CHECK) && defined(POOL_DEBUG)
    int cnt;
    pool_node_t *node;
    unsigned long current_time;
    unsigned long trace_leak_time;

    DBG("********************************************************************\n");
    DBG("*********************pool trace leak information********************\n");
    DBG("********************************************************************\n");
    trace_leak_time = pool_svc.trace_leak_time;
    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++)
    {
        node = pool_svc.alloc_head[cnt];
        while (node) 
        {
            current_time = POOL_CURRENT_TIME();
            if ( (node->time >= trace_leak_time) && (current_time - node->time >= timeout) ) 
            {
                DBG("Thread:%p,  File:%s,  Line:%lu\n",
                    node->thread_id, node->file, node->line);
            }
            node = node->alloc_next;
        }
    }
#endif
}

/**************************************************************************
* : ṩڴصʹ
* ˵:
*   ()  void
*   ()  pMonPoolInfo: ڴʹϢŵַ
*   ֵ:     void
* ˵:     void
**************************************************************************/
void pool_used_info(T_ZOss_Mon_Pool *pMonPoolInfo)
{
#if defined(_USE_MONITOR) && defined(POOL_DEBUG)
    unsigned long cnt = 0;
    unsigned long flags;

    if (pMonPoolInfo == NULL)
    {
        return;
    }

    POOL_LOCK(flags);
    for (cnt = 0; cnt < pool_info.num; cnt++)
    {
        pool_info.ele[cnt].size      = pool_size[cnt];
        pool_info.ele[cnt].total     = pool_num[cnt];
        pool_info.ele[cnt].used      = pool_num[cnt] - pool_svc.free_count[cnt];
        pool_info.ele[cnt].max_used  = pool_num[cnt] - pool_svc.min_free_count[cnt];  
    }
    POOL_UNLOCK(flags);

    pMonPoolInfo->num = pool_info.num;
    pMonPoolInfo->ele = pool_info.ele;
#endif
}

/**************************************************************************
* : ṩڴصʹ
* ˵: 
*   ()  void
*   ()  pMonPoolAllocInfo: ڴʹϢŵַ
*   ֵ:     void
* ˵: ڴҪٹߴ(Ϣշ)ͷ,ʹplatṩ
            ڴӿ
**************************************************************************/
void pool_alloc_info(T_ZOss_Mon_Pool_Alloc *pMonPoolAllocInfo)
{
#if defined(_USE_MONITOR) && defined(POOL_DEBUG)
    T_ZOss_Mon_Pool_Alloc   poolAlloc   = {0};
    pool_node_t             *pNode      = NULL;
    unsigned long            cnt         = 0;
    unsigned long            num         = 0;
    unsigned long            maxNum      = 0;

    if (pMonPoolAllocInfo == NULL)
    {
        return;
    }

    preempt_disable();

    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++)
    {
        maxNum += pool_num[cnt] - pool_svc.free_count[cnt];
    }
    poolAlloc.ele = (T_ZOss_Mon_Pool_Alloc_Ele *)zOss_Malloc(maxNum * sizeof(T_ZOss_Mon_Pool_Alloc_Ele));
    zOss_ASSERT(poolAlloc.ele != NULL);

    for (cnt = 0, num = 0; cnt < POOL_INDEX_NUM; cnt++)
    {
        pNode = pool_svc.alloc_head[cnt];
        while(pNode != NULL && num < maxNum)
        {
            poolAlloc.ele[num].addr         = (unsigned long)(pNode + 1);
            poolAlloc.ele[num].owner        = pNode->thread_id;
            poolAlloc.ele[num].timestamp    = pNode->time;
            poolAlloc.ele[num].file         = pNode->file;
            poolAlloc.ele[num++].line       = pNode->line;
            pNode = pNode->alloc_next;
        }
    }

    preempt_enable();

    pMonPoolAllocInfo->num = num;
    pMonPoolAllocInfo->ele = poolAlloc.ele;
#endif
}


/**************************************************************************
* : monitor_PoolLeakInfo
* : ṩڴصʹй¶
* ˵:
*   ()  void
*   ()  pMonPoolLeakInfo: ڴʹй¶Ϣŵַ
*   ֵ:     void
* ˵: ڴҪٹߴ(Ϣշ)ͷ
**************************************************************************/
void pool_leak_info(T_ZOss_Mon_Pool_Leak *pMonPoolLeakInfo)
{
#if defined(_USE_MONITOR) && defined(POOL_DEBUG)
    T_ZOss_Mon_Pool_Leak    poolLeak    = {0};
    pool_node_t             *pNode      = NULL;
    unsigned long            cnt         = 0;
    unsigned long            curTime     = 0;
    unsigned long            num         = 0;
    unsigned long            maxNum      = 0;

    if (pMonPoolLeakInfo == NULL)
    {
        return;
    }

    preempt_disable();  

    for (cnt = 0; cnt < POOL_INDEX_NUM; cnt++) 
    {
        pNode = pool_svc.alloc_head[cnt];
        while (pNode != NULL) 
        {
            curTime = POOL_CURRENT_TIME();
            if (curTime - pNode->time >= POOL_LEAK_CHECK_TIMEOUT) 
            {           
                maxNum++;          
            }
            pNode = pNode->alloc_next;  
        }  
    }
    poolLeak.ele = (T_ZOss_Mon_Pool_Leak_Ele *)zOss_Malloc(maxNum * sizeof(T_ZOss_Mon_Pool_Leak_Ele));
    zOss_ASSERT(poolLeak.ele != NULL);

    for (cnt = 0, num = 0; cnt < POOL_INDEX_NUM; cnt++)
    {
        pNode = pool_svc.alloc_head[cnt];
        while (pNode != NULL)
        {
            curTime = POOL_CURRENT_TIME();
            if (curTime - pNode->time >= POOL_LEAK_CHECK_TIMEOUT && num < maxNum)
            {
                poolLeak.ele[num].addr          = (unsigned long)(pNode + 1);
                poolLeak.ele[num].owner         = pNode->thread_id;
                poolLeak.ele[num].timestamp     = pNode->time;
                poolLeak.ele[num].file          = pNode->file;
                poolLeak.ele[num++].line        = pNode->line;
            }
            pNode = pNode->alloc_next;
        }
    }

    preempt_enable();

    pMonPoolLeakInfo->num = num;
    pMonPoolLeakInfo->ele = poolLeak.ele;
#endif
}

#ifdef __cplusplus
}
#endif

