/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : oss_ring.c
*    : oss_ring.c
* ļ : 
* ʵֹ : λ,οvxworksʵ
*      : κ
*      : V1.0
*  : 2007/08/20
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"

#ifdef __cplusplus
extern "C"
{
#endif   
/**************************************************************************
* 궨
**************************************************************************/
/* storage class specifier definitions */
#define RING_MIN(x, y)  (((x) < (y)) ? (x) : (y))

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* : zOss_RingCreate
* : λ
* ˵(IN)
                nbytes:λĴСλֽ
            (OUT)
*   ֵ: ɹλID; ʧ:ZOSS_NULL
* ˵:  
**************************************************************************/ 
T_ZOss_RingId zOss_RingCreate(SINT32 nbytes)
{
    CHAR            *buffer = NULL;
    T_ZOss_RingId   ring_id = (T_ZOss_RingId)zOss_Malloc(sizeof (T_ZOss_Ring));

    if (ring_id == NULL)
    {
        return NULL;
    }

    /*bump number of bytes requested because ring buffer algorithm
                always leaves at least one empty byte in buffer  */

    buffer = (CHAR *)zOss_Malloc((unsigned) ++nbytes);

    if (buffer == NULL)
    {
        zOss_Free((CHAR *)ring_id);
        return NULL;
    }

    ring_id->bufSize    = nbytes;
    ring_id->buf        = buffer;

    zOss_RingFlush(ring_id);

    return ring_id;
}

/**************************************************************************
* : zOss_RingFreeBytes
* : ɾλ
* ˵(IN)
                ring_id:λID
            (OUT)
*   ֵ:  
* ˵:  
**************************************************************************/ 
VOID zOss_RingDelete(T_ZOss_RingId ring_id)
{
    zOss_AssertExN(ring_id != NULL);
    zOss_Free (ring_id->buf);
    zOss_Free (ring_id);
}

/**************************************************************************
* : zOss_RingFlush
* : λ
* ˵(IN)
                ring_id:λID
            (OUT)
*   ֵ:  
* ˵:  
**************************************************************************/ 
VOID zOss_RingFlush(T_ZOss_RingId ring_id)
{
    zOss_AssertExN(ring_id != NULL);
    ring_id->pToBuf   = 0;
    ring_id->pFromBuf = 0;
}

/**************************************************************************
* : zOss_RingBufGet
* : ȡλеݿ
* ˵(IN)
                ring_id:λID
                buffer:ָ	  
                maxbytes:Ҫȡֽ
            (OUT)
                buffer:ָ	  
*   ֵ: ʵʶȡֽ
* ˵: ֵҪȡֽһ¡Ϊգ򷵻0
**************************************************************************/ 
SINT32 zOss_RingBufGet(T_ZOss_RingId ring_id, CHAR *buffer, SINT32 maxbytes)
{
    SINT32 bytesgot = 0;
    SINT32 pToBuf   = 0;
    SINT32 bytes2   = 0;
    SINT32 pRngTmp  = 0;
    
    zOss_AssertEx(ring_id != NULL && buffer != NULL, 0);
    
    pToBuf = ring_id->pToBuf;
    if (pToBuf >= ring_id->pFromBuf)
    {
        /* pToBuf has not wrapped around */
        bytesgot = RING_MIN (maxbytes, pToBuf - ring_id->pFromBuf);
        
        zOss_Memmove(buffer, &ring_id->buf[ring_id->pFromBuf], (size_t)bytesgot);
        
        ring_id->pFromBuf += bytesgot;
    }
    else
    {
        /* pToBuf has wrapped around.  Grab chars up to the end of the
         * buffer, then wrap around if we need to. */

        bytesgot = RING_MIN (maxbytes, ring_id->bufSize - ring_id->pFromBuf);
        
        zOss_Memmove(buffer, &ring_id->buf[ring_id->pFromBuf], (size_t)bytesgot);
        
        pRngTmp = ring_id->pFromBuf + bytesgot;

        /* If pFromBuf is equal to bufSize, we've read the entire buffer,
         * and need to wrap now.  If bytesgot < maxbytes, copy some more chars
         * in now. */

        if (pRngTmp == ring_id->bufSize)
        {
            bytes2 = RING_MIN (maxbytes - bytesgot, pToBuf);

            if(bytes2)
            {
                zOss_Memmove(buffer + bytesgot, ring_id->buf, (size_t)bytes2);
                bytesgot += bytes2;
            } 
            ring_id->pFromBuf = bytes2; 
        }
        else
        {
            ring_id->pFromBuf = pRngTmp;
        }
    }

    return (bytesgot);
}

/**************************************************************************
* : zOss_RingBufPut
* : λд
* ˵(IN)
                ring_id:λID
                buffer:дָ  
                nbytes:дݵĴС
            (OUT)
*   ֵ: ʵдֽ
* ˵: ֵҪдֽһ¡Ϊ򷵻0
**************************************************************************/ 
SINT32 zOss_RingBufPut(T_ZOss_RingId ring_id, CHAR *buffer, SINT32 nbytes)
{
    SINT32 bytesput = 0;
    SINT32 pFromBuf = 0;
    SINT32 bytes2   = 0;
    SINT32 pRngTmp  = 0;
    
    zOss_AssertEx(ring_id != NULL && buffer != NULL, 0);
    
    pFromBuf = ring_id->pFromBuf;
    if (pFromBuf > ring_id->pToBuf)
    {
        /* pFromBuf is ahead of pToBuf.  We can fill up to two bytes
         * before it */
        bytesput = RING_MIN(nbytes, (pFromBuf - ring_id->pToBuf) - 1);
        
        zOss_Memmove(&ring_id->buf[ring_id->pToBuf], buffer, (size_t)bytesput);

        ring_id->pToBuf += bytesput;
    }
    else if (pFromBuf == 0)
    {
        /* pFromBuf is at the beginning of the buffer.  We can fill till
         * the next-to-last element */
        bytesput = RING_MIN(nbytes, (ring_id->bufSize - ring_id->pToBuf) - 1);
        
        zOss_Memmove(&ring_id->buf[ring_id->pToBuf], buffer, (size_t)bytesput);
        
        ring_id->pToBuf += bytesput;
    }
    else
    {
        /* pFromBuf has wrapped around, and its not 0, so we can fill
         * at least to the end of the ring buffer.  Do so, then see if
         * we need to wrap and put more at the beginning of the buffer. */
        bytesput = RING_MIN(nbytes, ring_id->bufSize - ring_id->pToBuf);
        
        zOss_Memmove(&ring_id->buf[ring_id->pToBuf], buffer, (size_t)bytesput);
        
        pRngTmp = ring_id->pToBuf + bytesput;

        if (pRngTmp == ring_id->bufSize)
        {
            /* We need to wrap, and perhaps put some more chars */

            bytes2 = RING_MIN(nbytes - bytesput, pFromBuf - 1);

            if(bytes2)
            {
                zOss_Memmove(ring_id->buf, buffer + bytesput, (size_t)bytes2);
                bytesput += bytes2;
            }
            
            ring_id->pToBuf = bytes2;

        }
        else
        {
            ring_id->pToBuf = pRngTmp;
        }
    }

    return (bytesput);
}

/**************************************************************************
* : zOss_RingIsEmpty
* : жϻλǷΪ
* ˵(IN)
			    ring_id:λID
            (OUT)
*   ֵ: :TRUE; ǿ:FALSE
* ˵:  
**************************************************************************/ 
BOOL zOss_RingIsEmpty( T_ZOss_RingId ring_id)
{
    zOss_AssertEx(ring_id != NULL, FALSE);

    return (ring_id->pToBuf == ring_id->pFromBuf);
}

/**************************************************************************
* : zOss_RingIsFull
* : жϻλǷ
* ˵(IN)
                ring_id:λID
            (OUT)
*   ֵ: ǻ:TRUE; :FALSE
* ˵:  
**************************************************************************/ 
BOOL zOss_RingIsFull(T_ZOss_RingId ring_id)
{
    SINT32 n = 0;
    
    zOss_AssertEx(ring_id != NULL, FALSE);
    
    n = (ring_id->pToBuf - ring_id->pFromBuf) + 1;
    
    return ((n == 0) || (n == ring_id->bufSize));
}

/**************************************************************************
* : zOss_RingFreeBytes
* : ȡλʣֽ
* ˵(IN)
                ring_id:λID
            (OUT)
*   ֵ: ʣÿռֽ
* ˵:  
**************************************************************************/ 
SINT32 zOss_RingFreeBytes(T_ZOss_RingId ring_id)
{
    SINT32 n = 0;
    
    zOss_AssertEx(ring_id != NULL, 0);
    
    n = (ring_id->pFromBuf - ring_id->pToBuf) - 1;
    if (n < 0)
    {
        n += ring_id->bufSize;
    }

    return n;
}

/**************************************************************************
* : zOss_RingNBytes
* : ȡλʹõֽ
* ˵(IN)
                ring_id:λID
            (OUT)
*   ֵ: ʣÿռֽ
* ˵:  
**************************************************************************/ 
SINT32 zOss_RingNBytes(T_ZOss_RingId ring_id)
{
    SINT32 n = 0;

    zOss_AssertEx(ring_id != NULL, 0);
    
    n = ring_id->pToBuf - ring_id->pFromBuf;
    if (n < 0)
    {
        n += ring_id->bufSize;
    }

    return n;
}

/**************************************************************************
* : zOss_RingPutAhead
* : λ嵱ǰдָƫƴдһݣƶдָ
* ˵(IN)
                ring_id:λID
                writebyte:д
                offset:ƫ, ǰƶ, ƶ
                       Χ: -λֽ ~ +λֽ
            (OUT)
*   ֵ:  
* ˵: ƫƴ󳤶ʱԶ
**************************************************************************/ 
VOID zOss_RingPutAhead(T_ZOss_RingId ring_id, CHAR writebyte, SINT32 offset)
{
    SINT32 n = 0;

    zOss_AssertExN(ring_id != NULL);
    
    n = ring_id->pToBuf + offset;
    if (n >= ring_id->bufSize)
    {
        n -= ring_id->bufSize;
    }

    zOss_AssertExN((n >= 0) && (n < ring_id->bufSize));//ƫΧ
    
    *(ring_id->buf + n) = writebyte;
}

/**************************************************************************
* : zOss_RingMoveAhead
* : λдָƶֽ
* ˵(IN)
                ring_id:λID
                n:Ҫƶֽ,ǰƶƶ
                  Χ: -λֽ ~ +λֽ
            (OUT)
*   ֵ:  
* ˵: дָ볬󳤶ʱԶ
**************************************************************************/ 
VOID zOss_RingMoveAhead(T_ZOss_RingId ring_id, SINT32 n)
{
    zOss_AssertExN(ring_id != NULL);
    
    n += ring_id->pToBuf;

    if (n >= ring_id->bufSize)
    {
        n -= ring_id->bufSize;
    }

    zOss_AssertExN((n >= 0) && (n < ring_id->bufSize));//nֵΧ
    
    ring_id->pToBuf = n;
}

#ifdef __cplusplus
} 
#endif

