/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     oss_math.h
* ļʶ:     oss_math.h
* ժҪ:     OSS֧Ųݿͷļ
* ʹ÷:     #include "oss_math.h"
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/08/01      V1.0        Create                    
* 
*******************************************************************************/

#ifndef _OSS_MATH_H
#define _OSS_MATH_H

#ifdef _OS_LINUX

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include <linux/kernel.h>

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define LIBM_HI(__x)  (((libm_ieee_double_shape_type *)&__x)->parts.msw)
#define LIBM_LO(__x)  (((libm_ieee_double_shape_type *)&__x)->parts.lsw)
#define LIBM_HIp(__x) (((libm_ieee_double_shape_type *)__x)->parts.msw)
#define LIBM_LOp(__x) (((libm_ieee_double_shape_type *)__x)->parts.lsw)

/* Get two 32 bit ints from a double.  */
#define EXTRACT_WORDS(ix0, ix1, d)                                          \
    do {                                                                    \
        libm_ieee_double_shape_type ew_u;                                   \
        ew_u.value = (d);                                                   \
        (ix0) = ew_u.parts.msw;                                             \
        (ix1) = ew_u.parts.lsw;                                             \
    } while (0)

/* Get the more significant 32 bit int from a double.  */
#define GET_HIGH_WORD(i,d)                                                  \
    do {                                                                    \
        libm_ieee_double_shape_type gh_u;                                   \
        gh_u.value = (d);                                                   \
        (i) = gh_u.parts.msw;                                               \
    } while (0)

/* Get the less significant 32 bit int from a double.  */
#define GET_LOW_WORD(i,d)                                                   \
    do {                                                                    \
        libm_ieee_double_shape_type gl_u;                                   \
        gl_u.value = (d);                                                   \
        (i) = gl_u.parts.lsw;                                               \
    } while (0)

/* Set a double from two 32 bit ints.  */
#define INSERT_WORDS(d,ix0,ix1)                                             \
    do {                                                                    \
        libm_ieee_double_shape_type iw_u;                                   \
        iw_u.parts.msw = (ix0);                                             \
        iw_u.parts.lsw = (ix1);                                             \
        (d) = iw_u.value;                                                   \
    } while (0)

/* Set the more significant 32 bits of a double from an int.  */
#define SET_HIGH_WORD(d,v)                                                  \
    do {                                                                    \
        libm_ieee_double_shape_type sh_u;                                   \
        sh_u.value = (d);                                                   \
        sh_u.parts.msw = (v);                                               \
        (d) = sh_u.value;                                                   \
    } while (0)

/* Set the less significant 32 bits of a double from an int.  */
#define SET_LOW_WORD(d,v)                                                   \
    do {                                                                    \
        libm_ieee_double_shape_type sl_u;                                   \
        sl_u.value = (d);                                                   \
        sl_u.parts.lsw = (v);                                               \
        (d) = sl_u.value;                                                   \
    } while (0)

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef union 
{
    s32 asi32[2];

    s64 asi64;
    
    double value;

    struct 
    {
        unsigned int fraction3:16;
        unsigned int fraction2:16;
        unsigned int fraction1:16;
        unsigned int fraction0: 4;
        unsigned int exponent :11;
        unsigned int sign     : 1;
    } number;

    struct 
    {
        unsigned int function3:16;
        unsigned int function2:16;
        unsigned int function1:16;
        unsigned int function0:3;
        unsigned int quiet:1;
        unsigned int exponent: 11;
        unsigned int sign : 1;
    } nan;

    struct 
    {
        u32 lsw;
        u32 msw;
    } parts;
    
} libm_ieee_double_shape_type;


typedef union
{
    s32 asi32;
  
    float value;

    struct 
    {
        unsigned int fraction0: 7;
        unsigned int fraction1: 16;
        unsigned int exponent: 8;
        unsigned int sign : 1;
    } number;

    struct 
    {
        unsigned int function1:16;
        unsigned int function0:6;
        unsigned int quiet:1;
        unsigned int exponent:8;
        unsigned int sign:1;
    } nan;

} libm_ieee_float_shape_type;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/
double fabs(double x);
double copysign(double x, double y);
double sqrt(double x);
double scalbn (double x, int n);
double pow(double x, double y);
double log(double x);

#endif  // #ifdef _OS_LINUX

#endif  // #ifndef _OSS_MATH_H

