/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     linux_except_arm.c
* ļʶ:     linux_except_arm.c
* ժҪ:     linux֧Ų쳣ģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/07/18      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "linux_except_arm.h"
#include "sys_func_atcfg.h"
#include "sys_com.h"
#ifdef _USE_MULTI_CORE_RAMDUMP
#include "sup_ramdump.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                *
*******************************************************************************/
extern void linux_ramdump_user(void);
extern int zte_sys_err_hnd(int user_called, int ecode, int extra);

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define EXCEPT_LOCK(lock)       raw_spin_lock_irqsave(lock, old_intr)
#define EXCEPT_UNLOCK(lock)     raw_spin_unlock_irqrestore(lock, old_intr)

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
enum {
    LINUX_EXCEPT_NONE         = -1,
    LINUX_EXCEPT_CPU_START    = 0,
    LINUX_EXCEPT_CPU_END      = 7,
    LINUX_EXCEPT_ASSERT       = 128
};

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static raw_spinlock_t linux_lock;
static linux_except_t linux_except = {0};

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ʧܻص
* ˵:     
*   ()  exp:    Աʽ
                file:   Եļ
                line:   Եк
*   ()  void
*   ֵ:     void
* ˵:     úֻӦzOss_ASSERTʧܵ±
*******************************************************************************/
void linux_assert_failed(const char *exp, const char *file, const char *func, int line)
{
    unsigned long old_intr;

    EXCEPT_LOCK(&linux_lock);
    if (linux_except.nr == LINUX_EXCEPT_NONE)
    {
        linux_except.nr = LINUX_EXCEPT_ASSERT;
    }
    linux_except.exp     = exp;
    linux_except.file    = file;
    linux_except.func    = func;
    linux_except.line    = line;

    printk("\n*******************modem panic information start*******************\n");
    if (exp)
        printk("*******************expr:\t%s\n", exp);
    if (file)
        printk("*******************file:\t%s\n", file);
    if (func)
        printk("*******************func:\t%s\n", func);
    printk("*******************line:%d\n", line);
    printk("*******************modem panic information end*********************\n");
    panic("linux kernel panic\n");
}

#if 0
/*******************************************************************************
* :     쳣ĳʼ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ʼ
* ˵:     ο׼errnoĶ
*******************************************************************************/
int zOss_ExceptInit(void)
{
    unsigned long old_intr;

    raw_spin_lock_init(&linux_lock);

    EXCEPT_LOCK(&linux_lock);
    linux_except.nr      = LINUX_EXCEPT_NONE;
    linux_except.exp     = NULL;
    linux_except.file    = NULL;
    linux_except.func    = NULL;
    linux_except.line    = -1;
    EXCEPT_UNLOCK(&linux_lock);

    return 0x00;
}

/*******************************************************************************
* :     LINUXϵͳidle߳
* ˵:     
*   ()  loop_count: idle߳ѭĴ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_idle_thread(u32 loop_count)
{

}

/*******************************************************************************
* :     LINUXϵͳramdumpں
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_ramdump_entry(void)
{
    unsigned int old_intr;
    static unsigned int flag;

    if (flag)
        return;

    ZOSS_SAVE_IRQ(old_intr);

    if(zOss_GetExceptResetFlag() != EXCEPT_RESET_ENABLE)
    {
	 linux_ramdump_user();

    #ifdef _USE_MULTI_CORE_RAMDUMP
        zOss_RamdumpHandle(1, 1, 1);
    # else  
        zte_sys_err_hnd(1, 1, 1);
    #endif

        flag++;
    }
    else
    {
        zSys_ExceptReboot(0);
    }

    ZOSS_RESTORE_IRQ(old_intr);
}

#ifdef __cplusplus
}
#endif
#endif
