/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_irq.c
* ļ : 
* ʵֹ : TOS 3.0жģʵ
*      : 
*      : V1.0
*  : 2011/09/23
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/**************************************************************************
* ⲿ
**************************************************************************/
#ifdef TOS_STATISTIC_IRQ
extern int tos_statistic_irq_init_flag;
extern unsigned int tos_statistic_irq_assert_tick;
#endif

#ifdef _USE_MONITOR
extern T_ZOss_Mon_Event oss_trace_event_info;
#endif

void tos_statistic_irq_isr_start(unsigned int vector) __attribute__((weak));
void tos_statistic_irq_isr_end(unsigned int vector) __attribute__((weak));
void tos_statistic_irq_dsr_start(unsigned int vector) __attribute__((weak));
void tos_statistic_irq_dsr_end(unsigned int vector) __attribute__((weak));

/**************************************************************************
* 궨
**************************************************************************/
#ifdef TOS_TRACE_IRQ
# ifdef _USE_OSS_MIN
#  define TOS_TRACE_IRQ_NUM             10
# else
#  define TOS_TRACE_IRQ_NUM             100
# endif
#endif

#ifdef TOS_STATISTIC_IRQ
# ifdef _USE_OSS_MIN
#  define TOS_STATISTIC_IRQ_NUM         10
# else
#  define TOS_STATISTIC_IRQ_NUM         100
# endif
#endif
   
/* TOS_STATISTIC_IRQ_ATTACH_TAG */
#define TOS_STATISTIC_IRQ_ATTACH
#ifdef TOS_STATISTIC_IRQ_ATTACH
# ifdef _USE_OSS_MIN
#  define TOS_STATISTIC_IRQ_ATTACH_NUM  10
# else
#  define TOS_STATISTIC_IRQ_ATTACH_NUM  30
# endif
#endif

#ifdef CYGNUM_HAL_VECTOR_INTRFIRST
# define TOS_IRQ_VECTOR_BASE            CYGNUM_HAL_VECTOR_INTRFIRST
#else
# define TOS_IRQ_VECTOR_BASE            0
#endif

#ifdef CYGPKG_HAL_CORTEXM
# define TOS_TRANSLATE_VECTOR(_vector_, _index_) ((_index_) = (_vector_) + 1)
#else
# define TOS_TRANSLATE_VECTOR(_vector_, _index_)
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct {
    unsigned int    stm_0;
    unsigned int    stm_7;
} tos_statistic_irq_tick_t;

#ifdef TOS_STATISTIC_IRQ
typedef struct {
    unsigned int    vector;
    unsigned int    start_tick;
    unsigned int    end_tick;
} tos_statistic_irq_t;

typedef struct {
    unsigned int    start_tick;
    unsigned int    end_tick;
} tos_statistic_irq_thread_t;

typedef struct {
    unsigned int    tick;
    cyg_handle_t    thread;
    char            *thread_name;
} tos_statistic_irq_assert_t;
#endif

#ifdef TOS_STATISTIC_IRQ_ATTACH
typedef struct {
    unsigned int    vector;
    unsigned int    priority;
    unsigned int    data;
    void            *isr;
    void            *dsr;
} tos_statistic_irq_create_t;
#endif

#ifdef TOS_TRACE_IRQ
typedef struct {
    const char      *file;
    unsigned int    line;
    unsigned int    tick;
} tos_trace_irq_t;
#endif

/**************************************************************************
* ֲԭ
**************************************************************************/


/**************************************************************************
* ȫֳ/
**************************************************************************/
#ifdef TOS_STATISTIC_IRQ
tos_statistic_irq_tick_t    tos_irq_tick;
int                         tos_statistic_irq_init_flag     = 0;
unsigned int                tos_statistic_irq_isr_count     = 0;
unsigned int                tos_statistic_irq_dsr_count     = 0;
unsigned int                tos_statistic_irq_thread_count  = 0;
unsigned int                tos_statistic_irq_assert_count  = 0;
tos_statistic_irq_t         tos_statistic_irq_isr[TOS_STATISTIC_IRQ_NUM];
tos_statistic_irq_t         tos_statistic_irq_dsr[TOS_STATISTIC_IRQ_NUM];
tos_statistic_irq_thread_t  tos_statistic_irq_thread[TOS_STATISTIC_IRQ_NUM];
unsigned int                tos_statistic_irq_assert_tick;
tos_statistic_irq_assert_t  tos_statistic_irq_assert_array[TOS_STATISTIC_IRQ_NUM];
#endif

#ifdef TOS_STATISTIC_IRQ_ATTACH
unsigned int                tos_statistic_irq_attach_count;
tos_statistic_irq_create_t  tos_statistic_irq_attach[TOS_STATISTIC_IRQ_ATTACH_NUM];
#endif

#ifdef TOS_TRACE_IRQ
int                         tos_trace_irq_disable_flag          = 0;
unsigned int                tos_trace_irq_disable_count         = 0;
unsigned int                tos_trace_irq_disable_total_count   = 0;
tos_trace_irq_t             tos_trace_irq_disable[TOS_TRACE_IRQ_NUM];

int                         tos_trace_irq_enable_flag           = 0;
unsigned int                tos_trace_irq_enable_count          = 0;
unsigned int                tos_trace_irq_enable_total_count;
tos_trace_irq_t             tos_trace_irq_enable[TOS_TRACE_IRQ_NUM];

int                         tos_trace_irq_save_flag             = 0;
unsigned int                tos_trace_irq_save_count            = 0;
unsigned int                tos_trace_irq_save_total_count;
tos_trace_irq_t             tos_trace_irq_save[TOS_TRACE_IRQ_NUM];

int                         tos_trace_irq_restore_flag          = 0;
unsigned int                tos_trace_irq_restore_count         = 0;
unsigned int                tos_trace_irq_restore_total_count   = 0;
tos_trace_irq_t             tos_trace_irq_restore[TOS_TRACE_IRQ_NUM];
#endif


/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* :     ȡǰtick
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ǰtick
* ˵:     void
**************************************************************************/
#ifdef _USE_MONITOR
static unsigned long long tos_irq_current_tick(void)
{
    return (unsigned long long)(*(unsigned int *)0xf4b00010) | ((unsigned long long)((*(unsigned int *)0xf4b0002c) & 0xFFFFFF) << 32);
}
#endif

/**************************************************************************
* ȫֺʵ
**************************************************************************/

#ifdef TOS_STATISTIC_IRQ
/**************************************************************************
* :     жͳƹܣ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_open(void)
{
    tos_statistic_irq_init_flag = 1;
}

/**************************************************************************
* :     رжͳƹܣ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_close(void)
{
    tos_statistic_irq_init_flag = 0;
}

/**************************************************************************
* :     жͳƹܵĶԺ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_assert(void)
{
    if (tos_statistic_irq_init_flag) 
    {
        tos_statistic_irq_assert_array[tos_statistic_irq_assert_count].tick = tos_statistic_irq_assert_tick;
        tos_statistic_irq_assert_array[tos_statistic_irq_assert_count].thread = cyg_thread_self();
#ifdef CYGOPT_KERNEL_EXTEND_THREAD_NAME
        tos_statistic_irq_assert_array[tos_statistic_irq_assert_count].thread_name = cyg_thread_get_name(cyg_thread_self());
#else        
        tos_statistic_irq_assert_array[tos_statistic_irq_assert_count].thread_name = NULL;
#endif
        if (++tos_statistic_irq_assert_count >= TOS_STATISTIC_IRQ_NUM)
        {
            tos_statistic_irq_assert_count = 0x00;
        }
    }
}


/**************************************************************************
* :     ͳжϴʼִʱʱ
* ˵:     
*   ()  vector:     ж
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_isr_start(unsigned int vector)
{
    if (tos_statistic_irq_init_flag) 
    {
        tos_statistic_irq_isr[tos_statistic_irq_isr_count].vector = vector - TOS_IRQ_VECTOR_BASE;
        tos_statistic_irq_isr[tos_statistic_irq_isr_count].start_tick = *(volatile unsigned int *)0xf4b00010;
        tos_statistic_irq_isr[tos_statistic_irq_isr_count].end_tick = 0x00;
    }
}


/**************************************************************************
* :     ͳжϴִʱʱ
* ˵:     
*   ()  vector:     ж
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_isr_end(unsigned int vector)
{
    if (tos_statistic_irq_init_flag) 
    {
        tos_statistic_irq_isr[tos_statistic_irq_isr_count].end_tick = *(volatile unsigned int *)0xf4b00010;
        if (++tos_statistic_irq_isr_count >= TOS_STATISTIC_IRQ_NUM)
        {
            tos_statistic_irq_isr_count = 0x00;
        }
    }
}


/**************************************************************************
* :     ͳӳжϴʼִʱʱ
* ˵:     
*   ()  vector:     ж
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_dsr_start(unsigned int vector)
{
    if (tos_statistic_irq_init_flag)
    {
        tos_statistic_irq_dsr[tos_statistic_irq_dsr_count].vector = vector - TOS_IRQ_VECTOR_BASE;
        tos_statistic_irq_dsr[tos_statistic_irq_dsr_count].start_tick = *(volatile unsigned int *)0xf4b00010;

#if defined (OSS_TRACE_THREAD) && defined(_USE_MONITOR)
        if (gOsa_MonitorFlag)
        {
            UINT32 cnt = oss_trace_event_info.num;

            oss_trace_event_info.ele[cnt].event        = OSS_MON_EVENT_DSR_SWAPIN;
            oss_trace_event_info.ele[cnt].name         = "dsr";
            oss_trace_event_info.ele[cnt].handle       = vector - TOS_IRQ_VECTOR_BASE;
            oss_trace_event_info.ele[cnt].tickstamp    = tos_irq_current_tick();
            if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
            {
                cnt = 0;
            }
            oss_trace_event_info.num = cnt;
        }
#endif
    }
}


/**************************************************************************
* :     ͳӳжϴִʱʱ
* ˵:     
*   ()  vector:     ж
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_dsr_end(unsigned int vector)
{
    if (tos_statistic_irq_init_flag) 
    {
        tos_statistic_irq_dsr[tos_statistic_irq_dsr_count].end_tick = *(volatile unsigned int *)0xf4b00010;
        if (++tos_statistic_irq_dsr_count >= TOS_STATISTIC_IRQ_NUM)
        {
            tos_statistic_irq_dsr_count = 0x00;
        }        
#if defined (OSS_TRACE_THREAD) && defined(_USE_MONITOR)
        if (gOsa_MonitorFlag)
        {
            UINT32 cnt = oss_trace_event_info.num;

            oss_trace_event_info.ele[cnt].event        = OSS_MON_EVENT_DSR_SWAPOUT;
            oss_trace_event_info.ele[cnt].name         = "dsr";
            oss_trace_event_info.ele[cnt].handle       = vector - TOS_IRQ_VECTOR_BASE;
            oss_trace_event_info.ele[cnt].tickstamp    = tos_irq_current_tick();
            if (++cnt >= OSS_MON_INFO_MAX_NUMBER)
            {
                cnt = 0;
            }
            oss_trace_event_info.num = cnt;
        }
#endif
    }
}


/**************************************************************************
* :     ͳƱжϻ߳̿ʼִʱʱ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_thread_start(void)
{
    if (tos_statistic_irq_init_flag) 
    {
        tos_statistic_irq_thread[tos_statistic_irq_thread_count].start_tick = *(volatile unsigned int *)0xf4b00010;
        tos_statistic_irq_thread[tos_statistic_irq_thread_count].end_tick = 0x00;
    }
}


/**************************************************************************
* :     ͳƱжϻִ߳̽ʱʱ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_thread_end(void)
{
    if (tos_statistic_irq_init_flag) 
    {
        tos_statistic_irq_thread[tos_statistic_irq_thread_count].end_tick = *(volatile unsigned int *)0xf4b00010;
        if (++tos_statistic_irq_thread_count >= TOS_STATISTIC_IRQ_NUM)
        {
            tos_statistic_irq_thread_count = 0x00;
        }
    }
}
#endif


#ifdef TOS_STATISTIC_IRQ_ATTACH
/**************************************************************************
* :     Cyg_Interrupt::attachеô˺ͳϵͳжԴ
                vectorprioritydataisrdsr
* ˵:     
*   ()  vector:     
                priority:   ȼ
                data:       
                isr:        жϷַ
                dsr:        ӳжϷַ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_statistic_irq_attach_hook(unsigned int vector,
                                   unsigned int priority,
                                   unsigned int data,
                                   void *isr,
                                   void *dsr)
{
    tos_statistic_irq_attach[tos_statistic_irq_attach_count].vector   = vector - TOS_IRQ_VECTOR_BASE;
    tos_statistic_irq_attach[tos_statistic_irq_attach_count].priority = priority;
    tos_statistic_irq_attach[tos_statistic_irq_attach_count].data     = data;
    tos_statistic_irq_attach[tos_statistic_irq_attach_count].isr      = isr;
    tos_statistic_irq_attach[tos_statistic_irq_attach_count].dsr      = dsr;
    tos_statistic_irq_attach_count++;
    if (tos_statistic_irq_attach_count == TOS_STATISTIC_IRQ_ATTACH_NUM)
    {
        tos_statistic_irq_attach_count = 0x00;
    }
}
#endif


/**************************************************************************
* :     ĬϵжϷ
* ˵:     
*   ()  vector:     ж
                data:       жϷʱĲ
*   ()  void
*   ֵ:     μCyg_Interrupt::CALL_DSRCyg_Interrupt::HANDLEDʹ÷
* ˵:     void
**************************************************************************/
UINT32 tos_default_isr( UINT32 vector, UINT32 data)
{
    //HAL_INTERRUPT_MASK(vector);
    return 0x03;    /* Cyg_Interrupt::CALL_DSR | Cyg_Interrupt::HANDLED */
}

#ifdef _USE_OSS_MIN
/**************************************************************************
* :     ضжϵжϷ̺жӳٷ
* ˵:     
*   ()  μбеע
*   ()  void
*   ֵ:     жϷ̺жӳٷ̵ľ
* ˵:     1) ʧܣϵͳԣ
                2) úڴռ䣬tos_delete_irqͷţ
**************************************************************************/
UINT32 tos_create_irq(
                UINT32 vector,              /* ж         */
                UINT32 priority,            /* жȼ       */
                UINT32 data,                /* ָ         */
                tos_isr_t  isr,             /* жϷ     */
                tos_dsr_t  dsr,             /* жӳٷ */
                cyg_interrupt *interrupt)   /* жϽṹָ   */
{
    cyg_handle_t interrupt_handle = 0x00;

    CYG_ASSERT(interrupt != NULL, "NULL");

    TOS_TRANSLATE_VECTOR(vector, vector);
    if (isr == NULL)
        isr = tos_default_isr;

    cyg_interrupt_create(
        vector,             /* Vector to attach to          */
        priority,           /* Queue priority               */
        data,               /* Data pointer                 */
        (cyg_ISR_t *)isr,   /* Interrupt Service Routine    */
        (cyg_DSR_t *)dsr,   /* Deferred Service Routine     */
        &interrupt_handle,  /* returned handle              */
        interrupt           /* put interrupt here           */
    );
    CYG_ASSERT(interrupt_handle != 0x00, "NULL");
    cyg_interrupt_attach( interrupt_handle );
    cyg_interrupt_unmask(vector);

    return interrupt_handle;
}


/**************************************************************************
* :     ɾضжϵжϷ̺жӳٷ
* ˵:     
*   ()  interrupt_handle:   ɾжϷ̺жӳٷ̵ľ
*   ()  void
*   ֵ:     void
* ˵:     עϵͳõ˳򣬲ܵߵ:
                1) жϣ
                2) жϹҽӣ
                3) ɾжϷ̺жӳٷ̣
                4) ͷtos_create_irqڴռ䣻
**************************************************************************/
VOID tos_delete_irq(UINT32 interrupt_handle)
{
    cyg_interrupt *icb = NULL;     /* interrupt control block */

    CYG_ASSERT(interrupt_handle != 0x00, "NULL");

    icb = (cyg_interrupt*)interrupt_handle;
    cyg_interrupt_mask(icb->vector);
    cyg_interrupt_detach(interrupt_handle);
    cyg_interrupt_delete(interrupt_handle);
}
#else
/**************************************************************************
* :     ضжϵжϷ̺жӳٷ
* ˵:     
*   ()  μбеע
*   ()  void
*   ֵ:     жϷ̺жӳٷ̵ľ
* ˵:     1) ʧܣϵͳԣ
                2) úڴռ䣬tos_delete_irqͷţ
**************************************************************************/
UINT32 linux_create_irq(UINT32 vector,        /* ж         */
                           UINT32 priority,      /* жȼ       */
                           UINT32 data,          /* ָ         */
                           linux_isr_t isr,        /* жϷ     */
                           linux_dsr_t dsr)        /* жӳٷ */
{
    return 0x00;
}


/**************************************************************************
* :     ɾضжϵжϷ̺жӳٷ
* ˵:     
*   ()  interrupt_handle:   ɾжϷ̺жӳٷ̵ľ
*   ()  void
*   ֵ:     void
* ˵:     עϵͳõ˳򣬲ܵߵ:
                1) жϣ
                2) жϹҽӣ
                3) ɾжϷ̺жӳٷ̣
                4) ͷtos_create_irqڴռ䣻
**************************************************************************/
VOID linux_delete_irq(UINT32 interrupt_handle)
{

}
#endif


#ifdef TOS_TRACE_IRQ
/**************************************************************************
* :     irqٹܣ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_irq_open(void)
{
    tos_trace_irq_disable_flag = 1;
    tos_trace_irq_enable_flag  = 1;
    tos_trace_irq_save_flag    = 1;
    tos_trace_irq_restore_flag = 1;
}

/**************************************************************************
* :     رirqٹܣ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_irq_close(void)
{
    tos_trace_irq_disable_flag = 0;
    tos_trace_irq_enable_flag  = 0;
    tos_trace_irq_save_flag    = 0;
    tos_trace_irq_restore_flag = 0;
}

/**************************************************************************
* :     ȥʹж
* ˵:     
*   ()  file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_disable_irq(const char *file, unsigned int line)
{
    if (tos_trace_irq_disable_flag) 
    {
        tos_trace_irq_disable[tos_trace_irq_disable_count].file   = file;
        tos_trace_irq_disable[tos_trace_irq_disable_count].line   = line;
        tos_trace_irq_disable[tos_trace_irq_disable_count].tick   = *(volatile unsigned int *)0xf4b00010;
        tos_trace_irq_disable_total_count++;
        if (++tos_trace_irq_disable_count >= TOS_TRACE_IRQ_NUM)
        {
            tos_trace_irq_disable_count = 0x00;
        }
    }
}


/**************************************************************************
* :     ʹж
* ˵:     
*   ()  file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_enable_irq(const char *file, unsigned int line)
{
    if (tos_trace_irq_enable_flag) 
    {
        tos_trace_irq_enable[tos_trace_irq_enable_count].file = file;
        tos_trace_irq_enable[tos_trace_irq_enable_count].line = line;
        tos_trace_irq_enable[tos_trace_irq_enable_count].tick = *(volatile unsigned int *)0xf4b00010;
        tos_trace_irq_enable_total_count++;
        if (++tos_trace_irq_enable_count >= TOS_TRACE_IRQ_NUM)
        {
            tos_trace_irq_enable_count = 0x00;
        }
    }
}


/**************************************************************************
* :     ٱж
* ˵:     
*   ()  file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_save_irq(const char *file, unsigned int line)
{
    if (tos_trace_irq_save_flag) 
    {
        tos_trace_irq_save[tos_trace_irq_save_count].file = file;
        tos_trace_irq_save[tos_trace_irq_save_count].line = line;
        tos_trace_irq_save[tos_trace_irq_save_count].tick = *(volatile unsigned int *)0xf4b00010;
        tos_trace_irq_save_total_count++;
        if (++tos_trace_irq_save_count >= TOS_TRACE_IRQ_NUM)
        {
            tos_trace_irq_save_count = 0x00;
        }
    }
}


/**************************************************************************
* :     ٻָж
* ˵:     
*   ()  file:   ļ
                line:   к
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_restore_irq(const char *file, unsigned int line)
{
    if (tos_trace_irq_restore_flag) 
    {
        tos_trace_irq_restore[tos_trace_irq_restore_count].file   = file;
        tos_trace_irq_restore[tos_trace_irq_restore_count].line   = line;
        tos_trace_irq_restore[tos_trace_irq_restore_count].tick   = *(volatile unsigned int *)0xf4b00010;
        tos_trace_irq_restore_total_count++;
        if (++tos_trace_irq_restore_count >= TOS_TRACE_IRQ_NUM)
        {
            tos_trace_irq_restore_count = 0x00;
        }
    }
}


/**************************************************************************
* :     ԸжϽӿǷ
* ˵:     
*   ()  void
                void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_trace_irq_assert(void)
{
    //volatile int cnt;
    ZOSS_INTR old_intr;

    ZOSS_SAVE_IRQ(old_intr);
    *(unsigned int *)0x01 = 0x12345678;
    //for (cnt = 0x00; cnt < 60000000; cnt++);
    ZOSS_RESTORE_IRQ(old_intr);
}

#endif  /* TOS_TRACE_IRQ */

#ifdef __cplusplus
}
#endif

