/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_mmu_csky.c
* ļ : 
* ʵֹ : cskymmuʵģ
*      : 
*      : V1.0
*  : 2011/11/09
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : 
*    : V1.1
* ޸ : 2011/11/23
* ޸ : ع
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : 
*    : V1.2
* ޸ : 2012/03/09
* ޸ : ںĿ¼ֲplatĿ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0003
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0004
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "tos_mmu_csky.h"
#include <cyg/infra/cyg_ass.h>
#include "oss_api.h"

#ifdef __cplusplus
extern "C" 
{
#endif

#ifdef CYG_HAL_CSKYCPU_MMU

/**************************************************************************
* 궨
**************************************************************************/
#define CSKY_MMU_DEBUG

#define DPRAM_PHY_ADDR  (0x40000000)
#define DPRAM_VIR_ADDR  (0x40000000)
#define DPRAM_SIZE      (CSKY_PAGE_SIZE_16M)
#define DPRAM_ATTR      (CSKY_PAGE_CACHE_DISABLE | CSKY_PAGE_DIRTY | CSKY_PAGE_VALID)

#define ICP_PHY_ADDR    (0x50000000)
#define ICP_VIR_ADDR    (0x50000000)
#define ICP_SIZE        (CSKY_PAGE_SIZE_16M)
#define ICP_ATTR        (CSKY_PAGE_CACHE_DISABLE | CSKY_PAGE_DIRTY | CSKY_PAGE_VALID)

#define IO_PHY_ADDR     (0x60000000)
#define IO_VIR_ADDR     (0x60000000)
#define IO_SIZE         (CSKY_PAGE_SIZE_16M)
#define IO_ATTR         (CSKY_PAGE_CACHE_DISABLE | CSKY_PAGE_DIRTY | CSKY_PAGE_VALID)

#define NAND_PHY_ADDR   (0x82000000)
#define NAND_VIR_ADDR   (0xCA000000)
#define NAND_SIZE       (CSKY_PAGE_SIZE_16M)
#define NAND_ATTR       (CSKY_PAGE_CACHE_DISABLE | CSKY_PAGE_DIRTY | CSKY_PAGE_VALID)

#define GSM_PHY_ADDR    (0xF4000000)
#define GSM_VIR_ADDR    (0xF4000000)
#define GSM_SIZE        (0x3000000)
#define GSM_ATTR        (CSKY_PAGE_CACHE_DISABLE | CSKY_PAGE_DIRTY | CSKY_PAGE_VALID)

/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* ֲԭ
**************************************************************************/

/**************************************************************************
* ȫֳ/
**************************************************************************/
static csky_tlb_mismatch_t  tos_csky_tlb_mismatch      = {0};

static csky_mmu_region_t    *tos_csky_mmu_region_head  = NULL;

static csky_mmu_region_t    tos_csky_mmu_region[]      = 
{
    {
        DPRAM_PHY_ADDR, /* physical address */
        DPRAM_VIR_ADDR, /* virtual address  */
        DPRAM_SIZE,     /* region size      */
        DPRAM_ATTR,     /* region attribute */
        NULL
    },
    
    {
        ICP_PHY_ADDR,   /* physical address */
        ICP_VIR_ADDR,   /* virtual address  */
        ICP_SIZE,       /* region size      */
        ICP_ATTR,       /* region attribute */
        NULL
    },

    {
        IO_PHY_ADDR,    /* physical address */
        IO_VIR_ADDR,    /* virtual address  */
        IO_SIZE,        /* region size      */
        IO_ATTR,        /* region attribute */
        NULL
    },

    {
        NAND_PHY_ADDR,  /* physical address */
        NAND_VIR_ADDR,  /* virtual address  */
        NAND_SIZE,      /* region size      */
        NAND_ATTR,      /* region attribute */
        NULL
    },

    {
        GSM_PHY_ADDR,   /* physical address */
        GSM_VIR_ADDR,   /* virtual address  */
        GSM_SIZE,       /* region size      */
        GSM_ATTR,       /* region attribute */
        NULL
    },
};


/**************************************************************************
* ֲʵ
**************************************************************************/

/**************************************************************************
* :     ЭѡMMU
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     socоƬϿܴڶЭʵMMUЭѡ
**************************************************************************/
static inline void tos_csky_mmu_select_cp(void)
{
    asm volatile (                                                          \
        "cpseti cp15;"  /* select mmu coprocessor */                        \
        :                                                                   \
        :                                                                   \
        :                                                                   \
    );
}

#ifdef CSKY_MMU_DEBUG
/**************************************************************************
* :     mir(MMU Index Register)Ĵ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     mirĴֵ
* ˵:     void
**************************************************************************/
static inline cyg_uint32 tos_csky_mmu_mir_read(void)
{
    cyg_uint32 MIR = 0x00;

    asm volatile (                                                          \
        "cpseti cp15;"                                                      \
        "cprcr  r1, cpcr0;"                                                 \
        "mov    %0, r1;"                                                    \
        : "=r"(MIR)                                                         \
        :                                                                   \
        : "r1"                                                              \
    );

    return MIR & 0x3F;
}
#endif

/**************************************************************************
* :     дmir(MMU Index Register)Ĵ
* ˵:     
*   ()  MIR:    дMIRĴֵ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static inline void tos_csky_mmu_mir_write(cyg_uint32 MIR)
{
    asm volatile (                                                          \
        "cpseti cp15;"                                                      \
        "mov    r1, %0;"                                                    \
        "cpwcr  r1, cpcr0;"                                                 \
        :                                                                   \
        : "r"(MIR)                                                          \
        : "r1"                                                              \
    );
}

/**************************************************************************
* :     дmmumpr(MMU Page mask Register)Ĵ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     μck610оƬֲйmprĴ˵
**************************************************************************/
static inline void tos_csky_mmu_write_mpr(int value)
{
    asm volatile (                                                          \
        "cpseti cp15;"      /* select mmu coprocessor */                    \
        "mov    r1, %0;"                                                    \
        "cpwcr  r1, cpcr6;"                                                 \
        :                                                                   \
        : "r"(value)                                                        \
        : "r1"                                                              \
    );
}

/**************************************************************************
* :     һtlb
* ˵:     
*   ()  MIR:    tlb
                tlb:    tlbַ
*   ()  void
*   ֵ:     void
* ˵:     μck610оƬֲйTLBRI˵
**************************************************************************/
static inline void tos_csky_mmu_tlb_read(cyg_uint32 MIR, csky_tlb_entry_t *tlb)
{
    if (MIR >= CSKY_TLB_NUM)
    {
        return;
    }
    
    if (tlb == NULL)
    {
        return;
    }

    tos_csky_mmu_mir_write(MIR);

    asm volatile (                                                          \
        "cpseti cp15;"                                                      \
        "lrw    r1, (1<<29);"                                               \
        "cpwcr  r1, cpcr8;"     /* Write MICR               */              \
        "cprcr  r1, cpcr1;"     /* MRR(MMU Random Register) */              \
        "cprcr  r2, cpcr2;"     /* MEL0(MMU Entry Low 0)    */              \
        "cprcr  r3, cpcr3;"     /* MEL0(MMU Entry Low 0)    */              \
        "cprcr  r4, cpcr4;"     /* MEH(MMU Entry High)      */              \
        "mov    r5, %0;"                                                    \
        "stw    r1, (r5, 0);"                                               \
        "stw    r2, (r5, 4);"                                               \
        "stw    r3, (r5, 8);"                                               \
        "stw    r4, (r5, 12);"                                              \
        :                                                                   \
        : "r"(tlb)                                                          \
        : "r1", "r2", "r3", "r4", "r5"                                      \
    );
}

/**************************************************************************
* :     ʹָasidtlbʧЧ
* ˵:     
*   ()  asid:   asid Stands for Address Space Identify
*   ()  void
*   ֵ:     void
* ˵:     μck610оƬֲйTLBINV˵
**************************************************************************/
static inline void tos_csky_mmu_tlb_invalid(cyg_uint8 asid)
{
    asm volatile (                                                          \
        "cpseti cp15;"          /* select mmu coprocessor */                \
        "mov    r1, %0;"                                                    \
        "cpwcr  r1, cpcr4;"     /* MEH = asid       */                      \
        "lrw    r1, (1<<27);"   /* TLBINV           */                      \
        "cpwcr  r1, cpcr8;"     /* execute TLBINV   */                      \
        :                                                                   \
        : "r"(asid)                                                         \
        : "r1"                                                              \
    );
}

/**************************************************************************
* :     cskymmu
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void tos_csky_mmu_enable(void)
{
    asm volatile (                                                          \
        "mfcr   r1, cr18;"                                                  \
        "bseti  r1, 0;"                                                     \
        "bclri  r1, 1;"                                                     \
        "mtcr   r1, cr18;"                                                  \
        :                                                                   \
        :                                                                   \
        : "r1"                                                              \
    );
}


#if 0
/**************************************************************************
* :     رcskymmu
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void tos_csky_mmu_disable(void)
{
    asm volatile (                                                          \
        "mfcr   r1, cr18;"                                                  \
        "bclri  r1, 0;"                                                     \
        "bclri  r1, 1;"                                                     \
        "mtcr   r1, cr18;"                                                  \
        :                                                                   \
        :                                                                   \
        : "r1"                                                              \
    );
}
#endif

/**************************************************************************
* :     һtlb
* ˵:     
*   ()  MEL0:   MMU Entry Low 0PFN(Physical Frame Number)
                MEL1:   MMU Entry Low 1PFN(Physical Frame Number)
                MEH:    MMU Entry HighVPN(Virtual Page Number)
*   ()  void
*   ֵ:     void
* ˵:     μck610оƬֲйTLBWI˵
**************************************************************************/
static inline void tos_csky_mmu_tlb_set(cyg_uint32 MEL0, cyg_uint32 MEL1, cyg_uint32 MEH)
{
    asm volatile (                                                          \
        "cpseti cp15;"          /* select mmu coprocessor */                \
        "mov    r1, %0;"                                                    \
        "cpwcr  r1, cpcr2;"     /* MEL0             */                      \
        "mov    r1, %1;"                                                    \
        "cpwcr  r1, cpcr3;"     /* MEL1             */                      \
        "mov    r1, %2;"                                                    \
        "cpwcr  r1, cpcr4;"     /* MEH              */                      \
        "lrw    r1, (1<<28);"   /* TLBWR            */                      \
        "cpwcr  r1, cpcr8;"     /* execute TLBWR    */                      \
        :                                                                   \
        : "r"(MEL0), "r"(MEL1), "r"(MEH)                                    \
        : "r1"                                                              \
    );
}

/**************************************************************************
* :     ʼûõtlb
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     tos_csky_mmu_regionҪ£ϵͳ:
                1. õʼַCSKY_PAGE_SIZE_DEFAULTС룻
                2. õʼַCSKY_PAGE_SIZE_DEFAULTС룻
                3. õҳСCSKY_PAGE_SIZE_DEFAULT;
                4. ڱõĵַռ䲻ص;
**************************************************************************/
static void tos_csky_mmu_tlb_init(void)
{
    cyg_uint32          cnt         = 0;
    cyg_uint32          page_cnt    = 0;
    cyg_uint32          MEL0        = 0;
    cyg_uint32          MEL1        = 0;
    cyg_uint32          MEH         = 0;
    cyg_uint32          MIR         = 0;
    cyg_uint32          addr        = 0;
    csky_mmu_region_t   *region     = NULL;
    csky_mmu_region_t   *region_end = ARRAY_END(tos_csky_mmu_region);
    
    region = ARRAY_START(tos_csky_mmu_region);
    for (; region < region_end; region++) 
    {
        zOss_ASSERT((region->phy_addr%CSKY_PAGE_SIZE_DEFAULT) == 0);
        zOss_ASSERT((region->vir_addr%CSKY_PAGE_SIZE_DEFAULT) == 0);
        zOss_ASSERT(region->size >= CSKY_PAGE_SIZE_DEFAULT);
        if (region < region_end - 1)
        {
            zOss_ASSERT((region->phy_addr + region->size) <= (region + 1)->phy_addr);
        }
    }
    
    MIR = CSKY_TLB_REG_START;
    region = ARRAY_START(tos_csky_mmu_region);
    tos_csky_mmu_region_head = region;
    for (; region < region_end && MIR < CSKY_TLB_NUM; region++) 
    {
        page_cnt = region->size/(2*CSKY_PAGE_SIZE_DEFAULT);
        if (region->size%(2*CSKY_PAGE_SIZE_DEFAULT))
        {
            page_cnt++;
        }
        
        for (cnt = 0x00; cnt < page_cnt; cnt++, MIR++)
        {
            addr    = (region->phy_addr + (cnt*2)*CSKY_PAGE_SIZE_DEFAULT) >> CSKY_PFN_OFFSET;
            MEL0    = addr | region->attr;
            
            addr    = (region->phy_addr + (cnt*2+1)*CSKY_PAGE_SIZE_DEFAULT) >> CSKY_PFN_OFFSET;
            MEL1    = addr | region->attr;
            
            MEH     = region->vir_addr + cnt*2*CSKY_PAGE_SIZE_DEFAULT;
            
            tos_csky_mmu_tlb_set(MEL0, MEL1, MEH);
        }
        
        region->next = (csky_mmu_region_t *)(region + 1);
        if (region == region_end - 1)
        {
            region->next = NULL;
        }
    }
}

/**************************************************************************
* :     cskytlbƥʧʱֳ
* ˵:     
*   ()  mismatch:   ʧƥṹָ룬ڱֳ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void tos_csky_mmu_tlb_mismatch_save_context(csky_tlb_mismatch_t *mismatch)
{
    cyg_uint32 MEH = 0x00;
    cyg_uint32 MCR = 0x00;
    cyg_uint32 EPC = 0x00;

    zOss_AssertExN(mismatch != NULL);
    asm volatile (
        "cprcr  r2, cpcr4;"
        "cprcr  r3, cpcr5;"
        "mfcr   r4, epc;"
        "mov    %0, r2;"
        "mov    %1, r3;"
        "mov    %2, r4;"
        : "=r"(MEH), "=r"(MCR), "=r"(EPC)
        :
        : "r2", "r3", "r4"
    );

    mismatch->MEH       = MEH;
    mismatch->vpn       = MEH>>12;
    mismatch->asid      = MEH & ((0x1<<8) - 1);

    mismatch->MCR       = MCR;
    mismatch->pte_base  = MCR>>22;
    mismatch->bad_vpn2  = (MCR>>3) & ((0x1<<19) - 1);

    mismatch->epc       = EPC;
}

/**************************************************************************
* :     cskytlbƥʧʱtlb
* ˵:     
*   ()  mismatch:   ʧƥṹָ
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
static void tos_csky_mmu_tlb_mismatch_refill(csky_tlb_mismatch_t *mismatch)
{
    zOss_ASSERT(mismatch != NULL);
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* :     cskymmuܳʼ
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_csky_mmu_init(void)
{
    tos_csky_mmu_write_mpr(CSKY_PAGE_MASK_16M);

    tos_csky_mmu_tlb_init();

    tos_csky_mmu_enable();
}

/**************************************************************************
* :     cskytlbƥʧ
* ˵:     
*   ()  reg:    vectors.SбֳĴջ֡
*   ()  void
*   ֵ:     void
* ˵:     void
**************************************************************************/
void tos_csky_mmu_tlb_mismatch(HAL_SavedRegisters *reg)
{
    tos_csky_mmu_tlb_mismatch_save_context(&tos_csky_tlb_mismatch);
    tos_csky_mmu_tlb_mismatch_refill(&tos_csky_tlb_mismatch);
}

#endif  /* CYG_HAL_CSKYCPU_MMU */

#ifdef __cplusplus
}
#endif

