/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_ramdump_arm.c
* ļ : 
* ʵֹ : 
*      : 
*      : 1.0
*  : 2012/06/18
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

#if 0
/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "linux_ramdump.h"
#include "comm_api.h"
#include "hal_comm.h"
#include "sys_func_atcfg.h"
#include "linux_except_arm.h"
#include "linux_mem.cfg"
#ifdef _USE_ARM1_RAMDUMP
#include "drvs_icp.h"
#include "ps_ephy_interface.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif

#include "drvs_usbpoll.h"

/**************************************************************************
* ⲿ
**************************************************************************/

/**************************************************************************
* ⲿ
**************************************************************************/
extern VOID zOss_RamdumpSaveRegisters(VOID);
extern UINT32 cp15_readControlRegister( VOID );
extern UINT32 cp15_readDomainRegister( VOID );
extern UINT32 cp15_readTTB( VOID );
extern cyg_bool zTos_MmuGetReadableRegion(cyg_uint32 start, cyg_uint32 end, cyg_uint32 *p_start, cyg_uint32 *p_end);

/**************************************************************************
* 궨
**************************************************************************/
/* 滮ڴռֽڶ */
#define CMM_BUFFER_SIZE                     4096    /* 4k */
#define CONFIGURED_REGIONS_SIZE             4096    /* 4K */
#define PARSED_REGIONS_SIZE                 4096    /* 4K */
#define RAMDUMP_FILE_SIZE                   2048    /* 2K */
#define ERROR_CODE_SIZE                     1024    /* 1k */ 
#define IO_READ_BUFFER                      1024    /* 1K */
#define IO_WRITE_BUFFER                     1024    /* 1k */

#ifdef _USE_ARM1_RAMDUMP
#define HIGHMEM_FLAG_ARM02ARM1_SIZE         (4)
#define HIGHMEM_FLAG_ARM12ARM0_SIZE         (4)
#endif
/* io read/write buffer: [msg][data] */
#define RAMDUMP_IO_DATA_BASE(addr)          ((UINT32)addr + 4)

/* T_RamdumpCmmFileInfo */
#define CMM_FILE_BUF_SIZE(addr)             (*(UINT32 *)addr)
#define CMM_FILE_BUF_BASE(addr)             ((UINT32)addr + 4)


/* Ramdumpļ */
#define RAMDUMP_DIR_NAME                    "ramdump_dir"   /* ramdumpĿ¼    */
#define RAM_ARM0_NAME                       "arm0_ram.bin"  /* arm0_ramļ   */

#ifdef _USE_ARM1_RAMDUMP
#define RAM_ARM1_NAME                       "arm1_memory.bin"  /* arm1_ramļ   */
#define RAMDUMP_FLAG                        0x22222222
#define HIGHMEM_ARM1_CMM_INFO_BASE          0x20060000
#define HIGHMEM_ARM1_CONFIGURED_REGION_BASE (HIGHMEM_ARM1_CMM_INFO_BASE             + CMM_BUFFER_SIZE)
#define HIGHMEM_ARM1_PARSED_REGION_BASE     (HIGHMEM_ARM1_CONFIGURED_REGION_BASE    + CONFIGURED_REGIONS_SIZE)
#define HIGHMEM_ARM1_FLAG_ARM02ARM1_BASE    (HIGHMEM_ARM1_PARSED_REGION_BASE        + PARSED_REGIONS_SIZE + ERROR_CODE_SIZE)
#define HIGHMEM_ARM1_FLAG_ARM12ARM0_BASE    (HIGHMEM_ARM1_FLAG_ARM02ARM1_BASE       + HIGHMEM_FLAG_ARM02ARM1_SIZE)

#define ARM0_NOFITY_ARM1                                            \
    ramdump_send_msg_to_arm1();                                     \
    *(UINT32 *)HIGHMEM_ARM1_FLAG_ARM02ARM1_BASE = RAMDUMP_FLAG
    
#define ARM0_WAIT_ARM1                                              \
    while (RAMDUMP_FLAG != *(volatile UINT32*)HIGHMEM_ARM1_FLAG_ARM12ARM0_BASE) {}
        
#ifdef _USE_PSM
extern  SINT32 zOss_PsmGetSleepFlag(VOID);   /* arm1˯߱־ӿ */
extern  VOID   zL1e_WriteWakeUpEphyToRam(VOID);

#define ARM0_WAIT_DDR1_READY                                        \
    zL1e_WriteWakeUpEphyToRam();                                    \
    while ( PSM_DEEP_SLEEP == (UINT32)zOss_PsmGetSleepFlag() ) {}
#endif

#endif

#ifdef __GNUC__

#ifdef __thumb__
# define HAL_ARM_MODE(reg)                                          \
    "adr    "#reg", 1f;"                                            \
    "bx     "#reg";"                                                \
    ".arm   ;"                                                      \
    "1:     ;"

# define HAL_THUMB_MODE(reg)                                        \
    "adr    "#reg", 1f + 1;"                                        \
    "bx     "#reg";"                                                \
    "1:     ;"                                                      \
    ".thumb ;"

# define HAL_ARM_THUMB_REG(reg)                                     \
    ""#reg""
#else

# define HAL_ARM_MODE(reg)      ";"
# define HAL_THUMB_MODE(reg)    ";"
# define HAL_ARM_THUMB_REG(reg)

# endif

#define HAL_CLEAN_FLASH_CACHE()                                     \
    do                                                              \
    {                                                               \
        asm volatile (                                              \
            HAL_ARM_MODE(r0)                                        \
            "mov r0, #0;"                                           \
            "mcr p15, 0, r0, c7, c14, 0;"                           \
            "mcr p15, 0, r0, c7, c5, 0;"                            \
            "mcr p15, 0, r0, c7, c15, 0;"                           \
            "mcr p15, 0, r0, c7, c10, 4;"                           \
            HAL_THUMB_MODE(r0)                                      \
            :                                                       \
            :                                                       \
            :"r0"                                                   \
        );                                                          \
    }while(0)

#elif defined (__ARMCC_VERSION)

#define HAL_CLEAN_FLASH_CACHE()                                     \
    do                                                              \
    {                                                               \
        asm {                                                       \
            mov ip,  0;                                             \
            mcr p15, 0, ip, c7, c14, 0;                             \
            mcr p15, 0, ip, c7, c5, 0;                              \
            mcr p15, 0, ip, c7, c15, 0;                             \
            mcr p15, 0, ip, c7, c10, 4;                             \
        }                                                           \
    }while(0)
    
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    UINT32 cmmFileSize;
    CHAR   cmmFileBuffer[1];    /* cmmļ壬滹пռ */
}T_RamdumpCmmFileInfo;

typedef struct
{
    CHAR *cmmBuffer;                /* ɵĻֳָűĻַ */
    CHAR *configured_regions_info;  /* ųʼڴλ         */
    CHAR *parsed_regions_info;      /* 赼ڴλ       */
    CHAR *ramdump_file_info;        /* ŴݵļϢ       */
    CHAR *ioReadBuffer;             /* ݵĶַ         */
    CHAR *ioWriteBuffer;            /* ݵдַ         */
}T_RamDumpCfg;

typedef struct
{
    CHAR    fileName[DUMPFILENMAE_LEN]; /* ļ       */
    UINT32  baseAddr;                   /* ڴַ   */
    UINT32  size;                       /* С         */
} T_RamdumpFile;

typedef struct
{
    UINT32          fileNum;        /* ļ          */
    T_RamdumpFile   fileInfo[1];    /* ܻ  */
} T_RamdumpFileInfo;

typedef struct
{
   UINT32   start_addr;
   UINT32   end_addr;
   UINT32   map_start_addr;
   UINT32   copy_start_addr;
}T_RamdumpRegion;

typedef struct
{
   UINT32           region_num;
   T_RamdumpRegion  regions[1]; /* ܻ */
} T_RamdumpRegionInfo;

/**************************************************************************
* ֲԭ
**************************************************************************/
static VOID ramdump_main(VOID);
static VOID ramdump_transfer_data(VOID);
static VOID ramdump_create_cmm_file(VOID);
static VOID ramdump_save_file_info( const CHAR *name, UINT32 base_addr, UINT32 size );
static VOID ramdump_save_region_file_info( T_RamdumpRegionInfo *p_region_info, const CHAR *file_name );
static VOID IO_ReadData(UINT8 *buffer, UINT32 size);
static VOID IO_WriteData(UINT8 *buffer, UINT32 size);
static VOID ramdump_get_available_region( UINT32 memAddBegin, UINT32 end, UINT32 map_base, UINT32 copy_base,UINT32 memorybase );
static VOID ramdump_parse_region_info( UINT32 configured_region_base, UINT32 parsed_region_base );

/**************************************************************************
* ȫֳ/
**************************************************************************/
static struct cpu_regdump *Osa_ArmExceptDump = NULL;
static UINT8 Osa_ArmMode[6] =   /* ˳struc coreе˳һ£ܸ */
{
    0xdf,   /* SYS */
    0xd3,   /* SVC */
    0xd7,   /* ABT */
    0xdb,   /* UND */
    0xd2,   /* IRQ */
    0xd1,   /* FIQ */
}; 

static CHAR *Osa_BankRegsiter[3]    = {(CHAR *)"r13", (CHAR *)"r14", (CHAR *)"spsr"};
struct cpu_core Osa_CoreRegisters   = {0};
static T_RamDumpCfg  gOsa_Ramdump   = {0};  /* ramdumpϢ */

static T_RamdumpCmmFileInfo *g_cmm_file_info            = NULL;
static UINT32                g_cmm_file_max             = 0;
static T_RamdumpRegionInfo  *g_configured_regions_info  = NULL;
static UINT32                g_configured_regions_max   = 0;
static T_RamdumpRegionInfo  *g_parsed_regions_info      = NULL;
static UINT32                g_parsed_regions_max       = 0;
static T_RamdumpFileInfo    *g_ramdump_file_info        = NULL;
static UINT32                g_ramdump_file_max         = 0;
static T_zOss_RamdumpIoOpt  g_zRamdumpIoOpt = { zOss_RamdumpUsbInit,  zOss_RamdumpUsbReadData,
                                                zOss_RamdumpUsbWriteData, zOss_RamdumpUsbFinish};

/**************************************************************************
* ֲʵ
**************************************************************************/
/* Read CPSR register */
static inline UINT32 ARMV4T_READ_CPSR_REG(void)
{
    UINT32 control_reg = 0;

#ifdef __GNUC__
    asm volatile (
        HAL_ARM_MODE(r1)
        "MRS  %0, CPSR;"
        HAL_THUMB_MODE(r1)
        :"+r"(control_reg)
        :
        :HAL_ARM_THUMB_REG(r1)
    );
#elif defined (__ARMCC_VERSION)
    __asm {
        MRS  control_reg, CPSR
    }
#endif

    return control_reg;
}

/******************************************************************************
 * ƣ  ramdump_transfer_data
 *   PC๤߽нҪ
 * ˵  (IN):
 *                               pRamdkumpInfo:ļϢ
 *                              (OUT):
 *   ֵ
 * ˵
 *******************************************************************************/
static VOID ramdump_transfer_data()
{
    CHAR            *reqBuffer  = gOsa_Ramdump.ioReadBuffer;    /* Ϣ   */
    CHAR            *rspBuffer  = gOsa_Ramdump.ioWriteBuffer;   /* ӦϢ   */
    UINT32          rspDataLen  = 0;                            /* ӦϢ     */
    UINT32          *reqCmd     = NULL;
    UINT32          *rspCmd     = NULL;
    T_RamdumpFile   *fileInfo   = NULL;
    
    rspCmd      = (UINT32 *)rspBuffer;
    reqCmd      = (UINT32 *)reqBuffer;
    fileInfo    = g_ramdump_file_info->fileInfo;
    
    g_zRamdumpIoOpt.init();
    
    for(;;)
    {
        /* ͨѶڶ */
        g_zRamdumpIoOpt.read((UINT8 *)reqBuffer, CMD_BUFFER_LEN);
        
        switch (*reqCmd)
        {
        case DUMPFILE_LINK_REQ: /* ͬ */
            {
                T_DUMPFILE_LINK_RSP *rspMsg;
                *rspCmd = DUMPFILE_LINK_RSP;
                rspMsg = (T_DUMPFILE_LINK_RSP *)RAMDUMP_IO_DATA_BASE(rspBuffer);
                rspMsg->fileNum = g_ramdump_file_info->fileNum;
                rspDataLen = sizeof(*rspCmd) + sizeof(T_DUMPFILE_LINK_RSP);
                break;
            }
        case DUMPFILE_FILE_REQ: /* ȡļϢʼļ */
            {
                T_DUMPFILE_FILE_REQ *reqMsg;
                T_DUMPFILE_FILE_RSP *rspMsg;
                *rspCmd = DUMPFILE_FILE_RSP;
                reqMsg = (T_DUMPFILE_FILE_REQ *)RAMDUMP_IO_DATA_BASE(reqBuffer);
                rspMsg = (T_DUMPFILE_FILE_RSP *)RAMDUMP_IO_DATA_BASE(rspBuffer);
                
                /* жļǷȷ */
                if (reqMsg->fileNo < g_ramdump_file_info->fileNum)
                {
                    strcpy((char *)rspMsg->fileName, (char *)fileInfo[reqMsg->fileNo].fileName);
                    rspMsg->size = fileInfo[reqMsg->fileNo].size;
                    rspDataLen = sizeof(*rspCmd) + sizeof(T_DUMPFILE_FILE_RSP);
                }
                else
                {
                    *rspCmd = DUMPFILE_NO_FAIL;
                    rspDataLen = sizeof(*rspCmd);
                }
                
                break;
            }
        case DUMPFILE_READ_REQ: /* ȡļ */
            {
                T_DUMPFILE_READ_REQ *reqMsg;
                *rspCmd = DUMPFILE_READ_RSP;
                rspDataLen = sizeof(*rspCmd);
                reqMsg = (T_DUMPFILE_READ_REQ *)RAMDUMP_IO_DATA_BASE(reqBuffer);
                
                if (reqMsg->fileNo >= g_ramdump_file_info->fileNum)
                {
                    *rspCmd = DUMPFILE_LENGTH_FAIL;
                    break;
                }
                
                if (reqMsg->offset + reqMsg->length > fileInfo[reqMsg->fileNo].size)
                {
                    *rspCmd = DUMPFILE_NO_FAIL;
                    break;
                }
                
                g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
                g_zRamdumpIoOpt.write((UINT8 *)(fileInfo[reqMsg->fileNo].baseAddr + reqMsg->offset), reqMsg->length);
                continue;   /* ִһζ */
            }
        case DUMPFILE_END_REQ:  /*  */
            {
                *rspCmd = DUMPFILE_END_RSP;
                rspDataLen = sizeof(*rspCmd);
                g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
                g_zRamdumpIoOpt.finish();
                return;
            }
        default:    /* ָ */
            {
                *rspCmd = DUMPFILE_CMD_FAIL;
                rspDataLen = sizeof(*rspCmd);
                break;
            }
        }
        
        /* ͨѶд */
        g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
    }
}
/*******************************************************************************
 * ƣ ramdump_create_cmm_file
 *  ɻָջT32ű
 * ˵ (IN):
 *                             (OUT):
 *   ֵ
 * ˵
 ******************************************************************************/
static VOID ramdump_create_cmm_file(VOID )
{
    char    *cmmAddress = NULL;
    UINT32  *paddress   = NULL; 
    UINT32  length      = 0;
    UINT32  value       = 0;
    UINT32  control_reg = 0;
    int     i           = 0;
    int     j           = 0;
    
    cmmAddress = (char *)g_cmm_file_info->cmmFileBuffer;
    
    length = (UINT32)sprintf( cmmAddress, "ENTRY &%s\r\n", RAMDUMP_DIR_NAME );
    cmmAddress += length;
    
    if(Osa_ArmExceptDump != NULL)
    {
        value = Osa_ArmExceptDump->pc;
    }
    else
    {
        value = Osa_CoreRegisters.supervisor.lr;
    }
    length = (UINT32)sprintf(cmmAddress, "r.s pc %#lx\r\n", value);
    cmmAddress += length;
    
    /* лsvcģʽԭr0-r12 */
    length = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", (UINT32)Osa_ArmMode[0]);
    cmmAddress += length;
    
    for(i = 0; i < 13; i++)
    {
        length = (UINT32)sprintf(cmmAddress, "r.s r%d %#lx\r\n", i, Osa_CoreRegisters.r[i]);
        cmmAddress += length;
    }
    
    paddress = (UINT32 *)(&Osa_CoreRegisters.user.sp);
    /* fiq֮ģʽݼĴ */
    for(i = 0; i < 5; i++)
    {
        length = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", (UINT32)Osa_ArmMode[i]);
        cmmAddress += length;
        for(j = 0; j < 3; j++)
        {
            length = (UINT32)sprintf(cmmAddress, "r.s %s %#lx\r\n", Osa_BankRegsiter[j], *paddress);
            cmmAddress += length;
            paddress++; 
        }
    }
    
    /* FIQ r8-r14 */
    length = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", (UINT32)Osa_ArmMode[5]);
    cmmAddress += length;
    for(i = 8; i < 15; i++)
    {
        length = (UINT32)sprintf(cmmAddress, "r.s r%d %#lx\r\n", i, *paddress);
        cmmAddress += length;
        paddress++;
    }
    /* FIQ spsr */
    length = (UINT32)sprintf(cmmAddress, "r.s spsr %#lx\r\n", *paddress);
    cmmAddress += length;
    
    /* cpsr */
    if(Osa_ArmExceptDump != NULL)
    {
        switch(Osa_ArmExceptDump->vector)
        {
        case 0x04:  /* undefined instruction */
            {
                value = Osa_CoreRegisters.undefined.psr;
                break;
            }
        case 0x0C:  /* prefetch abort */
            {
                value = Osa_CoreRegisters.abort.psr;
                break;
            }
        case 0x10:  /* data abort */
            {
                value = Osa_CoreRegisters.abort.psr;
                break;
            }
        case 0x18:  /* IRQ */
            {
                value = Osa_CoreRegisters.irq.psr;
                break;
            }
        case 0x1C:  /* FIQ */
            {
                value = Osa_CoreRegisters.fiq.psr;
                break;
            }
        default:
            {
                break;
            }
        }
    }
    else
    {
        value = ARMV4T_READ_CPSR_REG();
    }
    length = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", value);
    cmmAddress += length;
    
    control_reg = cp15_readControlRegister();
    /* ֹMMU */   
    length = (UINT32)sprintf(cmmAddress, "per.s c15:0x1 %%long %#lx\r\n", (control_reg & 0xfffffffe));  
    cmmAddress += length;
    
    /* ramdump ڴļ */
    for ( i = 0; i < (int)g_parsed_regions_info->region_num; i++)
    {   
        length = (UINT32)sprintf(cmmAddress, "data.load.binary &%s\\%s_%d %#lx--%#lx /noclear\r\n",RAMDUMP_DIR_NAME, RAM_ARM0_NAME,i,
                                 g_parsed_regions_info->regions[i].start_addr ,g_parsed_regions_info->regions[i].end_addr);
        cmmAddress += length;
    }
    /* cp15 c1 MMUƼĴ */
    control_reg = cp15_readControlRegister();
    length = (UINT32)sprintf(cmmAddress, "per.s c15:0x1 %%long %#lx\r\n", control_reg);
    cmmAddress += length;
    
    /* cp15 c2 MMUҳĴ */
    control_reg = cp15_readTTB();
    length = (UINT32)sprintf(cmmAddress, "per.s c15:0x2 %%long %#lx\r\n", control_reg);
    cmmAddress += length;
    
    /* cp15 c3 MMUĴ */
    control_reg = cp15_readDomainRegister();
    length = (UINT32)sprintf(cmmAddress, "per.s c15:0x3 %%long %#lx\r\n", control_reg);
    cmmAddress += length;
    
    /*  */
    length = (UINT32)sprintf(cmmAddress, "ENDDO\r\n");
    cmmAddress += length;
    
    g_cmm_file_info->cmmFileSize = (UINT32)(cmmAddress - g_cmm_file_info->cmmFileBuffer);
    zOss_AssertExN( g_cmm_file_info->cmmFileSize <= g_cmm_file_max );
}

/**************************************************************************
 * ƣ  ramdump_get_available_region
 *   ĬõڴMMUڴݶԱȣ
                                 ɵڴ
 * ˵ (IN):  ڴʼַstartַend,ڴ
                                  ݵдַmemorybase
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_get_available_region( UINT32 memAddBegin, UINT32 end, UINT32 map_base, UINT32 copy_base,UINT32 memorybase )
{
    UINT32 region_start = 0;
    UINT32 region_end   = 0;
    UINT32 region_cnt   = 0;
    UINT32 *addr        = NULL;
    
    zOss_ASSERT( memAddBegin <= end );

    region_cnt = *(UINT32 *)memorybase; /* ڴĿ */
    zOss_AssertExN( region_cnt < g_parsed_regions_max );
    addr = (UINT32 *)memorybase + region_cnt * 4 + 1;   /* ַƫ */
    while ( zTos_MmuGetReadableRegion(memAddBegin, end, (cyg_uint32 *)&region_start, (cyg_uint32 *)&region_end) )
    {
        *addr++ = region_start;
        *addr++ = region_end;
        if(map_base != memAddBegin)
        {
           *addr++ = map_base  + region_start - memAddBegin;
        }
        else
        {
           *addr++ = map_base;
        }
        if(copy_base != 0)
        {
            *addr++ = copy_base + region_start - memAddBegin;
        }
        else
        {
            *addr++ = 0;
        }
        region_cnt ++;
 
        memAddBegin = region_end + 1;
        if (memAddBegin < region_end) break;
    }
    *(UINT32 *)memorybase = region_cnt;
}

/**************************************************************************
 * ƣ ramdump_parse_region_info
 * ڴļ
 * ˵ (IN): Ĭõַɵַ
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_parse_region_info( UINT32 configured_region_base, UINT32 parsed_region_base )
{   
    UINT32 i = 0;
    T_RamdumpRegionInfo *p_configured_info = NULL;
    T_RamdumpRegionInfo *p_parsed_info     = NULL;

    p_configured_info = (T_RamdumpRegionInfo *)configured_region_base;
    p_parsed_info     = (T_RamdumpRegionInfo *)parsed_region_base;
    
    for ( ; i < p_configured_info->region_num; i++ )
    {
        ramdump_get_available_region( p_configured_info->regions[i].start_addr,
                                      p_configured_info->regions[i].end_addr,
                                      p_configured_info->regions[i].map_start_addr,
                                      p_configured_info->regions[i].copy_start_addr,
                                      (UINT32)p_parsed_info );
    }
}

/**************************************************************************
 * ƣ ramdump_save_file_info
 * ļϢ߶ڴ
 * ˵ (IN):
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_save_file_info( const CHAR *name, UINT32 base_addr, UINT32 size )
{
    T_RamdumpFile *pfileInfo = NULL;
    
    pfileInfo = g_ramdump_file_info->fileInfo + g_ramdump_file_info->fileNum;
    strcpy( (char *)pfileInfo->fileName, name );
    pfileInfo->baseAddr = base_addr;
    pfileInfo->size     = size;
    
    g_ramdump_file_info->fileNum ++;
    zOss_AssertExN( g_ramdump_file_info->fileNum <  g_ramdump_file_max); 
}

/**************************************************************************
 * ƣ ramdump_save_region_file_info
 * ڴ鵼ļ
 * ˵ (IN):
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_save_region_file_info( T_RamdumpRegionInfo *p_region_info, const CHAR *file_name )
{
    int     i           = 0;
    CHAR    name[32]    = {0};
    
    for ( i=0; i<(int)p_region_info->region_num; i++ )
    {
        sprintf( name, "%s_%d", file_name, i );
        ramdump_save_file_info(name, 
                               p_region_info->regions[i].start_addr,
                               (p_region_info->regions[i].end_addr - p_region_info->regions[i].start_addr) + 1 );
    }
}

/**************************************************************************
 * ƣ ramdump_save_all_files_info
 * ļ
 * ˵ (IN):
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_save_all_files_info( VOID )
{
    ramdump_save_region_file_info( g_parsed_regions_info, RAM_ARM0_NAME );
    ramdump_save_file_info( "arm0_targetstate.cmm", (UINT32)g_cmm_file_info->cmmFileBuffer, g_cmm_file_info->cmmFileSize);

#ifdef _USE_ARM1_RAMDUMP
    ramdump_save_region_file_info( (T_RamdumpRegionInfo *)HIGHMEM_ARM1_PARSED_REGION_BASE, RAM_ARM1_NAME );
    ramdump_save_file_info( "arm1_targetstate.cmm", CMM_FILE_BUF_BASE(HIGHMEM_ARM1_CMM_INFO_BASE), CMM_FILE_BUF_SIZE(HIGHMEM_ARM1_CMM_INFO_BASE) );
#endif
}

#ifdef _USE_ARM1_RAMDUMP
/**************************************************************************
 * ƣ ramdump_send_msg_to_arm1
 *  Arm0 ICP ϢIDͺ
 * ˵ (IN):
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_send_msg_to_arm1( VOID )
{
    T_HalIcp_Msg icp_msg;
    zOss_Memset(&icp_msg, 0, sizeof(icp_msg));
    
    icp_msg.SrcModId = ICP_ARM0_MODULE_ID_OS;
    icp_msg.desModId = ICP_ARM1_MODULE_ID_OS;
    icp_msg.IntInfo.high_word = ZPLAT_LTE_ICP_ARM02ARM1_RAMDUMP_CF;
    zDrvIcp_SendMsg( (const T_HalIcp_Msg *)&icp_msg );
}

/**************************************************************************
 * ƣ ramdump_process_msg_from_arm1
 *  Arm0 ICPϢܴ
 * ˵ (IN):
 *                             (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_process_msg_from_arm1( const T_HalIcp_Msg *pMsg )
{
    T_HalIcp_Dword state = { 0 };
   
    zDrvIcp_GetState( ICP_MSG_ACTOR_ARM, &state );
    zDrvIcp_ClearState( ICP_MSG_ACTOR_ARM, state );

    /* ʹarm0쳣Ա㿪ʼramdump */
    zOss_ASSERT( FALSE );
}
#endif

/*****************************************************************************
 * ƣ ramdump_main
 *  ִramdumpPC๤߽нҪ
 * ˵ (IN):
 *            (OUT):
 *   ֵ
 * ˵
 ****************************************************************************/
static VOID ramdump_main(VOID)
{
    /* MMUбڴνбȶԷ */
    ramdump_parse_region_info( (UINT32)g_configured_regions_info, (UINT32)g_parsed_regions_info);
    /* ɻָĴT32űļ */
    ramdump_create_cmm_file();

#ifdef _USE_ARM1_RAMDUMP
#ifdef _USE_PSM
    ARM0_WAIT_DDR1_READY;
#endif   
    ramdump_parse_region_info(HIGHMEM_ARM1_CONFIGURED_REGION_BASE, HIGHMEM_ARM1_PARSED_REGION_BASE);

    ARM0_NOFITY_ARM1;
    ARM0_WAIT_ARM1;
#endif   

    /* ִramdumpݴ */
    ramdump_save_all_files_info();

    /* USB,׼ */
    ramdump_transfer_data();
    return;
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
 * ƣ zte_sys_err_hnd
 *  Ramdump
 * ˵
 *   ֵ
 * ˵1,һ
 *           2excepNum1˵ramdumpֳ쳣
 **************************************************************************/
int  zte_sys_err_hnd(int  user_called, int  ecode, int extra)
{
    static UINT32   excepNum        = 0;
    UINT32          excepResetFlag  = 0;
    ZOSS_INTR       old_intr;
    /* ж */
    ZOSS_SAVE_IRQ(old_intr);
    excepNum++;
    if (excepNum > 1)   /* ֻһγֳ */
    {
        for ( ; ; ) ;
    }

    excepResetFlag = zOss_GetExceptResetFlag();
    if ( excepResetFlag != EXCEPT_RESET_ENABLE)
    {
        /* ĴϢ */
        zOss_RamdumpSaveRegisters();
        /* ִramdump쳣 */
        ramdump_main();
        for ( ; ; ) ;
    }
    else
    {
        halComm_Soft_Reset(RESET_TO_EXCEPTRESET);   /* 쳣 */
    }
    return 0;
}

/**************************************************************************
 * ƣ zOss_RamdumpConfigureMem
 *  ڴϢ
 * ˵ (IN):
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpConfigureMem( UINT32 base, UINT32 size ,UINT32 map_base ,UINT32 copy_base )
{
    if (size == 0)
        return;
    if ((size - 1) > (0xFFFFFFFF - base))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "Hello,ڴεַô,ѯʹ!");
        return;
    }
    zOss_AssertExN( g_configured_regions_info->region_num < g_configured_regions_max);
    g_configured_regions_info->regions[g_configured_regions_info->region_num].start_addr        = base;
    g_configured_regions_info->regions[g_configured_regions_info->region_num].end_addr          = base + size - 1;
    g_configured_regions_info->regions[g_configured_regions_info->region_num].map_start_addr    = map_base;
    g_configured_regions_info->regions[g_configured_regions_info->region_num].copy_start_addr   = copy_base;
    (g_configured_regions_info->region_num)++;
}
 
/**************************************************************************
 * ƣ  Osa_SysErrHndInit
 *  ַȫֱʼ,ȡramdumpڴĬ
                                  arm0arm1ͬ
 * ˵
 *   ֵ
 * ˵
 ***************************************************************************/
VOID Osa_SysErrHndInit(VOID)
{
    UINT32 base   = 0;
    UINT32 size   = 0;
    UINT32 map_base     = 0;
    UINT32 copy_base    = 0;
    /* ַȫֱʼ */
    zOss_Memset((char *)tos_ramdump_vma_start(), 0, tos_ramdump_vma_end() - tos_ramdump_vma_start());
    gOsa_Ramdump.cmmBuffer                = (CHAR *)tos_ramdump_vma_start();
    gOsa_Ramdump.configured_regions_info  = gOsa_Ramdump.cmmBuffer               + CMM_BUFFER_SIZE;
    gOsa_Ramdump.parsed_regions_info      = gOsa_Ramdump.configured_regions_info + CONFIGURED_REGIONS_SIZE;
    gOsa_Ramdump.ramdump_file_info        = gOsa_Ramdump.parsed_regions_info     + PARSED_REGIONS_SIZE + ERROR_CODE_SIZE;
    gOsa_Ramdump.ioReadBuffer             = gOsa_Ramdump.ramdump_file_info       + RAMDUMP_FILE_SIZE;
    gOsa_Ramdump.ioWriteBuffer            = gOsa_Ramdump.ioReadBuffer            + IO_READ_BUFFER;
    
    g_cmm_file_info = (T_RamdumpCmmFileInfo * )gOsa_Ramdump.cmmBuffer;
    g_cmm_file_info->cmmFileSize = 0;
    g_cmm_file_max  = (CMM_BUFFER_SIZE - 4);    /* 4ʾṹһԱĴСͬ */ 
    
    g_configured_regions_info= (T_RamdumpRegionInfo *)gOsa_Ramdump.configured_regions_info;
    g_configured_regions_info->region_num = 0;
    g_configured_regions_max = (CONFIGURED_REGIONS_SIZE - 4) / sizeof(T_RamdumpRegion);
    
    g_parsed_regions_info = (T_RamdumpRegionInfo *)gOsa_Ramdump.parsed_regions_info;
    g_parsed_regions_info->region_num = 0;
    g_parsed_regions_max = (PARSED_REGIONS_SIZE - 4) / sizeof(T_RamdumpRegion);
    
    g_ramdump_file_info  = (T_RamdumpFileInfo*)gOsa_Ramdump.ramdump_file_info;
    g_ramdump_file_info->fileNum = 0;
    g_ramdump_file_max = (RAMDUMP_FILE_SIZE - 4) / sizeof(T_RamdumpFile);
    
    /* ramdumpڴĬ,Ĭ˳ҪĶ */
    base        = tos_ram_vma_start();
    size        = tos_ram_vma_end() - tos_ram_vma_start();
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem(base, size, map_base, copy_base);
    
    base        = tos_itcm_vma_start();
    size        = ITCM_SIZE;
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem(base, size, map_base, copy_base);
    
    base        = tos_dtcm_vma_start();
    size        = DTCM_SIZE;
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem(base, size, map_base, copy_base);
    
#ifdef _USE_ARM1_RAMDUMP
    /* arm0arm1ͬ */
    *(volatile UINT32 *)HIGHMEM_ARM1_FLAG_ARM12ARM0_BASE = RAMDUMP_FLAG ;
    *(volatile UINT32 *)HIGHMEM_ARM1_FLAG_ARM02ARM1_BASE = 0;
    HAL_CLEAN_FLASH_CACHE();
    zDrvIcp_RegCallback( ICP_ARM0_MODULE_ID_OS, ICP_ARM1_MODULE_ID_OS, ramdump_process_msg_from_arm1, ICP_ISR_CALLBACK ); 
#endif
}

/**************************************************************************
 * ƣ zOss_RamdumpInit
 *  ICPصʼ
 * ˵ (IN): 
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpInit( VOID )
{
#ifdef _USE_ARM1_RAMDUMP
    zDrvIcp_RegCallback( ICP_ARM0_MODULE_ID_OS, ICP_ARM1_MODULE_ID_OS, ramdump_process_msg_from_arm1, ICP_ISR_CALLBACK );
#endif
}

/**************************************************************************
 * ƣ zOss_RamdumpForceException
 *  ǿƲ쳣,Աramdump
 * ˵ (IN): 0:ARM쳣 1: 쳣 2: ϵͳ쳣
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpForceException( UINT32 type )
{
    if ( 0 == type )
    {
        *(int *)0x05 = 0x00;
    }
    else
    {
        zOss_AssertExN( FALSE );
    }
}

/**************************************************************************
 * ƣ zOss_RamdumpSetIoOpt
 *  ramdump Io ͨ
 * ˵ (IN): 
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpSetIoOpt(T_zOss_RamdumpIoOpt hook)
{
    g_zRamdumpIoOpt.init    = hook.init;
    g_zRamdumpIoOpt.read    = hook.read;
    g_zRamdumpIoOpt.write   = hook.write;
    g_zRamdumpIoOpt.finish  = hook.finish;    
}

#ifdef __cplusplus
}
#endif

#else

#include "oss_api.h"

extern int __init ramdump_init(void);

VOID zOss_RamdumpInit(VOID)
{
    ramdump_init();
    //zDrvIcp_RegCallback( ICP_ARM0_MODULE_ID_OS, ICP_ARM1_MODULE_ID_OS, ramdump_process, ICP_ISR_CALLBACK );
}

#endif
