/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     linux_ramdump_user.c
* ļʶ:     linux_ramdump_user.c
* ժҪ:     linuxû̬ramdumpʵģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2015/1/28       V1.0        Create          Ծ          ½
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "oss_sup.h"
#include "sup_ramdump.h"
#include "linux_except_arm.h"
#include <linux/ptrace.h>

#ifdef __cplusplus
extern "C"
{
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
extern struct cpu_core Osa_CoreRegisters;

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
extern void linux_assert_failed(const char *exp, const char *file, const char *func, int line);
#ifdef CONFIG_MMU
extern char *ramdump_mmu_cp15(char *addr);
#else
extern char *ramdump_mpu_cp15(char *addr);
#endif

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define RAMDUMP_CMM_BUF_LEN         (4096)

#define RAMDUMP_REG_NR              (15)	/* R0-R14 */
#define RAMDUMP_FIQ_REG_START       (8)		/* R8     */
#define RAMDUMP_FIQ_REG_END         (13)	/* R12    */

#define RAMDUMP_IO_BUF_LEN          (1024)
#define RAMDUMP_IO_DATA(base)       ((UINT32)base + 4)

#define RAMDUMP_ARM_USR_MOD         (0xd0)

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
enum
{
    RAMDUMP_USER_REGION_CMM,
    RAMDUMP_USER_REGION_DATA,
    RAMDUMP_USER_REGION_BSS,
    RAMDUMP_USER_REGION_HEAP,
    RAMDUMP_USER_REGION_STACK,
    RAMDUMP_USER_REGION_ARGS,
    RAMDUMP_USER_REGION_ENV,
};

typedef struct
{
    const char      *name;
    unsigned long   addr;
    unsigned long   size;
} ramdump_user_region_t;

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static const unsigned int arm_sys_mode[] = 
{
    0xdf,   /* SYS */
    0xd3,   /* SVC */
    0xd7,   /* ABT */
    0xdb,   /* UND */
    0xd2,   /* IRQ */
    0xd1,   /* FIQ */
};

ramdump_user_region_t ramdump_user_region[] = 
{
    { "ramdump_user.cmm",   },
    { "ramdump_user.data",  },
    { "ramdump_user.bss",   },
    { "ramdump_user.heap",  },
    { "ramdump_user.stack", },
    { "ramdump_user.args",  },
    { "ramdump_user.env",   },
};

/* store user dump cmm */
static unsigned char user_dump_cmm_buf[RAMDUMP_CMM_BUF_LEN];

static T_zOss_RamdumpIoOpt  g_zRamdumpIoOpt = { zOss_RamdumpUsbInit,      zOss_RamdumpUsbReadData,
                                                zOss_RamdumpUsbWriteData, zOss_RamdumpUsbFinish};

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ȨĴ
* ˵:     
*   ()  mem:    ַ
*   ()  void
*   ֵ:     ȨĴĵַ
* ˵:     void
*******************************************************************************/
static unsigned char* ramdump_store_sys_regs(unsigned char *mem)
{
	unsigned int	*fiq_regs 		= NULL;
	CPU_REG_BANK	*ptr_mode_regs 	= NULL;
	unsigned int 	fiq_regs_nr 	= RAMDUMP_FIQ_REG_START;
	unsigned int 	arm_sys_mode_nr = 0;

	zOss_RamdumpSaveRegisters();

	//SYS/SVC/ABT/UND/IRQ
	ptr_mode_regs = (CPU_REG_BANK*)(&Osa_CoreRegisters.user);
	do {
		mem += sprintf(mem, "r.s cpsr 0x%x\n", (unsigned int)arm_sys_mode[arm_sys_mode_nr]);
		mem += sprintf(mem, "r.s r13 0x%x\n", (unsigned int)(ptr_mode_regs->sp));
		mem += sprintf(mem, "r.s r14 0x%x\n", (unsigned int)(ptr_mode_regs->lr));
		mem += sprintf(mem, "r.s spsr 0x%x\n", (unsigned int)(ptr_mode_regs->psr));
		ptr_mode_regs++;
		arm_sys_mode_nr++;
	} while (arm_sys_mode_nr < (ARRAY_SIZE(arm_sys_mode) - 1));

	//FIQ r8-r12
	mem += sprintf(mem, "r.s cpsr 0x%x\n", (unsigned int)arm_sys_mode[arm_sys_mode_nr]);
	fiq_regs = ((unsigned int*)&Osa_CoreRegisters.fiq_r8);
	do {
		mem += sprintf(mem, "r.s r%d 0x%x\n", fiq_regs_nr, *(fiq_regs));
		fiq_regs++;
		fiq_regs_nr++;
	} while (fiq_regs_nr < RAMDUMP_FIQ_REG_END);
	//FIQ r13-r14/cpsr
	ptr_mode_regs = &Osa_CoreRegisters.fiq;
	mem += sprintf(mem, "r.s r13 0x%x\n", (unsigned int)(ptr_mode_regs->sp));
	mem += sprintf(mem, "r.s r14 0x%x\n", (unsigned int)(ptr_mode_regs->lr));
	mem += sprintf(mem, "r.s spsr 0x%x\n", (unsigned int)(ptr_mode_regs->psr));

	return mem;
}

/*******************************************************************************
* :     ûĴ溯
* ˵:     
*   ()  mem:   洢ָ
*				regs:  ûĴṹָ
*   ()  void
*   ֵ:     ƶĻָ
* ˵:     void
*******************************************************************************/
static unsigned char* ramdump_store_user_regs(unsigned char *mem, struct pt_regs *regs)
{
    unsigned int  cnt;
    unsigned int *uregs = (unsigned int *)regs;

    mem += sprintf(mem, "r.s cpsr 0x%x\n", RAMDUMP_ARM_USR_MOD);
    for (cnt = 0x00; cnt < RAMDUMP_REG_NR; cnt++)
        mem += sprintf(mem, "r.s r%d 0x%x\n", cnt, *uregs++);
    mem += sprintf(mem, "r.s pc 0x%x\n", *uregs++);
    mem += sprintf(mem, "r.s cpsr 0x%x\n", *uregs++);

    return mem;
}

/*******************************************************************************
* :     CP15Ĵ
* ˵:     
*   ()  mem:    ַ
*   ()  void
*   ֵ:     CP15Ĵĵַ
* ˵:     void
*******************************************************************************/
static unsigned char* ramdump_store_cp15_regs(unsigned char *mem)
{
#ifdef CONFIG_MMU
	return ramdump_mmu_cp15(mem);
#else
	return ramdump_mpu_cp15(mem);
#endif
}

/*******************************************************************************
* :     ûݶ
* ˵:     
*   ()  mem:    ַ
*   ()  void
*   ֵ:     ûݶκĵַ
* ˵:     void
*******************************************************************************/
static unsigned char* ramdump_store_user_segments(unsigned char *mem)
{
	mem += sprintf(mem, "data.load.binary &ramdump_dir\\ramdump_user.data 0x%x--0x%x /noclear\n", 
				  (unsigned int)(current->mm->start_data), 
	    		  (unsigned int)(current->mm->end_data));
	mem += sprintf(mem, "data.load.binary &ramdump_dir\\ramdump_user.bss 0x%x--0x%x /noclear\n", 
				  (unsigned int)(current->mm->end_data), 
	    		  (unsigned int)(current->mm->start_brk));
	mem += sprintf(mem, "data.load.binary &ramdump_dir\\ramdump_user.heap 0x%x--0x%x /noclear\n", 
				  (unsigned int)(current->mm->start_brk), 
	    		  (unsigned int)(current->mm->start_stack));
	mem += sprintf(mem, "data.load.binary &ramdump_dir\\ramdump_user.stack 0x%x--0x%x /noclear\n", 
				  (unsigned int)(current->mm->start_stack), 
	    		  (unsigned int)(current->mm->arg_start));
	mem += sprintf(mem, "data.load.binary &ramdump_dir\\ramdump_user.args 0x%x--0x%x /noclear\n", 
				  (unsigned int)(current->mm->arg_start), 
	    		  (unsigned int)(current->mm->arg_end));
	mem += sprintf(mem, "data.load.binary &ramdump_dir\\ramdump_user.env 0x%x--0x%x /noclear\n", 
				  (unsigned int)(current->mm->env_start), 
	    		  (unsigned int)(current->mm->env_end));

	return mem;
}

/*******************************************************************************
* :     Ramdumpű
* ˵:     
*   ()  cmm_buf:    ű
				regs:       Ĵָ
*   ()  void
*   ֵ:     Ľűֽ
* ˵:     void
*******************************************************************************/
static unsigned int ramdump_create_cmmbuf(unsigned char *cmm_buf, struct pt_regs *regs)
{
	unsigned char *buf = cmm_buf;

	buf += sprintf(buf, "ENTRY &ramdump_dir\n");
	buf = ramdump_store_sys_regs(buf);
	buf = ramdump_store_user_regs(buf, regs);
	buf = ramdump_store_user_segments(buf);
	buf = ramdump_store_cp15_regs(buf);
	buf += sprintf(buf, "ENDDO\n");

    if ((unsigned int)(buf - cmm_buf) <= RAMDUMP_CMM_BUF_LEN)
        return (unsigned int)(buf - cmm_buf);
    else
        return RAMDUMP_CMM_BUF_LEN;
}

/*******************************************************************************
* :     ׼Ramdumpû
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     ݵZOSS_SUCCESSʾɹʾʧ
* ˵:     void
*******************************************************************************/
static UINT32 ramdump_prepare_user_data(void)
{
	if (current->mm != NULL)
    {
        ramdump_user_region[RAMDUMP_USER_REGION_CMM].addr = (unsigned char*)user_dump_cmm_buf;
        ramdump_user_region[RAMDUMP_USER_REGION_CMM].size = ramdump_create_cmmbuf(user_dump_cmm_buf, signal_pt_regs());

        ramdump_user_region[RAMDUMP_USER_REGION_DATA].addr = (unsigned char*)(current->mm->start_data);
        ramdump_user_region[RAMDUMP_USER_REGION_DATA].size = (current->mm->end_data) - (unsigned int)(current->mm->start_data);

		ramdump_user_region[RAMDUMP_USER_REGION_BSS].addr = (unsigned char*)(current->mm->end_data);
		ramdump_user_region[RAMDUMP_USER_REGION_BSS].size = (unsigned int)(current->mm->start_brk) - (unsigned int)(current->mm->end_data);

		ramdump_user_region[RAMDUMP_USER_REGION_HEAP].addr = (unsigned char*)(current->mm->start_brk);
		ramdump_user_region[RAMDUMP_USER_REGION_HEAP].size = (unsigned int)(current->mm->start_stack) - (unsigned int)(current->mm->start_brk);

		ramdump_user_region[RAMDUMP_USER_REGION_STACK].addr = (unsigned char*)(current->mm->start_stack);
		ramdump_user_region[RAMDUMP_USER_REGION_STACK].size = (unsigned int)(current->mm->arg_start) - (unsigned int)(current->mm->start_stack);

		ramdump_user_region[RAMDUMP_USER_REGION_ARGS].addr = (unsigned char*)(current->mm->arg_start);
		ramdump_user_region[RAMDUMP_USER_REGION_ARGS].size = (unsigned int)(current->mm->arg_end) - (unsigned int)(current->mm->arg_start);

		ramdump_user_region[RAMDUMP_USER_REGION_ENV].addr = (unsigned char*)(current->mm->env_start);
		ramdump_user_region[RAMDUMP_USER_REGION_ENV].size = (unsigned int)(current->mm->env_end) - (unsigned int)(current->mm->env_start);

		return ZOSS_SUCCESS;
	}
	else
		return ZOSS_ERROR;
}

/*******************************************************************************
* :     û
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void ramdump_transfer_user_data(void)
{
	char 			*read_buffer;
	char 			*write_buffer;
	unsigned int 	*read_cmd;
	unsigned int 	*write_cmd;
	unsigned int 	write_datalen = 0;

	g_zRamdumpIoOpt.init();

	read_buffer  = kmalloc(RAMDUMP_IO_BUF_LEN, GFP_KERNEL);
	write_buffer = kmalloc(RAMDUMP_IO_BUF_LEN, GFP_KERNEL);
	read_cmd     = (unsigned int *)read_buffer;
	write_cmd    = (unsigned int *)write_buffer;

	for (;;) {
		g_zRamdumpIoOpt.read((unsigned char*)read_buffer, ZOSS_RAMDUMP_CMD_BUFFER_LEN);
		switch (*read_cmd) {
		case ZOSS_RAMDUMP_FILE_LINK_REQ:
			{
				T_zOss_RamumpFileLinkRsp *writeLinkRsp = (T_zOss_RamumpFileLinkRsp *)(write_buffer + sizeof(*write_cmd));
				*write_cmd = ZOSS_RAMDUMP_FILE_LINK_RSP;
				writeLinkRsp->fileNum = ARRAY_SIZE(ramdump_user_region);
				write_datalen = sizeof(*write_cmd) + sizeof(T_zOss_RamumpFileLinkRsp);
				break;
			}

		case ZOSS_RAMDUMP_FILE_FILE_REQ:
			{
				T_zOss_RamdumpFileFileReq *readFileReq = (T_zOss_RamdumpFileFileReq *)RAMDUMP_IO_DATA(read_buffer);
				T_zOss_RamdumpFileFileRsp *writeFileRsp = (T_zOss_RamdumpFileFileRsp *)(write_buffer + sizeof(*write_cmd));
				*write_cmd = ZOSS_RAMDUMP_FILE_FILE_RSP;
				strcpy(writeFileRsp->fileName, ramdump_user_region[readFileReq->fileNo].name);
                writeFileRsp->size = ramdump_user_region[readFileReq->fileNo].size;
				write_datalen = sizeof(*write_cmd) + sizeof(T_zOss_RamdumpFileFileRsp);
				break;
			}

		case ZOSS_RAMDUMP_FILE_READ_REQ:
			{
				T_zOss_RamdumpFileReadReq *readFileReq = (T_zOss_RamdumpFileReadReq *)RAMDUMP_IO_DATA(read_buffer);
				*write_cmd = ZOSS_RAMDUMP_FILE_READ_RSP;
				g_zRamdumpIoOpt.write((UINT8 *)write_cmd, sizeof(*write_cmd));
                g_zRamdumpIoOpt.write((UINT8 *)(ramdump_user_region[readFileReq->fileNo].addr + readFileReq->offset), readFileReq->length);

				continue;
			}

		case ZOSS_RAMDUMP_FILE_END_REQ:
			{
				*write_cmd = ZOSS_RAMDUMP_FILE_END_RSP;
				g_zRamdumpIoOpt.write((UINT8 *)write_cmd, sizeof(*write_cmd));
				g_zRamdumpIoOpt.finish();
				kfree(read_buffer);
				kfree(write_buffer);
				return;
			}

		default:
			{
				*write_cmd = ZOSS_RAMDUMP_FILE_CMD_FAIL;
				write_datalen = sizeof(*write_cmd);
				break;
			}
		}
		g_zRamdumpIoOpt.write((UINT8 *)write_buffer, write_datalen);
	}
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     û̬Ramdump
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_ramdump_user(void)
{
    if (ramdump_prepare_user_data() == ZOSS_SUCCESS)
        ramdump_transfer_user_data();
}

#ifdef __cplusplus
}
#endif

