/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     linux_ramlog.c
* ļʶ:     linux_ramlog.c
* ժҪ:     linux֧Ųramlogʵģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/07/16      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include <stdarg.h>
#include "oss_api.h"
#include "linux_ramlog.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
extern char _ramlog_start[];
extern char _ramlog_end[];

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#ifdef LINUX_RAMLOG
# define RAMLOG_LOCK(flags)     local_irq_save(flags)
# define RAMLOG_UNLOCK(flags)   local_irq_restore(flags)
#endif

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef struct {
    char * const start;
    char * const end;
    char *ptr;
    int full;
} linux_ramlog_t;

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
#ifdef LINUX_RAMLOG
static linux_ramlog_t linux_ramlog = {
    _ramlog_start,
    _ramlog_end,
    _ramlog_start,
    0x00,
};
#endif

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramlogӡ
* ˵:     
*   ()  fmt:    ʽ
                ...:    ɱб
*   ()  void
*   ֵ:     Ѵӡַ
* ˵:     void
*******************************************************************************/
int linux_ramlog_printf(const char *fmt, ...)
{
#ifdef LINUX_RAMLOG
    int size;
    va_list ap;
    unsigned long flags;

    RAMLOG_LOCK(flags);
    va_start(ap, fmt);
    size = vsnprintf(linux_ramlog.ptr, (size_t)(_ramlog_end - linux_ramlog.ptr), fmt, ap);
    va_end(ap);
    linux_ramlog.ptr += size;
    if (linux_ramlog.ptr >= _ramlog_end)
    {
        linux_ramlog.ptr = _ramlog_start;
        linux_ramlog.full = 0x01;
    }
    RAMLOG_UNLOCK();

    return size;
#else
    return 0x00;
#endif
}

/*******************************************************************************
* :     ȡramlogʹϢ
* ˵:     
*   ()  void
*   ()  start:  ramlogʼַ
                end:    ramlogַ
*   ֵ:     void
* ˵:     full־λλʾramlog
*******************************************************************************/
void linux_ramlog_info(char **start, char **end)
{
#ifdef LINUX_RAMLOG
    unsigned long flags;

    if (start == NULL || end == NULL)
        return;

    RAMLOG_LOCK();
    *start = linux_ramlog.start;
    if (linux_ramlog.full)
        *end = linux_ramlog.end;
    else
        *end = linux_ramlog.ptr;
    RAMLOG_UNLOCK();
#endif
}

/**************************************************************************
* :     ṩramlogʹõĻϢϢ
* ˵:     
*   ()  void
*   ()  pMonRamlogInfo: ramlogϢŵַ             
*   ֵ:     void
* ˵:     
**************************************************************************/
VOID z0ss_GetRamlogInfo(T_ZOss_Mon_Ramlog *pMonRamlogInfo)
{
#ifdef _USE_MONITOR
    char *ramlogStart = NULL;
    char *ramlogEnd   = NULL;

    if (pMonRamlogInfo)
    {
        linux_ramlog_info(&ramlogStart, &ramlogEnd);
        pMonRamlogInfo->ramlog   = ramlogStart;
        pMonRamlogInfo->size     = (UINT32)(ramlogEnd - ramlogStart);
    }
#endif
}

#ifdef __cplusplus
}
#endif

