/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     linux_stat.c
* ļʶ:     linux_stat.c
* ժҪ:     linuxϵͳ֧Ųͳģʵ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/10/22      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "sup.h"
#include "linux_stat.h"
#include <linux/hrtimer.h>
#include <linux/tick.h>
#include <linux/sched.h>
#include <linux/jiffies.h>
#include <linux/spinlock.h>
#include <linux/mutex.h>
#include <linux/printk.h>
#include <linux/kernel.h>
#include <linux/kernel_stat.h>
#include <linux/hrtimer.h>

#ifdef __cplusplus
extern "C" 
{
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define LINUX_STAT_PERIOD_MIN   (10)    /* Unit: ms */

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/
static u64 linux_stat_get_cpu_idle_time(int cpu);
static u64 linux_stat_get_cpu_iowait_time(int cpu);
static void linux_stat_get_time(u64 *idle_time_ptr, u64 *total_time_ptr);
static enum hrtimer_restart linux_stat_hrtimer_function(struct hrtimer *hrtimer);

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static u64 linux_stat_idle_time;
static u64 linux_stat_total_time;
static u32 linux_stat_hrtimer_period;
static linux_stat_callback_t linux_stat_callback;
static struct hrtimer linux_stat_hrtimer_id;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ȡĿʱ
* ˵:     
*   ()  cpu:    
*   ()  void
*   ֵ:     ʱ
* ˵:     void
*******************************************************************************/
static u64 linux_stat_get_cpu_idle_time(int cpu)
{
    u64 idle_time = -1ULL;
    u64 real_idle_time;

    if (cpu_online(cpu))
        idle_time = get_cpu_idle_time_us(cpu, NULL);

    if (idle_time == -1ULL)
        real_idle_time = kcpustat_cpu(cpu).cpustat[CPUTIME_IDLE];
    else
        real_idle_time = usecs_to_cputime64(idle_time);

    return real_idle_time;
}

/*******************************************************************************
* :     ȡI/Oȴʱ
* ˵:     
*   ()  cpu:    
*   ()  void
*   ֵ:     I/Oȴʱ
* ˵:     void
*******************************************************************************/
static u64 linux_stat_get_cpu_iowait_time(int cpu)
{
    u64 iowait_time = -1ULL;
    u64 real_iowait_time;

    if (cpu_online(cpu))
        iowait_time = get_cpu_iowait_time_us(cpu, NULL);

    if (iowait_time == -1ULL)
        real_iowait_time = kcpustat_cpu(cpu).cpustat[CPUTIME_IOWAIT];
    else
        real_iowait_time = usecs_to_cputime64(iowait_time);

    return real_iowait_time;
}

/*******************************************************************************
* :     ȡϵͳʱ
* ˵:     
*   ()  idle_time_ptr:  ϵͳʱָ
                total_time_ptr: ϵͳʱָ
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
static void linux_stat_get_time(u64 *idle_time_ptr, u64 *total_time_ptr)
{
    int cpu;
    u64 idle_time   = 0x00;
    u64 total_time  = 0x00;

    zOss_ASSERT(idle_time_ptr != NULL);
    zOss_ASSERT(total_time_ptr != NULL);

	for_each_possible_cpu(cpu) {
		total_time  += kcpustat_cpu(cpu).cpustat[CPUTIME_USER];
		total_time  += kcpustat_cpu(cpu).cpustat[CPUTIME_NICE];
		total_time  += kcpustat_cpu(cpu).cpustat[CPUTIME_SYSTEM];
        idle_time   += linux_stat_get_cpu_idle_time(cpu);
		total_time  += linux_stat_get_cpu_idle_time(cpu);
		total_time  += linux_stat_get_cpu_iowait_time(cpu);
		total_time  += kcpustat_cpu(cpu).cpustat[CPUTIME_IRQ];
		total_time  += kcpustat_cpu(cpu).cpustat[CPUTIME_SOFTIRQ];
		total_time  += kcpustat_cpu(cpu).cpustat[CPUTIME_STEAL];
	}

    *idle_time_ptr  = idle_time;
    *total_time_ptr = total_time;
}

/*******************************************************************************
* :     ߷ֱʶʱص
* ˵:     
*   ()  hrtimer:    ߷ֱʶʱṹָ
*   ()  void
*   ֵ:     ǷҪʱ־
* ˵:     void
*******************************************************************************/
static enum hrtimer_restart linux_stat_hrtimer_function(struct hrtimer *hrtimer)
{
    static u64 idle_time, total_time;

    hrtimer_forward_now(&linux_stat_hrtimer_id, ms_to_ktime(linux_stat_hrtimer_period));

    linux_stat_get_time(&idle_time, &total_time);
    linux_stat_callback(cputime_to_usecs(idle_time  - linux_stat_idle_time),
                        cputime_to_usecs(total_time - linux_stat_total_time));
    linux_stat_get_time(&linux_stat_idle_time, &linux_stat_total_time);

    return HRTIMER_RESTART;
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ͳģע
* ˵:     
*   ()  period:     ʱڣλ: ms
                callback:   ʱص
*   ()  void
*   ֵ:     void
* ˵:     void
*******************************************************************************/
void linux_stat_register(u32 period, linux_stat_callback_t callback)
{
    zOss_ASSERT(period >= LINUX_STAT_PERIOD_MIN);
    zOss_ASSERT(callback != NULL);

    linux_stat_hrtimer_period   = period;
    linux_stat_callback         = callback;

    hrtimer_init(&linux_stat_hrtimer_id, CLOCK_MONOTONIC, HRTIMER_MODE_REL);
    linux_stat_hrtimer_id.function = linux_stat_hrtimer_function;
    linux_stat_get_time(&linux_stat_idle_time, &linux_stat_total_time);
    hrtimer_start(&linux_stat_hrtimer_id, ms_to_ktime(linux_stat_hrtimer_period), HRTIMER_MODE_REL);
}

#ifdef __cplusplus
}
#endif

