/*******************************************************************************
* Ȩ (C)2014, ͨѶɷ޹˾
* 
* ļ:     linux_stub.c
* ļʶ:     linux_stub.c
* ժҪ:     linux֧Ų׮ģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2014/07/18      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "oss_api.h"
#include "osa.h"
#include "drvs_icp.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                                                      *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define LINUX_THREAD_SLEEP_TIME                 10

#define LINUX_THREAD_NAME                       "linux_thread"
#define LINUX_THREAD_STACK_SIZE                 2048
#define LINUX_THREAD_PRIORITY                   29

#define LINUX_THREAD_SEMA_SENDER_NAME           "sema_sender"
#define LINUX_THREAD_SEMA_SENDER_STACK_SIZE     2048
#define LINUX_THREAD_SEMA_SENDER_PRIORITY       31

#define LINUX_THREAD_SEMA_RECEIVER_NAME         "sema_receiver"
#define LINUX_THREAD_SEMA_RECEIVER_STACK_SIZE   2048
#define LINUX_THREAD_SEMA_RECEIVER_PRIORITY     30

#define LINUX_THREAD_MSG_SENDER_NAME            "msg_sender"
#define LINUX_THREAD_MSG_SENDER_STACK_SIZE      2048
#define LINUX_THREAD_MSG_SENDER_PRIORITY        30
#define LINUX_THREAD_MSG_SENDER_X_SIZE          11
#define LINUX_THREAD_MSG_SENDER_Y_SIZE          22

#define LINUX_THREAD_MSG_RECEIVER_NAME          "msg_receiver"
#define LINUX_THREAD_MSG_RECEIVER_STACK_SIZE    2048
#define LINUX_THREAD_MSG_RECEIVER_PRIORITY      31
#define LINUX_THREAD_MSG_RECEIVER_SIZE          33

#define LINUX_THREAD_MUTEX_X_NAME               "mutex_x"
#define LINUX_THREAD_MUTEX_X_STACK_SIZE         2048
#define LINUX_THREAD_MUTEX_X_PRIORITY           30

#define LINUX_THREAD_MUTEX_Y_NAME               "mutex_y"
#define LINUX_THREAD_MUTEX_Y_STACK_SIZE         2048
#define LINUX_THREAD_MUTEX_Y_PRIORITY           31

#define LINUX_TIMER_LENGTH                      1000

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/

/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/
static ZOSS_THREAD_ID linux_thread;

static ZOSS_THREAD_ID linux_thread_sema_sender;
static ZOSS_THREAD_ID linux_thread_sema_receiver;
static ZOSS_SEMAPHORE_ID linux_sema_sender;
static ZOSS_SEMAPHORE_ID linux_sema_receiver;

static ZOSS_THREAD_ID linux_thread_msg_sender_x;
static ZOSS_THREAD_ID linux_thread_msg_sender_y;
static ZOSS_THREAD_ID linux_thread_msg_receiver;

static ZOSS_THREAD_ID linux_thread_mutex_x;
static ZOSS_THREAD_ID linux_thread_mutex_y;
static ZOSS_MUTEX_ID linux_mutex;

static ZOSS_TIMER_ID linux_timer_id;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/

static VOID linux_thread_entry(SINT32 arg)
{
    for (;;) {
        printk("linux_thread is running\n");
        zOss_Sleep(LINUX_THREAD_SLEEP_TIME);
    }
}

static VOID linux_thread_sema_sender_entry(SINT32 arg)
{
    for (;;) {
        printk("sema_sender is running part1\n");
        zOss_PutSemaphore(linux_sema_sender);
        printk("sema_sender is running part2\n");
        zOss_GetSemaphore(linux_sema_receiver, ZOSS_WAIT_FOREVER);
    }
}

static VOID linux_thread_sema_receiver_entry(SINT32 arg)
{
    for (;;) {
        zOss_GetSemaphore(linux_sema_sender, ZOSS_WAIT_FOREVER);
        printk("sema_receiver is running part1\n");
        zOss_PutSemaphore(linux_sema_receiver);
        printk("sema_receiver is running part2\n");
    }
}

static VOID linux_thread_msg_sender_entry(SINT32 arg)
{
    void *msg_ptr;
    UINT32 msg_size;
    const size_t size = (size_t)arg;

    for (;;) {
        if (linux_thread_msg_receiver == NULL) {
            zOss_Sleep(LINUX_THREAD_SLEEP_TIME);
            continue;
        }

        msg_ptr = kmalloc(size, GFP_ATOMIC);
        zOss_ASSERT(msg_ptr != NULL);
        //printk("%s send start!\n", zOss_GetThreadName(zOss_GetCurThreadID(), NULL));
        zOss_SendMsg(linux_thread_msg_receiver, msg_ptr, size, ZOSS_WAIT_FOREVER);
        //printk("%s send end!\n", zOss_GetThreadName(zOss_GetCurThreadID(), NULL));
        zOss_Sleep(LINUX_THREAD_SLEEP_TIME);

        printk("%s receive start!\n", zOss_GetThreadName(zOss_GetCurThreadID(), NULL));
        zOss_RecvMsg(&msg_ptr, &msg_size, ZOSS_WAIT_FOREVER);
        printk("%s receive end! msg_size:%u\n", zOss_GetThreadName(zOss_GetCurThreadID(), NULL), (unsigned int)msg_size);
        kfree(msg_ptr);
    }
}

static VOID linux_thread_msg_receiver_entry(SINT32 arg)
{
    void *msg_ptr;
    UINT32 msg_size;

    for (;;) {
        printk("msg_receiver receive start!\n");
        zOss_RecvMsg(&msg_ptr, &msg_size, ZOSS_WAIT_FOREVER);
        printk("msg_receiver receive end! msg_size:%u\n", (unsigned int)msg_size);
        kfree(msg_ptr);

        msg_ptr = kmalloc(LINUX_THREAD_MSG_RECEIVER_SIZE, GFP_ATOMIC);
        zOss_ASSERT(msg_ptr != NULL);
        //printk("msg_receiver send to sender_x start!\n");
        zOss_SendMsg(linux_thread_msg_sender_x, msg_ptr, LINUX_THREAD_MSG_RECEIVER_SIZE, ZOSS_WAIT_FOREVER);
        //printk("msg_receiver send to sender_x end!\n");
        zOss_Sleep(LINUX_THREAD_SLEEP_TIME);

        msg_ptr = kmalloc(LINUX_THREAD_MSG_RECEIVER_SIZE, GFP_ATOMIC);
        zOss_ASSERT(msg_ptr != NULL);
        //printk("msg_receiver send to sender_y start!\n");
        zOss_SendMsg(linux_thread_msg_sender_y, msg_ptr, LINUX_THREAD_MSG_RECEIVER_SIZE, ZOSS_WAIT_FOREVER);
        //printk("msg_receiver send to sender_y end!\n");
        zOss_Sleep(LINUX_THREAD_SLEEP_TIME);
    }
}

static VOID linux_thread_mutex_x_entry(SINT32 arg)
{
    for (;;) {
        zOss_GetMutex(linux_mutex, ZOSS_WAIT_FOREVER);
        zOss_GetMutex(linux_mutex, ZOSS_WAIT_FOREVER);
        printk("mutex_x is running\n");
        zOss_PutMutex(linux_mutex);
        zOss_PutMutex(linux_mutex);
        zOss_Sleep(LINUX_THREAD_SLEEP_TIME);
    }
}

static VOID linux_thread_mutex_y_entry(SINT32 arg)
{
    for (;;) {
        zOss_GetMutex(linux_mutex, ZOSS_WAIT_FOREVER);
        zOss_GetMutex(linux_mutex, ZOSS_WAIT_FOREVER);
        printk("mutex_y is running\n");
        zOss_PutMutex(linux_mutex);
        zOss_PutMutex(linux_mutex);
        zOss_Sleep(LINUX_THREAD_SLEEP_TIME);
    }
}

static VOID linux_timer_callback(SINT32 arg)
{
    printk("linux_timer is running\n");
}

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/
void linux_wbt_sema_init(void)
{
    linux_sema_sender = zOss_CreateSemaphore(NULL, 0);
    linux_sema_receiver = zOss_CreateSemaphore(NULL, 0);

    linux_thread_sema_receiver = 
        zOss_CreateThread(LINUX_THREAD_SEMA_RECEIVER_NAME,
                          linux_thread_sema_receiver_entry,
                          0x00,
                          LINUX_THREAD_SEMA_RECEIVER_STACK_SIZE,
                          LINUX_THREAD_SEMA_RECEIVER_PRIORITY,
                          true,
                          true);

    linux_thread_sema_sender = 
        zOss_CreateThread(LINUX_THREAD_SEMA_SENDER_NAME,
                          linux_thread_sema_sender_entry,
                          0x00,
                          LINUX_THREAD_SEMA_SENDER_STACK_SIZE,
                          LINUX_THREAD_SEMA_SENDER_PRIORITY,
                          true,
                          true);
}

void linux_wbt_msg_init(void)
{
    linux_thread_msg_sender_x = 
        zOss_CreateThread(LINUX_THREAD_MSG_SENDER_NAME"_x",
                          linux_thread_msg_sender_entry,
                          LINUX_THREAD_MSG_SENDER_X_SIZE,
                          LINUX_THREAD_MSG_SENDER_STACK_SIZE,
                          LINUX_THREAD_MSG_SENDER_PRIORITY,
                          true,
                          true);

    linux_thread_msg_receiver = 
        zOss_CreateThread(LINUX_THREAD_MSG_RECEIVER_NAME,
                          linux_thread_msg_receiver_entry,
                          0x00,
                          LINUX_THREAD_MSG_RECEIVER_STACK_SIZE,
                          LINUX_THREAD_MSG_RECEIVER_PRIORITY,
                          true,
                          true);

    linux_thread_msg_sender_y = 
        zOss_CreateThread(LINUX_THREAD_MSG_SENDER_NAME"_y",
                          linux_thread_msg_sender_entry,
                          LINUX_THREAD_MSG_SENDER_Y_SIZE,
                          LINUX_THREAD_MSG_SENDER_STACK_SIZE,
                          LINUX_THREAD_MSG_SENDER_PRIORITY,
                          true,
                          true);
}

void linux_wbt_mutex_init(void)
{
    linux_mutex = zOss_CreateMutex("linux_mutex", ZOSS_INHERIT);

    linux_thread_mutex_x = 
        zOss_CreateThread(LINUX_THREAD_MUTEX_X_NAME,
                          linux_thread_mutex_x_entry,
                          0x00,
                          LINUX_THREAD_MUTEX_X_STACK_SIZE,
                          LINUX_THREAD_MUTEX_X_PRIORITY,
                          true,
                          true);

    linux_thread_mutex_y = 
        zOss_CreateThread(LINUX_THREAD_MUTEX_Y_NAME,
                          linux_thread_mutex_y_entry,
                          0x00,
                          LINUX_THREAD_MUTEX_Y_STACK_SIZE,
                          LINUX_THREAD_MUTEX_Y_PRIORITY,
                          true,
                          true);
}

void linux_wbt_thread_init(void)
{
    linux_thread = 
        zOss_CreateThread(LINUX_THREAD_NAME,
                          linux_thread_entry,
                          0x00,
                          LINUX_THREAD_STACK_SIZE,
                          LINUX_THREAD_PRIORITY,
                          true,
                          true);
}

void linux_wbt_timer_init(void)
{
    linux_timer_id = zOss_CreateTimer("timer", linux_timer_callback, 0x00, TRUE);
    zOss_StartTimer(linux_timer_id, LINUX_TIMER_LENGTH, linux_timer_callback, 0x00);
}

void linux_stub_init(void)
{
    linux_wbt_mutex_init();

    linux_wbt_timer_init();

    linux_wbt_msg_init();

    linux_wbt_thread_init();

    linux_wbt_sema_init();
}

#ifndef _USE_RAMDUMP

VOID Osa_SysErrHndInit(VOID)
{

}

VOID ramdump_process(const T_HalIcp_Msg *pMsg)
{
   // T_HalIcp_Dword state = { 0 };
   
   // zDrvIcp_GetState( ICP_MSG_ACTOR_ARM, &state );
   // zDrvIcp_ClearState( ICP_MSG_ACTOR_ARM, state );

    /* ʹarm0쳣Ա㿪ʼramdump */
    zOss_ASSERT( FALSE );
}

VOID zOss_RamdumpForceException(UINT32 type)
{       

}

VOID zOss_RamdumpConfigureMem(UINT32 base, UINT32 size, UINT32 map_base, UINT32 copy_base)
{

}

#endif

#ifdef __cplusplus
}
#endif

