/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : ose_except_arm.c
*    : ose_except_arm.c
* ļ : 
* ʵֹ : 
*      : olli
*      : V1.0
*  : 2005/31/05
* ˵ : 
*            @(#) $FilePath: /vobs/ose5/system/refsys/common/sys_err_hnd.c
*            @(#) $FileRevision: /main/tb_current_ose5/36  $
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "ose_typedef.h"
#include "oss_api.h"
#include "sysparam.h"
#include "cpu_intlock.h"
#include "comm_api.h"
#include "hal_comm.h"
#include "cpu_hal_arch.h"
#include "efmi.h"
#include "hfmi.h"
#include "ramlog.h"
#include "osa_ramdump.h"
#include "ose_err/ose_err.h"
#include "ose_err/efs_err.h"
#include "ose_err/heap_err.h"
#include "ose_spi/exception.h"
#include "sys_func_atcfg.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/

#ifdef _USE_OPOA
/*mmuʹڴĻַͿʱpageĿ*/
#define MMU_PAGE_SIZE           4096
#define ALIGN_NEXT(size,align)  (((UINT32)(size)+align-1)&(~(align-1)))
#define CP15_CONTROL_REG_V      0x2000  /* Exception vectors low(0) or high(1). */
#define CP15_FAULT_REG_PAGE     0x7     /* ҳĵַ任ʧЧ                 */

/*ֵҪʵȷ*/
#define MMU_FISRT_DESCRIPTION(pageBase) (((UINT32)pageBase&(~0x3ffUL))+0x11)
#define MMU_SECOND_DESCRIPTOR(phyBase)  (((UINT32)phyBase&(~0xFFFUL))+0x55e)   /* 0x55e=0b010101011110 */
#define  LOCK_ENABLE(old_lockstate)     ((old_lockstate)=LOCK_ENABLE_())

#endif
/*OSE MMUö(1M)Сҳ(4K)*/ 
#define MMU_FIRST_INDEX(virtualAddress)     ((UINT32)virtualAddress >> 20)              /* ȡbit31-20   */
#define MMU_SECOND_INDEX(virtualAddress)    (((UINT32)virtualAddress & 0xff000) >> 12)  /* ȡbit19-12   */

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    const CHAR  *expr;
    const CHAR  *file;
    UINT32      line;
} T_ZOss_Except_Info;

#ifdef _USE_OPOA
typedef struct tig_NODE         /* Node of a linked list. */
{
    struct tig_NODE *next;              /* Points at the next node in the list      */
    struct tig_NODE *previous;          /* Points at the previous node in the list  */
    UINT32          *secondPageBase;    /* ȶСҳַ                     */
    UINT32          secondPageOffset;   /* Сҳеƫ,Ӧַ        */
    UINT32          phyAddress;         /* ҳӦַ                       */
    UINT32          logicAddress;       /* ҳӦ߼ַ                       */
}T_Mmu_Node;

/* Header for a linked list. */
typedef struct             
{
    SINT32      count;                  /* Number of nodes in list  */
    T_Mmu_Node  *HEAD;
    T_Mmu_Node  *TAIL;
}T_Mmu_List;

typedef struct 
{
    UINT32              logic_sector_start;
    UINT32              physicAddress;
    ZOSS_SEMAPHORE_ID   semaphore_ptr;
}T_MMU_EXCEPT_MSG;
#endif
/**************************************************************************
* ȫֱ
**************************************************************************/ 
static struct cpu_regdump   *Osa_ArmExceptDump  = NULL;
struct cpu_core             Osa_CoreRegisters   = {0};
static UINT32               lcdBase             = 0;

#ifdef _USE_OPOA
static ZOSS_QUEUE_ID    g_mmuExceptQueueID  = 0;
static T_Mmu_List       g_mmuLruList        = {0};
static T_Mmu_Node       g_mmuLruNode[1000]  = {0};
UINT32                  Image_mmu_base      = 0;
UINT32                  Image_mmu_Limit     = 0;
UINT32                  mmu_secondPage_base = 0;
#endif
/************************************************************************** 
* ⲿ
**************************************************************************/   

/**************************************************************************  
* ⲿ
**************************************************************************/  
extern VOID zOss_SaveRegisters(VOID);
extern VOID ddLcd_DisplayError(UINT16 x, UINT16 y, CHAR *pBuf, CHAR *text, UINT16 len);
extern VOID sys_err_hnd_hook_install(OSADDRESS (*hook)(OSBOOLEAN, OSERRCODE, OSERRCODE));

#ifdef _USE_OPOA
extern SINT32 nand_Read(UINT32 dwStart, UINT32 dwLen, UINT8* to);
OSADDRESS zte_sys_err_hnd(OSBOOLEAN user_called, OSERRCODE ecode, OSERRCODE extra);
extern VOID zprefetch_exception(VOID);
extern VOID zdata_exception(VOID);
extern VOID  zzRestoreArmExceptRegister(struct cpu_core * pCore, UINT32 exceptPc, UINT32 spsr);
#endif
/**************************************************************************
* ֲʵ
**************************************************************************/
#ifdef _USE_OPOA
/*Read mmu table register.*/
static inline UINT32 ARMV4T_READ_TABLE_REG(VOID)
{
    UINT32 control_reg = 0;
    __asm
    {
        mrc p15,0,control_reg,c2,c0,0;
    }
    
    return control_reg;
}

/*Read control register.*/
static inline UINT32 ARMV4T_READ_CONTROL_REG(VOID)
{
    UINT32 control_reg = 0;
    __asm
    {
        mrc p15,0,control_reg,c1,c0,0;
    }
    
    return control_reg;
}

static  inline UINT32 ARMV4T_READ_FAULTSTATUS_REG(VOID)
{
    UINT32 control_reg = 0;
    __asm
    {
        mrc p15,0,control_reg,c5,c0,0;
    }
    
    return control_reg;
}

static inline  UINT32 ARMV4T_READ_FAULTADDRESS_REG(VOID)
{
    UINT32 control_reg = 0;
    __asm
    {
        mrc p15,0,control_reg,c6,c0,0;
    }
    
    return control_reg;
}

/*
 * Requires following armv4t cp15 function.
 * To use all TLB flush opertaions is is a defensive but on this
 * costly operation we are willing to take this small extra cost.
 */
static inline VOID ARMV4T_INVALIDATE_TLB(VOID)
{
    UINT32 zero = 0;
    __asm
    {
        mcr  p15,0,(zero),c8,c7,0;
        mcr  p15,0,(zero),c8,c5,0;
        mcr  p15,0,(zero),c8,c6,0;
    }
}

static inline UINT32 LOCK_ENABLE_(VOID)
{ 
    register UINT32 old_lockstate = 0;
    register UINT32 new_lockstate = 0;
    __asm 
    {
        MRS old_lockstate, CPSR;
        BIC new_lockstate, old_lockstate,#(IRQ_DISABLE |FIQ_DISABLE);
        MSR CPSR_c, (new_lockstate) 
    }
    
    return old_lockstate;
}

/**************************************************************************
* : zOss_ListInit
* : ʼ˫
* ˵ 
            (IN)
                pList:ָ
            (OUT)
*   ֵ:  
**************************************************************************/ 
static VOID zMmu_ListInit(T_Mmu_List *pList)
{
    zOss_AssertExN(pList != NULL);
    pList->HEAD  = NULL;
    pList->TAIL  = NULL;
    pList->count = 0;
}

/**************************************************************************
* : zOss_ListFirst
* : ȡ׽ڵ
* ˵ 
            (IN)
               pList:ָ
            (OUT)
*   ֵ: ڵָ(ûнڵʱؿ)
**************************************************************************/ 
static  T_Mmu_Node *zMmu_ListFirst(T_Mmu_List *pList)
{
    zOss_AssertEx(pList != NULL, NULL);
    return (pList->HEAD);
}

/**************************************************************************
* : zOss_ListDelete
* : ƳָĽڵ
* ˵ 
            (IN)
                pList:ָ
                pNode:ɾڵָ
            (OUT)
*   ֵ:  
**************************************************************************/ 
static VOID zMmu_ListDelete(T_Mmu_List *pList, T_Mmu_Node *pNode)
{
    zOss_AssertExN(pList != NULL && pNode != NULL);
    if (pNode->previous == NULL)
    {
        pList->HEAD = pNode->next;
    }
    else
    {
        pNode->previous->next = pNode->next;
    }

    if (pNode->next == NULL)
    {
        pList->TAIL = pNode->previous;
    }
    else
    {
        pNode->next->previous = pNode->previous;
    }

    /* update node count */
    pList->count--;
}

/**************************************************************************
* : zOss_ListInsert
* : ָĽڵڵ
* ˵ 
            (IN)
                pList:ָ
                pPrev:ڵָ룬pPrevΪʱʾ뵽λ
                pNode:Ľڵָ
            (OUT)
*   ֵ:  
**************************************************************************/ 
static VOID zMmu_ListInsert (T_Mmu_List *pList, T_Mmu_Node *pPrev, T_Mmu_Node *pNode)
{
    T_Mmu_Node *pNext = NULL;

    zOss_AssertExN(pList != NULL && pNode != NULL);
    
    if (pPrev == NULL)
    {   /* new node is to be first in list */
        pNext = pList->HEAD;
        pList->HEAD = pNode;
    }
    else
    {   /* make prev node point fwd to new */
        pNext = pPrev->next;
        pPrev->next = pNode;
    }

    if (pNext == NULL)
    {
        pList->TAIL = pNode;    /* new node is to be last in list */
    }
    else
    {
        pNext->previous = pNode;    /* make next node point back to new */
    }

    /* set pointers in new node, and update node count */

    pNode->next     = pNext;
    pNode->previous = pPrev;

    pList->count++;
}

/**************************************************************************
* : zOss_ListAdd
* : βӽڵ
* ˵ 
            (IN)
                pList:ָ
                pNode:ӽڵָ
            (OUT)
*   ֵ:  
**************************************************************************/ 
static VOID zMmu_ListAdd (T_Mmu_List *pList, T_Mmu_Node *pNode)
{
    zMmu_ListInsert(pList, pList->TAIL, pNode);
}

/**************************************************************************
* ƣ mmuExceptThread
*  ȡflashڴ
* ˵ (IN):
                  
*            (OUT):
*   ֵ   
* ˵ 
**************************************************************************/
static VOID mmuExceptThread(SINT32 arg)
{
    T_MMU_EXCEPT_MSG    pMmuExceptMsg       = {0};
    UINT32              logic_sector_start  = 0;
    UINT32              physicAddress       = 0;
    ZOSS_SEMAPHORE_ID   semaphore_ptr       = NULL;
    
    for(;;)
    {
        zOss_QueueRecv(g_mmuExceptQueueID, &pMmuExceptMsg, sizeof(T_MMU_EXCEPT_MSG), ZOSS_WAIT_FOREVER);
        logic_sector_start  = pMmuExceptMsg.logic_sector_start;
        physicAddress       = pMmuExceptMsg.physicAddress;
        semaphore_ptr       = pMmuExceptMsg.semaphore_ptr;
        nand_Read(logic_sector_start, MMU_PAGE_SIZE, (unsigned char *)physicAddress); /* 8=4096/512 */
        zOss_PutSemaphore(semaphore_ptr);
    }
}
/**************************************************************************
* ƣ Osa_SysErrHndInit
*  ӹܲϵͳ쳣
* ˵ (IN):
                  
*            (OUT):
*   ֵ   
* ˵ 
**************************************************************************/
static VOID Osa_Mmu_Init(UINT32 pagenum, CHAR *PhysicalAddress)
{
    UINT32 phyAddress   = 0;
    UINT32 i            = 0;
    PROCESS Process_ID  = 0;
    
    /* ʼLRU */
    phyAddress = ALIGN_NEXT(PhysicalAddress, 0x1000);   /* 4kb  */
    zMmu_ListInit((T_Mmu_List *)&g_mmuLruList);
    
    for(i = 0; i < pagenum; i++)
    {
        g_mmuLruNode[i].phyAddress = phyAddress + i * 0x1000;
        
        zMmu_ListAdd(&g_mmuLruList, &g_mmuLruNode[i]);
    }
    g_mmuExceptQueueID  = zOss_QueueCreate("mmuExceptQueue", 100, sizeof(T_MMU_EXCEPT_MSG));
    Process_ID          = create_process(OS_PRI_PROC, 
                                        "mmuExceptThread",
                                        (OSENTRYPOINT *)mmuExceptThread, 
                                        4096,  
                                        5, 
                                        0,
                                        (PROCESS) 0, 
                                        (struct OS_redir_entry *) NULL, 
                                        (OSVECTOR) 0, 
                                        (OSUSER) 0);
    start(Process_ID);
}
/**************************************************************************
* ƣ arm_mmu_Address_map
*  Сҳشڴ棬߼ַMMUӳ
* ˵ (IN):
                  logicAddress:ӳ߼ַ
*            (OUT):
*   ֵ   
* ˵
**************************************************************************/
static  UINT32 arm_mmu_Address_map(UINT32 logicAddress)
{
    UINT32 adjustAddress    = 0;
    UINT32 *mmuSecondBase   = NULL;
    //UINT32 mmudescriptor    = 0;
    UINT32 mmuOffset        = 0;
    UINT32 physicAddress    = 0;
    UINT32 mask             = 0;
    
    T_MMU_EXCEPT_MSG    mmuExceptMsg = {0};
    ZOSS_SEMAPHORE_ID   mmuExceptSem = {0};
    T_Mmu_Node          *node        = NULL;

    adjustAddress   = logicAddress & (~0xFFFUL);   /* 4KB   */
    node            = (T_Mmu_Node *)zMmu_ListFirst(&g_mmuLruList);
    physicAddress   = node->phyAddress;
    if(node->secondPageBase != NULL)
    {
        node->secondPageBase[node->secondPageOffset] = 0;/* ʹûPAGEЧ  */
    }
    ARMV4T_INVALIDATE_TLB();
    mmuSecondBase           = (UINT32 *)(mmu_secondPage_base + ((adjustAddress-Image_mmu_base) / 0x100000) * 1024);    
    mmuOffset               = MMU_SECOND_INDEX(adjustAddress);
    
    zMmu_ListDelete(&g_mmuLruList, node);
    
    node->secondPageBase    = mmuSecondBase;
    node->secondPageOffset  = mmuOffset;
    node->phyAddress        = physicAddress;
    node->logicAddress      = adjustAddress;
    
    LOCK_ENABLE(mask); 
    
    mmuExceptMsg.logic_sector_start = adjustAddress;
    mmuExceptMsg.physicAddress      = physicAddress;
    /* ȡź */
    mmuExceptSem                = zOss_CreateSemaphore( "mmuExceptSem", 0);
    mmuExceptMsg.semaphore_ptr  = mmuExceptSem;
    
    zOss_QueueSend(g_mmuExceptQueueID, &mmuExceptMsg, sizeof(T_MMU_EXCEPT_MSG), ZOSS_NO_WAIT, ZOSS_QUEUE_MSG_PRI_NORMAL);
    zOss_GetSemaphore(mmuExceptSem,ZOSS_WAIT_FOREVER);  /* ȡɹʾ */
    zOss_DeleteSemaphore(mmuExceptSem);

    LOCK_RESTORE(mask);
    
    mmuSecondBase[mmuOffset] = MMU_SECOND_DESCRIPTOR(physicAddress);
    
    ARMV4T_INVALIDATE_TLB();
    zMmu_ListAdd(&g_mmuLruList, node);
    return 1;
    
}

/**************************************************************************
* ƣ armv4t_mmu_valid_fault
*  ʧЧĵַ
* ˵ (IN):
                 extra:
*            (OUT):
*   ֵ ʧЧַ0
* ˵ ʱ0
**************************************************************************/
static UINT32 armv4t_mmu_valid_fault(struct cpu_regdump *extra)
{
   UINT32 fault_status = 0;

   zOss_AssertEx(extra != NULL, 0);
    
   if(!extra->fault_data_set) 
   {
        return 0;
   }

   if(extra->fault_data_addr < (UINT32)Image_mmu_base || extra->fault_data_addr >= (UINT32)(Image_mmu_Limit - 1))
   {
        return 0;
   }
   if (extra->vector == 0x10)   /* ݷ쳣 */
    {        
        fault_status = ((struct cpu_core *)(extra->sect[0].address))->fault_status & 0xf;
        if (fault_status != CP15_FAULT_REG_PAGE)
        {
            return 0;    /* 쳣ַӳ    */
        }
        else
        {
            return extra->fault_data_addr;
        }
    }
   else if(extra->vector == 0xc)    /* Ԥȡָ쳣 */
   {
        return extra->fault_data_addr;
    }
   else
   {
        return 0;   /*  */
   }
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
* ƣ zzexception_c
*  ӹܲϵͳ쳣ڵǰ̻߳
* ˵ (IN):
                  
*            (OUT):
*   ֵ   
* ˵ 
**************************************************************************/
VOID zexception_c(SINT32 vector, UINT32 exceptPc, struct cpu_core * pCore)
{
    struct cpu_regdump  regDump         = {0};
    UINT32              cpsr            = 0;
    UINT32              faultAddress    = 0;
    UINT32              mask            = 0;
    UINT32              reg             = 0;

    zOss_AssertExN(pCore != NULL);

    if(vector == 0x0c)     /* Ԥȡָ쳣ʱ,c5 c6,оƬ   */
    {
        pCore->fault_status     = 0;
        regDump.fault_data_set  = 1;
        regDump.fault_data_addr = pCore->abort.lr;
    }
    else if(vector == 0x10)  /* ݷ쳣 */
    {
        reg                     = ARMV4T_READ_FAULTADDRESS_REG();
        regDump.fault_data_addr = reg;
        reg                     = ARMV4T_READ_FAULTSTATUS_REG();
        pCore->fault_status     = reg;
        reg                     |= 0x100;
        regDump.fault_data_set  = reg;
    }
    else
    {
        pCore->fault_status     = 0;
        regDump.fault_data_set  = 0;
        regDump.fault_data_addr = 0;
    }
    LOCK_ENABLE(mask); /* жϲ֮ǰ״̬ */
    
    regDump.pc      = exceptPc;
    cpsr            = pCore->user.psr;
    regDump.sr      = cpsr;
    regDump.vector  = (UINT32)vector;
    switch (cpsr & 0x1f)
    {
        case 0x13:  /* svrģʽ */
        {
            regDump.sp = pCore->supervisor.sp;
            break;
        }
        case 0x17:  /* abort */
        {
            regDump.sp = pCore->abort.sp;
            break;
        }
        case 0x1b:  /* undefined */
        {
            regDump.sp = pCore->undefined.sp;
            break;
        }
        case 0x1f:  /* system */
        case 0x10:   /* usr,systemʹͬĴ */
        {
            regDump.sp = pCore->user.sp;
            break;
        }
        case 0x11:   /* FIQ */
        {
            regDump.sp = pCore->fiq.sp;
            break;
        }
        case 0x12:  /* IRQ */
        {
            regDump.sp = pCore->irq.sp;
            break;
        }
        default:
        {
            regDump.sp = 0;
            break;
        }
    }

    regDump.magic               = 0x2daea;    /* magicֵ÷ */
    regDump.no_sects            = 1;
    regDump.sect[0].identity    = 0;
    regDump.sect[0].size        = sizeof(struct cpu_core);
    regDump.sect[0].address     = (UINT32)pCore;
    faultAddress                = armv4t_mmu_valid_fault(&regDump);
    
    LOCK_RESTORE(mask); /* maskֵָж״̬ */
    
    if(faultAddress)
    {
        arm_mmu_Address_map(faultAddress);
        zzRestoreArmExceptRegister(pCore, exceptPc, cpsr); /* ֱת쳣Ļ */
    }
    else    /* 쳣   */
    {
        zte_sys_err_hnd(0, OSE_EUNEXPECTED_EXCEPTION_REGDUMP, (UINT32)&regDump);
    }
}

/**************************************************************************
* : zOSS_MmuOpoa_Init
* : mmuİع
* ˵ 
            (IN)
    		     base:ַ
    		     size:С
            (OUT)
*   ֵ:  
**************************************************************************/ 
VOID zOSS_MmuOpoa_Init(UINT32 base, UINT32 size, UINT32 page_num, CHAR *mmu_map, CHAR *phybuf)
{
    UINT32 vectorType           = 0;
    UINT32 vectorBase           = 0;
    UINT32 phyaddress           = 0;
    Msr    old_msr              = 0;
    UINT32 LogicAddressBegin    = 0;
    UINT32 LogicAddressEnd      = 0;
    UINT32 LogicAddress         = 0;
    UINT32 *mmuFirstBase        = NULL;
    UINT32 mmuOffset            = 0; 

    if(page_num==0)
    {
        return;
    }
    Image_mmu_base      = base;
    Image_mmu_Limit     = size;
    mmu_secondPage_base = (UINT32)mmu_map;
    LOCK_SAVE(old_msr);
    hal_arch_cpu_descriptor->disable_mmu();
    mmuFirstBase        = (UINT32 *)ARMV4T_READ_TABLE_REG();
    vectorType          = ARMV4T_READ_CONTROL_REG() & CP15_CONTROL_REG_V;
    if(!vectorType)
    {
        vectorBase = 0;
    }
    else
    {
        vectorBase = 0xffff0000UL;
    }
    *(UINT32 *)(vectorBase + 0x2c) = (UINT32)zprefetch_exception;
    *(UINT32 *)(vectorBase + 0x30) = (UINT32)zdata_exception;

    LogicAddressBegin   = Image_mmu_base;
    LogicAddressEnd     = Image_mmu_Limit - 1;/* Image$$resouce$$Limitַڸ */
    phyaddress          = ALIGN_NEXT(mmu_secondPage_base, 0x400);
    for(LogicAddress = LogicAddressBegin; LogicAddress < LogicAddressEnd; LogicAddress += 0x100000)
    {
        mmuOffset               = MMU_FIRST_INDEX(LogicAddress);
        mmuFirstBase[mmuOffset] = MMU_FISRT_DESCRIPTION(phyaddress);/* g_next_small_pg_map_item_tbl_baseϵͳʼѾ1kb */
        phyaddress              += 0x400; /* Сҳ1kb */
    }
    hal_arch_cpu_descriptor->enable_mmu(1, 1, 0, 0, 0, (UINT32)mmuFirstBase);
    LOCK_RESTORE(old_msr);

    Osa_Mmu_Init(page_num,phybuf);
}
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣ Osa_GetSysPoolInfo
* ѯϵͳڴϢ
* ˵(IN)
*   ֵ
* ˵: 
**************************************************************************/
static UINT32 Osa_GetSysPoolInfo(VOID)
{
    EfmiStatus              rv          = EFMI_OK;
    struct EfmiPoolCursor   pc          = {0};
    struct EfmiPoolInfo     pool_info   = {0};
    struct EfmiSignalCursor psc         = {0};
    struct EfmiSignalInfo   ps_info     = {0};
    
    int  count          = 0;
    BOOL firstSignal    = TRUE;
    BOOL firstPool      = TRUE;

    ramlog_printf("ַ: : С: ::\n");

    for(; ;)
    {
        if(firstPool)
        {
            rv          = ose_efmi_get_first_pool(&pc, &pool_info, sizeof(pool_info));
            firstPool   = FALSE;
        }
        else
        {
            rv          = ose_efmi_get_next_pool(&pc, &pool_info);
            firstSignal = TRUE;
            if(rv == EFMI_END_OF_LIST)
            {
                ramlog_printf(":%d\n", count);
                return ZOSS_SUCCESS;
            }
            else if(rv != EFMI_OK)
            {
                return ZOSS_ERROR;/* ѭ */
            }
                
        }
        
        for(; ;)
        {
            if(firstSignal)
            {
                rv          = ose_efmi_get_first_pool_signal(pool_info.pool_id, 
                                                             &psc, 
                                                             &ps_info, 
                                                             sizeof(ps_info));
                firstSignal = FALSE;
            }
            else
            {
                rv = ose_efmi_get_next_pool_signal(&psc, &ps_info);

                if(rv == EFMI_END_OF_LIST)
                {
                    break;
                }
                else if(rv != EFMI_OK)
                {
                    return ZOSS_ERROR;/* ѭ */
                }
            }

            if(ps_info.sig_status == EFMI_SS_VALID)
            {
                /* ַ: : С: : */
                ramlog_printf("%#x:%x:%d:%#x\n", ps_info.signal_pointer, ps_info.owner,
                                 ps_info.size_in_pool, ps_info.sender_pid);
            }
            else if(ps_info.sig_status == EFMI_SS_NO_ENDMARK)
            {
                ramlog_printf("%#x:%x:%d:%#x:endmark broken\n", ps_info.signal_pointer, 
                                ps_info.owner, ps_info.size_in_pool, ps_info.sender_pid);
            }
            else if(ps_info.sig_status == EFMI_SS_BROKEN_SIGADM)
            {
                ramlog_printf("%#x:%x:%d:%#x:controlBlock broken\n", ps_info.signal_pointer,
                            ps_info.owner, ps_info.size_in_pool, ps_info.sender_pid);
            }
            else
            {
                continue;
            }
            
            count++;
        }
    }
}

/**************************************************************************
* ƣOsa_GetSysHeapInfo
* ѯڴϸϢ
* ˵(IN)
*   ֵ
* ˵: 
**************************************************************************/
static UINT32 Osa_GetSysHeapInfo(VOID)
{
    HfmiStatus                  rv  = HFMI_OK;
    struct HfmiHeapCursor       hhc = {0};
    struct HfmiHeapInfo         hi  = {0};
    struct HfmiBufferCursor     bc  = {0};
    struct HfmiBufferInfo       bi  = {0};
    struct HfmiHeapStatistics   hs  = {0};
    
    CHAR            *file       = NULL;
    int             line        = 0;
    int             count       = 0;
    BOOL            firstbuffer = TRUE;
    BOOL            firstheap   = TRUE;
    ExtAnnotation   *ad         = NULL;
    UINT32          pid         = 0;
    UINT32          RamSize     = 0;
    UINT32          HeapMaxSize = 0;
    T_Mem_MemInfo   mem_info    = {0};
    
    ramlog_printf("ַ(0x):߳(0x):ļ(0x):к:\n");

    for(; ;)
    {
        if(firstheap)
        {
            rv          = (HfmiStatus)ose_hfmi_get_first_heap(&hhc, &hi, sizeof(hi));
            firstheap   = FALSE;
        }
        else
        {
            rv          = (HfmiStatus)ose_hfmi_get_next_heap(&hhc, &hi, sizeof(hi));
            firstbuffer = TRUE;
            if(rv == HFMI_END_OF_LIST)
            {
                ramlog_printf(":%d\n", count);
                sysparam_readattr_long("krn/log_mem/RAM", "size", (long *)&RamSize);
                sysparam_readattr_long("heap", "max_size", (long *)&HeapMaxSize);
                HeapMaxSize         = HeapMaxSize > RamSize ? RamSize : HeapMaxSize;
                mem_info.nMemTotal  = mem_info.nMemTotal < HeapMaxSize ? HeapMaxSize : mem_info.nMemTotal;
                ramlog_printf("heaptotal:%d heapused:%d\n", mem_info.nMemTotal, mem_info.nMemUsed);
                return ZOSS_SUCCESS;
            }
            else if(rv != HFMI_OK)
            {
                return ZOSS_ERROR; /* ѭ */
            }
                
        }
        
        ose_hfmi_get_heap_statistics(hi.href, &hs, sizeof(hs));
        mem_info.nMemTotal  += hs.total_used + hs.total_free;
        mem_info.nMemUsed   += hs.total_used;
        
        for(; ;)
        {
            if(firstbuffer)
            {
                rv          = (HfmiStatus)ose_hfmi_get_first_buffer(hi.href, &bc, &bi, sizeof(bi));
                firstbuffer = FALSE;
            }
            else
            {
                rv = (HfmiStatus)ose_hfmi_get_next_buffer(&bc, &bi, sizeof(bi));
                if(rv == HFMI_END_OF_LIST)
                {
                    break;
                }
                else if(rv != HFMI_OK)
                {
                    return ZOSS_ERROR; /* ѭ */
                }
            }
            //rv = ose_hfmi_get_buffer_file_line(&bc,0,filename, sizeof(filename),&line);
            if(!(bi.status & HFMI_BUFFER_ALLOCATED))
            {
                continue; /* free heap buffer */
            }

            if(bi.status & HFMI_BUFFER_IS_ANNOTATED)
            {
                ad      = (ExtAnnotation*)(bi.data_address - sizeof(ExtAnnotation));
                file    = (CHAR *)ad->def_annot.file;
                line    = HDM_GET_LINE(ad->def_annot.control);
                pid     = ad->pid;
            }
            else
            {
                file    = NULL;
                line    = 0;
                pid     = 0;
            }
            count++;
            /* ַ: ߳: ļ: к: */
            ramlog_printf("%#x:%x:%#x:%d\n", bi.data_address, pid, file, line);
        }
    }
}

/**************************************************************************
* ƣ Osa_EncodeError
*  LCDʾ쳣Ϣ
* ˵ (IN):
                   user_called:Ϊʱ,ʾû,Ϊʱ,ʾں
                   ecode:
                   extra:󸽼
*            (OUT):
**************************************************************************/
static VOID Osa_EncodeError(CHAR *buf, OSBOOLEAN user_called, OSERRCODE ecode, OSERRCODE extra)
{
    OSERRCODE cause = ecode & OSE_EERROR_MASK;

    if (ecode == 0xFFFFFFFF && extra != 0)
    {
        /* Assertion failed. */
        T_ZOss_Except_Info *efl = (T_ZOss_Except_Info *)extra;
        
        zOss_SaveRegisters();
        sprintf((char *)buf, "Failed assertion: %s File: %s line:%u\n", efl->expr, 
                efl->file, efl->line);
        return;
    }

    /* ARM쳣 */
    if (cause == OSE_EUNEXPECTED_EXCEPTION_REGDUMP)
    {
        struct cpu_dumpsection *sect0   = NULL;
        Osa_ArmExceptDump               = (struct cpu_regdump *)extra;
        sect0                           = &Osa_ArmExceptDump->sect[0];
        Osa_CoreRegisters               = *(struct cpu_core *)sect0->address;
        
        sprintf((char *)buf, "ARM exception Vector:%#lx PC=%#lx SR=%#lx SP=%#lx\n",
                Osa_ArmExceptDump->vector, Osa_ArmExceptDump->pc, 
                Osa_ArmExceptDump->sr, Osa_ArmExceptDump->sp);
        return;
    }

    /* ֪ϵͳ쳣 */
    /* 浱ǰĴֵ */
    zOss_SaveRegisters();
    
    if (user_called)/* û쳣 */
    {
        if (ecode == 0xFFFFFFFE && extra != 0)
        {
            /* Unknown signal received. */
            sprintf((char *)buf, "Unknown signal received\n");
        }
        else if (ecode == OSE_EFS_EABORT_CALLED)
        {
            OseEfsAbortFileLine *efl = (OseEfsAbortFileLine *)extra;
            
            zOss_AssertExN(efl != NULL);
            sprintf((char *)buf, "Abort called file:%s line:%u\n",
                     efl->file, efl->line);
        }
        /* Check for error reported by HEAP. */
        else if ((ecode & OSE_ESUBCODE_MASK) == OSE_HEAP_EBASE)
        {
            const CHAR *desc = NULL;
            /*desc = heaperr_str(ecode & ~OSE_EFATAL_MASK);*/
            sprintf((char *)buf, "Heap reports error %#lx: %s\n",
                     ecode, desc != NULL ? desc : "unknown");

            /* Heap exhausted errors could be handled (for instance by extending
               the heap) or just ignored (in such cases malloc() would return
               NULL). */
            Osa_GetSysHeapInfo();
        }
        else /* Other application specific error codes. */
        {
            sprintf((char *)buf, "Application reports error %#lx "
                     "extra %#lx\n", ecode, extra);
        }
    }
    else /* Kernel detected/reported error. */
    {
        sprintf((char *)buf, "Kernel detected error %#lx "
            "extra %#lx\n", ecode, extra);
        Osa_GetSysPoolInfo();
    }

    return;
}

/**************************************************************************
* ƣ Osa_heap_debug_alloc_hook
*  heap alloc hookfile line ownerϢ
* ˵ (IN):
                  
*            (OUT):
*   ֵ   
* ˵ 
**************************************************************************/
VOID Osa_heap_debug_alloc_hook(OSHEAP heap, VOID *ptr, size_t size, size_t annsz,
                                         PROCESS owner, const CHAR *file, UINT32 line)
{
    ExtAnnotation *ad = (ExtAnnotation*)((CHAR *)ptr - sizeof(ExtAnnotation));
    if(owner == 0)
    {
        ad->pid = current_process();
    }
    else
    {
        ad->pid = owner;
    }
    
    ad->def_annot.file      = (const char *)file;
    ad->def_annot.control   = line;
}

/**************************************************************************
* ƣ Osa_heap_debug_fileline_hook
*  heap fileline hookȡfile line ownerϢ
* ˵ (IN):
                  
*            (OUT):
*   ֵ   
* ˵ 
**************************************************************************/
VOID Osa_heap_debug_fileline_hook(OSHEAP heap, struct HeapBufferInfoReply *hbi, UINT32 offset)
{
    return;
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
 * ƣ zte_sys_err_hnd
 *  ӹOSEϵͳ쳣
 * ˵ (IN):
                   user_called:Ϊʱ,ʾû,Ϊʱ,ʾں
                   ecode:
                   extra:󸽼
*             (OUT):
 *   ֵᷢ쳣ִеֵ
 * ˵ 
**************************************************************************/
OSADDRESS zte_sys_err_hnd(OSBOOLEAN user_called, OSERRCODE ecode, OSERRCODE extra)
{ 
    static UINT32   iCount          = 0;
    UINT8           excepResetFlag  = 0;
    Msr             oldMsr          = 0;
    UINT32          errcodeBase     = 0;
    UINT32          errcodeSize     = 0;

    /* ARMж */
    LOCK_SAVE(oldMsr);
    iCount++;
    if(iCount > 1)/* ֻһγֳ */
    {
        for ( ; ; ) ;
    }

    excepResetFlag = (UINT8)zOss_GetExceptResetFlag();
    if (excepResetFlag != EXCEPT_RESET_ENABLE)
    {
        zOss_RamdumpforEncodeError( &errcodeBase , &errcodeSize );
        /*  */
        Osa_EncodeError( (CHAR *)errcodeBase, user_called, ecode, extra);
        /* LCDʾ쳣Ϣ */
        if(USE_RAMDUMP_DISPLAY_ENABLE == zOss_GetRamdumpDisplayFlag())
        {
            ddLcd_DisplayError(0, 0, (CHAR *)lcdBase,
                               (CHAR *)errcodeBase, (UINT16)errcodeSize);
        }
        /* ִramdump쳣 */
        zOss_RamdumpMain();
        for ( ; ; ) ;
    }
    else
    {
        zDrv_Soft_Reset(RESET_TO_EXCEPTRESET);/* 쳣 */
    }
    LOCK_RESTORE(oldMsr);
    return 0;
 }

/**************************************************************************
* ƣ Osa_SysErrHndInit
*  ӹܲϵͳ쳣
* ˵ (IN):
                  
*            (OUT):
*   ֵ   
* ˵ 
**************************************************************************/
VOID Osa_SysErrHndInit(VOID)
{   
    HeapDebugHooks hooks = {0};
    /* ramdisk */
    sysparam_readattr_long("ramdisk", "base", (long *)&lcdBase);
    
    hooks.debug_alloc       = (DEBUG_ALLOC_FUNC)Osa_heap_debug_alloc_hook;
    hooks.debug_fileline    = (DEBUG_FILELINE_FUNC)Osa_heap_debug_fileline_hook;
    
    ose_heap_set_debug_hooks(ose_heap_ref(0), sizeof(ExtAnnotation), &hooks);
    sys_err_hnd_hook_install(zte_sys_err_hnd);
}

#ifdef __cplusplus
}
#endif

