/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : P98C_OSS
*    : ose_pool_info.c
* ļ : 
* ʵֹ : ʵoseϵͳpoolڴϢȡ
*      : 
*      : V1.0
*  : 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : chenxingfang
* ޸ : 2012-09-17
* ޸ : ʽ淶PC-LINT߲ EC:617001782014
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : chenxingfang
* ޸ : 2012-09-27
* ޸ : ߲ EC:617001782003
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#ifdef _OS_OSE
#include "stdio.h"
#include "ose.h"
#include "ose_spi/ose_spi.h"
#include "oss_api.h"

#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define pool_printf(...)  zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, ##__VA_ARGS__)

/**************************************************************************
* ݽṹ
**************************************************************************/

/**************************************************************************
* ֲԭ
**************************************************************************/
 
/**************************************************************************
* ȫֳ/
**************************************************************************/
 
/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
* ƣlist_pool_info
* гpoolڴϸϢ
* ˵(IN)
            pool_id:poolڴID
            (OUT)   
*   ֵ:
* ˵
**************************************************************************/
static VOID list_pool_info(PROCESS pool_id)
{
    OSADDRESS   *value      = NULL;
    OSADDRESS   *value1     = NULL;
    OSADDRESS   loop        = 0;
    OSADDRESS   inUse       = 0;
    CHAR        temp[100]   = {0};
    CHAR        temp1[100]  = {0};
    
    struct OS_poolcb *pool = get_poolcb(pool_id);
    
    if (pool == NULL)
    {
        pool_printf("Error: %#lx is not a valid pool identifier.", pool_id);
        return;
    }
    
    pool_printf("Pool id.....: %#lx", pool_id);
    pool_printf("Total size..: %lu", pool->tot_size);
    pool_printf("Never used..: %lu (%lu%%)", pool->free_size, (100 * (pool->free_size)) / pool->tot_size);
    pool_printf("Max used....: %lu (%lu%%)", (pool->tot_size - pool->free_size), (100 * (pool->tot_size - pool->free_size)) / pool->tot_size);
    pool_printf("--------------------------------------------------------------------------------");
    
    pool_printf("Stack sizes: %lu", pool->stk_conf_entries);
    
    if (pool->stk_conf_entries > 0)
    {
        value = &pool->values[pool->stk_conf_sizes];
        loop = pool->stk_conf_entries;
        sprintf((char *)temp, " Conf.: ");
        
        while (loop--)
        {
            sprintf((char *)temp1, "%7lu", *value++);
            strcat((char *)temp, (const char *)temp1);
        }
        
        pool_printf("%s", (char *)temp);
        temp[0] = 0;
        sprintf((char *)temp, " Alloc:");
        value = &pool->values[pool->stk_alloc_sizes];
        loop  = pool->stk_conf_entries;
        inUse = 0;
        
        while (loop--) 
        {
            inUse += *value;
            sprintf((char *)temp1, "%7lu", *value++);
            strcat((char *)temp, (const char *)temp1);
        }
        
        sprintf((char *)temp1, " Sum: %lu", inUse);
        strcat((char *)temp, (const char *)temp1);
        pool_printf("%s", (char *)temp);
        
        temp[0] = 0;
        sprintf((char *)temp, " Mem..:");
        value  = &pool->values[pool->stk_conf_sizes];
        value1 = &pool->values[pool->stk_alloc_sizes];
        loop   = pool->stk_conf_entries;
        inUse  = 0;
        
        while (loop--)
        {
            inUse += (*value) * (*value1);
            sprintf((char *)temp1, "%7lu", (*value++) * (*value1++));
            strcat((char *)temp, (const char *)temp1);
        }
        
        sprintf((char *)temp1, " Sum: %lu", inUse);
        strcat((char *)temp, (const char *)temp1);
        pool_printf("%s", (char *)temp);
    }
    
    pool_printf("--------------------------------------------------------------------------------");
    pool_printf("Signal sizes: %lu", pool->sig_conf_entries);
    if (pool->sig_conf_entries > 0)
    {
        value = &pool->values[pool->sig_conf_sizes];
        loop  = pool->sig_conf_entries;
        temp[0] = 0;
        sprintf((char *)temp, " Conf.: ");
        
        while (loop--)
        {
            sprintf((char *)temp1, "%7lu", *value++);
            strcat((char *)temp, (const char *)temp1);
        }
        
        pool_printf("%s", (char *)temp);
        
        temp[0] = 0;
        sprintf((char *)temp, " Alloc:");
        value = &pool->values[pool->sig_alloc_sizes];
        loop  = pool->sig_conf_entries;
        inUse = 0;
        
        while (loop--)
        {
            inUse += *value;
            sprintf((char *)temp1, "%7lu", *value++);
            strcat((char *)temp, (const char *)temp1);
        }
        
        sprintf((char *)temp1, " Sum: %lu", inUse);
        strcat((char *)temp, (const char *)temp1);
        pool_printf("%s", (char *)temp);
        
        temp[0] = 0;
        sprintf((char *)temp, " Mem..:");
        value  = &pool->values[pool->sig_conf_sizes];
        value1 = &pool->values[pool->sig_alloc_sizes];
        loop   = pool->sig_conf_entries;
        inUse  = 0;
        
        while (loop--)
        {
            inUse += (*value) * (*value1);
            sprintf((char *)temp1, "%7lu", (*value++) * (*value1++));
            strcat((char *)temp, (const char *)temp1);
        }
        
        sprintf((char *)temp1, " Sum: %lu", inUse);
        strcat((char *)temp, (const char *)temp1);
        pool_printf("%s", (char *)temp);
    }
    
    free_buf((union SIGNAL **)&pool);
}

/**************************************************************************
* ȫֺʵ
**************************************************************************/

/**************************************************************************
* ƣlist_pools
* гpoolڴϸϢ
* ˵(IN)
            (OUT)   
*   ֵ:
* ˵
**************************************************************************/
VOID list_pools(VOID)
{
    struct OS_pid_list *list = get_pool_list(0);
    
    if (list != NULL)
    {
        OSBUFSIZE count = list->count;
        unsigned int i = 0;
        
        for(i = 0 ; i < count; i++)
        {
            list_pool_info(list->list[i]);
        }
    }
}

/**************************************************************************
* ƣlist_pool_info
* гźŵϢ
* ˵(IN)
            pid:ID
            listDetail:ǷгϸϢ
            (OUT)   
*   ֵ:
* ˵
**************************************************************************/
VOID list_proc_sig_info(PROCESS pid, OSBOOLEAN listDetail)
{
    struct OS_sig_info  sig_info    = {0};
    PROCESS             sig_pool    = get_sig_poolid(pid);
    struct OS_poolcb    *pool       = get_poolcb(sig_pool);
    OSBOOLEAN           status      = get_sig_info(&sig_info, sig_pool, pid, 0);
    
    if (status == 5)
    {
        OSADDRESS       *value          = &pool->values[pool->sig_conf_sizes];
        OSADDRESS       loop            = pool->sig_conf_entries;
        int             sig_alloc[10]   = {0};
        OSADDRESS       sigptr          = sig_info.next;
        CHAR            thread_name[64] = {0};
        CHAR            temp[100]       = {0};
        CHAR            temp1[100]      = {0};
        unsigned int    i               = 0;
        struct OS_pcb   *pPcb           = get_pcb(pid);
        
        if (NULL != pPcb && OS_ILLEGAL != pPcb->type)
        {
            strcpy((char *)thread_name, &pPcb->strings[pPcb->name]);
            free_buf((union SIGNAL **)&pPcb);
            pool_printf("Signals owned by process %s(%#lx)", (char *)thread_name, pid);
        }
        
        if (listDetail > 0)
        {
            pool_printf("%10s %10s %10s %10s %10s %10s %10s", "sigptr", "sig_no", "owner", "sender_pid", "addressee_pid", "sig_size", "size_in_pool");
        }
        while (sigptr > 0)
        {
            status = get_sig_info(&sig_info, sig_pool, pid, sigptr);
            
            switch (status)
            {
            case 1:
                {
                    for (i = 0; i < loop; i++)
                    {
                        if (sig_info.sig_size <= value[i])
                        {
                            sig_alloc[i]++;
                        }
                        else
                        {
                            break;
                        }
                    }
                    
                    break;
                }
            case 2:
                {
                    pool_printf("No valid endmark found");
                    break;
                }
            case 3:
                {
                    pool_printf("The signal's administration block is faulty");
                    return; /* Not safe to continue */
                }
            case 4:
                {
                    pool_printf("The signal's address is wild (inside a pool)");
                    return; /* Not safe to continue */
                }
            case 5:
                {
                    pool_printf("The signal's address is wild (not inside any pool)");
                    return; /* Not safe to continue */
                }
            default:
                {
                    return;
                }
            }
            
            if (listDetail > 0)
            {
                pool_printf("%#10lx %#10lx %#10lx %#10lx %#10lx %10ld %10ld", sigptr, sig_info.sig_no, sig_info.owner, \
                            sig_info.sender_pid, sig_info.addressee_pid, sig_info.sig_size, sig_info.size_in_pool);
            }
            
            sigptr = sig_info.next;
        }
        
        pool_printf("statistics:");
        
        temp[0] = 0;
        sprintf((char *)temp, " Conf.: ");
        for (i = 0; i < loop; i++) 
        {
            sprintf((char *)temp1, "%7lu", value[i]);
            strcat((char *)temp, (const char *)temp1);
        }
        
        pool_printf("%s", (char *)temp);
        
        temp[0] = 0;
        sprintf((char *)temp, " Alloc:");
        
        for (i = 0; i < loop; i++) 
        {
            sprintf((char *)temp1, "%7lu", sig_alloc[i]);
            strcat((char *)temp, (const char *)temp1);
        }
        
        pool_printf("%s", (char *)temp);
        pool_printf("--------------------------------------------------------------------------------");
    }
    
    free_buf((union SIGNAL **)&pool);
}

/**************************************************************************
* ƣlist_all_sig_info
* гнźŵϢ
* ˵(IN)
            (OUT)   
*   ֵ:
* ˵
**************************************************************************/
VOID list_all_sig_info(VOID)
{
    struct OS_pid_list  *bidlist    = NULL;
    struct OS_pid_list  *pidlist    = NULL;
    OSBUFSIZE           bid_count   = 0;
    OSBUFSIZE           pid_count   = 0;
    unsigned int        i           = 0;
    unsigned int        j           = 0;
    
    bidlist     = get_bid_list(0);
    bid_count   = bidlist->count;
    
    for(i = 0; i < bid_count; i++)
    {
        pidlist = get_pid_list(bidlist->list[i]);
        if(pidlist != NULL)
        {
            pid_count = pidlist->count;
            
            for(j = 0; j < pid_count; j++)
            {
                list_proc_sig_info(pidlist->list[j], 0);
            }
            
            free_buf((union SIGNAL **)&pidlist);
        }
        else
        {
            continue;
        }
    }
    
    free_buf((union SIGNAL **)&bidlist);
}
#endif

/**************************************************************************
* ֲʵ
**************************************************************************/

#ifdef __cplusplus
}
#endif

