/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : ose_ramdump_arm.c 
*    : ose_ramdump_arm.c
* ļ : 
* ʵֹ : ramdumpŻ
*      : 
*      : V1.0
*  : 2012/02/17
* ˵ :          
**************************************************************************/
/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : junkuiZhao
* ޸ : 2012/09/15
* ޸ : PC-LINTڱ淶޸ EC: 617001781881  
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : junkuiZhao
* ޸ : 2012/10/10
* ޸ : ߲ EC: 617001781957
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "ose_typedef.h" 
#include "oss_api.h"
#include "sysparam.h"
#include "ose_ramdump_arm.h"
#include "drvs_usbpoll.h"
#include "ose_spi/exception.h"

#ifdef _USE_ARM1_RAMDUMP
#include "drvs_icp.h"
#include "ps_ephy_interface.h"
#endif
#ifdef __cplusplus
extern "C"
{
#endif

/**************************************************************************
* 궨
**************************************************************************/
#define  RAMDUMP_DIR_NAME           "ramdump_dir"       /* ramdumpĿ¼    */
#define  RAMDUMP_ARM0_FILE_NAME     "arm0_memory.bin"   /* arm0ڴļ   */
#define  RAMDUMP_ARM1_FILE_NAME     "arm1_memory.bin"   /* arm1ڴļ   */
    
#define  RAMDUMP_FLAG               0x22222222

/* io read/write buffer: [msg][data] */
#define RAMDUMP_IO_DATA_BASE(addr)  ((UINT32)addr + 4)

/* T_RamdumpCmmFileInfo */
#define CMM_FILE_BUF_SIZE(addr)     (*(UINT32 *)addr)
#define CMM_FILE_BUF_BASE(addr)     ((UINT32)addr + 4)

#ifdef _USE_ARM1_RAMDUMP
#define ARM0_NOFITY_ARM1                \
        ramdump_send_msg_to_arm1();     \
        *(UINT32 *)HIGHMEM_ARM1_FLAG_ARM02ARM1_BASE = RAMDUMP_FLAG
    
#define ARM0_WAIT_ARM1                  \
        while ( RAMDUMP_FLAG != *(volatile UINT32*)HIGHMEM_ARM1_FLAG_ARM12ARM0_BASE ){}
          
#ifdef _USE_PSM
extern  SINT32 zOss_PsmGetSleepFlag(VOID);  /* arm1˯߱־ӿ */
extern  VOID   zL1e_WriteWakeUpEphyToRam(VOID);
#ifdef _USE_PSM_NEW_FRAMEWORK
#define ARM0_WAIT_DDR1_READY
#else
#define ARM0_WAIT_DDR1_READY            \
        zL1e_WriteWakeUpEphyToRam();    \
        while ( PSM_DEEP_SLEEP == (UINT32)zOss_PsmGetSleepFlag()){}
#endif
#endif
#endif

/**************************************************************************
* ݽṹ
**************************************************************************/
typedef struct
{
    UINT32  buf_size;
    CHAR    buf[1];
}T_RamdumpCmmFileInfo;

typedef struct
{
   UINT32   start_addr;
   UINT32   end_addr;
   UINT32   map_start_addr;
   UINT32   copy_start_addr;
}T_RamdumpRegion;

typedef struct
{
   UINT32           region_num;
   T_RamdumpRegion  regions[1];         /* ܻ */
}T_RamdumpRegionInfo;

typedef struct
{
    CHAR   fileName[DUMPFILENMAE_LEN];  /* ļ           */
    UINT32 baseAddr;                    /* ڴַ       */
    UINT32 size;                        /* С             */
}T_RamdumpFile;

typedef struct
{
    UINT32          fileNum;            /* ļ         */
    T_RamdumpFile   fileInfo[1];        /* ܻ */
}T_RamdumpFileInfo;


/**************************************************************************
* ȫֳ/
**************************************************************************/
static struct cpu_regdump *Osa_ArmExceptDump = NULL;
static UINT8 Osa_ArmMode[6] = /* ˳struc coreе˳һ£ܸ */
{
    0xdf,   /* SYS  */
    0xd3,   /* SVC  */
    0xd7,   /* ABT  */
    0xdb,   /* UND  */
    0xd2,   /* IRQ  */
    0xd1,   /* FIQ  */
}; 

static CHAR *Osa_BankRegsiter[3] = {(CHAR *)"r13", (CHAR *)"r14", (CHAR *)"spsr"};

extern struct cpu_core Osa_CoreRegisters; 

#ifdef _USE_ARM1_RAMDUMP
static UINT32               HIGHMEM_ARM1_BASE           = 0;
#endif
static UINT32               HIGHMEM_ARM0_BASE           = 0;
static T_RamdumpCmmFileInfo *g_cmm_file_info            = NULL;
static UINT32               g_cmm_file_max              = 0;
static T_RamdumpRegionInfo  *g_configured_regions_info  = NULL;
static UINT32               g_configured_regions_max    = 0;
static T_RamdumpRegionInfo  *g_parsed_regions_info      = NULL;
static UINT32               g_parsed_regions_max        = 0;
static T_RamdumpFileInfo    *g_ramdump_file_info        = NULL;
static UINT32               g_ramdump_file_max          = 0;
static CHAR                 *g_err_code_buf             = NULL;

static T_zOss_RamdumpHookFunc g_zRamump_Hook[_USE_RAMDUMP_HOOK_NUM] = {NULL};

static T_zOss_RamdumpIoOpt g_zRamdumpIoOpt = { zOss_RamdumpUsbInit,  zOss_RamdumpUsbReadData,
                                               zOss_RamdumpUsbWriteData, zOss_RamdumpUsbFinish};
/************************************************************************** 
* ⲿ
**************************************************************************/   

/**************************************************************************  
* ⲿ
**************************************************************************/
extern UINT32 cp15_readControlRegister( VOID );
extern UINT32 cp15_readDomainRegister( VOID );
extern UINT32 cp15_readTTB( VOID );
extern UINT32 read_cpsr( VOID );

extern VOID mmu_generate_info( VOID );
extern BOOL mmu_get_readable_region( UINT32 begin, UINT32 end , UINT32 *p_begin, UINT32 *p_end );

extern OSADDRESS image_text_start(void);
extern OSADDRESS image_text_end(void);
extern OSADDRESS image_data_start(void);
extern OSADDRESS image_data_end(void);

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
 * ƣramdump_create_cmm_file
 * t32űļ
 * ˵(IN): 
 *           (OUT):
 *   ֵ  
 * ˵
**************************************************************************/
static VOID ramdump_create_cmm_file( VOID )
{
    char    *cmmAddress     = NULL; 
    //char    *cmmbufferbase  = NULL;
    UINT32  *paddress       = NULL;
    UINT32  length          = 0;
    UINT32  value           = 0;
    UINT32  i               = 0;
    UINT32  j               = 0;
    UINT32  control_reg     = 0;
  
    cmmAddress  = (char *)g_cmm_file_info->buf;
    length      = (UINT32)sprintf( cmmAddress, "ENTRY &%s\r\n", RAMDUMP_DIR_NAME );
    cmmAddress  += length;

    if(Osa_ArmExceptDump != NULL)
    {
        value = Osa_ArmExceptDump->pc;
    }
    else
    {
        value = Osa_CoreRegisters.supervisor.lr;
    }
    length      = (UINT32)sprintf(cmmAddress, "r.s pc %#lx\r\n", value);
    cmmAddress += length;

    /* лsvcģʽԭr0-r12 */
    length      = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", Osa_ArmMode[0]);
    cmmAddress += length;
    
    for(i = 0; i < 13; i++)
    {
        length      = (UINT32)sprintf(cmmAddress, "r.s r%d %#lx\r\n", i, Osa_CoreRegisters.r[i]);
        cmmAddress += length;
    }

    paddress = &Osa_CoreRegisters.user.sp;
    /* fiq֮ģʽݼĴ */
    for(i = 0; i < 5; i++)
    {
        length      = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", Osa_ArmMode[i]);
        cmmAddress  += length;
        for(j = 0; j < 3; j++)
        {
            length      = (UINT32)sprintf(cmmAddress, "r.s %s %#lx\r\n", Osa_BankRegsiter[j], *paddress);
            cmmAddress += length;
            paddress++; 
        }
    }

    /* FIQ r8-r14 */
    length      = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", Osa_ArmMode[5]);
    cmmAddress += length;
    for(i = 8; i < 15; i++)
    {
        length      = (UINT32)sprintf(cmmAddress, "r.s r%d %#lx\r\n", i, *paddress);
        cmmAddress  += length;
        paddress++;
    }
    /* FIQ spsr */
    length      = (UINT32)sprintf(cmmAddress, "r.s spsr %#lx\r\n", *paddress);
    cmmAddress  += length;

    /* cpsr */
    if(Osa_ArmExceptDump != NULL)
    {
        switch(Osa_ArmExceptDump->vector)
        {
            case 0x04:/* undefined instruction */
            {
                value = Osa_CoreRegisters.undefined.psr;
                break;
            }
            case 0x0C:/* prefetch abort */
            {
                value = Osa_CoreRegisters.abort.psr;
                break;
            }
            case 0x10:/* data abort */
            {
                value = Osa_CoreRegisters.abort.psr;
                break;
            }
            case 0x18:/* IRQ */
            {
                value = Osa_CoreRegisters.irq.psr;
                break;
            }
            case 0x1C:/* FIQ */
            {
                value = Osa_CoreRegisters.fiq.psr;
                break;
            }
            default:
            {
                break;
            }
        }
    }
    else
    {
        value = read_cpsr();
    }
    length      = (UINT32)sprintf(cmmAddress, "r.s cpsr %#lx\r\n", value);
    cmmAddress += length;

    control_reg = cp15_readControlRegister();
    
    /* ֹMMU */
    length      = (UINT32)sprintf(cmmAddress, "per.s c15:0x1 %%long %#lx\r\n", (control_reg & 0xfffffffe));
    cmmAddress += length;

    /* ramdumpļ */
    for ( i = 0; i < g_parsed_regions_info->region_num; i++)
    {   
        length      = (UINT32)sprintf(cmmAddress, "data.load.binary &%s\\%s_%d %#lx--%#lx /noclear\r\n",RAMDUMP_DIR_NAME, RAMDUMP_ARM0_FILE_NAME,i,
                              g_parsed_regions_info->regions[i].start_addr ,g_parsed_regions_info->regions[i].end_addr);
        cmmAddress += length;
    }
  
    /* cp15 c1 MMUƼĴ */
    control_reg = cp15_readControlRegister();
    length      = (UINT32)sprintf(cmmAddress, "per.s c15:0x1 %%long %#lx\r\n", control_reg);
    cmmAddress += length;
    
    /* cp15 c2 MMUҳĴ */
    control_reg = cp15_readTTB();
    length      = (UINT32)sprintf(cmmAddress, "per.s c15:0x2 %%long %#lx\r\n", control_reg);
    cmmAddress += length;
    
    /* cp15 c3 MMUĴ */
    control_reg = cp15_readDomainRegister();
    length      = (UINT32)sprintf(cmmAddress, "per.s c15:0x3 %%long %#lx\r\n", control_reg);
    cmmAddress += length;

    /*  */
    length      = (UINT32)sprintf(cmmAddress, "ENDDO\r\n");
    cmmAddress += length;

    g_cmm_file_info->buf_size = (UINT32)(cmmAddress - (char *)g_cmm_file_info->buf);
    zOss_AssertExN( g_cmm_file_info->buf_size <= g_cmm_file_max );
}

/**************************************************************************
 * ƣ ramdump_transfer_data
 *  PC๤߽нҪ
 * ˵ (IN): 
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_transfer_data( VOID )
{
    UINT32          *reqCmd     = NULL;
    UINT32          *rspCmd     = NULL;
    UINT32          rspDataLen  = 0;
    CHAR            *reqBuffer  = NULL;
    CHAR            *rspBuffer  = NULL;
    T_RamdumpFile   *fileInfo   = NULL;
    
    reqBuffer = (CHAR *)HIGHMEM_ARM0_IO_READBUF_BASE;
    rspBuffer = (CHAR *)HIGHMEM_ARM0_IO_WRITEBUF_BASE;
    rspCmd    = (UINT32 *)rspBuffer;
    reqCmd    = (UINT32 *)reqBuffer;
    fileInfo  = g_ramdump_file_info->fileInfo;

    g_zRamdumpIoOpt.init();
    
    for(;;)
    {
        /* ͨѶڶ */
        g_zRamdumpIoOpt.read((UINT8 *)reqBuffer, CMD_BUFFER_LEN);
        switch (*reqCmd)
        {
            case DUMPFILE_LINK_REQ:    /* ͬ */
            {
                T_DUMPFILE_LINK_RSP *rspMsg = NULL;
                *rspCmd                     = DUMPFILE_LINK_RSP;
                rspMsg                      = (T_DUMPFILE_LINK_RSP *)RAMDUMP_IO_DATA_BASE(rspBuffer);
                rspMsg->fileNum             = g_ramdump_file_info->fileNum;
                rspDataLen                  = sizeof(*rspCmd) + sizeof(T_DUMPFILE_LINK_RSP);
                break;
            }
            
            case DUMPFILE_FILE_REQ:    /* ȡļϢʼļ */
            {
                T_DUMPFILE_FILE_REQ *reqMsg = NULL;
                T_DUMPFILE_FILE_RSP *rspMsg = NULL;
                *rspCmd                     = DUMPFILE_FILE_RSP;
                reqMsg                      = (T_DUMPFILE_FILE_REQ *)RAMDUMP_IO_DATA_BASE(reqBuffer);
                rspMsg                      = (T_DUMPFILE_FILE_RSP *)RAMDUMP_IO_DATA_BASE(rspBuffer);

                /* жļǷȷ */
                if (reqMsg->fileNo < g_ramdump_file_info->fileNum)
                {
                    strcpy((char *)rspMsg->fileName, (char *)fileInfo[reqMsg->fileNo].fileName);
                    rspMsg->size    = fileInfo[reqMsg->fileNo].size;
                    rspDataLen      = sizeof(*rspCmd) + sizeof(T_DUMPFILE_FILE_RSP);
                }
                else
                {
                    *rspCmd     = DUMPFILE_NO_FAIL;
                    rspDataLen  = sizeof(*rspCmd);
                }

                break;
            }
            
            case DUMPFILE_READ_REQ:     /* ȡļ */
            {
                T_DUMPFILE_READ_REQ *reqMsg = NULL;
                *rspCmd                     = DUMPFILE_READ_RSP;
                rspDataLen                  = sizeof(*rspCmd);
                reqMsg                      = (T_DUMPFILE_READ_REQ *)RAMDUMP_IO_DATA_BASE(reqBuffer);

                if (reqMsg->fileNo >= g_ramdump_file_info->fileNum) 
                {
                    *rspCmd = DUMPFILE_LENGTH_FAIL;
                    break;
                }
                
                if (reqMsg->offset + reqMsg->length > fileInfo[reqMsg->fileNo].size)
                {
                    *rspCmd = DUMPFILE_NO_FAIL;
                    break;
                }

                g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
                g_zRamdumpIoOpt.write((UINT8 *)(fileInfo[reqMsg->fileNo].baseAddr + reqMsg->offset), reqMsg->length);
                continue;/* ִһζ */
            }
            
            case DUMPFILE_END_REQ:     /*  */
            {
                *rspCmd     = DUMPFILE_END_RSP;
                rspDataLen  = sizeof(*rspCmd);
                g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
                g_zRamdumpIoOpt.finish();
                return;
            }
            
            default:                    /* ָ */
            {
                *rspCmd     = DUMPFILE_CMD_FAIL;
                rspDataLen  = sizeof(*rspCmd);
                break;
            }
        }

        /* ͨѶд */
        g_zRamdumpIoOpt.write((UINT8 *)rspBuffer, rspDataLen);
    }
}

/**************************************************************************
 * ƣramdump_save_all_files_info
 * ļϢ߶ڴ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_save_file_info( const CHAR *name, UINT32 base_addr, UINT32 size )
{
    T_RamdumpFile *pfileInfo = NULL;

    zOss_AssertExN(name != NULL);
    
    pfileInfo = g_ramdump_file_info->fileInfo + g_ramdump_file_info->fileNum;
    strcpy( (char *)pfileInfo->fileName, (const char *)name );
    pfileInfo->baseAddr = base_addr;
    pfileInfo->size     = size;
    
    g_ramdump_file_info->fileNum ++;
    zOss_AssertExN( g_ramdump_file_info->fileNum < g_ramdump_file_max); 
}

/**************************************************************************
 * ƣramdump_save_all_files_info
 * ڴ鵼ļ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_save_region_file_info( T_RamdumpRegionInfo *p_region_info, const CHAR *file_name )
{
    UINT32  i                       = 0;
    CHAR    name[DUMPFILENMAE_LEN]  = {0};
    zOss_AssertExN(p_region_info != NULL);
    
    for (; i < p_region_info->region_num; i++ )
    {
        sprintf((char *)name, "%s_%d", file_name, i );
        ramdump_save_file_info( name, 
                                p_region_info->regions[i].start_addr,
                               (p_region_info->regions[i].end_addr - p_region_info->regions[i].start_addr) + 1 );
    }
}

/**************************************************************************
 * ƣramdump_save_all_files_info
 * ļ
 * ˵(IN):
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_save_all_files_info( VOID )
{
    UINT32 arm0_errcode_len = 0;
#ifdef _USE_ARM1_RAMDUMP
    UINT32 arm1_errcode_len = 0;
#endif

    ramdump_save_region_file_info( g_parsed_regions_info, (const CHAR *)RAMDUMP_ARM0_FILE_NAME );
    ramdump_save_file_info( (const CHAR *)"arm0_targetstate.cmm", (UINT32)g_cmm_file_info->buf, g_cmm_file_info->buf_size );

    arm0_errcode_len = strlen((const char *)g_err_code_buf );
#ifndef _USE_ARM1_RAMDUMP
    ramdump_save_file_info( (const CHAR *)"err_log.txt", (UINT32)g_err_code_buf, arm0_errcode_len );
#else
    arm1_errcode_len = strlen( (char *)HIGHMEM_ARM1_ERR_CODE_BASE );
    strcpy( (char *)(g_err_code_buf + arm0_errcode_len), (char *)HIGHMEM_ARM1_ERR_CODE_BASE );
    ramdump_save_file_info( "err_log.txt", (UINT32)g_err_code_buf, (arm0_errcode_len + arm1_errcode_len ));
    
    ramdump_save_region_file_info( (T_RamdumpRegionInfo *)HIGHMEM_ARM1_PARSED_REGION_BASE, RAMDUMP_ARM1_FILE_NAME );
    ramdump_save_file_info( "arm1_targetstate.cmm", CMM_FILE_BUF_BASE(HIGHMEM_ARM1_CMM_INFO_BASE), CMM_FILE_BUF_SIZE(HIGHMEM_ARM1_CMM_INFO_BASE) );
#endif
}

/**************************************************************************
 * ƣ  ramdump_get_available_region
 *   ĬõڴMMUڴݶԱȣ
               ɵڴ
 * ˵ (IN):  ڴʼַmemAddBeginַend,ڴ
                     ݵдַmemorybase
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_get_available_region( UINT32 memAddBegin, UINT32 end, UINT32 map_base, UINT32 copy_base,UINT32 memorybase )
{
    UINT32 region_start = 0;
    UINT32 region_end   = 0;
    UINT32 region_cnt   = 0;
    UINT32 *addr        = NULL;
    
    zOss_ASSERT( memAddBegin <= end );

    region_cnt = *(UINT32 *)memorybase; /* ڴĿ */
    zOss_AssertExN( region_cnt < g_parsed_regions_max );
    addr = (UINT32 *)memorybase + region_cnt * 4 + 1;   /* ַƫ */
    while ( mmu_get_readable_region(memAddBegin, end, &region_start, &region_end) )
    {
        *addr++ = region_start;
        *addr++ = region_end;
        if(map_base != memAddBegin)
        {
           *addr++ = map_base  + region_start - memAddBegin;
        }
        else
        {
           *addr++ = map_base;
        }
        if(copy_base != 0)
        {
            *addr++ = copy_base + region_start - memAddBegin;
        }
        else
        {
            *addr++ = 0;
        }
        region_cnt ++;
 
        memAddBegin = region_end + 1;
        if (memAddBegin < region_end) break;
    }
    *(UINT32 *)memorybase = region_cnt;
}
/**************************************************************************
 * ƣramdump_parse_region_info
 * ڴļ
 * ˵(IN): Ĭõַɵַ
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_parse_region_info( UINT32 configured_region_base, UINT32 parsed_region_base )
{   
    UINT32 i = 0;
    T_RamdumpRegionInfo *p_configured_info = NULL;
    T_RamdumpRegionInfo *p_parsed_info     = NULL;

    p_configured_info = (T_RamdumpRegionInfo *)configured_region_base;
    p_parsed_info     = (T_RamdumpRegionInfo *)parsed_region_base;
    
    for ( ; i < p_configured_info->region_num; i++ )
    {
        ramdump_get_available_region( p_configured_info->regions[i].start_addr,
                                      p_configured_info->regions[i].end_addr,
                                      p_configured_info->regions[i].map_start_addr,
                                      p_configured_info->regions[i].copy_start_addr,
                                      (UINT32)p_parsed_info );
    }
}
#ifdef _USE_ARM1_RAMDUMP
/**************************************************************************
 * ƣ ramdump_send_msg_to_arm1
 *  Arm0 ICP ϢIDͺ
 * ˵ (IN):
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_send_msg_to_arm1( VOID )
{
    T_HalIcp_Msg icp_msg;

    zOss_Memset(&icp_msg, 0, sizeof(icp_msg));
    
    icp_msg.SrcModId            = ICP_ARM0_MODULE_ID_OS;
    icp_msg.desModId            = ICP_ARM1_MODULE_ID_OS;
    icp_msg.IntInfo.high_word   = ZPLAT_LTE_ICP_ARM02ARM1_RAMDUMP_CF;
    zDrvIcp_SendMsg( (const T_HalIcp_Msg *)&icp_msg );
}

/**************************************************************************
 * ƣ ramdump_process_msg_from_arm1
 *  Arm0 ICPϢܴ
 * ˵ (IN):
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
static VOID ramdump_process_msg_from_arm1( const T_HalIcp_Msg *pMsg )
{
    T_HalIcp_Dword state = { 0 };
   
    zDrvIcp_GetState( ICP_MSG_ACTOR_ARM, &state );
    zDrvIcp_ClearState( ICP_MSG_ACTOR_ARM, state  );

    /* ¼ʽ */
    strcpy( (char *)g_err_code_buf, "arm0: force error!" );

    /* ʹarm0쳣Ա㿪ʼramdump */
    zOss_ASSERT( FALSE );
}
#endif  

/*****************************************************************************
* ȫֺʵ
******************************************************************************/
/*****************************************************************************
 * ƣ zOss_RamdumpConfigureMem
 *  ڴϢ
 * ˵ (IN):
 *                 base:      ڴARM0࿴ʼַ
 *                 size :     ڴδС
 *                 map_base:  ڴ࿴ʼַ
 *                 copy_base: ramdumpҪضݿָڴĵַ
 *                            Ҫ0 [base , size]:[copy_base , size ]
 *            (OUT):
 *   ֵ   
 * ˵ 
******************************************************************************/
VOID zOss_RamdumpConfigureMem( UINT32 base, UINT32 size ,UINT32 map_base ,UINT32 copy_base )
{
    if (size == 0)
        return;
    if ((size - 1) > (0xFFFFFFFF - base))
    {
        zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "Hello,ڴεַô,ѯʹ!");
        return;
    }
    zOss_AssertExN( g_configured_regions_info->region_num < g_configured_regions_max);
    g_configured_regions_info->regions[g_configured_regions_info->region_num].start_addr        = base;
    g_configured_regions_info->regions[g_configured_regions_info->region_num].end_addr          = base + size - 1;
    g_configured_regions_info->regions[g_configured_regions_info->region_num].map_start_addr    = map_base;
    g_configured_regions_info->regions[g_configured_regions_info->region_num].copy_start_addr   = copy_base;
    (g_configured_regions_info->region_num)++;
}
 
/**************************************************************************
 * ƣ zOss_RamdumpHndInit
 *  ַȫֱʼ,ȡramdumpڴĬ
                                  arm0arm1ͬ
 * ˵ (IN):
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpInit( VOID )
{  
    UINT32 base = 0;
    UINT32 size = 0;
    UINT32 map_base     = 0;
    UINT32 copy_base    = 0;

    /*==========================================
          ַȫֱʼ
    ==========================================*/
    sysparam_readattr_long( "krn/region/highmemory", "base", (long *)&HIGHMEM_ARM0_BASE );
    #ifdef _USE_ARM1_RAMDUMP
    sysparam_readattr_long( "krn/region/highmemory_arm1", "base", (long *)&HIGHMEM_ARM1_BASE );
    #endif
    g_cmm_file_info             = (T_RamdumpCmmFileInfo * )HIGHMEM_ARM0_CMM_INFO_BASE;
    g_cmm_file_info->buf_size   = 0;
    g_cmm_file_max              = (HIGHMEM_CMM_INFO_SIZE - 4);/* 4ʾṹһԱĴСͬ */ 
    
    g_configured_regions_info               = (T_RamdumpRegionInfo *)(HIGHMEM_ARM0_CONFIGURED_REGION_BASE);
    g_configured_regions_info->region_num   = 0;
    g_configured_regions_max                = (HIGHMEM_CONFIGURED_REGION_SIZE - 4) / sizeof(T_RamdumpRegion);
    
    g_parsed_regions_info               = (T_RamdumpRegionInfo *)(HIGHMEM_ARM0_PARSED_REGION_BASE);
    g_parsed_regions_info->region_num   = 0;
    g_parsed_regions_max                = (HIGHMEM_PARSED_REGION_SIZE - 4) / sizeof(T_RamdumpRegion);

    g_ramdump_file_info             = (T_RamdumpFileInfo *)HIGHMEM_ARM0_FILE_INFO_BASE;
    g_ramdump_file_info->fileNum    = 0;
    g_ramdump_file_max              = (HIGHMEM_FILE_INFO_SIZE - 4) / sizeof(T_RamdumpFile);

    g_err_code_buf = (CHAR *)HIGHMEM_ARM0_ERR_CODE_BASE;
    zOss_Memset( g_err_code_buf, 0, (UINT32)HIGHMEM_ERR_CODE_SIZE );
    strcpy( (char *)g_err_code_buf, "arm0: exact error!" );
   
    /*==========================================================
          ramdumpڴĬ,Ĭ˳ҪĶ
    ==========================================================*/
    /*   */
    base = image_text_start();
    size = (image_text_end() - base) + 1;
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem( base, size , map_base , copy_base);
   
     /*  ݶ */
    base = image_data_start();
    size = (image_data_end() - base) + 1;
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem( base, size , map_base , copy_base);
 
     /*  Ѷ */
    sysparam_readattr_long( "krn/log_mem/RAM", "base", (long *)&base );
    sysparam_readattr_long( "krn/log_mem/RAM", "size", (long *)&size );
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem( base, size , map_base , copy_base);
     
     /* ARMж */
    sysparam_readattr_long( "krn/region/vectors", "base", (long *)&base );
    sysparam_readattr_long( "krn/region/vectors", "size", (long *)&size );
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem( base, size , map_base , copy_base);

     /* highmemory */
    sysparam_readattr_long( "krn/region/highmemory", "base", (long *)&base );
    sysparam_readattr_long( "krn/region/highmemory", "size", (long *)&size );
    map_base    = base;
    copy_base   = 0;
    zOss_RamdumpConfigureMem( base, size , map_base , copy_base);
    
#ifdef _USE_ARM1_RAMDUMP    
    /*==========================================
          arm0arm1ͬ
    ==========================================*/
    /* *(volatile UINT32 *)HIGHMEM_ARM1_FLAG_ARM12ARM0_BASE = RAMDUMP_FLAG ; */
    *(volatile UINT32 *)HIGHMEM_ARM1_FLAG_ARM02ARM1_BASE = 0;
    zDrvIcp_RegCallback( ICP_ARM0_MODULE_ID_OS, ICP_ARM1_MODULE_ID_OS, ramdump_process_msg_from_arm1, ICP_ISR_CALLBACK ); 
#endif
    
}

/**************************************************************************
 * ƣ zOss_RamdumpMain
 *  RAMDUMP
 * ˵ (IN):
 *            (OUT):
 *   ֵ    
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpMain( VOID )
{   
    UINT32 cnt = 0;
        
    mmu_generate_info();
    ramdump_parse_region_info( (UINT32)g_configured_regions_info , (UINT32)g_parsed_regions_info);
    ramdump_create_cmm_file();
    
#ifdef _USE_ARM1_RAMDUMP
#ifdef _USE_PSM
    ARM0_WAIT_DDR1_READY;
#endif   
    ramdump_parse_region_info(HIGHMEM_ARM1_CONFIGURED_REGION_BASE, HIGHMEM_ARM1_PARSED_REGION_BASE);

    ARM0_NOFITY_ARM1;
    ARM0_WAIT_ARM1;
#endif   

    /*ִramdumpݴ*/
    ramdump_save_all_files_info();

    for (cnt = 0; cnt < _USE_RAMDUMP_HOOK_NUM; cnt++)
    {
        if (g_zRamump_Hook[cnt])
        {
            g_zRamump_Hook[cnt]();
        }
    }
    
    ramdump_transfer_data();
}

/**************************************************************************
 * ƣ zOss_RamdumpforEncodeError
 *  Ϊڴַռ
 * ˵ (IN): 
 *            (OUT): ַʹС
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpforEncodeError( UINT32 *p_base ,UINT32 *p_size )
{  
    UINT32 len  = strlen( (char *)HIGHMEM_ARM0_ERR_CODE_BASE );

    zOss_AssertExN(p_base != NULL && p_size != NULL);
    
    *p_base = HIGHMEM_ARM0_ERR_CODE_BASE + len;
    *p_size = (HIGHMEM_ERR_CODE_SIZE - len) - 1;
}

/**************************************************************************
 * ƣ zOss_RamdumpForceException
 *  ǿƲ쳣,Աramdump
 * ˵ (IN): 0:ARM쳣 1: 쳣 2: ϵͳ쳣
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpForceException( UINT32 type )
{   
    CHAR *errlogBase = (CHAR *)HIGHMEM_ARM0_ERR_CODE_BASE ;
    strcpy((char *)errlogBase, "arm0: force error!");
    
    if ( 0 == type )
    {   
        assert(FALSE);
    }
    else
    {   
        zOss_ASSERT(FALSE);
    }
}

/**************************************************************************
 * ƣ zOss_RamdumHookInstall
 *  RAMDUMPṩעᰲװӿ
 * ˵ (IN): 
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpHookInstall(T_zOss_RamdumpHookFunc hook)
{
    UINT32 cnt = 0;
    ZOSS_INTR old_intr;
    
    ZOSS_SAVE_IRQ(old_intr);
    for (cnt = 0; cnt < _USE_RAMDUMP_HOOK_NUM; cnt++)
    {
        if (g_zRamump_Hook[cnt] == NULL)
        {
            g_zRamump_Hook[cnt] = hook;
        }
    }
    ZOSS_RESTORE_IRQ(old_intr);
}

/**************************************************************************
 * ƣ zOss_RamdumpSetIoOpt
 *  ramdump Io ͨ
 * ˵ (IN): 
 *           (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpSetIoOpt(T_zOss_RamdumpIoOpt hook)
{
    g_zRamdumpIoOpt.init    = hook.init;
    g_zRamdumpIoOpt.read    = hook.read;
    g_zRamdumpIoOpt.write   = hook.write;
    g_zRamdumpIoOpt.finish  = hook.finish;    
}

#ifdef __cplusplus
}
#endif


