/*******************************************************************************
* Ȩ (C)2011, ͨѶɷ޹˾
* 
* ļ:     tos_card.c
* ļʶ:     tos_card.c
* ժҪ:     TOS 3.0 fat32 ļϵͳT豸ģ͵֧Ųģ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2011/07/17      V1.0        Create                    
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "drv_pub.h"
#include "hal_fsms.h"
#include "oss_api.h"
#include <cyg/io/devtab.h>
#include <cyg/io/disk.h>

/*******************************************************************************
*                                                                      *
*******************************************************************************/


/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define DISCNUM    0
#define CYGDAT_DEVS_DISK_SD_DISK0_NAME   "disksd"

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef struct cyg_sd_disk_info_t {
    cyg_uint32      sd_saved_baudrate;
    cyg_uint32      sd_block_count;
    cyg_bool        sd_read_only;
    cyg_bool        sd_connected;
    cyg_uint32      sd_heads_per_cylinder;
    cyg_uint32      sd_sectors_per_head;
    cyg_uint32      sd_read_block_length;
    cyg_uint32      sd_write_block_length;
} cyg_sd_disk_info_t;

/*******************************************************************************
*                                ֲ                                  *
*******************************************************************************/


/*******************************************************************************
*                              ֲ̬                                *
*******************************************************************************/


/*******************************************************************************
*                                ֲʵ                                  *
*******************************************************************************/
static Cyg_ErrNo    sd_disk_read(disk_channel *chan, void* buf_arg, cyg_uint32 blocks, cyg_uint32 first_block);
static Cyg_ErrNo    sd_disk_write(disk_channel* chan, const void* buf_arg, cyg_uint32 blocks, cyg_uint32 first_block);
static Cyg_ErrNo    sd_disk_get_config(disk_channel* chan, cyg_uint32 key, const void* buf, cyg_uint32* len);
static Cyg_ErrNo    sd_disk_set_config(disk_channel* chan, cyg_uint32 key, const void* buf, cyg_uint32* len);
static cyg_bool     sd_disk_init(struct cyg_devtab_entry* tab);
static Cyg_ErrNo    sd_disk_lookup(struct cyg_devtab_entry** tab, struct cyg_devtab_entry *sub_tab, const char* name);
static Cyg_ErrNo    sd_disk_lookup(struct cyg_devtab_entry** tab, struct cyg_devtab_entry *sub_tab, const char* name);

extern FS_MS_ERROR_TYPE FS_MS_GetGeometry(unsigned int DiscNR, unsigned int *total_lba, unsigned int* sector_size);
extern FS_MS_ERROR_TYPE FS_MS_Write(unsigned int DiscNR, unsigned int startSector, unsigned int nofSectors, const void * userAddress);
extern FS_MS_ERROR_TYPE FS_MS_Read(unsigned int DiscNR, unsigned int startSector, unsigned int nofSectors, void * userAddress);
/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
DISK_FUNS(cyg_sd_disk_funs,
          sd_disk_read,
          sd_disk_write,
          sd_disk_get_config,
          sd_disk_set_config);
static cyg_sd_disk_info_t cyg_sd_disk0_hwinfo = { .sd_connected = 0 };
DISK_CONTROLLER(cyg_sd_disk_controller_0, cyg_sd_disk0_hwinfo);
DISK_CHANNEL(cyg_sd_disk0_channel,
             cyg_sd_disk_funs,
             cyg_sd_disk0_hwinfo,
             cyg_sd_disk_controller_0,
             false,                         
             1);
             
BLOCK_DEVTAB_ENTRY(cyg_sd_disk0,
                   CYGDAT_DEVS_DISK_SD_DISK0_NAME,
                   0,
                   &cyg_io_disk_devio,
                   &sd_disk_init,
                   &sd_disk_lookup,
                   &cyg_sd_disk0_channel);

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     sdӿ
* ˵:     
*                      (IN)  
*                          chan :ͨ;
*                          buf_arg:bufferָ;
*                          blocks  :ȡblockĸ;
*                          first_block:һblock;
*                      (OUT)  
*                          ɹ0,ʧܷطֵ;                       
*   ֵ:     
* ˵:     
*******************************************************************************/
static  Cyg_ErrNo sd_disk_read(disk_channel* chan, void* buf_arg, cyg_uint32 blocks, cyg_uint32 first_block)
{
    cyg_sd_disk_info_t* disk    = (cyg_sd_disk_info_t*) chan->dev_priv;
    cyg_uint8*          buf     = (cyg_uint8*) buf_arg;
    FS_MS_ERROR_TYPE   retCode  = FS_MS_OK;

    //CYG_TRACE_FUNC_START_ALWAYS();
    if (! disk->sd_connected) {
        return -ENODEV;
    }
    retCode = FS_MS_Read(DISCNUM,first_block , blocks, buf);
    if (retCode != FS_MS_OK)
    {
        zOss_ASSERT(0);
    }

    //CYG_TRACE_FUNC_END_ALWAYS();

    return ENOERR;
}

/*******************************************************************************
* :     sdдӿ
* ˵:     
*                      (IN)  
*                          chan :ͨ;
*                          buf_arg:bufferָ;
*                          blocks  :ȡblockĸ;
*                          first_block:һblock;
*                      (OUT)  
*                          ɹ0,ʧܷطֵ;                       
*   ֵ:     
* ˵:     
*******************************************************************************/
static Cyg_ErrNo  sd_disk_write(disk_channel* chan, const void* buf_arg, cyg_uint32 blocks, cyg_uint32 first_block)
{
    cyg_sd_disk_info_t*    disk = (cyg_sd_disk_info_t*) chan->dev_priv;
    FS_MS_ERROR_TYPE   retCode  = FS_MS_OK;

    //CYG_TRACE_FUNC_START_ALWAYS();

    if (! disk->sd_connected) {
        return -ENODEV;
    }
    retCode = FS_MS_Write(DISCNUM, first_block,blocks,buf_arg);
    if (retCode != FS_MS_OK)
    {
        zOss_ASSERT(0);
    }

    //CYG_TRACE_FUNC_END_ALWAYS();

    return ENOERR;
}
/*******************************************************************************
* :    ȡsdýӿ
* ˵:     
*                      (IN)  
*                          chan :ͨ;
*                          key:ؼ;
*                          buf  :bufferָ;
*                          len:;
*                      (OUT)  
*                          ɹ0,ʧܷطֵ;                       
*   ֵ:     
* ˵:     
*******************************************************************************/
static Cyg_ErrNo
sd_disk_get_config(disk_channel* chan, cyg_uint32 key, const void* buf, cyg_uint32* len)
{
    return ENOERR;
}
/*******************************************************************************
* :    sdýӿ
* ˵:     
*                      (IN)  
*                          chan :ͨ;
*                          key:ؼ;
*                          buf  :bufferָ;
*                          len:;
*                      (OUT)  
*                          ɹ0,ʧܷطֵ;                       
*   ֵ:     
* ˵:     
*******************************************************************************/
static Cyg_ErrNo
sd_disk_set_config(disk_channel* chan, cyg_uint32 key, const void* buf, cyg_uint32* len)
{
    return ENOERR;
}
/*******************************************************************************
* :   sdʼ
* ˵:     
*                      (IN)  
*                          tab :豸ڱ
*                      (OUT)  
*                          ɹTRUE,ʧFALSE;                       
*   ֵ:     
* ˵:     
*******************************************************************************/
static cyg_bool
sd_disk_init(struct cyg_devtab_entry* tab)
{
    disk_channel*   chan    = (disk_channel*) tab->priv;
    return (*chan->callbacks->disk_init)(tab);
}
/*******************************************************************************
* :   sd豸
* ˵:     
*                      (IN)  
*                          tab :豸ڱָ;
*                          sub_tab:μ豸ڱ;
*                          name  :豸;
*                      (OUT)  
*                          ɹ0,ʧܷطֵ;                       
*   ֵ:     
* ˵:     
*******************************************************************************/
static Cyg_ErrNo
sd_disk_lookup(struct cyg_devtab_entry** tab, struct cyg_devtab_entry *sub_tab, const char* name)
{
    disk_channel*           chan    = (disk_channel*) (*tab)->priv;
    cyg_sd_disk_info_t     *disk    = (cyg_sd_disk_info_t*) chan->dev_priv;
    cyg_disk_info_t  *chanInfo      = chan->info;
    FS_MS_ERROR_TYPE  retCode       = FS_MS_OK;
    unsigned int  totalLib          = 0;
    unsigned int sectorSize         = 0;
    retCode = FS_MS_GetGeometry(DISCNUM,&totalLib,&sectorSize);
    if (retCode != FS_MS_OK)
    {
        zOss_ASSERT(0);
    }
   // chanInfo->connected = true;
   // chanInfo->block_size = sectorSize;
   // chanInfo->blocks_num = totalLib;
    chanInfo->ident.max_transfer   = 0xFFFFFFFF;
    disk->sd_connected = false;
    chan->valid     = true; 
    if(!disk->sd_connected)
    {
        cyg_disk_identify_t ident;
        ident.lba_sectors_num   = totalLib;
        ident.phys_block_size   = 1;
        disk->sd_connected      = true;
        (*chan->callbacks->disk_connected)(*tab, &ident);
    }
    return (*chan->callbacks->disk_lookup)(tab, sub_tab, name);
}


