/**************************************************************************
*
*                  Copyright (c) 2012 ZTE Corporation.
*
***************************************************************************
* ģ   : 
*    : tos_ramdump_csky.c
* ļ : 
* ʵֹ : 
*      : 
*      : 
*  : 
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : 0001
*    : dengningkun
* ޸ : 2012/9/27
* ޸ : ʽ淶PC-LINT  EC:617001782169
**************************************************************************/
/**************************************************************************
* ޸ı : 0002
*    : dengningkun
* ޸ : 2012/10/10
* ޸ : ߲               EC:617001782205
**************************************************************************/

/**************************************************************************
* #include
**************************************************************************/
#include "oss_api.h"
#include "tos_ramdump.h"
#include "comm_api.h"
#include "hal_comm.h"
#include "kpd_api.h"
#include "sys_func_atcfg.h"

#include "tos_except_csky.h"

#ifdef __cplusplus
extern "C"
{
#endif

#include "drvs_usbpoll.h"
//#include "drvs_kpd.h"

/**************************************************************************
* ⲿ
**************************************************************************/
extern VOID zOss_SaveRegisters(VOID);

/**************************************************************************
* 궨
**************************************************************************/
/* 滮Ķѿռֽڶ */
#define CMM_BUFFER_SIZE                 5120    /* 5k */
#define IO_FILE_INFO                    1024    /* 1K */
#define IO_READ_BUFFER                  1024    /* 1K */
#define IO_WRITE_BUFFER                 1024    /* 1k */
#define RAM_DUMPBUFER_SIZE              (CMM_BUFFER_SIZE+IO_FILE_INFO\
	                                    +IO_READ_BUFFER+IO_WRITE_BUFFER)
#define GET_TRANSFER_DATA_AREA(buffer)  ((char *)buffer + 4)

/* Ramdumpļ */
#define RAM_NAME        "ram.bin"           /* ramļ     */
#define CDS_SCRIPT_NAME "targetstate.scr"   /* TOSűļ    */
#define REG_TOTAL_NUM   80
#define NORMAL_REG_NUM  16
#define CTRL_REG_NUM    22
extern unsigned char _ram_start[], _ram_end[];

/**************************************************************************
* ݽṹ
**************************************************************************/
/* sas ramɷʵһڴʼַ */
typedef struct
{
    UINT32 accessStart;
    UINT32 accessEnd;
    UINT32 accessLength;
}T_RamSection;

/* cmmļ */
typedef struct
{
    UINT32 cmmFileSize;
    CHAR  cmmFileBuffer[1]; /* 滹пռ */
}T_CmmFile;

/* ȡTOS Ϣ,ramdump */
typedef struct
{
    CHAR *cmmBuffer;        /* ɵĻֳָűĻַ */
    CHAR *ioFileInfo;       /* ŴݵļϢ       */
    CHAR *ioReadBuffer;     /* ݵĶַ         */
    CHAR *ioWriteBuffer;    /* ݵдַ         */
}T_OsaRamDumpCfg;

typedef struct
{
    CHAR    fileName[DUMPFILENMAE_LEN]; /* ļ       */
    UINT32  baseAddr;                   /* ڴַ   */
    UINT32  size;                       /* С         */
} T_RamdumpFile;

typedef struct
{
    UINT32          fileNum;        /* ļ         */
    T_RamdumpFile   fileInfo[1];    /* ܻ */
} T_RamdumpFileInfo;


/**************************************************************************
* ֲԭ
**************************************************************************/
VOID Osa_RamdumpMain(VOID);
static VOID IO_ReadData(UINT8 *buffer, UINT32 size);
static VOID IO_WriteData(UINT8 *buffer, UINT32 size);
VOID zOss_TransferRamdumpData(T_RamdumpFileInfo *pioFileInfo);
VOID Osa_CreateCdsBatch(VOID);

/**************************************************************************
* ȫֳ/
**************************************************************************/
T_OsaRamDumpCfg         gOsa_Ramdump                    = {0};  /* TOSϢ   */
volatile UINT32         gRamdumpAdrress[REG_TOTAL_NUM]  = {0};  /* ĴϢ       */
tos_except_register_t  *gEceptRegister                  = NULL;

/**************************************************************************
* ȫֺʵ
**************************************************************************/
/**************************************************************************
 * ƣOsa_SysErrHndInit
 * 쳣ʼ
 * ˵
 *   ֵ
 * ˵
**************************************************************************/
VOID Osa_SysErrHndInit(VOID)
{
    gOsa_Ramdump.cmmBuffer      = (CHAR *)zOss_Malloc(RAM_DUMPBUFER_SIZE);
    zOss_Memset(gOsa_Ramdump.cmmBuffer , 0, RAM_DUMPBUFER_SIZE);
    gOsa_Ramdump.ioFileInfo     =  gOsa_Ramdump.cmmBuffer + CMM_BUFFER_SIZE;
    gOsa_Ramdump.ioReadBuffer   =  gOsa_Ramdump.ioFileInfo + IO_FILE_INFO;
    gOsa_Ramdump.ioWriteBuffer  = gOsa_Ramdump.ioReadBuffer +IO_READ_BUFFER;
}

/**************************************************************************
 * ƣ zte_sys_err_hnd
 *  Ramdump
 * ˵
 *   ֵ
 * ˵1,һ
 *           2excepNum1˵ramdumpֳ쳣
**************************************************************************/
int  zte_sys_err_hnd(int  user_called, int  ecode, int extra)
{
    static UINT32   excepNum        = 0;
    UINT32          excepResetFlag  = 0;
    ZOSS_INTR       old_intr;

    /* ж */
    ZOSS_SAVE_IRQ(old_intr);

    excepNum++;
    if (excepNum > 1)   /* ֻһγֳ */
    {
        for ( ; ; ) ;
    }

    excepResetFlag = zOss_GetExceptResetFlag();
    if (excepResetFlag != EXCEPT_RESET_ENABLE)
    {
        gEceptRegister = tos_dump_except_register();
        if (gEceptRegister)
        {
            zOss_Memcpy((VOID *)gRamdumpAdrress,gEceptRegister,sizeof(tos_except_register_t));
        }
        else
        {
            zOss_SaveRegisters();
        }
        /* ɻָĴtosűļ */
        Osa_CreateCdsBatch();
        /* ִramdump쳣 */
        Osa_RamdumpMain();
        for ( ; ; ) ;
    }
    else
    {
        zDrv_Soft_Reset(RESET_TO_EXCEPTRESET);   /* 쳣 */
    }
    return 0;
}

/**************************************************************************
 * ƣ  zOss_TransferRamdumpData
 *   PC๤߽нҪ
 * ˵  (IN):pRamdkumpInfo:ļϢ
 *             (OUT):
 *   ֵ
 * ˵
**************************************************************************/
VOID zOss_TransferRamdumpData(T_RamdumpFileInfo *pioFileInfo)
{
    CHAR            *reqBuffer  = gOsa_Ramdump.ioReadBuffer;    /* Ϣ   */
    CHAR            *rspBuffer  = gOsa_Ramdump.ioWriteBuffer;   /* ӦϢ   */
    UINT32          rspDataLen  = 0;                            /* ӦϢ     */
    UINT32          *reqCmd     = NULL;
    UINT32          *rspCmd     = NULL;
    T_RamdumpFile   *fileInfo   = NULL;
    BOOL            result      = FALSE;

    zOss_AssertExN(pioFileInfo != NULL);
    
    rspCmd      = (UINT32 *)rspBuffer;
    reqCmd      = (UINT32 *)reqBuffer;
    fileInfo    = pioFileInfo->fileInfo;
    
    /* ʼUSB */
    zDrvUsbPoll_Init();
    
    /* ѯUSBǷ */
    while (!result)
    {
        result = zDrvUsbPoll_isConnect();
    }
    
    for(;;)
    {
        /* ͨѶڶ */
        IO_ReadData((UINT8 *)reqBuffer, CMD_BUFFER_LEN);
        
        switch (*reqCmd)
        {
        case DUMPFILE_LINK_REQ: /* ͬ */
            {
                T_DUMPFILE_LINK_RSP *rspMsg;
                *rspCmd = DUMPFILE_LINK_RSP;
                rspMsg = (T_DUMPFILE_LINK_RSP *)GET_TRANSFER_DATA_AREA(rspBuffer);
                rspMsg->fileNum = pioFileInfo->fileNum;
                rspDataLen = sizeof(*rspCmd) + sizeof(T_DUMPFILE_LINK_RSP);
                break;
            }
        case DUMPFILE_FILE_REQ: /* ȡļϢʼļ */
            {
                T_DUMPFILE_FILE_REQ *reqMsg;
                T_DUMPFILE_FILE_RSP *rspMsg;
                *rspCmd = DUMPFILE_FILE_RSP;
                reqMsg = (T_DUMPFILE_FILE_REQ *)GET_TRANSFER_DATA_AREA(reqBuffer);
                rspMsg = (T_DUMPFILE_FILE_RSP *)GET_TRANSFER_DATA_AREA(rspBuffer);
                
                /* жļǷȷ */
                if (reqMsg->fileNo < pioFileInfo->fileNum)
                {
                    strcpy((char *)rspMsg->fileName, (char *)fileInfo[reqMsg->fileNo].fileName);
                    rspMsg->size = fileInfo[reqMsg->fileNo].size;
                    rspDataLen = sizeof(*rspCmd) + sizeof(T_DUMPFILE_FILE_RSP);
                }
                else
                {
                    *rspCmd = DUMPFILE_NO_FAIL;
                    rspDataLen = sizeof(*rspCmd);
                }
                
                break;
            }
        case DUMPFILE_READ_REQ: /*ȡļ*/
            {
                T_DUMPFILE_READ_REQ *reqMsg;
                *rspCmd = DUMPFILE_READ_RSP;
                rspDataLen = sizeof(*rspCmd);
                reqMsg = (T_DUMPFILE_READ_REQ *)GET_TRANSFER_DATA_AREA(reqBuffer);
                
                if (reqMsg->fileNo >= pioFileInfo->fileNum)
                {
                    *rspCmd = DUMPFILE_LENGTH_FAIL;
                    break;
                }
                
                if (reqMsg->offset + reqMsg->length > fileInfo[reqMsg->fileNo].size)
                {
                    *rspCmd = DUMPFILE_NO_FAIL;
                    break;
                }
                
                IO_WriteData((UINT8 *)rspBuffer, rspDataLen);
                IO_WriteData((UINT8 *)(fileInfo[reqMsg->fileNo].baseAddr + reqMsg->offset), reqMsg->length);
                continue;   /* ִһζ */
            }
        case DUMPFILE_END_REQ:  /*  */
            {
                *rspCmd = DUMPFILE_END_RSP;
                rspDataLen = sizeof(*rspCmd);
                IO_WriteData((UINT8 *)rspBuffer, rspDataLen);
                {
                    int i ;
                    for (i= 0; i< 100;i++)  /* ȴݷ */
                    {
                        zDrvUsbPoll_Isr();
                    }
                }
                return;
            }
        default:    /* ָ */
            {
                *rspCmd = DUMPFILE_CMD_FAIL;
                rspDataLen = sizeof(*rspCmd);
                break;
            }
        }
        
        /* ͨѶд */
        IO_WriteData((UINT8 *)rspBuffer, rspDataLen);
    }
}

/**************************************************************************
 * ƣ Osa_RamdumpMain
 *  ִramdumpPC๤߽нҪ
 * ˵ (IN):
 *            (OUT):
 *   ֵ
 * ˵
**************************************************************************/
VOID Osa_RamdumpMain(VOID)
{
    T_RamdumpFileInfo   *pioFileInfo    = NULL;
    T_RamdumpFile       *pfileInfo      = NULL;

    pioFileInfo = (T_RamdumpFileInfo *)gOsa_Ramdump.ioFileInfo;
    zOss_AssertExN(pioFileInfo != NULL);
    
    pfileInfo   = pioFileInfo->fileInfo;
    zOss_AssertExN(pfileInfo != NULL);
    
    /* TOS  batch head */
    strcpy((char *)pfileInfo->fileName,CDS_SCRIPT_NAME);
    pfileInfo->baseAddr = (UINT32)((T_CmmFile *)gOsa_Ramdump.cmmBuffer)->cmmFileBuffer;
    pfileInfo->size = ((T_CmmFile *)gOsa_Ramdump.cmmBuffer)->cmmFileSize;
    pfileInfo++;
    pioFileInfo->fileNum++;
    /* ram head */
    strcpy((char *)pfileInfo->fileName,RAM_NAME);
    pfileInfo->baseAddr = (UINT32)_ram_start;
    pfileInfo->size = (UINT32)(_ram_end - _ram_start);
    pfileInfo++;
    pioFileInfo->fileNum++;
    /* USB,׼ */
    zOss_TransferRamdumpData(pioFileInfo);
    return;
}

/**************************************************************************
 * ƣ Osa_CreateCdsBatch
 *  ɻָջCDSű
 * ˵ (IN):
 *            (OUT):
 *   ֵ
 * ˵
**************************************************************************/
VOID Osa_CreateCdsBatch(VOID )
{
    char    *cmmAddress = NULL;
    char    *cmmBase    = NULL;
    SINT32  length      = 0;
    SINT32  regIndex    = 0;
    int     i           = 0 ;
    
    T_CmmFile *cmmFile = (T_CmmFile *)gOsa_Ramdump.cmmBuffer;
    zOss_AssertExN(cmmFile != NULL );
    cmmBase     = (char *)cmmFile->cmmFileBuffer;
    cmmAddress = cmmBase;
    /* RAM */
    length = sprintf(cmmAddress, "restore  %s binary %#lx\r\n",RAM_NAME, (UINT32)_ram_start);
    cmmAddress += length;
    /* ƼĴ, gRamdumpAdrress ַǰ汣r0-r15,regIndexǴ16ʼ */
    regIndex = 16;
    if(gEceptRegister)
    {
        length  = sprintf(cmmAddress,"set $cr0 = %#lx\r\n",(int)gEceptRegister->epsr);
        regIndex++;
    }
    else
    {
        length = sprintf(cmmAddress, "set $cr0 = %#lx\r\n",  gRamdumpAdrress[regIndex++]);
    }
    cmmAddress += length;
    for (i = 1; i <CTRL_REG_NUM; i++)
    {
        if (i == 16)
        {
            continue;
        }
        length = sprintf(cmmAddress,"set $cr%d =  %#lx\r\n",i,gRamdumpAdrress[regIndex++]);
        cmmAddress += length;
    }
    /* r0-r15 */
    regIndex = 0;
    for (i = 0; i < NORMAL_REG_NUM; i++)
    {
        length = sprintf(cmmAddress, "set  $r%d =  %#lx\r\n", i, gRamdumpAdrress[regIndex++]);
        cmmAddress += length;
    }
    if(gEceptRegister)
    {
        length = sprintf(cmmAddress, "set  $pc =  %#lx\r\n",(unsigned int) gEceptRegister->epc );
    }
    else
    {
        length = sprintf(cmmAddress, "set  $pc =  %#lx\r\n",  gRamdumpAdrress[--regIndex]);
    }
    
    cmmAddress += length;
    cmmFile->cmmFileSize = (UINT32)(cmmAddress - cmmBase);
    return;
}

/**************************************************************************
 * ƣ zOss_RamdumpConfigureMem
 *  ڴϢ
 * ˵ 
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpConfigureMem( UINT32 base, UINT32 size ,UINT32 map_base ,UINT32 copy_base )
{
    return ;    
}

/**************************************************************************
 * ƣ zOss_RamdumpInit
 *  ICPصʼ
 * ˵ 
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpInit( VOID)
{
    return ;
}

/**************************************************************************
 * ƣ zOss_RamdumpForceException
 *  ǿƲ쳣,Աramdump
 * ˵ (IN): 0:ARM쳣 1: 쳣 2: ϵͳ쳣
 *            (OUT):
 *   ֵ   
 * ˵ 
**************************************************************************/
VOID zOss_RamdumpForceException( UINT32 type )
{   
   
    if ( 0 == type )
    {   
        UINT32 *temp = (UINT32 *)0xFFFFFFFF;
        *temp = 5;
    }
    else if ( 2 == type )
    {   
        assert( FALSE );
    }
    else
    {   
        zOss_AssertExN( FALSE );
    }
}

/**************************************************************************
* ֲʵ
**************************************************************************/
/**************************************************************************
 * ƣ IO_ReadData
 * USB
 * ˵
 *   ֵ
 * ˵
**************************************************************************/
static VOID IO_ReadData(UINT8 *buffer, UINT32 size)
{
    UINT32 count = 0;

    do
    {
        zDrvUsbPoll_Isr();
        count = (UINT32)zDrvUsbPoll_Read(buffer, size);
        if( size <= count)
        {
            break;
        }

        buffer += count;
        size -=count;
    }while (size > 0);
    
}

/**************************************************************************
 * ƣ IO_WriteData
 *  дUSB
 * ˵ (IN):pRamdkumpInfo:ļϢ
 *            (OUT):
 *   ֵ
 * ˵
 **************************************************************************/
static VOID IO_WriteData(UINT8 *buffer, UINT32 size)
{
    UINT32 count = 0;

    while (size > 0)
    {
        zDrvUsbPoll_Isr();
        count = (UINT32)zDrvUsbPoll_Write(buffer, size);
        if( size <= count)
        {
            break;
        }

        buffer += count;
        size -=count;
    }

}


#ifdef __cplusplus
}
#endif

